/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.dto;

import com.baijia.tianxiao.biz.consult.user.dto.response.ConsulterResponseDto;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constant.Sex;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.util.date.DateUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulterDto
implements MsgUser {
    private static final Logger log = LoggerFactory.getLogger(ConsulterDto.class);
    private Long consulterId;
    private Long orgId;
    private Long userNumber;
    private String studentName;
    private Long subAccountId;
    private String nickName;
    private String mobile;
    private int intensionLevel = IntentionLevel.LEVEL_1.getValue();
    private int consultSource;
    private String weixin;
    private String weixinNickName;
    private String weixinOpenId;
    private int chat = 0;
    private String parentName;
    private String parentMobile;
    private Long nextRemindTime;
    private String school;
    private String qq;
    @JsonProperty(value="mail")
    private String mail;
    private Long birthday;
    private String degreeClass;
    private boolean canEditMobile;
    private Integer origin;
    private String portrait;
    private Integer consultStatus;
    private Integer relatives;
    private Integer sex;
    private String address;
    private String latitude;
    private String longitude;
    private Integer campusOrgNumber;
    private Integer campusOrgId;
    private Integer isConsulter;
    private Long cascadeId;
    private Integer isInvalid;
    private String reasonForInvalid;
    private Integer consulterType;
    private Long lastRemindTime;
    private Long finallyHoldTime;
    private Long areaId;
    private String intensionLevelStr;
    private String consultSourceStr;
    private String consultStatusStr;
    private String relativesStr;
    private String sexStr;
    private Integer remainingDayNum;
    private String province;
    private String city;
    private String county;
    private Integer allowToPull;
    private Integer allowToSms;
    private MsgUserRole msgUserRole = MsgUserRole.STUDENT;
    private static final Long ONE_DAY_TIME = 86400000L;

    public String getIntensionLevelStr() {
        return IntentionLevel.getLabel((Integer)this.intensionLevel);
    }

    public String getConsultSourceStr() {
        return MessageSource.getDesc((Integer)this.consultSource);
    }

    public String getConsultStatusStr() {
        return ConsultUserStatus.getLabel((int)this.consultStatus);
    }

    public String getRelativesStr() {
        return Relatives.getLabel((Integer)this.relatives);
    }

    public String getSexStr() {
        return Sex.getLabel((Integer)this.sex);
    }

    public Integer getRemainingDayNum() {
        int dayNum = 0;
        if (this.cascadeId != null && this.cascadeId.intValue() != Flag.NULL.getInt() && this.finallyHoldTime != null) {
            Date now = new Date();
            Date findllyHoldDate = new Date(this.finallyHoldTime);
            if (findllyHoldDate.after(now)) {
                dayNum = DateUtil.getStartOfDayAccurateToMillSeconde((Date)findllyHoldDate).equals(DateUtil.getStartOfDayAccurateToMillSeconde((Date)now)) ? 1 : (int)((DateUtil.getStartOfDayAccurateToMillSeconde((Date)new Date(this.finallyHoldTime)).getTime() - DateUtil.getStartOfDayAccurateToMillSeconde((Date)new Date()).getTime()) / ONE_DAY_TIME);
            }
            if (dayNum == 0) {
                dayNum = 1;
            }
        }
        return dayNum;
    }

    public Long getUserId() {
        return this.consulterId;
    }

    public String getName() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.studentName})) {
            return this.studentName;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.weixinNickName})) {
            return this.weixinNickName;
        }
        return "\u5728\u7ebf\u7559\u5355\u5b66\u751f";
    }

    public Long getNumber() {
        return this.userNumber;
    }

    public UserRoleEnum getRole() {
        return UserRoleEnum.STUDENT;
    }

    public MsgUserRole getMsgUserRole() {
        return this.msgUserRole;
    }

    public void setMsgUserRole(MsgUserRole msgUserRole) {
        this.msgUserRole = msgUserRole;
    }

    public int getIntentLevel() {
        return this.intensionLevel;
    }

    public static ConsulterResponseDto convertToDto(TxConsultUser user) {
        ConsulterResponseDto dto = new ConsulterResponseDto();
        if (user != null) {
            dto.setOrgId(user.getOrgId());
            dto.setConsulterId(user.getId());
            dto.setAddress(user.getAddress());
            dto.setBirthday(user.getBirthday() != null ? user.getBirthday().getTime() : 0L);
            dto.setConsultSource(user.getConsultSource());
            dto.setConsultStatus(user.getConsultStatus());
            dto.setDegreeClass(user.getDegreeClass());
            dto.setMail(user.getMail());
            dto.setIntensionLevel(user.getIntensionLevel());
            dto.setCanEditMobile(true);
            dto.setMobile(user.getMobile());
            dto.setNextRemindTime(user.getNextRemindTime() != null ? user.getNextRemindTime().getTime() : 0L);
            dto.setNickName(user.getNickName());
            dto.setParentMobile(user.getParentMobile());
            dto.setParentName(user.getParentName());
            dto.setQq(user.getQq());
            dto.setSchool(user.getSchool());
            dto.setStudentName(user.getName());
            dto.setUserNumber(user.getUserNumber());
            dto.setWeixin(user.getWeixin());
            dto.setWeixinNickName(user.getWeixinNickName());
            dto.setWeixinOpenId(user.getWeixinOpenId());
            dto.setPortrait(user.getPortrait());
            dto.setRelatives(user.getRelatives());
            dto.setSex(user.getSex());
            dto.setLatitude(user.getLatitude());
            dto.setLongitude(user.getLongitude());
            dto.setCampusOrgId(user.getCampusOrgId());
            dto.setIsConsulter(user.getIsConsulter());
            dto.setCascadeId(user.getCascadeId());
            dto.setIsInvalid(user.getIsInvalid());
            dto.setReasonForInvalid(user.getReasonForInvalid());
            if (user.getLastRemindTime() != null) {
                dto.setLastRemindTime(user.getLastRemindTime().getTime());
            }
            if (user.getFinallyHoldTime() != null) {
                dto.setFinallyHoldTime(user.getFinallyHoldTime().getTime());
            }
            if (user.getStudentId() != null && user.getStudentId() > 0L) {
                dto.setMsgUserRole(MsgUserRole.STUDENT);
            } else {
                dto.setMsgUserRole(MsgUserRole.getUserRole((int)(user.getIsConsulter() == null ? 0 : user.getIsConsulter())));
            }
            dto.setAreaId(user.getAreaId());
        }
        return dto;
    }

    public static TxConsultUser convertToConsultUser(ConsulterDto dto) {
        if (dto == null) {
            return null;
        }
        TxConsultUser user = new TxConsultUser();
        user.setOrgId(dto.getOrgId());
        user.setAddress(dto.getAddress());
        user.setBirthday(dto.getBirthday() != null && dto.getBirthday() > 0L ? new Date(dto.getBirthday()) : null);
        user.setConsultSource(Integer.valueOf(dto.getConsultSource()));
        user.setConsultStatus(dto.getConsultStatus());
        user.setDegreeClass(dto.getDegreeClass());
        user.setMail(dto.getMail());
        user.setIntensionLevel(Integer.valueOf(dto.getIntensionLevel()));
        user.setMobile(dto.getMobile());
        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0L) {
            user.setNextRemindTime(new Date(dto.getNextRemindTime()));
        }
        user.setNickName(dto.getNickName());
        user.setParentMobile(dto.getParentMobile());
        user.setParentName(dto.getParentName());
        user.setQq(dto.getQq());
        user.setSchool(dto.getSchool());
        user.setName(dto.getStudentName());
        user.setUserNumber(dto.getUserNumber());
        user.setWeixin(dto.getWeixin());
        user.setWeixinNickName(dto.getWeixinNickName());
        if (StringUtils.isNotBlank((CharSequence)dto.getWeixinOpenId()) && !"0".equals(dto.getWeixinOpenId())) {
            user.setWeixinOpenId(dto.getWeixinOpenId());
        }
        user.setPortrait(dto.getPortrait());
        user.setRelatives(dto.getRelatives());
        if (dto.getSex() != null) {
            user.setSex(dto.getSex());
        }
        user.setLatitude(dto.getLatitude());
        user.setLongitude(dto.getLongitude());
        if (dto.getCampusOrgNumber() != null) {
            user.setCampusOrgId(dto.getCampusOrgId());
        }
        user.setIsConsulter(dto.getIsConsulter());
        user.setCascadeId(dto.getCascadeId());
        user.setIsInvalid(dto.getIsInvalid());
        user.setReasonForInvalid(dto.getReasonForInvalid());
        user.setAreaId(dto.getAreaId());
        return user;
    }

    public void setRemainingDayNum(Integer remainingDayNum) {
        this.remainingDayNum = remainingDayNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsulterDto)) {
            return false;
        }
        ConsulterDto other = (ConsulterDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$consulterId = this.getConsulterId();
        Long other$consulterId = other.getConsulterId();
        if (this$consulterId == null ? other$consulterId != null : !((Object)this$consulterId).equals(other$consulterId)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$userNumber = this.getUserNumber();
        Long other$userNumber = other.getUserNumber();
        if (this$userNumber == null ? other$userNumber != null : !((Object)this$userNumber).equals(other$userNumber)) {
            return false;
        }
        String this$studentName = this.getStudentName();
        String other$studentName = other.getStudentName();
        if (this$studentName == null ? other$studentName != null : !this$studentName.equals(other$studentName)) {
            return false;
        }
        Long this$subAccountId = this.getSubAccountId();
        Long other$subAccountId = other.getSubAccountId();
        if (this$subAccountId == null ? other$subAccountId != null : !((Object)this$subAccountId).equals(other$subAccountId)) {
            return false;
        }
        String this$nickName = this.getNickName();
        String other$nickName = other.getNickName();
        if (this$nickName == null ? other$nickName != null : !this$nickName.equals(other$nickName)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        if (this.getIntensionLevel() != other.getIntensionLevel()) {
            return false;
        }
        if (this.getConsultSource() != other.getConsultSource()) {
            return false;
        }
        String this$weixin = this.getWeixin();
        String other$weixin = other.getWeixin();
        if (this$weixin == null ? other$weixin != null : !this$weixin.equals(other$weixin)) {
            return false;
        }
        String this$weixinNickName = this.getWeixinNickName();
        String other$weixinNickName = other.getWeixinNickName();
        if (this$weixinNickName == null ? other$weixinNickName != null : !this$weixinNickName.equals(other$weixinNickName)) {
            return false;
        }
        String this$weixinOpenId = this.getWeixinOpenId();
        String other$weixinOpenId = other.getWeixinOpenId();
        if (this$weixinOpenId == null ? other$weixinOpenId != null : !this$weixinOpenId.equals(other$weixinOpenId)) {
            return false;
        }
        if (this.getChat() != other.getChat()) {
            return false;
        }
        String this$parentName = this.getParentName();
        String other$parentName = other.getParentName();
        if (this$parentName == null ? other$parentName != null : !this$parentName.equals(other$parentName)) {
            return false;
        }
        String this$parentMobile = this.getParentMobile();
        String other$parentMobile = other.getParentMobile();
        if (this$parentMobile == null ? other$parentMobile != null : !this$parentMobile.equals(other$parentMobile)) {
            return false;
        }
        Long this$nextRemindTime = this.getNextRemindTime();
        Long other$nextRemindTime = other.getNextRemindTime();
        if (this$nextRemindTime == null ? other$nextRemindTime != null : !((Object)this$nextRemindTime).equals(other$nextRemindTime)) {
            return false;
        }
        String this$school = this.getSchool();
        String other$school = other.getSchool();
        if (this$school == null ? other$school != null : !this$school.equals(other$school)) {
            return false;
        }
        String this$qq = this.getQq();
        String other$qq = other.getQq();
        if (this$qq == null ? other$qq != null : !this$qq.equals(other$qq)) {
            return false;
        }
        String this$mail = this.getMail();
        String other$mail = other.getMail();
        if (this$mail == null ? other$mail != null : !this$mail.equals(other$mail)) {
            return false;
        }
        Long this$birthday = this.getBirthday();
        Long other$birthday = other.getBirthday();
        if (this$birthday == null ? other$birthday != null : !((Object)this$birthday).equals(other$birthday)) {
            return false;
        }
        String this$degreeClass = this.getDegreeClass();
        String other$degreeClass = other.getDegreeClass();
        if (this$degreeClass == null ? other$degreeClass != null : !this$degreeClass.equals(other$degreeClass)) {
            return false;
        }
        if (this.isCanEditMobile() != other.isCanEditMobile()) {
            return false;
        }
        Integer this$origin = this.getOrigin();
        Integer other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !((Object)this$origin).equals(other$origin)) {
            return false;
        }
        String this$portrait = this.getPortrait();
        String other$portrait = other.getPortrait();
        if (this$portrait == null ? other$portrait != null : !this$portrait.equals(other$portrait)) {
            return false;
        }
        Integer this$consultStatus = this.getConsultStatus();
        Integer other$consultStatus = other.getConsultStatus();
        if (this$consultStatus == null ? other$consultStatus != null : !((Object)this$consultStatus).equals(other$consultStatus)) {
            return false;
        }
        Integer this$relatives = this.getRelatives();
        Integer other$relatives = other.getRelatives();
        if (this$relatives == null ? other$relatives != null : !((Object)this$relatives).equals(other$relatives)) {
            return false;
        }
        Integer this$sex = this.getSex();
        Integer other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !((Object)this$sex).equals(other$sex)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$latitude = this.getLatitude();
        String other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !this$latitude.equals(other$latitude)) {
            return false;
        }
        String this$longitude = this.getLongitude();
        String other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !this$longitude.equals(other$longitude)) {
            return false;
        }
        Integer this$campusOrgNumber = this.getCampusOrgNumber();
        Integer other$campusOrgNumber = other.getCampusOrgNumber();
        if (this$campusOrgNumber == null ? other$campusOrgNumber != null : !((Object)this$campusOrgNumber).equals(other$campusOrgNumber)) {
            return false;
        }
        Integer this$campusOrgId = this.getCampusOrgId();
        Integer other$campusOrgId = other.getCampusOrgId();
        if (this$campusOrgId == null ? other$campusOrgId != null : !((Object)this$campusOrgId).equals(other$campusOrgId)) {
            return false;
        }
        Integer this$isConsulter = this.getIsConsulter();
        Integer other$isConsulter = other.getIsConsulter();
        if (this$isConsulter == null ? other$isConsulter != null : !((Object)this$isConsulter).equals(other$isConsulter)) {
            return false;
        }
        Long this$cascadeId = this.getCascadeId();
        Long other$cascadeId = other.getCascadeId();
        if (this$cascadeId == null ? other$cascadeId != null : !((Object)this$cascadeId).equals(other$cascadeId)) {
            return false;
        }
        Integer this$isInvalid = this.getIsInvalid();
        Integer other$isInvalid = other.getIsInvalid();
        if (this$isInvalid == null ? other$isInvalid != null : !((Object)this$isInvalid).equals(other$isInvalid)) {
            return false;
        }
        String this$reasonForInvalid = this.getReasonForInvalid();
        String other$reasonForInvalid = other.getReasonForInvalid();
        if (this$reasonForInvalid == null ? other$reasonForInvalid != null : !this$reasonForInvalid.equals(other$reasonForInvalid)) {
            return false;
        }
        Integer this$consulterType = this.getConsulterType();
        Integer other$consulterType = other.getConsulterType();
        if (this$consulterType == null ? other$consulterType != null : !((Object)this$consulterType).equals(other$consulterType)) {
            return false;
        }
        Long this$lastRemindTime = this.getLastRemindTime();
        Long other$lastRemindTime = other.getLastRemindTime();
        if (this$lastRemindTime == null ? other$lastRemindTime != null : !((Object)this$lastRemindTime).equals(other$lastRemindTime)) {
            return false;
        }
        Long this$finallyHoldTime = this.getFinallyHoldTime();
        Long other$finallyHoldTime = other.getFinallyHoldTime();
        if (this$finallyHoldTime == null ? other$finallyHoldTime != null : !((Object)this$finallyHoldTime).equals(other$finallyHoldTime)) {
            return false;
        }
        Long this$areaId = this.getAreaId();
        Long other$areaId = other.getAreaId();
        if (this$areaId == null ? other$areaId != null : !((Object)this$areaId).equals(other$areaId)) {
            return false;
        }
        String this$intensionLevelStr = this.getIntensionLevelStr();
        String other$intensionLevelStr = other.getIntensionLevelStr();
        if (this$intensionLevelStr == null ? other$intensionLevelStr != null : !this$intensionLevelStr.equals(other$intensionLevelStr)) {
            return false;
        }
        String this$consultSourceStr = this.getConsultSourceStr();
        String other$consultSourceStr = other.getConsultSourceStr();
        if (this$consultSourceStr == null ? other$consultSourceStr != null : !this$consultSourceStr.equals(other$consultSourceStr)) {
            return false;
        }
        String this$consultStatusStr = this.getConsultStatusStr();
        String other$consultStatusStr = other.getConsultStatusStr();
        if (this$consultStatusStr == null ? other$consultStatusStr != null : !this$consultStatusStr.equals(other$consultStatusStr)) {
            return false;
        }
        String this$relativesStr = this.getRelativesStr();
        String other$relativesStr = other.getRelativesStr();
        if (this$relativesStr == null ? other$relativesStr != null : !this$relativesStr.equals(other$relativesStr)) {
            return false;
        }
        String this$sexStr = this.getSexStr();
        String other$sexStr = other.getSexStr();
        if (this$sexStr == null ? other$sexStr != null : !this$sexStr.equals(other$sexStr)) {
            return false;
        }
        Integer this$remainingDayNum = this.getRemainingDayNum();
        Integer other$remainingDayNum = other.getRemainingDayNum();
        if (this$remainingDayNum == null ? other$remainingDayNum != null : !((Object)this$remainingDayNum).equals(other$remainingDayNum)) {
            return false;
        }
        String this$province = this.getProvince();
        String other$province = other.getProvince();
        if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$county = this.getCounty();
        String other$county = other.getCounty();
        if (this$county == null ? other$county != null : !this$county.equals(other$county)) {
            return false;
        }
        Integer this$allowToPull = this.getAllowToPull();
        Integer other$allowToPull = other.getAllowToPull();
        if (this$allowToPull == null ? other$allowToPull != null : !((Object)this$allowToPull).equals(other$allowToPull)) {
            return false;
        }
        Integer this$allowToSms = this.getAllowToSms();
        Integer other$allowToSms = other.getAllowToSms();
        if (this$allowToSms == null ? other$allowToSms != null : !((Object)this$allowToSms).equals(other$allowToSms)) {
            return false;
        }
        MsgUserRole this$msgUserRole = this.getMsgUserRole();
        MsgUserRole other$msgUserRole = other.getMsgUserRole();
        return !(this$msgUserRole == null ? other$msgUserRole != null : !this$msgUserRole.equals(other$msgUserRole));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsulterDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $consulterId = this.getConsulterId();
        result = result * 59 + ($consulterId == null ? 43 : ((Object)$consulterId).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $userNumber = this.getUserNumber();
        result = result * 59 + ($userNumber == null ? 43 : ((Object)$userNumber).hashCode());
        String $studentName = this.getStudentName();
        result = result * 59 + ($studentName == null ? 43 : $studentName.hashCode());
        Long $subAccountId = this.getSubAccountId();
        result = result * 59 + ($subAccountId == null ? 43 : ((Object)$subAccountId).hashCode());
        String $nickName = this.getNickName();
        result = result * 59 + ($nickName == null ? 43 : $nickName.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        result = result * 59 + this.getIntensionLevel();
        result = result * 59 + this.getConsultSource();
        String $weixin = this.getWeixin();
        result = result * 59 + ($weixin == null ? 43 : $weixin.hashCode());
        String $weixinNickName = this.getWeixinNickName();
        result = result * 59 + ($weixinNickName == null ? 43 : $weixinNickName.hashCode());
        String $weixinOpenId = this.getWeixinOpenId();
        result = result * 59 + ($weixinOpenId == null ? 43 : $weixinOpenId.hashCode());
        result = result * 59 + this.getChat();
        String $parentName = this.getParentName();
        result = result * 59 + ($parentName == null ? 43 : $parentName.hashCode());
        String $parentMobile = this.getParentMobile();
        result = result * 59 + ($parentMobile == null ? 43 : $parentMobile.hashCode());
        Long $nextRemindTime = this.getNextRemindTime();
        result = result * 59 + ($nextRemindTime == null ? 43 : ((Object)$nextRemindTime).hashCode());
        String $school = this.getSchool();
        result = result * 59 + ($school == null ? 43 : $school.hashCode());
        String $qq = this.getQq();
        result = result * 59 + ($qq == null ? 43 : $qq.hashCode());
        String $mail = this.getMail();
        result = result * 59 + ($mail == null ? 43 : $mail.hashCode());
        Long $birthday = this.getBirthday();
        result = result * 59 + ($birthday == null ? 43 : ((Object)$birthday).hashCode());
        String $degreeClass = this.getDegreeClass();
        result = result * 59 + ($degreeClass == null ? 43 : $degreeClass.hashCode());
        result = result * 59 + (this.isCanEditMobile() ? 79 : 97);
        Integer $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : ((Object)$origin).hashCode());
        String $portrait = this.getPortrait();
        result = result * 59 + ($portrait == null ? 43 : $portrait.hashCode());
        Integer $consultStatus = this.getConsultStatus();
        result = result * 59 + ($consultStatus == null ? 43 : ((Object)$consultStatus).hashCode());
        Integer $relatives = this.getRelatives();
        result = result * 59 + ($relatives == null ? 43 : ((Object)$relatives).hashCode());
        Integer $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : ((Object)$sex).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : $latitude.hashCode());
        String $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : $longitude.hashCode());
        Integer $campusOrgNumber = this.getCampusOrgNumber();
        result = result * 59 + ($campusOrgNumber == null ? 43 : ((Object)$campusOrgNumber).hashCode());
        Integer $campusOrgId = this.getCampusOrgId();
        result = result * 59 + ($campusOrgId == null ? 43 : ((Object)$campusOrgId).hashCode());
        Integer $isConsulter = this.getIsConsulter();
        result = result * 59 + ($isConsulter == null ? 43 : ((Object)$isConsulter).hashCode());
        Long $cascadeId = this.getCascadeId();
        result = result * 59 + ($cascadeId == null ? 43 : ((Object)$cascadeId).hashCode());
        Integer $isInvalid = this.getIsInvalid();
        result = result * 59 + ($isInvalid == null ? 43 : ((Object)$isInvalid).hashCode());
        String $reasonForInvalid = this.getReasonForInvalid();
        result = result * 59 + ($reasonForInvalid == null ? 43 : $reasonForInvalid.hashCode());
        Integer $consulterType = this.getConsulterType();
        result = result * 59 + ($consulterType == null ? 43 : ((Object)$consulterType).hashCode());
        Long $lastRemindTime = this.getLastRemindTime();
        result = result * 59 + ($lastRemindTime == null ? 43 : ((Object)$lastRemindTime).hashCode());
        Long $finallyHoldTime = this.getFinallyHoldTime();
        result = result * 59 + ($finallyHoldTime == null ? 43 : ((Object)$finallyHoldTime).hashCode());
        Long $areaId = this.getAreaId();
        result = result * 59 + ($areaId == null ? 43 : ((Object)$areaId).hashCode());
        String $intensionLevelStr = this.getIntensionLevelStr();
        result = result * 59 + ($intensionLevelStr == null ? 43 : $intensionLevelStr.hashCode());
        String $consultSourceStr = this.getConsultSourceStr();
        result = result * 59 + ($consultSourceStr == null ? 43 : $consultSourceStr.hashCode());
        String $consultStatusStr = this.getConsultStatusStr();
        result = result * 59 + ($consultStatusStr == null ? 43 : $consultStatusStr.hashCode());
        String $relativesStr = this.getRelativesStr();
        result = result * 59 + ($relativesStr == null ? 43 : $relativesStr.hashCode());
        String $sexStr = this.getSexStr();
        result = result * 59 + ($sexStr == null ? 43 : $sexStr.hashCode());
        Integer $remainingDayNum = this.getRemainingDayNum();
        result = result * 59 + ($remainingDayNum == null ? 43 : ((Object)$remainingDayNum).hashCode());
        String $province = this.getProvince();
        result = result * 59 + ($province == null ? 43 : $province.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $county = this.getCounty();
        result = result * 59 + ($county == null ? 43 : $county.hashCode());
        Integer $allowToPull = this.getAllowToPull();
        result = result * 59 + ($allowToPull == null ? 43 : ((Object)$allowToPull).hashCode());
        Integer $allowToSms = this.getAllowToSms();
        result = result * 59 + ($allowToSms == null ? 43 : ((Object)$allowToSms).hashCode());
        MsgUserRole $msgUserRole = this.getMsgUserRole();
        result = result * 59 + ($msgUserRole == null ? 43 : $msgUserRole.hashCode());
        return result;
    }

    public String toString() {
        return "ConsulterDto(super=" + super.toString() + ", consulterId=" + this.getConsulterId() + ", orgId=" + this.getOrgId() + ", userNumber=" + this.getUserNumber() + ", studentName=" + this.getStudentName() + ", subAccountId=" + this.getSubAccountId() + ", nickName=" + this.getNickName() + ", mobile=" + this.getMobile() + ", intensionLevel=" + this.getIntensionLevel() + ", consultSource=" + this.getConsultSource() + ", weixin=" + this.getWeixin() + ", weixinNickName=" + this.getWeixinNickName() + ", weixinOpenId=" + this.getWeixinOpenId() + ", chat=" + this.getChat() + ", parentName=" + this.getParentName() + ", parentMobile=" + this.getParentMobile() + ", nextRemindTime=" + this.getNextRemindTime() + ", school=" + this.getSchool() + ", qq=" + this.getQq() + ", mail=" + this.getMail() + ", birthday=" + this.getBirthday() + ", degreeClass=" + this.getDegreeClass() + ", canEditMobile=" + this.isCanEditMobile() + ", origin=" + this.getOrigin() + ", portrait=" + this.getPortrait() + ", consultStatus=" + this.getConsultStatus() + ", relatives=" + this.getRelatives() + ", sex=" + this.getSex() + ", address=" + this.getAddress() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", campusOrgNumber=" + this.getCampusOrgNumber() + ", campusOrgId=" + this.getCampusOrgId() + ", isConsulter=" + this.getIsConsulter() + ", cascadeId=" + this.getCascadeId() + ", isInvalid=" + this.getIsInvalid() + ", reasonForInvalid=" + this.getReasonForInvalid() + ", consulterType=" + this.getConsulterType() + ", lastRemindTime=" + this.getLastRemindTime() + ", finallyHoldTime=" + this.getFinallyHoldTime() + ", areaId=" + this.getAreaId() + ", intensionLevelStr=" + this.getIntensionLevelStr() + ", consultSourceStr=" + this.getConsultSourceStr() + ", consultStatusStr=" + this.getConsultStatusStr() + ", relativesStr=" + this.getRelativesStr() + ", sexStr=" + this.getSexStr() + ", remainingDayNum=" + this.getRemainingDayNum() + ", province=" + this.getProvince() + ", city=" + this.getCity() + ", county=" + this.getCounty() + ", allowToPull=" + this.getAllowToPull() + ", allowToSms=" + this.getAllowToSms() + ", msgUserRole=" + this.getMsgUserRole() + ")";
    }

    public Long getConsulterId() {
        return this.consulterId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getUserNumber() {
        return this.userNumber;
    }

    public String getStudentName() {
        return this.studentName;
    }

    public Long getSubAccountId() {
        return this.subAccountId;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getMobile() {
        return this.mobile;
    }

    public int getIntensionLevel() {
        return this.intensionLevel;
    }

    public int getConsultSource() {
        return this.consultSource;
    }

    public String getWeixin() {
        return this.weixin;
    }

    public String getWeixinNickName() {
        return this.weixinNickName;
    }

    public String getWeixinOpenId() {
        return this.weixinOpenId;
    }

    public int getChat() {
        return this.chat;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getParentMobile() {
        return this.parentMobile;
    }

    public Long getNextRemindTime() {
        return this.nextRemindTime;
    }

    public String getSchool() {
        return this.school;
    }

    public String getQq() {
        return this.qq;
    }

    public String getMail() {
        return this.mail;
    }

    public Long getBirthday() {
        return this.birthday;
    }

    public String getDegreeClass() {
        return this.degreeClass;
    }

    public boolean isCanEditMobile() {
        return this.canEditMobile;
    }

    public Integer getOrigin() {
        return this.origin;
    }

    public String getPortrait() {
        return this.portrait;
    }

    public Integer getConsultStatus() {
        return this.consultStatus;
    }

    public Integer getRelatives() {
        return this.relatives;
    }

    public Integer getSex() {
        return this.sex;
    }

    public String getAddress() {
        return this.address;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public Integer getCampusOrgNumber() {
        return this.campusOrgNumber;
    }

    public Integer getCampusOrgId() {
        return this.campusOrgId;
    }

    public Integer getIsConsulter() {
        return this.isConsulter;
    }

    public Long getCascadeId() {
        return this.cascadeId;
    }

    public Integer getIsInvalid() {
        return this.isInvalid;
    }

    public String getReasonForInvalid() {
        return this.reasonForInvalid;
    }

    public Integer getConsulterType() {
        return this.consulterType;
    }

    public Long getLastRemindTime() {
        return this.lastRemindTime;
    }

    public Long getFinallyHoldTime() {
        return this.finallyHoldTime;
    }

    public Long getAreaId() {
        return this.areaId;
    }

    public String getProvince() {
        return this.province;
    }

    public String getCity() {
        return this.city;
    }

    public String getCounty() {
        return this.county;
    }

    public Integer getAllowToPull() {
        return this.allowToPull;
    }

    public Integer getAllowToSms() {
        return this.allowToSms;
    }

    public void setConsulterId(Long consulterId) {
        this.consulterId = consulterId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setUserNumber(Long userNumber) {
        this.userNumber = userNumber;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }

    public void setSubAccountId(Long subAccountId) {
        this.subAccountId = subAccountId;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setIntensionLevel(int intensionLevel) {
        this.intensionLevel = intensionLevel;
    }

    public void setConsultSource(int consultSource) {
        this.consultSource = consultSource;
    }

    public void setWeixin(String weixin) {
        this.weixin = weixin;
    }

    public void setWeixinNickName(String weixinNickName) {
        this.weixinNickName = weixinNickName;
    }

    public void setWeixinOpenId(String weixinOpenId) {
        this.weixinOpenId = weixinOpenId;
    }

    public void setChat(int chat) {
        this.chat = chat;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setParentMobile(String parentMobile) {
        this.parentMobile = parentMobile;
    }

    public void setNextRemindTime(Long nextRemindTime) {
        this.nextRemindTime = nextRemindTime;
    }

    public void setSchool(String school) {
        this.school = school;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    public void setDegreeClass(String degreeClass) {
        this.degreeClass = degreeClass;
    }

    public void setCanEditMobile(boolean canEditMobile) {
        this.canEditMobile = canEditMobile;
    }

    public void setOrigin(Integer origin) {
        this.origin = origin;
    }

    public void setPortrait(String portrait) {
        this.portrait = portrait;
    }

    public void setConsultStatus(Integer consultStatus) {
        this.consultStatus = consultStatus;
    }

    public void setRelatives(Integer relatives) {
        this.relatives = relatives;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setCampusOrgNumber(Integer campusOrgNumber) {
        this.campusOrgNumber = campusOrgNumber;
    }

    public void setCampusOrgId(Integer campusOrgId) {
        this.campusOrgId = campusOrgId;
    }

    public void setIsConsulter(Integer isConsulter) {
        this.isConsulter = isConsulter;
    }

    public void setCascadeId(Long cascadeId) {
        this.cascadeId = cascadeId;
    }

    public void setIsInvalid(Integer isInvalid) {
        this.isInvalid = isInvalid;
    }

    public void setReasonForInvalid(String reasonForInvalid) {
        this.reasonForInvalid = reasonForInvalid;
    }

    public void setConsulterType(Integer consulterType) {
        this.consulterType = consulterType;
    }

    public void setLastRemindTime(Long lastRemindTime) {
        this.lastRemindTime = lastRemindTime;
    }

    public void setFinallyHoldTime(Long finallyHoldTime) {
        this.finallyHoldTime = finallyHoldTime;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public void setIntensionLevelStr(String intensionLevelStr) {
        this.intensionLevelStr = intensionLevelStr;
    }

    public void setConsultSourceStr(String consultSourceStr) {
        this.consultSourceStr = consultSourceStr;
    }

    public void setConsultStatusStr(String consultStatusStr) {
        this.consultStatusStr = consultStatusStr;
    }

    public void setRelativesStr(String relativesStr) {
        this.relativesStr = relativesStr;
    }

    public void setSexStr(String sexStr) {
        this.sexStr = sexStr;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public void setAllowToPull(Integer allowToPull) {
        this.allowToPull = allowToPull;
    }

    public void setAllowToSms(Integer allowToSms) {
        this.allowToSms = allowToSms;
    }
}

