/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.push.service.impl;

import com.baijia.tianxiao.biz.consult.push.service.WechatService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.CardType;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dto.content.AudioMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.ImageMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.TextMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.api.MessagePushService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageContentDto;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageDto;
import com.baijia.tianxiao.util.ListUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger log = LoggerFactory.getLogger(WechatServiceImpl.class);
    @Autowired
    private MessagePushService messagePushService;
    @Autowired
    private ConsultMessageService messageService;
    @Autowired
    private UserCacheService userCacheService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao credentialDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private OrgStudentDao studentDao;
    @Autowired
    private CustomActivityService customActivityService;

    @Override
    @Transactional(noRollbackFor={BussinessException.class})
    public boolean sendMsgToWechat(Long orgId, Integer cascadeId, ConsultMessage message) throws CustomException {
        OrgSubAccount subAccount;
        log.info("[Wechat] Message = {},orgId={},cascadeId={}", new Object[]{ToStringBuilder.reflectionToString((Object)message), orgId, cascadeId});
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        message.setOrgId(orgId);
        TxConsultUser user = (TxConsultUser)this.consultUserDao.getById((Serializable)Long.valueOf(message.getReceiverId()), new String[0]);
        String openId = user.getWeixinOpenId();
        if (cascadeId == null) {
            cascadeId = 0;
        }
        int kefuId = user.getKefuId().intValue();
        int role = this.userCacheService.getUserRole(user);
        boolean isNeedUpdate = false;
        if (role == MsgUserRole.STUDENT.getValue()) {
            OrgStudent orgStudent = (OrgStudent)this.studentDao.getById((Serializable)user.getStudentId(), new String[0]);
            if (orgStudent != null && StringUtils.isNotBlank((String)orgStudent.getWeixin()) && !(openId = orgStudent.getWeixin()).equals(user.getWeixinOpenId())) {
                user.setWeixinOpenId(openId);
                isNeedUpdate = true;
                log.info("[Message] sync weixin openId,orgId={},consultUserId={}", (Object)openId, (Object)user.getId());
            }
            Set<Integer> set = this.getHeadTeachers(orgId, user.getUserId());
            log.info("[Message] HeadTeachers={},kefuId={}", set, (Object)kefuId);
            if (!set.isEmpty()) {
                if (set.contains(kefuId) && kefuId != cascadeId) {
                    String name = this.getAccountName(orgId, kefuId);
                    if (name != null) {
                        throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_OWNER, this.getMessage(name));
                    }
                    set.remove(kefuId);
                }
                if (!set.contains(cascadeId)) {
                    throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_OWNER, "\u60a8\u7684\u6d88\u606f\u65e0\u6cd5\u9001\u8fbe\uff0c\u8be5\u5b66\u5458\u5df2\u6709\u73ed\u4e3b\u4efb\u8001\u5e08\u8ddf\u8fdb");
                }
                kefuId = cascadeId;
            }
        } else if (role == MsgUserRole.CLUE.getValue()) {
            kefuId = user.getCascadeId().intValue();
        }
        if (kefuId > 0) {
            TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)Integer.valueOf(kefuId), new String[0]);
            if (cascadeAccount == null || cascadeAccount.getIsdel() == 1 || cascadeAccount.getStatus() == 1) {
                log.warn("[Message] KefuId is invalid.CascadeId=" + cascadeId);
                kefuId = -1;
            }
        } else if (kefuId == 0 && (subAccount = this.orgSubAccountDao.getByOrgId(Integer.valueOf(orgId.intValue()), new String[0])) != null && subAccount.getIsdel() == 1) {
            log.warn("[Message] KefuId is invalid.OrgId=" + orgId);
            kefuId = -1;
        }
        if (kefuId >= 0 && cascadeId != kefuId) {
            if (role == MsgUserRole.CLUE.getValue()) {
                String name = this.getAccountName(orgId, kefuId);
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_OWNER, this.getMessage(name));
            }
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_OWNER, "\u60a8\u7684\u6d88\u606f\u65e0\u6cd5\u9001\u8fbe\uff0c\u8be5\u7528\u6237\u5df2\u6709\u8001\u5e08\u8ddf\u8fdb");
        }
        if (!user.getKefuId().equals(kefuId)) {
            user.setKefuId(new Long(kefuId));
            isNeedUpdate = true;
            log.info("[Message] KefuId from {} to {}", (Object)user.getKefuId(), (Object)kefuId);
        }
        if (kefuId == -1) {
            user.setKefuId(Long.valueOf(cascadeId.longValue()));
            isNeedUpdate = true;
            log.info("[Message] Set kefuId={}", (Object)user.getKefuId());
        }
        if (isNeedUpdate) {
            this.consultUserDao.update((Object)user, new String[0]);
        }
        MessageDto dto = this.toMessageDto(account, message, message.getReceiverId());
        log.info("[Message] Message = " + dto.toString());
        WebResponse response = this.messagePushService.handle(dto);
        log.info("[Message] Response = " + response.toString());
        if (response.getCode() == 0L) {
            try {
                Date now = new Date();
                user.setLastRemindTime(now);
                user.setUpdateTime(now);
                Integer userRole = this.userCacheService.getUserRole(user);
                user.setCascadeId(Long.valueOf(cascadeId.longValue()));
                message.setReceiverRole(userRole.intValue());
                user.setWeixinOpenId(openId);
                this.consultUserDao.update((Object)user, new String[0]);
            }
            catch (Exception e) {
                log.error("sendMsgToWechat - update LastRemindTime - error:{}", (Throwable)e);
            }
        }
        MsgUserRole userRole = this.getOrgAccountType(orgId, cascadeId);
        message.setSenderRole(userRole.getValue());
        message.setContent(message.getContent());
        this.messageService.addMessage(message);
        return true;
    }

    private String getAccountName(long orgId, int cascadeId) {
        OrgInfo orgInfo;
        if (cascadeId > 0) {
            TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)Integer.valueOf(cascadeId), new String[0]);
            if (cascadeAccount == null || cascadeAccount.getIsdel() == 1 || cascadeAccount.getStatus() == 1) {
                log.warn("[Message] Message TXCascadeAccount is invalidate.cascadeAccount={}", (Object)cascadeAccount);
            } else {
                TXCascadeCredential credential = this.credentialDao.getTXCascadeCredentialByCredentialId(cascadeAccount.getCredentialId());
                if (credential != null) {
                    return credential.getName() == null ? credential.getMobile() : credential.getName();
                }
                log.error("[Message] Message TXCascadeCredential is invalidate.credentialId=" + cascadeAccount.getCredentialId());
            }
        }
        if (cascadeId == 0 && (orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf((int)orgId), new String[]{"contacts", "name"})) != null) {
            if (StringUtils.isNotBlank((String)orgInfo.getContacts())) {
                return orgInfo.getContacts();
            }
            return orgInfo.getName();
        }
        return "\u533f\u540d\u7528\u6237";
    }

    private MessageDto toMessageDto(OrgAccount account, ConsultMessage msg, Long consultUserId) {
        MessageDto pushDto = new MessageDto();
        pushDto.setMsgId(Integer.valueOf((int)msg.getId()));
        pushDto.setMsgT(Integer.valueOf(msg.getMsgType()));
        pushDto.setConsultUserId(consultUserId);
        pushDto.setOrgId(account.getId());
        MessageContentDto content = new MessageContentDto();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        if (msg.getMsgType() == MsgType.TEXT.getValue()) {
            TextMsgContent msgContent = (TextMsgContent)gson.fromJson(msg.getContent(), TextMsgContent.class);
            content.setText(msgContent.getText());
        } else if (msg.getMsgType() == MsgType.PICTURE.getValue()) {
            ImageMsgContent imageMsgContent = (ImageMsgContent)gson.fromJson(msg.getContent(), ImageMsgContent.class);
            content.setUrl(imageMsgContent.getUrl());
            content.setWidth(Integer.valueOf(imageMsgContent.getWidth()));
            content.setStorageId(Integer.valueOf(imageMsgContent.getStorageId()));
            content.setHeight(Integer.valueOf(imageMsgContent.getHeight()));
        } else if (msg.getMsgType() == MsgType.VOICE.getValue()) {
            AudioMsgContent msgContent = (AudioMsgContent)gson.fromJson(msg.getContent(), AudioMsgContent.class);
            content.setLength(Integer.valueOf(msgContent.getLen()));
            content.setUrl(msgContent.getUrl());
            content.setStorageId(Integer.valueOf((int)msgContent.getStorageId()));
        } else {
            OrgInfo info = this.orgInfoDao.getOrgInfo(Integer.valueOf(account.getId()), new String[]{"name", "shortName"});
            String title = info.getShortName();
            if (StringUtils.isBlank((String)title)) {
                title = info.getName();
            }
            CardMsgContent card = (CardMsgContent)gson.fromJson(msg.getContent(), CardMsgContent.class);
            content.setText(this.getActivityOrCourseContent(title, card));
        }
        pushDto.setContent(content);
        return pushDto;
    }

    private MsgUserRole getOrgAccountType(long orgId, Integer cascadeId) {
        if (cascadeId == null || cascadeId == 0) {
            OrgSubAccount subAccount = this.orgSubAccountDao.getMasterByOrgId(Integer.valueOf((int)orgId));
            log.info("OrgId=" + orgId + ";OrgSubAccount=" + subAccount);
            if (subAccount != null) {
                return MsgUserRole.HEADER;
            }
            return MsgUserRole.BRANCH_HEADER;
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
        if (cascadeAccount.getAccountType() == 3) {
            return MsgUserRole.MANAGER;
        }
        return MsgUserRole.STAFF;
    }

    private Set<Integer> getHeadTeachers(Long orgId, Long userId) {
        List orgCourseIds = this.studentCourseDao.getOrgCourseIds(orgId, userId, null);
        List courseIds = ListUtil.toKeyList((Collection)orgCourseIds, (String)"courseId", OrgStudentCourse.class);
        List courses = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"cascadeId"});
        HashSet<Integer> set = new HashSet<Integer>();
        if (courses != null && courses.size() > 0) {
            for (OrgCourse course : courses) {
                if (course.getCascadeId() == null || course.getCascadeId() < 0) continue;
                set.add(course.getCascadeId());
            }
        }
        return set;
    }

    private String getMessage(String name) {
        return "\u60a8\u7684\u6d88\u606f\u65e0\u6cd5\u9001\u8fbe\uff0c" + name + "\u4e3a\u5bf9\u65b9\u7684\u8054\u7cfb\u4eba\uff0c\u4ec5" + name + "\u53ef\u4e0e\u5bf9\u65b9\u8054\u7cfb";
    }

    private String getActivityOrCourseContent(String orgName, CardMsgContent card) {
        StringBuilder sb = new StringBuilder();
        String url = null;
        url = card.getType() == CardType.ACTIVITY.getValue() ? this.getWechatUrl(card.getAction()) : card.getAction();
        sb.append(orgName).append("\u7ed9\u60a8\u53d1\u9001\u4e86").append(this.getCardDesc(card.getType())).append("\n").append("\u3010").append(card.getTitle()).append("\u3011").append("\n\n").append(this.getHrefLink(url, "\u70b9\u51fb\u6b64\u5904\u67e5\u770b"));
        return sb.toString();
    }

    private String getWechatUrl(String action) {
        int templateId;
        Map<String, String> map = this.parseParams(action);
        int activityId = Integer.parseInt(map.get("activityId"));
        CustomActivityDto dto = this.customActivityService.getCustomActivity(activityId, templateId = Integer.parseInt(map.get("templateId")));
        if (dto != null) {
            return dto.getWebAuthUrl();
        }
        return this.removeParam("templateId", action);
    }

    private Map<String, String> parseParams(String action) {
        log.info("[Wechat] Activity URL=", (Object)action);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            List params = URLEncodedUtils.parse((URI)new URI(action), (String)"UTF-8");
            if (params != null) {
                for (NameValuePair pair : params) {
                    map.put(pair.getName(), pair.getValue());
                }
            }
        }
        catch (URISyntaxException e) {
            log.error("URISyntaxException", (Throwable)e);
        }
        return map;
    }

    public String removeParam(String param, String action) {
        action = action.replaceAll("#!/", "");
        String url = action.split("\\?")[0];
        try {
            List params = URLEncodedUtils.parse((URI)new URI(action), (String)"UTF-8");
            if (params != null) {
                for (NameValuePair pair : params) {
                    if (!param.equals(pair.getName())) continue;
                    params.remove(pair);
                    break;
                }
            }
            String paramsStr = URLEncodedUtils.format((List)params, (String)"UTF-8");
            url = url + "?" + paramsStr + "#!/";
        }
        catch (URISyntaxException e) {
            log.error("URISyntaxException", (Throwable)e);
        }
        return url;
    }

    private String getHrefLink(String href, String content) {
        String link = "<a href=\"%s\">%s</a>";
        return String.format(link, href, content);
    }

    private String getCardDesc(int type) {
        CardType cardType = CardType.getTypeByValue((int)type);
        switch (cardType) {
            case ACTIVITY: {
                return "\u6d3b\u52a8";
            }
            case COURSE: {
                return "\u8bfe\u7a0b";
            }
        }
        throw new RuntimeException("CardType exception.CardType=" + cardType);
    }
}

