/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.wechat.dto.msgtoapp.MessageDto;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.util.Date;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wechatMsgConsumeService")
public class WechatMsgServiceImpl
extends AbstractConsultService<MessageDto> {
    private static final Logger log = LoggerFactory.getLogger(WechatMsgServiceImpl.class);
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private ConsulterAPIService consulterAPIService;

    @Override
    public MessageSource getConsultType() {
        return MessageSource.WECHAT;
    }

    @Override
    protected ConsultMessage buildPushMessageContent(MessageDto msg, Long consultUserId) {
        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setConsultType(this.getConsultType().getValue());
        pushMsg.setCreateTime(new Date(msg.getTime()));
        pushMsg.setMsgType(msg.getMsgT());
        pushMsg.setHeight(msg.getContent().getHeight());
        pushMsg.setLength(msg.getContent().getLength());
        pushMsg.setContent(msg.getContent().getText());
        pushMsg.setUrl(msg.getContent().getUrl());
        pushMsg.setWidth(msg.getContent().getWidth());
        return pushMsg;
    }

    private MsgUser builderSender(MessageDto dto) {
        TxConsultUser txConsultUser = new TxConsultUser();
        txConsultUser = new TxConsultUser();
        txConsultUser.setName(dto.getNick());
        txConsultUser.setOrgId(new Long(dto.getOrgId()));
        txConsultUser.setWeixinOpenId(dto.getWechatOpenId());
        txConsultUser.setWeixinNickName(dto.getNick());
        txConsultUser.setConsultSource(Integer.valueOf(MessageSource.WECHAT.getValue()));
        if (StringUtils.isNotBlank((CharSequence)dto.getWechatAppid())) {
            txConsultUser.setWeixinAppId(dto.getWechatAppid());
        } else {
            Fans fans = this.fansDao.getByOpenId(dto.getWechatOpenId());
            if (fans != null) {
                txConsultUser.setWeixinAppId(fans.getAuthorizerAppId());
            }
        }
        TxConsultUser result = (TxConsultUser)this.consulterAPIService.saveOrUpdateByWechatOpenId(txConsultUser).getData();
        log.info("[Wechat Message] result : {} ", (Object)result);
        return ConsulterDto.convertToDto(result);
    }

    private MsgUser buildOrgMsgUser(@NonNull Long orgId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"orgId", "shortName"});
        if (orgInfo == null) {
            log.warn("can not get org info by orgId:{}", (Object)orgId);
            return null;
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        return this.buildReceiver(orgInfo, orgAccount.getNumber().longValue());
    }

    @Override
    public boolean consume(MessageDto message) {
        if (message == null || StringUtils.isBlank((CharSequence)message.getWechatOpenId())) {
            throw new IllegalArgumentException(" no weixin open id .");
        }
        MsgUser receiver = this.buildOrgMsgUser(new Long(message.getOrgId()));
        MsgUser sender = this.builderSender(message);
        if (sender == null || receiver == null) {
            log.warn("sender :{} or receiver:{} is null,skip wechat  msg:{}", new Object[]{sender, receiver, message});
            return false;
        }
        ConsultMessage msgContent = this.buildPushMessageContent(message, sender.getUserId());
        log.info("consume wechat msg sender:{},receiver:{},msgContent:{}", new Object[]{sender.getName(), receiver, msgContent});
        boolean result = this.consultMessageService.sendConsultMessage(sender, receiver, msgContent);
        log.info("push wechat msg:{},sender:{},receiver:{},result:{}", new Object[]{msgContent, sender, receiver, result});
        return result;
    }

    @Override
    public MessageDto transfer(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        try {
            return (MessageDto)JacksonUtil.str2Obj((String)body, MessageDto.class);
        }
        catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", (Object)body, (Object)e);
            return null;
        }
    }
}

