/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.dto.ConsultUserDetailDto;
import com.baijia.tianxiao.biz.consult.dto.MessageRecordDto;
import com.baijia.tianxiao.biz.consult.msg.service.ConsultMsgService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.CardType;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.constant.MsgUserType;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dto.ConsultMessageDto;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.solr.enums.TimeType;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.sal.push.utils.MsgContentFactory;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsultMsgServiceImpl
implements ConsultMsgService {
    private static final Logger log = LoggerFactory.getLogger(ConsultMsgServiceImpl.class);
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao orgTxCascadeCredentialDao;
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private ConsultAvatarUrlService consultAvatarUrlService;
    @Autowired
    private TxCascadeCredentialService credentialService;

    @Override
    public List<MessageRecordDto> getMessageRecordDtoList(Long orgId) {
        List txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);
        HashMap<Integer, TXCascadeAccount> txCascadeAccountMap = new HashMap<Integer, TXCascadeAccount>();
        HashMap<Integer, TXCascadeCredential> txCascadeCredentialMap = new HashMap<Integer, TXCascadeCredential>();
        ArrayList<Integer> credentialIds = new ArrayList<Integer>();
        if (GenericsUtils.notNullAndEmpty((Object)txCascadeAccounts)) {
            for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
                credentialIds.add(txCascadeAccount.getCredentialId());
                txCascadeAccountMap.put(txCascadeAccount.getId(), txCascadeAccount);
            }
            List txCascadeCredentials = this.orgTxCascadeCredentialDao.getTxCascadCredentialListByCredentialIds(credentialIds);
            for (TXCascadeCredential txCascadeCredential : txCascadeCredentials) {
                Integer credentialId = txCascadeCredential.getId();
                txCascadeCredentialMap.put(credentialId, txCascadeCredential);
            }
        }
        log.info("credentialIds params{}", credentialIds);
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        Integer orgNumber = orgAccount.getNumber();
        OrgSubAccount orgSubAccount = this.orgSubAccountDao.getMasterByOrgId(Integer.valueOf(orgId.intValue()));
        int orgType = GenericsUtils.notNullAndEmpty((Object)orgSubAccount) ? MsgUserRole.HEADER.getValue() : MsgUserRole.BRANCH_HEADER.getValue();
        HashMap<Integer, MessageRecordDto> messageRecordMap = new HashMap<Integer, MessageRecordDto>();
        log.info("orgId param:{}, orgType param {}", (Object)orgId, (Object)orgType);
        HashSet<Long> consultIds = new HashSet<Long>();
        boolean isShow = this.credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        List consultMessagesByOrgNumber = this.messageDao.getMsgDtoByOrgNumberOrCacadeId(orgNumber, Integer.valueOf(orgType), this.getConsultRoles());
        log.info("consultMessagesByOrgNumber params{}", (Object)consultMessagesByOrgNumber);
        if (GenericsUtils.notNullAndEmpty((Object)consultMessagesByOrgNumber)) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[0]);
            MessageRecordDto messageRecordDto = MessageRecordDto.buildInstanceByOrg(orgInfo, orgNumber, orgType);
            messageRecordMap.put(orgNumber, messageRecordDto);
            int count = 1;
            boolean hasMore = false;
            ArrayList<ConsultUserDetailDto> list = new ArrayList<ConsultUserDetailDto>();
            for (ConsultMessageDto consultMessageDto : consultMessagesByOrgNumber) {
                if (count <= 3) {
                    ConsultUserDetailDto consultUserDetailDto = this.buildConsultUserDetailDto(consultMessageDto, isShow);
                    consultIds.add(consultMessageDto.getConsultId());
                    list.add(consultUserDetailDto);
                } else {
                    hasMore = true;
                }
                ++count;
            }
            messageRecordDto.setList(list);
            messageRecordDto.setHasMore(hasMore);
            log.info("orgNumber param:{}, messageRecordMap param:{}", (Object)orgNumber, messageRecordMap);
        }
        if (GenericsUtils.notNullAndEmpty(txCascadeAccountMap)) {
            for (Integer casId : txCascadeAccountMap.keySet()) {
                TXCascadeAccount txCascadeAccount = (TXCascadeAccount)txCascadeAccountMap.get(casId);
                Integer type = txCascadeAccount.getAccountType();
                log.info("casId param:{}, cascadeType param:{}", (Object)casId, (Object)type);
                List<Integer> consultRoles = this.getConsultRoles();
                List consultMessagesByCascadeId = this.messageDao.getMsgDtoByOrgNumberOrCacadeId(casId, type, consultRoles);
                log.info("casId param:{}, consultMessagesByCascadeId params:{}", (Object)casId, (Object)consultMessagesByCascadeId);
                if (!GenericsUtils.notNullAndEmpty((Object)consultMessagesByCascadeId)) continue;
                int count = 1;
                boolean hasMore = false;
                Integer credentialId = txCascadeAccount.getCredentialId();
                TXCascadeCredential txCascadeCredential = (TXCascadeCredential)txCascadeCredentialMap.get(credentialId);
                MessageRecordDto messageRecordDto = new MessageRecordDto();
                messageRecordMap.put(casId, messageRecordDto);
                messageRecordDto.setName(txCascadeCredential.getName() == null ? "" : txCascadeCredential.getName());
                messageRecordDto.setUserId(casId);
                messageRecordDto.setAvatarUrl("http://img.gsxservice.com/11868862_i0x2qxlp.png");
                messageRecordDto.setUserRole(type);
                messageRecordDto.setUserTypeString(MsgUserRole.getByCode((Integer)type).getDesc());
                ArrayList<ConsultUserDetailDto> list = new ArrayList<ConsultUserDetailDto>();
                for (ConsultMessageDto consultMessageDto : consultMessagesByCascadeId) {
                    if (count <= 3) {
                        ConsultUserDetailDto consultUserDetailDto = this.buildConsultUserDetailDto(consultMessageDto, isShow);
                        consultIds.add(consultMessageDto.getConsultId());
                        list.add(consultUserDetailDto);
                    } else {
                        hasMore = true;
                    }
                    ++count;
                }
                messageRecordDto.setList(list);
                messageRecordDto.setHasMore(hasMore);
                log.info("casId param:{}, messageRecordMap params:{}", (Object)casId, messageRecordMap);
            }
        }
        if (GenericsUtils.isNullOrEmpty(messageRecordMap)) {
            log.info("messageRecordMap \u4e3a\u7a7a");
            return Collections.EMPTY_LIST;
        }
        Map avatarUrlNameMobiledtoMap = this.consultAvatarUrlService.batchConsultAvatarUrlAndNameDtoMap(consultIds, orgId);
        ArrayList<MessageRecordDto> messageRecordDtos = new ArrayList<MessageRecordDto>();
        for (Integer userId : messageRecordMap.keySet()) {
            MessageRecordDto messageRecordDto = (MessageRecordDto)messageRecordMap.get(userId);
            List<ConsultUserDetailDto> list = messageRecordDto.getList();
            for (ConsultUserDetailDto consultUserDetailDto : list) {
                Long consultId = consultUserDetailDto.getUserId();
                ConsultAvatarUrlAndNameDto dto = (ConsultAvatarUrlAndNameDto)avatarUrlNameMobiledtoMap.get(consultId);
                consultUserDetailDto.setAvatarUrl(dto.getAvatarUrl());
                consultUserDetailDto.setName(dto.getName());
            }
            messageRecordDtos.add(messageRecordDto);
        }
        Comparator<MessageRecordDto> sortOfMessageRecordDto = new Comparator<MessageRecordDto>(){

            @Override
            public int compare(MessageRecordDto o1, MessageRecordDto o2) {
                Long createTime1 = o1.getList().get(0).getCreateTime();
                Long createTime2 = o2.getList().get(0).getCreateTime();
                return createTime1 - createTime2 >= 0L ? 1 : -1;
            }
        };
        Collections.sort(messageRecordDtos, sortOfMessageRecordDto);
        Collections.reverse(messageRecordDtos);
        return messageRecordDtos;
    }

    @Override
    public List<ConsultUserDetailDto> getConsultUserDetailDtos(Long orgId, Integer userId, Integer userType, Integer typeSource, PageDto pageDto, Integer timeType) {
        List<Integer> consultRoles;
        Integer count;
        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        int limit = pageDto.getPageSize();
        Date startTime = null;
        Date endTime = null;
        if (GenericsUtils.notNullAndEmpty((Object)timeType)) {
            TimeType receiveTime = TimeType.getTimeTypeByCode((Integer)timeType);
            TimeRange range = receiveTime.timeRange();
            startTime = range.getStartTime();
            endTime = range.getEndTime();
        }
        pageDto.setCount(Integer.valueOf((count = this.messageDao.getMsgTotal(userId, userType, consultRoles = this.getConsultRoles(), typeSource, startTime, endTime)) == null ? 0 : count));
        if (count == 0) {
            return Collections.EMPTY_LIST;
        }
        log.info("count param:{}", (Object)count);
        boolean isShow = this.credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        List consultMessageDtos = this.messageDao.getMsgListByFilter(userId, userType, consultRoles, typeSource, startTime, endTime, Integer.valueOf(start), Integer.valueOf(limit));
        HashSet<Long> consultIds = new HashSet<Long>();
        ArrayList<ConsultUserDetailDto> consultUserDetailDtos = new ArrayList<ConsultUserDetailDto>();
        if (GenericsUtils.isNullOrEmpty((Object)consultMessageDtos)) {
            return Collections.EMPTY_LIST;
        }
        for (ConsultMessageDto consultMessageDto : consultMessageDtos) {
            ConsultUserDetailDto consultUserDetailDto = this.buildConsultUserDetailDto(consultMessageDto, isShow);
            consultIds.add(consultMessageDto.getConsultId());
            consultUserDetailDtos.add(consultUserDetailDto);
        }
        Map avatarUrlNameMobiledtoMap = this.consultAvatarUrlService.batchConsultAvatarUrlAndNameDtoMap(consultIds, orgId);
        for (ConsultUserDetailDto consultUserDetailDto : consultUserDetailDtos) {
            Long consultId = consultUserDetailDto.getUserId();
            ConsultAvatarUrlAndNameDto dto = (ConsultAvatarUrlAndNameDto)avatarUrlNameMobiledtoMap.get(consultId);
            consultUserDetailDto.setAvatarUrl(dto.getAvatarUrl());
            consultUserDetailDto.setName(dto.getName());
        }
        return consultUserDetailDtos;
    }

    private List<Integer> getConsultRoles() {
        Set consultSet = MsgUserRole.getStuUsers();
        List consultRoles = MsgUserRole.getRoles((Collection)consultSet);
        return consultRoles;
    }

    private ConsultUserDetailDto buildConsultUserDetailDto(ConsultMessageDto consultMessageDto, boolean isShow) {
        String text;
        ConsultUserDetailDto consultUserDetailDto = new ConsultUserDetailDto();
        consultUserDetailDto.setUserId(consultMessageDto.getConsultId());
        Integer msgType = consultMessageDto.getMsgType();
        String msgTypeString = MsgType.getTypeByValue((int)msgType).getDesc();
        consultUserDetailDto.setMsgTypeString(msgTypeString);
        consultUserDetailDto.setMsgType(msgType);
        if (msgType.intValue() == MsgType.CARD.getValue()) {
            Gson gson = new Gson();
            CardMsgContent msgContent = (CardMsgContent)gson.fromJson(consultMessageDto.getText(), CardMsgContent.class);
            consultUserDetailDto.setCardType(msgContent.getType());
            CardType cardType = CardType.getTypeByValue((int)msgContent.getType());
            if (GenericsUtils.notNullAndEmpty((Object)cardType)) {
                consultUserDetailDto.setCardTypeString(cardType.getDesc());
            }
        }
        consultUserDetailDto.setContent((text = MsgContentFactory.getContentByConsultMessageDto((ConsultMessageDto)consultMessageDto)) == null ? "" : text);
        if (consultMessageDto.getMsgType().intValue() == MsgType.CARD.getValue() && !isShow) {
            consultUserDetailDto.setContent(MsgContentFactory.maskMobile((String)text));
        }
        int userRole = consultMessageDto.getConsultRole();
        consultUserDetailDto.setUserRole(userRole);
        consultUserDetailDto.setUserType(MsgUserType.getUserType((int)userRole).getValue());
        MsgUserRole msgUserRole = MsgUserRole.getByCode((Integer)userRole);
        consultUserDetailDto.setUserTypeString(MsgUserRole.getText((MsgUserRole)msgUserRole));
        int type = consultMessageDto.getConsultType();
        consultUserDetailDto.setType(type);
        MessageSource source = MessageSource.getByType((Integer)type);
        String typeDesc = MessageSource.getText((MessageSource)source);
        if (GenericsUtils.notNullAndEmpty((Object)typeDesc)) {
            consultUserDetailDto.setTypeString(typeDesc);
        } else {
            consultUserDetailDto.setTypeString(source.getDesc());
        }
        consultUserDetailDto.setCreateTime(consultMessageDto.getCreate_time().getTime());
        return consultUserDetailDto;
    }
}

