/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.service.impl;

import com.baijia.tianxiao.biz.consult.dto.response.ConsultCallRecordDto;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserCallRecordService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.callservice.constant.ConsultCallRecordManner;
import com.baijia.tianxiao.dal.callservice.dao.ConsultCallRecordDao;
import com.baijia.tianxiao.dal.callservice.po.ConsultCallRecord;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultUserCallRecordServiceImpl
implements ConsultUserCallRecordService {
    private static final Logger log = LoggerFactory.getLogger(ConsultUserCallRecordServiceImpl.class);
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private ConsultCallRecordDao consultCallRecordDao;

    @Override
    public List<ConsultCallRecordDto> listConsultCallRecord(Long orgId, Long cascadeId, Long studentId, Long consulterId) {
        ArrayList<ConsultCallRecordDto> dtoList = new ArrayList<ConsultCallRecordDto>();
        List list = this.consultCallRecordDao.listBy(orgId, studentId, consulterId);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ConsultCallRecordDto dto = null;
            for (ConsultCallRecord record : list) {
                dto = new ConsultCallRecordDto();
                dto.setCallStatus(record.getCallStatus());
                dto.setCreateTime(record.getCreateTime().getTime());
                dto.setId(record.getId());
                dto.setSeconds(record.getDuringTime());
                if (record.getIsCallByOrg().intValue() == Flag.TRUE.getInt()) {
                    dto.setCallManner(ConsultCallRecordManner.CALL.getCode());
                } else {
                    dto.setCallManner(ConsultCallRecordManner.ANSWER.getCode());
                }
                if (record.getStorageId() != null && record.getStorageId() > 0L) {
                    dto.setSoundId(record.getStorageId());
                    OrgStorage orgStorage = (OrgStorage)this.orgStorageDao.getById((Serializable)record.getStorageId(), new String[0]);
                    dto.setSoundUrl(StorageUtil.constructUrl((OrgStorage)orgStorage));
                }
                dtoList.add(dto);
            }
        }
        return dtoList;
    }

    @Override
    @Transactional
    public void saveOrUpdate(ConsultCallRecord record) {
        this.consultCallRecordDao.saveOrUpdate((Object)record, new String[0]);
    }
}

