/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.pc.service.impl;

import com.baijia.tianxiao.biz.consult.enums.GenderStatus;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultListResponseDto;
import com.baijia.tianxiao.biz.consult.user.pc.service.ClueService;
import com.baijia.tianxiao.common.service.ImportDataProcessService;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.baidu.Location;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.push.service.impl.ConsultMessageServiceImpl;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.util.ExcelUtils;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.baidu.BaiduMapUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImportClueServiceImpl
implements ImportDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(ImportClueServiceImpl.class);
    public static final String CLUE_IMPORT_TEMPLATE_PATH = "/excel/consult_import.xlsx";
    public static final String CLUE_RESULT_TEMPLATE_PATH = "/excel/consult_result.xlsx";
    @Autowired
    private AreaDao areaDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private ConsultMessageServiceImpl messageService;
    private static final Map<String, Map<String, Object>> cache = Maps.newHashMap();
    private static final ImportDataProcessService.SingleSaveErrorResult IMPORT_SUCCESS = ImportDataProcessService.SingleSaveErrorResult.createSuccessResult((String)"\u5bfc\u5165\u6210\u529f");
    private static final ImportDataProcessService.SingleSaveErrorResult IMPORT_FAIL = ImportDataProcessService.SingleSaveErrorResult.createFailResult((String)"\u5bfc\u5165\u5931\u8d25");
    private static final ImportDataProcessService.SingleSaveErrorResult CLUE_EXSIST = new ImportDataProcessService.SingleSaveErrorResult(true, "\u7ebf\u7d22\u5df2\u5b58\u5728");
    @Autowired
    private ClueService clueService;

    public DataProcType getProcessType() {
        return DataProcType.CONSULT;
    }

    public boolean validateHeader(List<String> headers) {
        if (CollectionUtils.isEmpty(headers)) {
            return false;
        }
        int index = 0;
        for (String header : headers) {
            if (!cache.containsKey(header.trim())) {
                log.debug("validateHeader = {},{}", (Object)index, (Object)header.trim());
                return false;
            }
            Map<String, Object> item = cache.get(header);
            int sequence = (Integer)item.get("index");
            if (index != sequence) {
                log.debug("validateHeader = {},{}", (Object)index, (Object)sequence);
                return false;
            }
            ++index;
        }
        return true;
    }

    public ImportDataProcessService.SingleSaveErrorResult saveSingleData(Long orgId, Long cascadeId, List<String> headers, Object[] lineData, boolean updateRepeat) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId.");
        Preconditions.checkArgument((lineData != null && lineData.length > 0 ? 1 : 0) != 0, (Object)"lineData \u4e3a\u7a7a");
        try {
            ConsultListResponseDto consultUser = new ConsultListResponseDto();
            this.buildConsultDto(cascadeId, consultUser, lineData, headers, updateRepeat, orgId);
            Date nextRemindTime = new Date();
            nextRemindTime = new Date(nextRemindTime.getTime() - 300000L);
            consultUser.setNextRemindTimeStr(nextRemindTime);
            consultUser.setNextRemindTime(nextRemindTime.getTime());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)consultUser.getTagsStr())) {
                String[] tags = consultUser.getTagsStr().replaceAll("\uff0c", ",").split(",");
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (String t : tags) {
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)t)) continue;
                    map.put(t, "");
                }
                StringBuilder builder = new StringBuilder();
                ArrayList<TagInfoDto> list = new ArrayList<TagInfoDto>();
                for (String t : map.keySet()) {
                    TagInfoDto dto = new TagInfoDto();
                    dto.setContent(t);
                    list.add(dto);
                }
                consultUser.setTagsStr(JacksonUtil.obj2Str(list));
            }
            this.clueService.addClueInfo(orgId, consultUser, updateRepeat);
        }
        catch (BussinessException ex) {
            if (ex.getErrorCode().getSubsystemErrorCode() == CrmErrorCode.CUSTOM_HAS_EXISTS.getSubsystemErrorCode()) {
                return new ImportDataProcessService.SingleSaveErrorResult(true, "\u7ebf\u7d22\u5df2\u5b58\u5728");
            }
            log.warn("save clue error:{}", (Throwable)ex);
            return ImportDataProcessService.SingleSaveErrorResult.createFailResult((String)ex.getMessage());
        }
        catch (Exception ex) {
            log.warn("save clue error:{}", (Throwable)ex);
            return IMPORT_FAIL;
        }
        return IMPORT_SUCCESS;
    }

    private int getAreaId(String region, int level) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)region) || level == 0) {
            return 0;
        }
        List areas = this.areaDao.getAreaByBname(region, level);
        if (CollectionUtils.isNotEmpty((Collection)areas)) {
            return ((Area)areas.get(0)).getId();
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildConsultDto(Long cascadeId, ConsultListResponseDto dto, Object[] lineData, List<String> headers, boolean updateRepeat, Long orgId) {
        Preconditions.checkArgument((lineData.length == headers.size() ? 1 : 0) != 0, (Object)"\u6570\u636e\u6570\u76ee\u548c\u8868\u5934\u4e0d\u5339\u914d");
        Preconditions.checkArgument((boolean)this.validateHeader(headers), (Object)("\u8868\u5934\u683c\u5f0f\u9519\u8bef:" + headers.toString()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss 'CST' yyyy", Locale.ENGLISH);
        for (int i = 0; i < lineData.length; ++i) {
            String fieldName = cache.get(headers.get(i)).get("propName").toString();
            boolean empty = Boolean.parseBoolean(cache.get(headers.get(i)).get("empty").toString());
            String name = headers.get(i);
            Object value = lineData[i];
            if (fieldName == null) continue;
            if (fieldName.equals("birthday") && lineData[i] != null && !lineData[i].equals("")) {
                try {
                    Date date = dateFormat.parse(lineData[i].toString());
                    dto.setBirthdayStr(dateFormat.parse(lineData[i].toString()));
                    dto.setBirthday(date.getTime());
                    lineData[i] = lineData[i].toString();
                }
                catch (Exception e) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u751f\u65e5\u3011\u683c\u5f0f\u6709\u8bef\uff0c\u9700\u4e3a2001/1/1\u6216\u80052001-1-1\u6837\u5f0f");
                }
            }
            if (empty && (value == null || "".equals(value))) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + name + "\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                if (value == null || value instanceof String && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)value))) continue;
                BeanUtils.setProperty((Object)dto, (String)fieldName, (Object)value);
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.warn("set ConsultInfoResponseDto.{} = {} failed!", (Object)fieldName, value);
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.getName())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u59d3\u540d\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getName().length() > 15) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u59d3\u540d\u3011\u6700\u591a\u8f93\u516515\u4e2a\u5b57\u7b26");
        }
        if (!StringUtils.hanziAndLetterValidate((String)dto.getName())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u59d3\u540d\u3011\u53ea\u5141\u8bb8\u82f1\u6587\u5b57\u6bcd\u3001\u6c49\u5b57\u548c\u6570\u5b57");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getMobile().length() != 11) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u9700\u4e3a11\u4f4d\u6570\u5b57");
        }
        if (!dto.getMobile().startsWith("1")) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u5fc5\u987b\u4ee51\u5f00\u5934");
        }
        if (!ParamValidateUtils.validateMobile((String)dto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u7a7a\u683c");
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getSexStr())) {
            if (dto.getSexStr().equals(GenderStatus.FEMAN.getName())) {
                dto.setSex(GenderStatus.FEMAN.getCode());
            } else {
                if (!dto.getSexStr().equals(GenderStatus.MAN.getName())) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6027\u522b\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
                dto.setSex(GenderStatus.MAN.getCode());
            }
        } else {
            dto.setSex(GenderStatus.NONE.getCode());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getConsultStatusStr())) {
            if (ConsultUserStatus.getValue((String)dto.getConsultStatusStr()) == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u8ddf\u8fdb\u72b6\u6001\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
            }
            dto.setConsultStatus(ConsultUserStatus.getValue((String)dto.getConsultStatusStr()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getIntensionLevelStr())) {
            if (IntentionLevel.getValue((String)dto.getIntensionLevelStr()) == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u610f\u5411\u7ea7\u522b\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
            }
            dto.setIntensionLevel(IntentionLevel.getValue((String)dto.getIntensionLevelStr()));
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.getCascadeIdStr())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6240\u5c5e\u4eba\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("\u81ea\u5df1".equals(dto.getCascadeIdStr())) {
            dto.setCascadeId(TianxiaoPCContext.getTXCascadeId() == null ? 0L : (long)TianxiaoPCContext.getTXCascadeId().intValue());
        } else {
            if (!"\u516c\u6d77".equals(dto.getCascadeIdStr())) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6240\u5c5e\u4eba\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
            dto.setCascadeId(-1L);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getTagsStr())) {
            String[] tags = dto.getTagsStr().split("[,|\uff0c]");
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String t : tags) {
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)t)) continue;
                map.put(t, "");
            }
            if (map.keySet().size() > 30) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6807\u7b7e\u3011\u6700\u591a\u8f93\u516530\u4e2a\u6807\u7b7e");
            }
            for (String tag : map.keySet()) {
                if (!StringUtils.hanziAndLetterValidate((String)tag)) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6807\u7b7e\u3011\u591a\u4e2a\u6807\u7b7e\u7528\u9017\u53f7\u8fdb\u884c\u95f4\u9694\uff0c\u4e0d\u80fd\u5305\u542b\u5176\u4ed6\u7279\u6b8a\u5b57\u7b26\u6216\u7a7a\u683c");
                }
                if (tag.length() <= 15) continue;
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6807\u7b7e\u3011\u5355\u4e2a\u6807\u7b7e\u6700\u591a\u8f93\u516515\u4e2a\u5b57\u7b26");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getRelativesStr())) {
            if (Relatives.getValue((String)dto.getRelativesStr()) == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u4eb2\u5c5e\u5173\u7cfb\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
            }
            dto.setRelatives(Relatives.getValue((String)dto.getRelativesStr()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getParentName())) {
            if (dto.getParentName().length() > 15) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u59d3\u540d\u3011\u6700\u591a\u8f93\u516515\u4e2a\u5b57\u7b26");
            }
            if (!StringUtils.hanziAndLetterValidate((String)dto.getParentName())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u59d3\u540d\u3011\u53ea\u5141\u8bb8\u82f1\u6587\u5b57\u6bcd\u3001\u6c49\u5b57\u548c\u6570\u5b57");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getParentMobile())) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dto.getParentMobile())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (dto.getParentMobile().length() != 11) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u9700\u4e3a11\u4f4d\u6570\u5b57");
            }
            if (!dto.getParentMobile().startsWith("1")) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u5fc5\u987b\u4ee51\u5f00\u5934");
            }
            if (!ParamValidateUtils.validateMobile((String)dto.getParentMobile())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u7a7a\u683c");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getSchool())) {
            if (dto.getSchool().length() > 15) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u516c\u7acb\u5b66\u6821\u3011\u6700\u591a\u8f93\u516515\u4e2a\u5b57\u7b26");
            }
            if (!StringUtils.hanziAndLetterValidate((String)dto.getSchool())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u516c\u7acb\u5b66\u6821\u3011\u53ea\u5141\u8bb8\u82f1\u6587\u5b57\u6bcd\u3001\u6c49\u5b57\u548c\u6570\u5b57");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getDegreeClass())) {
            if (dto.getDegreeClass().length() > 15) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5e74\u7ea7\u3011\u6700\u591a\u8f93\u516515\u4e2a\u5b57\u7b26");
            }
            if (!StringUtils.hanziAndLetterValidate((String)dto.getDegreeClass())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5e74\u7ea7\u3011\u53ea\u5141\u8bb8\u82f1\u6587\u5b57\u6bcd\u3001\u6c49\u5b57\u548c\u6570\u5b57");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getQq())) {
            if (dto.getQq().length() > 15) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010QQ\u3011\u6700\u591a\u8f93\u516515\u4e2a\u5b57\u7b26");
            }
            if (!Pattern.matches("^[0-9]*$", dto.getQq())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010QQ\u3011\u9700\u586b\u5199\u6570\u5b57");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getMail())) {
            if (dto.getMail().length() > 50) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u90ae\u7bb1\u3011\u6700\u591a\u8f93\u516550\u4e2a\u5b57\u7b26");
            }
            if (!Pattern.matches("^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$", dto.getMail())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u90ae\u7bb1\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        String province = dto.getProvince();
        String city = dto.getCity();
        String county = dto.getCounty();
        String address = dto.getAddress();
        String region = "";
        int level = 0;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)county)) {
            region = county;
            level = AreaUtils.AreaLevel.COUNTY.ordinal();
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)city)) {
            region = city;
            level = AreaUtils.AreaLevel.CITY.ordinal();
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)province)) {
            region = province;
            level = AreaUtils.AreaLevel.PROVINCE.ordinal();
        }
        int areaId = this.getAreaId(region, level);
        try {
            Location location = BaiduMapUtils.getLngAndLat((String)address, (String)region);
            if (location != null) {
                dto.setLatitude(location.getLat());
                dto.setLongitude(location.getLng());
            }
            dto.setAreaId(areaId);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        dto.setConsultSource(MessageSource.IMPORT.getValue());
        List targets = this.txConsultUserDao.lookByMobile(orgId, dto.getMobile(), new String[0]);
        if (!updateRepeat) {
            if (targets == null || targets.isEmpty()) return;
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u3010\u624b\u673a\u53f7\u3011\u8be5\u624b\u673a\u53f7\u5df2\u5bf9\u5e94\u5176\u4ed6\u7ebf\u7d22");
        }
        if (targets.size() > 1) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u3010\u624b\u673a\u53f7\u3011\u8be5\u624b\u673a\u53f7\u5df2\u5bf9\u5e94\u591a\u6761\u7ebf\u7d22,\u65e0\u6cd5\u5904\u7406");
        }
        if (targets.size() != 1 || ((TxConsultUser)targets.get(0)).getDelStatus() != 0 || ((TxConsultUser)targets.get(0)).getCascadeId().equals(-1) || dto.getCascadeId() == ((TxConsultUser)targets.get(0)).getCascadeId().longValue()) return;
        throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u8be5\u7ebf\u7d22\u5df2\u5b58\u5728\uff0c\u4e14\u5f52\u5c5e\u4e8e\u4ed6\u4eba");
    }

    public ImportDataProcessService.BatchSaveResult batchImportDatas(Long orgId, Long cascadeId, List<String> headers, List<Object[]> datas, boolean updateRepeat) {
        ImportDataProcessService.BatchSaveResult batchSaveResult = new ImportDataProcessService.BatchSaveResult();
        for (int i = 0; i < datas.size(); ++i) {
            Object[] data = datas.get(i);
            try {
                ImportDataProcessService.SingleSaveErrorResult singleSaveErrorResult = this.saveSingleData(orgId, cascadeId, headers, data, updateRepeat);
                if (!singleSaveErrorResult.isRepeat()) continue;
                batchSaveResult.getRepeatIndexs().add(i);
                continue;
            }
            catch (Throwable ex) {
                batchSaveResult.getFailIndexs().add(i);
            }
        }
        return batchSaveResult;
    }

    public void afterComplete() {
        log.info("[Notice] Batch notice");
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("clue_category", 2);
        this.messageService.sendNotice(Long.valueOf(TianxiaoPCContext.getOrgId().longValue()), Integer.valueOf(-1), NoticeMsgContent.createNoticeContent((NoticeType)NoticeType.BATCH_IMPORT, (String)ActionUtil.getAction((String)"action_to_crm_clue_list", param)));
    }

    public int[] getUniqueIndex() {
        return new int[]{1};
    }

    public ImportDataProcessService.SingleSaveErrorResult validate(Long orgId, Long cascadeId, List<String> headers, ImportDataProcessService.SingleSaveErrorResult result, List<ImportDataProcessService.SingleSaveErrorResult> dataList, boolean updateRepeat) {
        result.setSuccess(true);
        try {
            this.buildConsultDto(cascadeId, new ConsultListResponseDto(), result.getLineData(), headers, updateRepeat, orgId);
        }
        catch (BussinessException e) {
            result.setSuccess(false);
            result.setErrorMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            result.setSuccess(false);
            result.setErrorMsg(CommonErrorCode.SYSTEM_ERROR.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadValidateResult(OutputStream os, Long orgId, String taskId, Collection<ImportDataProcessService.SingleSaveErrorResult> data) {
        InputStream in = null;
        try {
            int demoRowNo;
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(CLUE_RESULT_TEMPLATE_PATH);
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(1);
            XSSFRow row = null;
            int rowNo = demoRowNo = 2;
            int cellNo = 0;
            Map demoFormatMap = ExcelUtils.getCellInfoMap((XSSFSheet)sheet, (int)demoRowNo, (int)0, (int)25);
            XSSFCellStyle cellStyle = null;
            Object value = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss 'CST' yyyy", Locale.ENGLISH);
            for (ImportDataProcessService.SingleSaveErrorResult result : data) {
                if (result.isSuccess()) continue;
                if (sheet.getRow(rowNo) == null) {
                    row = sheet.createRow(rowNo);
                }
                cellNo = 0;
                for (int i = 0; i <= result.getLineData().length; ++i) {
                    value = i == 0 ? result.getErrorMsg() : result.getLineData()[i - 1];
                    if (sheet.getRow(demoRowNo).getCell(cellNo) == null) {
                        sheet.getRow(demoRowNo).createCell(cellNo);
                    }
                    cellStyle = sheet.getRow(demoRowNo).getCell(cellNo).getCellStyle();
                    cellStyle = ExcelUtils.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap);
                    cellStyle.setWrapText(true);
                    cellStyle.setLocked(false);
                    ExcelUtils.fillCellStyleWithBGColor((XSSFCellStyle)cellStyle, (XSSFColor)new XSSFColor(Color.YELLOW), (short)1);
                    ExcelUtils.fillCellStyleWithFullBorder((XSSFCellStyle)cellStyle, (short)1, (short)IndexedColors.GREY_25_PERCENT.getIndex());
                    if (i == 11 && result.getLineData()[i - 1] != null && !result.getLineData()[i - 1].toString().equals("")) {
                        try {
                            Date date = dateFormat.parse(result.getLineData()[i - 1].toString());
                            ExcelUtils.fillTheXSSFCellWithDateValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)cellStyle, (Date)date);
                            ++cellNo;
                            continue;
                        }
                        catch (Exception date) {
                            // empty catch block
                        }
                    }
                    ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)cellStyle, (String)(value == null ? "" : value.toString()));
                    ++cellNo;
                }
                ++rowNo;
            }
            Object rightValue = null;
            for (ImportDataProcessService.SingleSaveErrorResult result : data) {
                if (!result.isSuccess()) continue;
                if (sheet.getRow(rowNo) == null) {
                    row = sheet.createRow(rowNo);
                }
                cellNo = 0;
                for (int i = 0; i <= result.getLineData().length; ++i) {
                    rightValue = i == 0 ? "" : result.getLineData()[i - 1];
                    if (sheet.getRow(demoRowNo).getCell(cellNo) == null) {
                        sheet.getRow(demoRowNo).createCell(cellNo);
                    }
                    cellStyle = sheet.getRow(demoRowNo).getCell(cellNo).getCellStyle();
                    cellStyle = ExcelUtils.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap);
                    cellStyle.setWrapText(true);
                    cellStyle.setLocked(false);
                    ExcelUtils.fillCellStyleWithBGColor((XSSFCellStyle)cellStyle, (XSSFColor)new XSSFColor(Color.WHITE), (short)1);
                    ExcelUtils.fillCellStyleWithFullBorder((XSSFCellStyle)cellStyle, (short)1, (short)IndexedColors.GREY_25_PERCENT.getIndex());
                    if (i == 11 && result.getLineData()[i - 1] != null && !result.getLineData()[i - 1].toString().equals("")) {
                        try {
                            Date date = dateFormat.parse(result.getLineData()[i - 1].toString());
                            ExcelUtils.fillTheXSSFCellWithDateValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)cellStyle, (Date)date);
                            ++cellNo;
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)cellStyle, (String)(rightValue == null ? "" : rightValue.toString()));
                    ++cellNo;
                }
                ++rowNo;
            }
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("", (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadImportResult(OutputStream os, Long orgId, String taskId, Collection<ImportDataProcessService.SingleSaveErrorResult> data) {
        InputStream in = null;
        try {
            int demoRowNo;
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(CLUE_RESULT_TEMPLATE_PATH);
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(1);
            Object row = null;
            int rowNo = demoRowNo = 2;
            int cellNo = 0;
            Map demoFormatMap = ExcelUtils.getCellInfoMap((XSSFSheet)sheet, (int)demoRowNo, (int)0, (int)25);
            XSSFCellStyle cellStyle = null;
            Object value = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss 'CST' yyyy", Locale.ENGLISH);
            for (ImportDataProcessService.SingleSaveErrorResult result : data) {
                if (result.isSuccess()) continue;
                if (sheet.getRow(demoRowNo).getCell(cellNo) == null) {
                    sheet.getRow(demoRowNo).createCell(cellNo);
                }
                cellNo = 0;
                for (int i = 0; i <= result.getLineData().length; ++i) {
                    value = i == 0 ? result.getErrorMsg() : result.getLineData()[i - 1];
                    if (sheet.getRow(demoRowNo).getCell(cellNo) == null) {
                        sheet.getRow(demoRowNo).createCell(cellNo);
                    }
                    cellStyle = sheet.getRow(demoRowNo).getCell(cellNo).getCellStyle();
                    cellStyle = ExcelUtils.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)cellStyle, (Map)demoFormatMap);
                    cellStyle.setWrapText(true);
                    cellStyle.setLocked(false);
                    ExcelUtils.fillCellStyleWithBGColor((XSSFCellStyle)cellStyle, (XSSFColor)new XSSFColor(Color.YELLOW), (short)1);
                    ExcelUtils.fillCellStyleWithFullBorder((XSSFCellStyle)cellStyle, (short)1, (short)IndexedColors.GREY_25_PERCENT.getIndex());
                    if (i == 11 && result.getLineData()[i - 1] != null && !result.getLineData()[i - 1].toString().equals("")) {
                        try {
                            Date date = dateFormat.parse(result.getLineData()[i - 1].toString());
                            ExcelUtils.fillTheXSSFCellWithDateValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)cellStyle, (Date)date);
                            ++cellNo;
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)cellStyle, (String)(value == null ? "" : value.toString()));
                    ++cellNo;
                }
                ++rowNo;
            }
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadImportTemplate(OutputStream os) {
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(CLUE_IMPORT_TEMPLATE_PATH);
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        String header = "\u59d3\u540d:name:true,\u624b\u673a\u53f7:mobile:true,\u6027\u522b:sexStr:false,\u8ddf\u8fdb\u72b6\u6001:consultStatusStr:false,\u610f\u5411\u7ea7\u522b:intensionLevelStr:false,\u6240\u5c5e\u4eba:cascadeIdStr:false,\u6807\u7b7e:tagsStr:false,\u4eb2\u5c5e\u5173\u7cfb:relativesStr:false,\u5bb6\u957f\u59d3\u540d:parentName:false,\u5bb6\u957f\u624b\u673a\u53f7:parentMobile:false,\u751f\u65e5:birthday:false,\u516c\u7acb\u5b66\u6821:school:false,\u5e74\u7ea7:degreeClass:false,\u7701:province:false,\u5e02:city:false,\u533a:county:false,\u8be6\u7ec6\u5730\u5740:address:false,QQ:qq:false,\u90ae\u7bb1:mail:false";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)header) && header.contains(":")) {
            String[] cells = header.split(",");
            int index = 0;
            LinkedHashMap<String, Object> subMap = null;
            for (String cell : cells) {
                subMap = new LinkedHashMap<String, Object>();
                String[] column = cell.split(":");
                String name = column[0].trim();
                String propName = column[1];
                boolean empty = Boolean.parseBoolean(column[2]);
                subMap.put("propName", propName);
                subMap.put("index", index);
                subMap.put("empty", empty);
                cache.put(name, subMap);
                ++index;
            }
        }
    }
}

