/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.service.impl;

import com.baijia.tianxiao.biz.consult.dto.request.MergeConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.dto.response.OrgMsgUser;
import com.baijia.tianxiao.biz.consult.enums.CallUserType;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.biz.consult.user.dto.request.ConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.dto.request.ListConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.CallStudentInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.ConsulterResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.GetConsulterInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.SimpleConsulterInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.exception.NoAvailableMobileException;
import com.baijia.tianxiao.biz.consult.user.exception.NonConsultUserException;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserService;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.advisory.dao.OrgCallRecorderDao;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.callservice.dto.MakeCallDto;
import com.baijia.tianxiao.sal.callservice.service.CallService;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCommentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgCommentsListReponse;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgTagListResopnseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultUserServiceImpl
implements ConsultUserService {
    private static final Logger log = LoggerFactory.getLogger(ConsultUserServiceImpl.class);
    @Resource
    private TxConsultUserDao consultUserDao;
    @Resource
    private OrgStudentService orgStudentService;
    @Resource
    private OrgStudentTagService orgStudentTagService;
    @Resource
    private OrgStudentCommentService orgStudentCommentService;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private CallServiceInfoDao callServiceInfoDao;
    @Resource
    private OrgCallRecorderDao orgCallRecorderDao;
    @Resource
    private CallService callService;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private UserDao userDao;
    @Resource
    private FansDao fansDao;
    @Autowired
    protected ConsultMessageService consultMessageService;
    @Autowired
    private TxBacklogDao txBacklogDao;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long saveConsultUser(Long orgId, ConsulterRequestDto consulter) throws BussinessException {
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        Preconditions.checkNotNull((Object)consulter, (Object)"consulter user info is null");
        consulter.setOrgId(orgId);
        TxConsultUser consulterUser = null;
        if (consulter.getNextRemindTime() != null && consulter.getNextRemindTime() > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0b\u6b21\u63d0\u9192\u65f6\u95f4\u8d85\u8fc7\u6700\u5927\u8303\u56f4(2037-1-1)\u4e86");
        }
        if (consulter.getBirthday() != null && consulter.getBirthday() > System.currentTimeMillis()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u6765\u7684\u60a8\u8fd8\u672a\u51fa\u751f\u5427");
        }
        this.doSaveBefore(consulter, orgId);
        if (consulter.getConsulterId() != null && consulter.getConsulterId() > 0L) {
            consulterUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulter.getConsulterId(), new String[0]);
            if (consulterUser == null) throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_NOT_EXISTS);
            this.copyFrom(consulterUser, consulter);
            this.editConsult(consulterUser, consulter, orgId);
            this.updateSysBacklog(orgId, consulterUser.getId());
        } else {
            consulterUser = ConsulterDto.convertToConsultUser(consulter);
            this.addConsult(consulterUser, consulter, orgId);
            this.addSysBacklog(orgId, consulterUser.getId());
        }
        log.info("success save consulter :{} into db,return id:{}", (Object)consulter.getName(), (Object)consulterUser.getId());
        return consulterUser.getId();
    }

    private void copyFrom(TxConsultUser user, ConsulterDto dto) {
        user.setAddress(dto.getAddress());
        user.setBirthday(dto.getBirthday() != null && dto.getBirthday() > 0L ? new Date(dto.getBirthday()) : null);
        user.setConsultSource(Integer.valueOf(dto.getConsultSource()));
        user.setConsultStatus(dto.getConsultStatus());
        user.setDegreeClass(dto.getDegreeClass());
        user.setMail(dto.getEmail());
        user.setFatherOccupation(dto.getFatherOccupation());
        user.setIntensionLevel(dto.getIntensionLevel());
        user.setMatherOccupation(dto.getMatherOccupation());
        user.setMobile(dto.getMobile());
        if (dto.getNextRemindTime() == null || dto.getNextRemindTime() <= 0L) {
            user.setNextRemindTime(DateUtil.getOffSetDate((int)3));
        } else {
            user.setNextRemindTime(new Date(dto.getNextRemindTime()));
        }
        user.setNickName(dto.getNickName());
        user.setParentMobile(dto.getParentMobile());
        user.setParentName(dto.getParentName());
        user.setQq(dto.getQq());
        user.setSchool(dto.getSchool());
        user.setName(dto.getStudentName());
    }

    private void addConsult(TxConsultUser consulterUser, ConsulterRequestDto consulter, Long orgId) {
        consulterUser.setManually(1);
        this.consultUserDao.save((Object)consulterUser, new String[0]);
        if (consulter.getSaveStudent() == BizConf.TRUE.intValue()) {
            log.info("--------consulterUser:{}", (Object)consulterUser);
            OrgStudentAddresponseDto orgStudentAddresponseDto = this.saveStudent(consulterUser, consulter, orgId);
            if (orgStudentAddresponseDto != null && orgStudentAddresponseDto.getStudentId() > 0L) {
                Long studentId = orgStudentAddresponseDto.getStudentId();
                OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
                if (student != null && student.getOrgId().longValue() == orgId.longValue() && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue() && student.getUserId() != null && student.getUserId() > 0L) {
                    User user = (User)this.userDao.getById((Serializable)student.getUserId(), new String[0]);
                    consulterUser.setUserId(user.getId());
                    consulterUser.setUserNumber(user.getNumber());
                }
                consulterUser.setStudentId(studentId);
                this.consultUserDao.update((Object)consulterUser, new String[]{"studentId"});
            }
        }
        this.saveUserTags(orgId, consulterUser.getId(), consulter.getTags());
        this.sendConsultMessage(consulterUser, orgId);
    }

    private void sendConsultMessage(TxConsultUser consulterUser, Long orgId) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        ConsultMessage message = new ConsultMessage();
        message.setConsultType(ConsultType.INPUT.getValue());
        message.setMsgType(MsgType.TEXT.getValue());
        message.setText("\u63d0\u9192\u65f6\u95f4:" + TianXiaoConstant.DAY_TIME_FORMAT.format(consulterUser.getNextRemindTime()));
        log.info("send to add consulter msg");
        this.consultMessageService.sendConsultMessage((MsgUser)ConsulterDto.convertToDto(consulterUser), (MsgUser)new OrgMsgUser(orgId, orgAccount.getNumber().longValue()), message);
    }

    private void editConsult(TxConsultUser consulterUser, ConsulterRequestDto consulter, Long orgId) {
        OrgStudentAddresponseDto orgStudentAddresponseDto;
        if (consulter.getSaveStudent() == BizConf.TRUE.intValue() && null != (orgStudentAddresponseDto = this.saveStudent(consulterUser, consulter, orgId)) && orgStudentAddresponseDto.getStudentId() > 0L) {
            consulterUser.setStudentId(orgStudentAddresponseDto.getStudentId());
            consulterUser.setUserId(orgStudentAddresponseDto.getUserId());
            consulterUser.setUserNumber(orgStudentAddresponseDto.getUserNumber());
        }
        if (consulterUser.getMobile().contains("****")) {
            consulterUser.setMobile(null);
        }
        Long studentId = consulterUser.getStudentId();
        this.getAndUpdateStudent(studentId, orgId, consulter.getMobile(), consulter.getName());
        this.consultUserDao.update((Object)consulterUser, new String[0]);
    }

    private void getAndUpdateStudent(Long studentId, Long orgId, String mobile, String name) {
        OrgStudent student;
        if (!(studentId == null || studentId <= 0L || (student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0])) == null || student.getOrgId().longValue() != orgId.longValue() || student.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue() || mobile.equals(student.getMobile()) && name.equals(student.getName()))) {
            student.setMobile(mobile);
            student.setShowMobile(mobile);
            student.setName(name);
            this.orgStudentDao.update((Object)student, new String[]{"mobile", "showMobile", "name"});
        }
    }

    private void doSaveBefore(ConsulterRequestDto consulter, Long orgId) throws BussinessException {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{consulter.getMobile()}) && !consulter.getMobile().contains("****")) {
            List targets = this.consultUserDao.lookByMobile(orgId, consulter.getMobile(), new String[0]);
            log.info("doSaveBefore---------consulter={},targets={}", (Object)consulter, (Object)targets);
            if (targets != null && !targets.isEmpty()) {
                if (consulter.getConsulterId() != null && consulter.getConsulterId() > 0L) {
                    if (targets.size() > 1 || ((TxConsultUser)targets.get(0)).getId().longValue() != consulter.getConsulterId().longValue()) {
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u7801\u5bf9\u5e94\u7684\u54a8\u8be2\u7528\u6237\u5df2\u5b58\u5728");
                    }
                } else {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u7801\u5bf9\u5e94\u7684\u54a8\u8be2\u7528\u6237\u5df2\u5b58\u5728");
                }
            }
        }
    }

    private OrgStudentAddresponseDto saveStudent(TxConsultUser consulterUser, ConsulterRequestDto consulter, Long orgId) {
        log.info("save consulter user:{} into org student", (Object)consulterUser);
        OrgStudentAddresponseDto result = this.orgStudentService.addStudent(this.buildStudentInfoDto(consulterUser, consulter.getConfirm()), null, null, orgId);
        return result;
    }

    private void saveUserTags(Long orgId, Long consulterId, String tags) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tags})) {
            log.debug("save tags :{} into db", (Object)tags);
            try {
                List tagDtos = JacksonUtil.str2List((String)tags, TagInfoDto.class);
                this.orgStudentTagService.addStudentTag(tagDtos, Integer.valueOf(StudentType.CONSULT_USER.getCode()), consulterId, orgId);
            }
            catch (Exception e) {
                log.error("save tags:{} catch error:{}", (Object)tags, (Object)e);
            }
        }
    }

    private StudentInfoDto buildStudentInfoDto(TxConsultUser user, Integer confirm) {
        StudentInfoDto dto = new StudentInfoDto();
        dto.setAddress(user.getAddress());
        dto.setBirthdayDate(user.getBirthday());
        dto.setDegreeClass(user.getDegreeClass());
        dto.setFatherOccupation(user.getFatherOccupation());
        dto.setMail(user.getMail());
        dto.setMatherOccupation(user.getMatherOccupation());
        dto.setMobile(user.getMobile());
        dto.setName(user.getName());
        dto.setNextRemindTimeDate(user.getNextRemindTime());
        dto.setParentMobile(user.getParentMobile());
        dto.setParentName(user.getParentName());
        dto.setQq(user.getQq());
        dto.setSchool(user.getSchool());
        dto.setStudentId(user.getStudentId());
        dto.setWeixin(user.getWeixinOpenId());
        dto.setConsultUserId(user.getId());
        dto.setStudentNumber(user.getUserNumber());
        dto.setSource(user.getConsultSource());
        dto.setConfirm(confirm);
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public ConsulterResponseDto getConsultUser(Long orgId, Long consulterId) throws NonConsultUserException {
        OrgCommentsListReponse commentsDto;
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        Preconditions.checkNotNull((Object)consulterId, (Object)"consult user id can not be null");
        TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        if (consultUser == null || !consultUser.getOrgId().equals(orgId)) {
            throw new NonConsultUserException(consulterId);
        }
        if (consultUser.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
            throw new NonConsultUserException(consulterId);
        }
        ConsulterResponseDto dto = ConsulterDto.convertToDto(consultUser);
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            dto.setStudentName("\u533f\u540d\u5b66\u751f");
        } else {
            dto.setStudentName(dto.getName());
        }
        if (consultUser.getStudentId() != null && consultUser.getStudentId() > 0L) {
            this.setOrigin(consultUser.getStudentId(), dto);
        } else if (consultUser.getConsultSource().intValue() == ConsultType.ONLINE_IM.getValue()) {
            dto.setOrigin(0);
        } else {
            dto.setOrigin(1);
        }
        this.getFansInfo(dto);
        OrgTagListResopnseDto tagDto = this.orgStudentTagService.getTags(Integer.valueOf(StudentType.CONSULT_USER.getCode()), consulterId, orgId);
        if (tagDto != null) {
            List tags = tagDto.getTags();
            if (tags != null && !tags.isEmpty() && tags.size() > 5) {
                tags = tags.subList(0, 5);
            }
            dto.setTags(tags);
        }
        if ((commentsDto = this.orgStudentCommentService.getComments(Integer.valueOf(StudentType.CONSULT_USER.getCode()), consulterId, orgId)) != null) {
            dto.setComments(commentsDto.getComments());
        }
        return dto;
    }

    private void setOrigin(Long studentId, ConsulterResponseDto dto) {
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (student != null) {
            dto.setOrigin(student.getOrigin());
        }
    }

    private void getFansInfo(ConsulterResponseDto dto) {
        if (null != dto && StringUtils.isNotBlank((CharSequence)dto.getWeixinOpenId())) {
            Fans fans = this.fansDao.getByOpenId(dto.getWeixinOpenId());
            if (fans != null) {
                dto.setChat(BizConf.TRUE);
            } else {
                dto.setChat(BizConf.FALSE);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(readOnly=true)
    public GetConsulterInfoResponseDto getExistStudentId(Long orgId, Long consulterId, Long userNumber) throws NonConsultUserException {
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        Preconditions.checkArgument((consulterId != null || userNumber != null ? 1 : 0) != 0, (Object)"user number");
        GetConsulterInfoResponseDto result = new GetConsulterInfoResponseDto();
        if (consulterId != null) {
            TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[]{"userId", "mobile", "delStatus", "studentId"});
            log.debug("consultUser:{}", (Object)consultUser);
            if (consultUser == null || consultUser.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) throw new NonConsultUserException(consulterId);
            if (null != consultUser.getStudentId() && consultUser.getStudentId() > 0L) {
                result.setStudentId(consultUser.getStudentId());
            }
            result.setConsultUserId(consulterId);
            return result;
        } else {
            if (userNumber == null) return result;
            User user = this.userDao.getByNumber(userNumber, new String[]{"id", "mobile"});
            if (user == null) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65e0\u6cd5\u67e5\u8be2\u5230\u5e73\u53f0\u7528\u6237,\u7528\u6237\u8868\u793a:" + userNumber);
            List list = this.consultUserDao.lookByUserId(orgId, user.getId(), new String[]{"id", "studentId"});
            log.info("getExistStudentId------List<TxConsultUser> list={}", (Object)list);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                TxConsultUser consulter = (TxConsultUser)list.get(0);
                if (null != consulter.getStudentId() && consulter.getStudentId() > 0L) {
                    result.setStudentId(consulter.getStudentId());
                }
                result.setConsultUserId(consulter.getId());
                return result;
            } else {
                OrgStudent orgStudent = this.orgStudentDao.getStudent(orgId, user.getId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[]{"id", "userId", "delStatus"});
                log.info("getExistStudentId-----orgStudent={}", (Object)orgStudent);
                if (null == orgStudent) return result;
                result.setStudentId(orgStudent.getId());
            }
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<SimpleConsulterInfoResponseDto> searchConsulterInfos(Integer type, Long orgId, ListConsulterRequestDto request, PageDto pageDto) {
        List<TxConsultUser> users;
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        if (request == null) {
            request = new ListConsulterRequestDto();
        }
        if (CollectionUtils.isNotEmpty(users = this.queryResult(type, orgId, request, pageDto))) {
            ArrayList result = Lists.newArrayList();
            HashSet<Long> studentIds = new HashSet<Long>();
            for (TxConsultUser user : users) {
                if (user.getStudentId() != null && user.getStudentId() > 0L) {
                    studentIds.add(user.getStudentId());
                }
                result.add(this.buildSimpleConsultInfo(user));
            }
            if (null == type || null != type && 1 == type) {
                Map<Long, OrgStudent> cache = this.getAndCacheStudents(studentIds);
                for (SimpleConsulterInfoResponseDto dto : result) {
                    OrgStudent stu;
                    Long studentId = dto.getStudentId();
                    if (studentId == null || studentId <= 0L || (stu = cache.get(studentId)) == null) continue;
                    dto.setStudentId(stu.getId());
                    if (StringUtils.isBlank((CharSequence)stu.getName())) {
                        if (StringUtils.isNotEmpty((CharSequence)stu.getNickName())) {
                            dto.setName(stu.getNickName());
                        } else {
                            dto.setName(MaskUtil.maskMobile((String)stu.getMobile()));
                        }
                    } else {
                        dto.setStudentName(stu.getName());
                    }
                    String mobile = stu.getMobile();
                    dto.setMobile(mobile);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private List<TxConsultUser> queryResult(Integer type, Long orgId, ListConsulterRequestDto request, PageDto pageDto) {
        HashSet consultSources = Sets.newHashSet();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getConsultSources()})) {
            for (String consultSource : StringUtils.splitByWholeSeparator((String)request.getConsultSources(), (String)",")) {
                if (!StringUtils.isNumeric((CharSequence)consultSource)) {
                    log.warn("error consult course :{},ignore condition", (Object)consultSource);
                    continue;
                }
                consultSources.add(Integer.parseInt(consultSource));
            }
        } else if (request.getConsultSource() != null) {
            consultSources.add(request.getConsultSource());
        }
        List users = this.consultUserDao.search(type, request.getKey(), orgId, request.getIntensionLevel(), (Collection)consultSources, request.getStartTime(), request.getEndTime(), pageDto, new String[0]);
        return users;
    }

    private Map<Long, OrgStudent> getAndCacheStudents(Set<Long> studentIds) {
        List students;
        Map studentMap = Maps.newHashMap();
        if (studentIds != null && !studentIds.isEmpty() && (students = this.orgStudentDao.getByIds(studentIds, new String[]{"id", "name", "nickName", "mobile", "showMobile"})) != null && !students.isEmpty()) {
            studentMap = CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, Long>(){

                public Long apply(OrgStudent input) {
                    return input.getId();
                }
            });
        }
        return studentMap;
    }

    private SimpleConsulterInfoResponseDto buildSimpleConsultInfo(TxConsultUser user) {
        SimpleConsulterInfoResponseDto dto = new SimpleConsulterInfoResponseDto();
        if (user.getConsultSource().intValue() == ConsultType.MARKING.getValue()) {
            dto.setConsultType(ConsultType.ONLINE_IM);
        } else {
            dto.setConsultType(ConsultType.getByType((Integer)user.getConsultSource()));
        }
        dto.setConsultUserId(user.getId());
        dto.setIntensionLevel(user.getIntensionLevel());
        dto.setMobile(user.getMobile());
        dto.setName(StringUtils.isNotBlank((CharSequence)user.getName()) ? user.getName() : "\u533f\u540d\u5b66\u751f");
        dto.setNumber(user.getUserNumber());
        dto.setStudentId(user.getStudentId());
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public CallStudentInfoResponseDto getCallStudentInfoByMobile(Long consulterId, String mobile, Long orgId) throws NonConsultUserException {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile is illegal");
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"org id is illegal");
        Preconditions.checkArgument((consulterId != null && consulterId > 0L ? 1 : 0) != 0, (Object)"consulter id is illegal");
        CallStudentInfoResponseDto result = new CallStudentInfoResponseDto();
        result.setMobile(mobile);
        TxConsultUser user = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[]{"id", "name", "weixinNickName", "mobile", "orgId"});
        if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
            throw new NonConsultUserException(consulterId);
        }
        result.setConsulterId(user.getId());
        mobile = user.getMobile();
        result.setStudentName(user.getName());
        OrgInfo info = this.orgInfoDao.getOrgInfo(Integer.valueOf(orgId.intValue()), new String[]{"extension"});
        Preconditions.checkArgument((info != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{info.getExtension()}) ? 1 : 0) != 0, (Object)"\u673a\u6784\u5206\u673a\u53f7\u672a\u5206\u914d");
        OrgCommentsListReponse commentResp = null;
        Map callInfo = this.orgCallRecorderDao.queryCallCountAndTime(mobile, info.getExtension());
        log.debug("query call info by mobile:{},orgId:{},result:{}", new Object[]{mobile, orgId, callInfo});
        if (callInfo != null) {
            String cntKey = "CNT_id";
            Number count = (Number)callInfo.get(cntKey);
            if (count != null) {
                result.setCallCount(count.intValue());
            }
            result.setLastCallTime((Date)callInfo.get("MAX_TIME"));
        }
        OrgStudent orgStudent = null;
        if (user.getStudentId() != null && user.getStudentId() > 0L && ((orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)user.getStudentId(), new String[0])) == null || orgStudent.getOrgId().longValue() != orgId.longValue() && orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue())) {
            orgStudent = null;
        }
        if (orgStudent != null) {
            result.setStudentId(orgStudent.getId());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgStudent.getName()})) {
                result.setStudentName(orgStudent.getName());
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgStudent.getNickName()})) {
                result.setStudentName(orgStudent.getNickName());
            }
            commentResp = this.orgStudentCommentService.getComments(Integer.valueOf(StudentType.ORG_STUDENTS.getCode()), orgStudent.getId(), orgId);
            if (commentResp != null && CollectionUtils.isNotEmpty((Collection)commentResp.getComments())) {
                log.debug("student comment info:{}", (Object)commentResp);
                result.setComments(commentResp.getComments());
            }
        } else {
            commentResp = this.orgStudentCommentService.getComments(Integer.valueOf(StudentType.CONSULT_USER.getCode()), consulterId, orgId);
            if (commentResp != null && CollectionUtils.isNotEmpty((Collection)commentResp.getComments())) {
                log.debug("consulter comment info:{}", (Object)commentResp);
                result.setComments(commentResp.getComments());
            }
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public boolean callStudent(Long consulterId, Long studentId, String subscriberTel, CallUserType userType, Long orgId) throws NonConsultUserException {
        Preconditions.checkArgument((consulterId != null && consulterId > 0L || studentId != null && studentId > 0L ? 1 : 0) != 0, (Object)"consulter user id or student id at least have one value");
        Preconditions.checkArgument((userType != null ? 1 : 0) != 0, (Object)"user type is illegal");
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"org id is illegal.");
        MakeCallDto makeCall = new MakeCallDto();
        if (consulterId != null) {
            TxConsultUser user = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[]{"userId", "id", "orgId", "mobile", "parentMobile"});
            if (user == null || !user.getOrgId().equals(orgId)) {
                throw new NonConsultUserException(consulterId);
            }
            if (StringUtils.isBlank((CharSequence)user.getMobile()) && user.getUserId() == 0L) {
                log.warn("no cdb user exist and no consulter mobile:{}", (Object)user);
                throw new NoAvailableMobileException(consulterId);
            }
            if (user.getUserId() != null && user.getUserId() > 0L) {
                makeCall.setCalledUserId(user.getUserId());
            } else {
                makeCall.setCalledUserId(CallService.ANONYMOUS_USER_ID);
            }
            if (userType.equals((Object)CallUserType.Parent)) {
                if (StringUtils.isBlank((CharSequence)user.getParentMobile())) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u8bbe\u7f6e\u54a8\u8be2\u5ba2\u6237\u5bb6\u957f\u8054\u7cfb\u7535\u8bdd");
                }
                makeCall.setCalledUserMobile(user.getParentMobile());
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{user.getMobile()})) {
                makeCall.setCalledUserMobile(user.getMobile());
            }
        } else {
            OrgStudent orgStudent = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[]{"userId", "orgId", "mobile", "parentMobile"});
            if (orgStudent == null || !orgStudent.getOrgId().equals(orgId)) {
                throw new NonConsultUserException(studentId);
            }
            makeCall.setCalledUserId(orgStudent.getUserId());
            if (userType.equals((Object)CallUserType.Parent)) {
                if (StringUtils.isBlank((CharSequence)orgStudent.getParentMobile())) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u8bbe\u7f6e\u82b1\u540d\u518c\u5b66\u751f\u5bb6\u957f\u8054\u7cfb\u7535\u8bdd");
                }
                makeCall.setCalledUserMobile(orgStudent.getParentMobile());
            } else {
                String mobile = orgStudent.getStudentMobile();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile})) {
                    makeCall.setCalledUserMobile(mobile);
                }
            }
        }
        makeCall.setSubscriberUserId(orgId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{subscriberTel})) {
            makeCall.setSubscriberMobile(subscriberTel);
        }
        log.info("submit call student request:{}", (Object)makeCall);
        return this.callService.callParty(makeCall);
    }

    @Override
    @Transactional(readOnly=true)
    public ConsulterDto getConsultUserBaseInfo(Long orgId, Long consulterId) throws NonConsultUserException {
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        Preconditions.checkNotNull((Object)consulterId, (Object)"consult user id can not be null");
        TxConsultUser consultUser = (TxConsultUser)this.consultUserDao.getById((Serializable)consulterId, new String[0]);
        if (consultUser == null || !consultUser.getOrgId().equals(orgId)) {
            throw new NonConsultUserException(consulterId);
        }
        ConsulterResponseDto dto = ConsulterDto.convertToDto(consultUser);
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            dto.setStudentName("\u533f\u540d\u5b66\u751f");
        } else {
            dto.setStudentName(dto.getName());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mergeCosulter(MergeConsulterRequestDto param, Long orgId) throws BussinessException {
        Preconditions.checkNotNull((Object)orgId, (Object)"org id can not be null");
        this.paramValidator(param);
        TxConsultUser sourceConsultUser = this.consultUserDao.getOrgConsultUser(orgId, param.getSourceConsulter());
        log.info("ConsultUserServiceImpl:mergeCosulter-------sourceConsultUser={}", (Object)sourceConsultUser);
        if (sourceConsultUser == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u539f\u59cb\u54a8\u8be2\u7528\u6237\u4e0d\u5b58\u5728");
        }
        TxConsultUser destConsultUser = this.consultUserDao.getOrgConsultUser(orgId, param.getDestConsulter());
        log.info("ConsultUserServiceImpl:mergeCosulter-------destConsultUser={}", (Object)destConsultUser);
        if (destConsultUser == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u76ee\u6807\u54a8\u8be2\u7528\u6237\u4e0d\u5b58\u5728");
        }
        OrgStudent student = this.getAndSetStudentId(param, orgId, destConsultUser);
        log.info("ConsultUserServiceImpl:mergeCosulter-------student={}", (Object)student);
        this.orgStudentTagService.mergeTags(sourceConsultUser, destConsultUser, orgId);
        this.orgStudentCommentService.mergeCommentRecord(sourceConsultUser, destConsultUser, orgId);
        this.deleteSourceConsult(sourceConsultUser);
        this.updateConsultSouce(sourceConsultUser, destConsultUser);
        this.mergeStudentInfo(param, sourceConsultUser, destConsultUser, orgId, student);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OrgStudent getAndSetStudentId(MergeConsulterRequestDto param, Long orgId, TxConsultUser destConsultUser) throws BussinessException {
        OrgStudent student = null;
        Long studentId = param.getStudentId();
        if (param.getStudentId() == null || param.getStudentId() <= 0L) return student;
        if (studentId == null || studentId == 0L) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY, "\u65e0\u6743\u5408\u5e76\u8be5\u5b66\u751f");
        student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (student == null || student.getOrgId().longValue() != orgId.longValue()) throw new BussinessException((UniverseErrorCode)CommonErrorCode.UNKNOW, "\u5b66\u751f\u4e0d\u5b58\u5728");
        destConsultUser.setUserId(student.getUserId());
        destConsultUser.setStudentId(student.getId());
        return student;
    }

    private void mergeStudentInfo(MergeConsulterRequestDto param, TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId, OrgStudent student) {
        if (param.getStudentId() != null && param.getStudentId() > 0L) {
            this.getAndSetStudent(param, orgId, destConsultUser.getUserId(), student, sourceConsultUser, destConsultUser.getConsultSource());
        }
        this.updateDestConsultUser(destConsultUser, param, sourceConsultUser);
    }

    private void getAndSetStudent(MergeConsulterRequestDto param, Long orgId, Long userId, OrgStudent student, TxConsultUser sourceConsult, Integer consultSource) {
        if (student != null) {
            log.debug("from student:{}", (Object)student);
            student.setAddress(param.getAddress());
            student.setDegreeClass(param.getDegreeClass());
            student.setFatherOccupation(param.getFatherOccupation());
            student.setMatherOccupation(param.getMatherOccupation());
            student.setName(param.getStudentName());
            student.setNextRemindTime(new Date(param.getNextRemindTime()));
            student.setParentName(param.getParentName());
            student.setParentMobile(param.getParentMobile());
            if (param.getBirthday() != null && param.getBirthday() > 0L) {
                student.setBirthday(new Date(param.getBirthday()));
            }
            student.setSchool(param.getSchool());
            student.setShowMobile(param.getMobile());
            if (StringUtils.isBlank((CharSequence)student.getWeixin()) && StringUtils.isNotBlank((CharSequence)sourceConsult.getWeixinOpenId())) {
                student.setWeixin(sourceConsult.getWeixinOpenId());
            }
            log.debug("to student:{}", (Object)student);
            if (StringUtils.isNotBlank((CharSequence)param.getStudentName())) {
                student.setPinyin(HanZiPinYinUtils.trans2PinYin((String)param.getStudentName(), (String)""));
            } else {
                student.setPinyin("");
            }
            if (consultSource != null) {
                student.setSource(consultSource);
                if (consultSource.intValue() == ConsultType.ONLINE_IM.getValue()) {
                    student.setOrigin(Integer.valueOf(0));
                } else {
                    student.setOrigin(Integer.valueOf(1));
                }
            } else {
                student.setOrigin(Integer.valueOf(1));
            }
            this.orgStudentDao.update((Object)student, Boolean.valueOf(false), new String[0]);
        }
    }

    private void updateConsultSouce(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser) {
        if (sourceConsultUser.getCreateTime().before(destConsultUser.getCreateTime())) {
            destConsultUser.setConsultSource(sourceConsultUser.getConsultSource());
        }
    }

    void updateDestConsultUser(TxConsultUser destConsultUser, MergeConsulterRequestDto param, TxConsultUser sourceConsultUser) {
        destConsultUser.setAddress(param.getAddress());
        destConsultUser.setBirthday(new Date(param.getBirthday()));
        destConsultUser.setConsultStatus(param.getConsultStatus());
        destConsultUser.setDegreeClass(param.getDegreeClass());
        destConsultUser.setFatherOccupation(param.getFatherOccupation());
        destConsultUser.setIntensionLevel(param.getIntensionLevel());
        destConsultUser.setMatherOccupation(param.getMatherOccupation());
        String mobile = param.getMobile();
        if (StringUtils.isNotBlank((CharSequence)mobile) && !mobile.contains("*")) {
            destConsultUser.setMobile(param.getMobile());
        }
        destConsultUser.setNextRemindTime(new Date(param.getNextRemindTime()));
        destConsultUser.setParentName(param.getParentName());
        destConsultUser.setParentMobile(param.getParentMobile());
        destConsultUser.setSchool(param.getSchool());
        destConsultUser.setName(param.getStudentName());
        destConsultUser.setWeixin(this.mergeProperties(sourceConsultUser.getWeixin(), destConsultUser.getWeixin()));
        destConsultUser.setWeixinAppId(this.mergeProperties(sourceConsultUser.getWeixinAppId(), destConsultUser.getWeixinAppId()));
        destConsultUser.setWeixinNickName(this.mergeProperties(sourceConsultUser.getWeixinNickName(), destConsultUser.getWeixinNickName()));
        destConsultUser.setWeixinOpenId(this.mergeProperties(sourceConsultUser.getWeixinOpenId(), destConsultUser.getWeixinOpenId()));
        this.consultUserDao.update((Object)destConsultUser, new String[0]);
    }

    private String mergeProperties(String source, String dest) {
        if (StringUtils.isNotBlank((CharSequence)source) && StringUtils.isNotBlank((CharSequence)dest)) {
            return dest;
        }
        if (StringUtils.isNotBlank((CharSequence)source) && StringUtils.isBlank((CharSequence)dest)) {
            return source;
        }
        if (StringUtils.isBlank((CharSequence)source) && StringUtils.isNotBlank((CharSequence)dest)) {
            return dest;
        }
        return "";
    }

    void deleteSourceConsult(TxConsultUser sourceConsultUser) {
        sourceConsultUser.setDelStatus(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        sourceConsultUser.setUpdateTime(new Date());
        this.delSysBacklog(sourceConsultUser.getOrgId(), sourceConsultUser);
        log.info("deleteSourceConsult.sourceConsultUser:{}", (Object)sourceConsultUser);
        this.consultUserDao.update((Object)sourceConsultUser, new String[]{"delStatus", "updateTime"});
    }

    private void paramValidator(MergeConsulterRequestDto param) {
        Preconditions.checkNotNull((Object)param.getSourceConsulter(), (Object)"source consulter id can not be null");
        Preconditions.checkNotNull((Object)param.getDestConsulter(), (Object)"destination consulter id can not be null");
    }

    @Override
    @Transactional(readOnly=true)
    public List<TxConsultUser> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        List consulters = this.consultUserDao.searchHasMobileConsulter(pageDto, format, value);
        log.debug("consulters:{}", (Object)consulters);
        return consulters;
    }

    @Override
    public Long regConsulter(Long orgId, String openId, String showName, Long studentId) {
        List consulters = null;
        if (StringUtils.isNotBlank((CharSequence)openId) && !openId.equals("0")) {
            consulters = this.consultUserDao.lookByParams(orgId, openId, new String[0]);
        } else {
            openId = "";
        }
        OrgStudent student = null;
        if (studentId != null && studentId > 0L && ((student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0])) == null || student.getOrgId().longValue() != orgId.longValue())) {
            student = null;
        }
        if (consulters != null && !consulters.isEmpty()) {
            TxConsultUser consulter = (TxConsultUser)consulters.get(0);
            if (student != null) {
                consulter.setStudentId(studentId);
                consulter.setUpdateTime(new Date());
                consulter.setUserId(student.getUserId());
                this.consultUserDao.update((Object)consulter, new String[]{"studentId", "updateTime", "userId"});
            }
            return ((TxConsultUser)consulters.get(0)).getId();
        }
        return this.saveAndReturnId(orgId, openId, showName, student);
    }

    private Long saveAndReturnId(Long orgId, String openId, String showName, OrgStudent student) {
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setWeixinOpenId(openId);
        consultUser.setName(showName);
        consultUser.setNickName(showName);
        consultUser.setOrgId(orgId);
        if (student != null) {
            consultUser.setStudentId(student.getId());
            consultUser.setUserId(student.getUserId());
            consultUser.setNextRemindTime(student.getNextRemindTime());
            consultUser.setConsultSource(student.getSource());
        } else {
            consultUser.setNextRemindTime(DateUtil.getOffSetDate((int)5));
            consultUser.setConsultSource(Integer.valueOf(ConsultType.WECHAT.getValue()));
        }
        this.consultUserDao.save((Object)consultUser, new String[0]);
        this.addSysBacklog(orgId, consultUser.getId());
        return consultUser.getId();
    }

    @Override
    public void delConsulter(Long consulterId, Long orgId) {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        Preconditions.checkArgument((consulterId != null && consulterId > 0L ? 1 : 0) != 0, (Object)"consulterId is illegal");
        TxConsultUser consultUser = this.consultUserDao.getOrgConsultUser(orgId, consulterId);
        log.info("delConsulter---------consulterId={},orgId={},consultUser={}", new Object[]{consulterId, orgId, consultUser});
        if (null == consultUser) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u54a8\u8be2\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        this.delSysBacklog(orgId, consultUser);
        consultUser.setDelStatus(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        consultUser.setUpdateTime(new Date());
        this.consultUserDao.update((Object)consultUser, new String[]{"delStatus", "updateTime"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addSysBacklog(Long orgId, Long consulterId) {
        TxConsultUser consulter;
        if (null != consulterId && consulterId > 0L && null != (consulter = this.consultUserDao.getOrgConsultUser(orgId, consulterId))) {
            log.info("addSysBacklog-------orgId={},consulter={}", (Object)orgId, (Object)consulter);
            List list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulter.getId(), orgId, Boolean.valueOf(false), new String[]{"id"});
            if (CollectionUtils.isEmpty((Collection)list)) {
                TxBacklog txBacklog = new TxBacklog();
                if (null != consulter.getStudentId() && consulter.getStudentId() > 0L) {
                    txBacklog.setStudentId(consulter.getStudentId());
                }
                txBacklog.setOrgId(orgId);
                txBacklog.setConsultUserId(consulter.getId());
                txBacklog.setContent("\u8ddf\u8fdb\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consulter.getName()) ? consulter.getName() : "\u533f\u540d\u5b66\u751f"));
                txBacklog.setIsSys(BizConf.TRUE.intValue());
                txBacklog.setEndTime(consulter.getNextRemindTime());
                txBacklog.setRemindTime(consulter.getNextRemindTime());
                txBacklog.setCreateTime(new Date());
                txBacklog.setUpdateTime(new Date());
                this.txBacklogDao.save((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                log.info("addSysBacklog:save--------txBacklog={}", (Object)txBacklog);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSysBacklog(Long orgId, Long consulterId) {
        if (null != consulterId && consulterId > 0L) {
            TxConsultUser consulter = this.consultUserDao.getOrgConsultUser(orgId, consulterId);
            log.info("updateSysBacklog------orgId={},consulter={}", (Object)orgId, (Object)consulter);
            if (null != consulter && (null == consulter.getStudentId() || consulter.getStudentId() <= 0L)) {
                List list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulter.getId(), orgId, Boolean.valueOf(false), new String[0]);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    TxBacklog txBacklog = (TxBacklog)list.get(0);
                    if (consulter.getNextRemindTime().getTime() != txBacklog.getEndTime().getTime()) {
                        txBacklog.setEndTime(consulter.getNextRemindTime());
                        txBacklog.setRemindTime(consulter.getNextRemindTime());
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update((Object)txBacklog, new String[]{"endTime", "remindTime", "updateTime"});
                    }
                } else {
                    this.addSysBacklog(orgId, consulter.getId());
                }
            }
        }
    }

    private void delSysBacklog(Long orgId, TxConsultUser consultUser) {
        block4: {
            List list;
            block3: {
                log.info("delSysBacklog-------orgId={}, consultUser={}", (Object)orgId, (Object)consultUser);
                list = null;
                if (null == consultUser.getStudentId() || consultUser.getStudentId() <= 0L) break block3;
                list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(consultUser.getStudentId(), consultUser.getOrgId(), null, new String[0]);
                if (!CollectionUtils.isNotEmpty((Collection)list)) break block4;
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog || txBacklog.getConsultUserId().longValue() != consultUser.getId().longValue()) continue;
                    txBacklog.setConsultUserId(Long.valueOf(0L));
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
                break block4;
            }
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consultUser.getId(), consultUser.getOrgId(), null, new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (TxBacklog txBacklog : list) {
                    if (null == txBacklog) continue;
                    txBacklog.setConsultUserId(Long.valueOf(0L));
                    txBacklog.setDelStatus(DeleteStatus.DELETED.getValue());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update((Object)txBacklog, Boolean.valueOf(false), new String[0]);
                }
            }
        }
    }
}

