/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.pc.service.impl;

import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultListResponseDto;
import com.baijia.tianxiao.biz.consult.user.pc.service.ClueService;
import com.baijia.tianxiao.common.service.ImportDataProcessService;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.baidu.Location;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.baidu.BaiduMapUtils;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImportClueServiceImpl
implements ImportDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(ImportClueServiceImpl.class);
    @Autowired
    private AreaDao areaDao;
    private static final Map<String, Map<String, Object>> cache = Maps.newHashMap();
    private static final ImportDataProcessService.SingleSaveErrorResult IMPORT_SUCCESS = ImportDataProcessService.SingleSaveErrorResult.createSuccessResult((String)"\u5bfc\u5165\u6210\u529f");
    private static final ImportDataProcessService.SingleSaveErrorResult CLUE_EXSIST = new ImportDataProcessService.SingleSaveErrorResult(true, "\u7ebf\u7d22\u5df2\u5b58\u5728");
    @Autowired
    private ClueService clueService;

    public DataProcType getProcessType() {
        return DataProcType.CONSULT;
    }

    public boolean validateHeader(List<String> headers) {
        if (CollectionUtils.isEmpty(headers)) {
            return false;
        }
        int index = 0;
        for (String header : headers) {
            if (!cache.containsKey(header.trim())) {
                return false;
            }
            Map<String, Object> item = cache.get(header);
            int sequence = (Integer)item.get("index");
            if (index != sequence) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public ImportDataProcessService.SingleSaveErrorResult saveSingleData(Long orgId, List<String> headers, Object[] lineData, boolean updateRepeat) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId.");
        Preconditions.checkArgument((lineData != null && lineData.length > 0 ? 1 : 0) != 0, (Object)"lineData \u4e3a\u7a7a");
        try {
            ConsultListResponseDto consultUser = new ConsultListResponseDto();
            this.buildOrgCourseInfoDto(consultUser, lineData, headers);
            this.wrapDto(consultUser);
            this.clueService.addClueInfo(orgId, consultUser, updateRepeat);
        }
        catch (BussinessException ex) {
            if (ex.getErrorCode().getSubsystemErrorCode() == CrmErrorCode.CUSTOM_HAS_EXISTS.getSubsystemErrorCode()) {
                return CLUE_EXSIST;
            }
            log.warn("save clue error:{}", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.warn("save clue error:{}", (Throwable)ex);
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.HANDLER_FAILED);
        }
        return IMPORT_SUCCESS;
    }

    private void wrapDto(ConsultListResponseDto consulter) throws UnsupportedEncodingException {
        String province = consulter.getProvince();
        String city = consulter.getCity();
        String county = consulter.getCounty();
        String address = consulter.getAddress();
        String region = "";
        int level = 0;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)county)) {
            region = county;
            level = AreaUtils.AreaLevel.COUNTY.ordinal();
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)city)) {
            region = city;
            level = AreaUtils.AreaLevel.CITY.ordinal();
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)province)) {
            region = province;
            level = AreaUtils.AreaLevel.PROVINCE.ordinal();
        }
        int areaId = this.getAreaId(region, level);
        Location location = BaiduMapUtils.getLngAndLat((String)address, (String)region);
        if (location != null) {
            consulter.setLatitude(location.getLat());
            consulter.setLongitude(location.getLng());
        }
        consulter.setAreaId(areaId);
    }

    private int getAreaId(String region, int level) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)region) || level == 0) {
            return 0;
        }
        List areas = this.areaDao.getAreaByBname(region, level);
        if (CollectionUtils.isNotEmpty((Collection)areas)) {
            return ((Area)areas.get(0)).getId();
        }
        return 0;
    }

    private void buildOrgCourseInfoDto(ConsultListResponseDto dto, Object[] lineData, List<String> headers) {
        Preconditions.checkArgument((lineData.length == headers.size() ? 1 : 0) != 0, (Object)"\u6570\u636e\u6570\u76ee\u548c\u8868\u5934\u4e0d\u5339\u914d");
        Preconditions.checkArgument((boolean)this.validateHeader(headers), (Object)("\u8868\u5934\u683c\u5f0f\u9519\u8bef:" + headers.toString()));
        for (int i = 0; i < lineData.length; ++i) {
            String fieldName = cache.get(headers.get(i)).get("propName").toString();
            boolean empty = Boolean.parseBoolean(cache.get(headers.get(i)).get("empty").toString());
            String name = headers.get(i);
            Object value = lineData[i];
            if (fieldName == null) continue;
            if (empty && (value == null || "".equals(value))) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + name + "\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                if (value == null || value instanceof String && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)value))) continue;
                BeanUtils.setProperty((Object)dto, (String)fieldName, (Object)value);
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.warn("set ConsultInfoResponseDto.{} = {} failed!", (Object)fieldName, value);
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR);
            }
        }
        if (!StringUtils.hanziAndLetterValidate((String)dto.getName()) || dto.getName().length() > 15) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.NAME_MUST_BE_HANZI_CHAR);
        }
        if (!ParamValidateUtils.validateMobile((String)dto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.MOBILE_FORMAT_ERROR);
        }
    }

    public ImportDataProcessService.BatchSaveResult batchImportDatas(Long orgId, List<String> headers, List<Object[]> datas, boolean updateRepeat) {
        ImportDataProcessService.BatchSaveResult batchSaveResult = new ImportDataProcessService.BatchSaveResult();
        for (int i = 0; i < datas.size(); ++i) {
            Object[] data = datas.get(i);
            try {
                ImportDataProcessService.SingleSaveErrorResult singleSaveErrorResult = this.saveSingleData(orgId, headers, data, updateRepeat);
                if (!singleSaveErrorResult.isRepeat()) continue;
                batchSaveResult.getRepeatIndexs().add(i);
                continue;
            }
            catch (Throwable ex) {
                batchSaveResult.getFailIndexs().add(i);
            }
        }
        return batchSaveResult;
    }

    static {
        String header = "\u5b66\u5458\u59d3\u540d:name:true,\u5b66\u5458\u624b\u673a:mobile:true,\u5bb6\u957f\u59d3\u540d:parentName:false,\u5bb6\u957f\u624b\u673a:parentMobile:false,\u751f\u65e5:birthday:false,\u610f\u5411\u7ea7\u522b:intensionLevel:false,\u54a8\u8be2\u72b6\u6001:consultStatus:false,\u5b66\u6821:school:false,\u73ed\u7ea7:degreeClass:false,\u7701:province:false,\u5e02:city:false,\u533a:county:false,\u8be6\u7ec6\u5730\u5740:address:false,\u7236\u4eb2\u804c\u4e1a:fatherOccupation:false,\u6bcd\u4eb2\u804c\u4e1a:matherOccupation:false";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)header) && header.contains(":")) {
            String[] cells = header.split(",");
            int index = 0;
            HashMap subMap = null;
            for (String cell : cells) {
                subMap = Maps.newHashMap();
                String[] column = cell.split(":");
                String name = column[0].trim();
                String propName = column[1];
                boolean empty = Boolean.parseBoolean(column[2]);
                subMap.put("propName", propName);
                subMap.put("index", index);
                subMap.put("empty", empty);
                cache.put(name, subMap);
                ++index;
            }
        }
    }
}

