/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.sync.impl;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.biz.consult.sync.SyncService;
import com.baijia.tianxiao.dal.advisory.service.AdvisoryService;
import com.baijia.tianxiao.dal.dto.response.AdvisoryInfoDto;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="syncStudentAdvisoryInfo")
public class SyncStudentAdvisoryInfoServiceImpl
implements SyncService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SyncStudentAdvisoryInfoServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private AdvisoryService advisoryService;
    @Autowired(required=false)
    private CloudAccount cloudAccount;
    private Properties queuePropties;
    private AtomicBoolean flag = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo = this.getSyncInfo(MsgSyncType.ADVISORY);
        log.info("start query msg by syncInfo:{}", (Object)syncInfo);
        if (this.flag.get()) {
            log.warn("last sync is not complete");
            return;
        }
        this.flag.set(true);
        try {
            this.syncTask(syncInfo);
        }
        catch (Exception e) {
            log.error("catch error:", (Throwable)e);
        }
        finally {
            this.flag.set(false);
        }
        log.info("send msg end,save syncInfo:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncTask(TxMsgSyncTimestamp syncInfo) {
        List dtos = this.advisoryService.getAdvisoryInfos(syncInfo.getSyncId(), syncInfo.getSyncTime(), 200);
        if (CollectionUtils.isNotEmpty((Collection)dtos)) {
            CloudQueue queue = this.cloudAccount.getMNSClient().getQueueRef(this.queuePropties.getProperty("consult.msg.queue"));
            ArrayList messages = Lists.newArrayList();
            for (AdvisoryInfoDto dto : dtos) {
                Message msg = new Message(ConsultType.APPOINTMENT.getValue() + "$" + JacksonUtil.obj2Str((Object)dto));
                messages.add(msg);
                if (dto.getAdvisoryId() <= syncInfo.getSyncId()) continue;
                syncInfo.setSyncId(dto.getAdvisoryId());
            }
            log.info("add {} messages into queue", (Object)messages.size());
            queue.batchPutMessage((List)messages);
        }
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }

    public void afterPropertiesSet() throws Exception {
        this.queuePropties = PropertiesReader.getProperties((String)"mns.properties");
        if (this.cloudAccount == null) {
            String id = this.queuePropties.getProperty("mns.accesskeyid");
            String secret = this.queuePropties.getProperty("mns.accesskeysecret");
            String endpoint = this.queuePropties.getProperty("mns.accountendpoint");
            this.cloudAccount = new CloudAccount(id, secret, endpoint);
        }
    }
}

