/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.biz.consult.msg.service.ConsultMessageConsumeService;
import com.baijia.tianxiao.biz.consult.msg.service.MessageConsumeService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class MessageConsumeServiceImp
implements InitializingBean,
ApplicationContextAware,
MessageConsumeService {
    private static final Logger log = LoggerFactory.getLogger(MessageConsumeServiceImp.class);
    private ApplicationContext context;
    private Map<Integer, ConsultMessageConsumeService> messageConsumeServiceMap;
    public static final String CONSULT_MSG_QUEUE = "consult.msg.queue";

    @Override
    public void consumeMessage(CloudQueue queue) {
        int i = 1;
        log.info("start pop msg from queue:{}", (Object)queue.getQueueURL());
        while (true) {
            try {
                while (true) {
                    Message message;
                    if ((message = queue.popMessage(12)) != null) {
                        log.info("get msg:{},body:{}", (Object)message.getMessageId(), (Object)message.getMessageBodyAsString());
                        if (this.consumeMessage(message)) {
                            log.info("msg:{} is success consume", (Object)message.getMessageId());
                            queue.deleteMessage(message.getReceiptHandle());
                        }
                    } else {
                        log.info("no message sleep 10 s");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    i = 1;
                }
            }
            catch (ClientException e) {
                log.error("catch msn client exception:", (Throwable)e);
                try {
                    Thread.sleep(20 * i * 1000);
                    ++i;
                }
                catch (InterruptedException e1) {
                }
                catch (Exception e2) {
                    log.error("catch exception:", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                log.error("pop msg from consult msg queue catch  exception:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private boolean consumeMessage(Message message) {
        try {
            Integer msgType = this.getConsultMsgTypeFromMsgBody(message);
            ConsultMessageConsumeService service = this.messageConsumeServiceMap.get(msgType);
            return service.consume(message.getMessageBodyAsString().substring(2));
        }
        catch (IllegalArgumentException e) {
            log.error("illegal message:", (Throwable)e);
        }
        catch (Exception e) {
            log.error("consume message catch error:", (Throwable)e);
        }
        return false;
    }

    private Integer getConsultMsgTypeFromMsgBody(Message message) {
        String messageBody = message.getMessageBodyAsString();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{messageBody}) && messageBody.length() > 2) {
            String head = messageBody.substring(0, 2);
            if (head.endsWith("$")) {
                try {
                    return Integer.parseInt(head.substring(0, 1));
                }
                catch (NumberFormatException e) {
                    log.error("message head is illeagl format type$");
                    throw new IllegalArgumentException("message format is illegal");
                }
            }
            log.error("message head is illeagl format type$");
            throw new IllegalArgumentException("message format is illegal");
        }
        log.error("message body is illegal:{}", (Object)messageBody);
        throw new IllegalArgumentException("message format is illegal");
    }

    public void afterPropertiesSet() throws Exception {
        Map services = this.context.getBeansOfType(ConsultMessageConsumeService.class);
        this.messageConsumeServiceMap = new HashMap<Integer, ConsultMessageConsumeService>();
        for (ConsultMessageConsumeService service : services.values()) {
            this.messageConsumeServiceMap.put(service.getConsultType().getValue(), service);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

