/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.pc.service.impl;

import com.baijia.tianxiao.biz.consult.enums.ConsulterOutLineType;
import com.baijia.tianxiao.biz.consult.enums.GenderStatus;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultListResponseDto;
import com.baijia.tianxiao.biz.consult.user.pc.service.ClueService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.constant.IntentionLevel;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueServiceImpl
implements ClueService {
    private static final Logger log = LoggerFactory.getLogger(ClueServiceImpl.class);
    @Resource
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TxStudentTagDao txStudentTagDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TXSaleClueRuleService txSaleClueRuleService;

    @Override
    public ConsultInfoResponseDto getBaseInfo(Long orgId, Long consulterId) throws Exception {
        if (null == orgId || orgId <= 0L || null == consulterId || consulterId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxConsultUser consulter = this.txConsultUserDao.getOrgConsultUser(orgId, consulterId);
        if (null == consulter) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        ConsultInfoResponseDto baseInfoDto = new ConsultInfoResponseDto();
        this.cluePo2Dto(consulter, baseInfoDto);
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());
        if (!isShowMobile) {
            baseInfoDto.setMobile(MaskUtil.maskMobile((String)baseInfoDto.getMobile()));
            baseInfoDto.setParentMobile(MaskUtil.maskMobile((String)baseInfoDto.getParentMobile()));
        }
        log.info("getBaseInfo---------baseInfoDto={}", (Object)baseInfoDto);
        return baseInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception {
        if (null == orgId || orgId <= 0L || null == clueInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        this.doSaveBefore(orgId, clueInfo);
        TxConsultUser consulter = new TxConsultUser();
        consulter.setIsConsulter(Integer.valueOf(Flag.TRUE.getInt()));
        this.clueDto2Po(clueInfo, consulter, orgId);
        this.txConsultUserDao.save((Object)consulter, Boolean.valueOf(false), new String[0]);
        log.info("addClueInfo---------consulter={}", (Object)consulter.toString());
        String contentFmt = "\u6dfb\u52a0\u7ebf\u7d22%s";
        contentFmt = String.format(contentFmt, consulter.getName());
        this.addSysConsulterComment(orgId, consulter.getId(), contentFmt);
        return consulter.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo, boolean updateRepeat) throws Exception {
        if (null == orgId || orgId <= 0L || null == clueInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        log.info("orgId:{}, clueInfo:{}, updateRepeat:{}", new Object[]{orgId, clueInfo, updateRepeat});
        TxConsultUser consulter = null;
        if (updateRepeat) {
            List consulters = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile(), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)consulters)) {
                consulter = (TxConsultUser)consulters.get(0);
                clueInfo.setId(consulter.getId());
            } else {
                consulter = new TxConsultUser();
            }
        } else {
            this.doSaveBefore(orgId, clueInfo);
            consulter = new TxConsultUser();
        }
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        log.debug("txSaleClueRule={}", (Object)txSaleClueRule);
        consulter.setFinallyHoldTime(DateUtil.getDiffDateTime((Date)new Date(), (int)txSaleClueRule.getMaxClueDelay()));
        consulter.setIsConsulter(Integer.valueOf(Flag.TRUE.getInt()));
        this.clueDto2Po(clueInfo, consulter, orgId);
        if (consulter.getId() != null && consulter.getId() > 0L) {
            this.txConsultUserDao.update((Object)consulter, new String[0]);
        } else {
            this.txConsultUserDao.save((Object)consulter, Boolean.valueOf(false), new String[0]);
        }
        log.info("addClueInfo---------consulter={}", (Object)consulter.toString());
        String contentFmt = "\u6dfb\u52a0\u7ebf\u7d22%s";
        contentFmt = String.format(contentFmt, consulter.getName());
        this.addSysConsulterComment(orgId, consulter.getId(), contentFmt);
        return consulter.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void editClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception {
        if (null == orgId || orgId <= 0L || null == clueInfo || null == clueInfo.getId() || clueInfo.getId() <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxConsultUser consulter = this.txConsultUserDao.getOrgConsultUser(orgId, clueInfo.getId());
        if (null == consulter) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        this.doSaveBefore(orgId, clueInfo);
        if (clueInfo.getMobile().contains("****")) {
            clueInfo.setMobile(consulter.getMobile());
        }
        if (clueInfo.getParentMobile().contains("****")) {
            clueInfo.setParentMobile(consulter.getParentMobile());
        }
        this.clueDto2Po(clueInfo, consulter, orgId);
        this.txConsultUserDao.update((Object)consulter, Boolean.valueOf(false), new String[0]);
        log.info("editClueInfo---------consulter={}", (Object)consulter.toString());
        String contentFmt = "\u4fee\u6539\u7ebf\u7d22%s";
        contentFmt = String.format(contentFmt, consulter.getName());
        this.addSysConsulterComment(orgId, consulter.getId(), contentFmt);
    }

    private void cluePo2Dto(TxConsultUser po, ConsultInfoResponseDto dto) throws IllegalAccessException, InvocationTargetException {
        log.info("cluePo2Dto---------po={}", (Object)po);
        BeanUtils.copyProperties((Object)dto, (Object)po);
        dto.setConsultSourceStr(MessageSource.getByType((Integer)po.getConsultSource()).getDesc());
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }
        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
            dto.setNextRemindTimeStr(po.getNextRemindTime());
        }
        dto.setConsultSourceStr(MessageSource.getByType((Integer)dto.getConsultSource()).getDesc());
        dto.setConsultStatusStr(ConsultUserStatus.getLabel((int)dto.getConsultStatus()));
        dto.setRelativesStr(Relatives.getLabel((Integer)dto.getRelatives()));
        dto.setId(dto.getId());
        dto.setCascadeIdStr(dto.getCascadeId() + "");
        dto.setSexStr(GenderStatus.getGenderStr(dto.getSex()));
        dto.setIntensionLevelStr(IntentionLevel.getLabel((Integer)dto.getIntensionLevel()));
        if (null != dto.getAreaId() && dto.getAreaId() > 0) {
            Map areaMap = AreaUtils.getAreaNameByCode((Integer)dto.getAreaId());
            dto.setProvince((String)areaMap.get("province"));
            dto.setCity((String)areaMap.get("city"));
            dto.setCounty((String)areaMap.get("county"));
        }
        if (dto.getCascadeId() == -1L) {
            dto.setCascadeIdStr("\u516c\u5171\u6c60");
        } else {
            Map casCadeMaps = this.txCascadeCredentialService.getByTxCasCadeIds(po.getOrgId());
            log.debug("cluePo2Dto casCadeMaps={},caid={}", (Object)casCadeMaps, (Object)dto.getCascadeId());
            dto.setCascadeIdStr((String)casCadeMaps.get(dto.getCascadeId()));
        }
    }

    private void clueDto2Po(ConsultListResponseDto dto, TxConsultUser po, Long orgId) throws IllegalAccessException, InvocationTargetException {
        log.info("clueDto2Po---------dto={}", (Object)dto);
        BeanUtils.copyProperties((Object)po, (Object)dto);
        if (dto.getNextRemindTime() == null) {
            po.setNextRemindTime(DateUtil.getOffSetDate((int)5));
        } else {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        }
        if (null == po.getId() || 0L == po.getId()) {
            po.setOrgId(orgId);
            po.setCreateTime(new Date());
        }
        if (null != dto.getBirthday()) {
            po.setBirthday(new Date(dto.getBirthday()));
        }
        if (dto.getCascadeId() == 0L) {
            po.setCascadeId(Long.valueOf(TianxiaoPCContext.getTXCascadeId() == null ? 0L : TianxiaoPCContext.getTXCascadeId().longValue()));
        } else {
            po.setCascadeId(Long.valueOf(dto.getCascadeId()));
        }
        po.setUpdateTime(new Date());
        if (po.getCascadeId() != null && po.getCascadeId() >= 0L) {
            po.setLastRemindTime(new Date());
        }
    }

    private void doSaveBefore(Long orgId, ConsultListResponseDto clueInfo) {
        if (clueInfo.getNextRemindTime() != null && clueInfo.getNextRemindTime() > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0b\u6b21\u63d0\u9192\u65f6\u95f4\u8d85\u8fc7\u6700\u5927\u8303\u56f4(2037-1-1)\u4e86");
        }
        if (clueInfo.getBirthday() != null && clueInfo.getBirthday() > System.currentTimeMillis()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u6765\u7684\u60a8\u8fd8\u672a\u51fa\u751f\u5427");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{clueInfo.getMobile()}) && !clueInfo.getMobile().contains("****")) {
            List targets = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile(), new String[0]);
            log.info("doSaveBefore---------clueInfo={},targets={}", (Object)clueInfo, (Object)targets);
            if (targets != null && !targets.isEmpty()) {
                if (clueInfo.getId() != null && clueInfo.getId() > 0L) {
                    if (targets.size() > 1 || ((TxConsultUser)targets.get(0)).getId().longValue() != clueInfo.getId().longValue()) {
                        throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u8be5\u624b\u673a\u53f7\u5df2\u5bf9\u5e94\u5176\u4ed6\u7ebf\u7d22");
                    }
                } else {
                    throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u8be5\u624b\u673a\u53f7\u5df2\u5bf9\u5e94\u5176\u4ed6\u7ebf\u7d22");
                }
            }
        }
    }

    @Override
    public List<ConsultListResponseDto> getClueList(long orgId, CommonSearchRequestDto request, PageDto pageDto) throws Exception {
        AutoMatchQueryRequest matchModel = request.generateAutoMatchModel(ConsultListResponseDto.class);
        Integer cascadeId = null;
        Integer isInvalid = null;
        List notInConsultUserIds = null;
        List inConsultUserIds = null;
        switch (ConsulterOutLineType.getEnum(request.getStatus())) {
            case MINE: {
                cascadeId = TianxiaoPCContext.getTXCascadeId();
                if (cascadeId == null) {
                    cascadeId = 0;
                }
                isInvalid = DataStatus.NORMAL.getValue();
                break;
            }
            case PUBLISH: {
                cascadeId = -1;
                isInvalid = DataStatus.NORMAL.getValue();
                break;
            }
            case NOT_FOLLOW_UP: {
                notInConsultUserIds = this.txStudentCommentDao.getLastDateComments(Long.valueOf(orgId), DateUtil.getStartOfDay((Date)DateUtil.getDayDiff((int)-7)), new String[0]);
                cascadeId = TianxiaoPCContext.getTXCascadeId();
                if (cascadeId == null) {
                    cascadeId = 0;
                }
                isInvalid = DataStatus.NORMAL.getValue();
                break;
            }
            case SUBORDINATE: {
                cascadeId = -2;
                isInvalid = DataStatus.NORMAL.getValue();
                break;
            }
            case INVALID: {
                isInvalid = DataStatus.DELETE.getValue();
            }
        }
        if (request.getName() != null && request.getName().equals("tag") && (inConsultUserIds = this.txStudentTagDao.searchByTagValue(Long.valueOf(orgId), request.getQuery(), new String[0])).isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List consultUsers = this.txConsultUserDao.searchConsultByCustomParam(orgId, matchModel, cascadeId, isInvalid, inConsultUserIds, notInConsultUserIds, pageDto);
        Map casCadeMaps = this.txCascadeCredentialService.getByTxCasCadeIds(Long.valueOf(orgId));
        boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(Long.valueOf(orgId), TianxiaoPCContext.getTXCascadeId());
        ArrayList result = Lists.newArrayList();
        for (TxConsultUser consultUser : consultUsers) {
            ConsultListResponseDto dto = ConsultListResponseDto.convertToDto(consultUser);
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile((String)dto.getParentMobile()));
            }
            if (consultUser.getCascadeId() == -1L) {
                dto.setCascadeIdStr("\u516c\u5171\u6c60");
            } else {
                dto.setCascadeIdStr((String)casCadeMaps.get(consultUser.getCascadeId()));
            }
            if (request.getStatus() == ConsulterOutLineType.INVALID.getValue()) {
                dto.setCascadeIdStr("");
            }
            result.add(dto);
        }
        return result;
    }

    @Override
    public void delClueInfo(Long clueInfoId) throws Exception {
        TxConsultUser consultUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)clueInfoId, new String[0]);
        consultUser.setDelStatus(Integer.valueOf(DataStatus.DELETE.getValue()));
        this.txConsultUserDao.update((Object)consultUser, new String[0]);
        String contentFmt = "\u5220\u9664\u7ebf\u7d22%s";
        contentFmt = String.format(contentFmt, consultUser.getName());
        this.addSysConsulterComment(consultUser.getOrgId(), consultUser.getId(), contentFmt);
    }

    @Override
    public void delClueInfo(List<Long> clueInfoIds) throws Exception {
        List consultUsers = this.txConsultUserDao.getByIds(clueInfoIds, new String[0]);
        for (TxConsultUser txConsultUser : consultUsers) {
            txConsultUser.setDelStatus(Integer.valueOf(DataStatus.DELETE.getValue()));
            this.txConsultUserDao.update((Object)txConsultUser, new String[0]);
            String contentFmt = "\u5220\u9664\u7ebf\u7d22%s";
            contentFmt = String.format(contentFmt, txConsultUser.getName());
            this.addSysConsulterComment(txConsultUser.getOrgId(), txConsultUser.getId(), contentFmt);
        }
    }

    public void addSysConsulterComment(Long orgId, Long consulterId, String content) {
        TxStudentComment po = new TxStudentComment();
        po.setOrgId(orgId);
        po.setConsultUserId(consulterId);
        po.setIsSystem(Integer.valueOf(Flag.TRUE.getInt()));
        po.setContent(content);
        this.txStudentCommentDao.save((Object)po, new String[0]);
    }
}

