/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.push.service.impl;

import com.baijia.tianxiao.biz.consult.push.service.WechatService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dto.content.AudioMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.ImageMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.TextMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.sal.push.dto.ConsultUserCacheDto;
import com.baijia.tianxiao.sal.push.dto.OrgCacheDto;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.baijia.tianxiao.sal.wechat.api.MessagePushService;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageContentDto;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageDto;
import com.baijia.tianxiao.util.ListUtil;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger log = LoggerFactory.getLogger(WechatServiceImpl.class);
    @Autowired
    private MessagePushService messagePushService;
    @Autowired
    private ConsultMessageService messageService;
    @Autowired
    private UserCacheService userCacheService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXCascadeAccountDao cascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao credentialDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Autowired
    private OrgCourseDao orgCourseDao;

    @Override
    @Transactional(noRollbackFor={BussinessException.class})
    public boolean sendMsgToWechat(Long orgId, Integer cascadeId, ConsultMessage message) throws CustomException {
        TXCascadeAccount cascadeAccount;
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        TxConsultUser user = (TxConsultUser)this.consultUserDao.getById((Serializable)Long.valueOf(message.getReceiverId()), new String[0]);
        if (cascadeId == null) {
            cascadeId = 0;
        }
        int kefuId = user.getKefuId().intValue();
        int role = this.userCacheService.getUserRole(user);
        if (role == MsgUserRole.STUDENT.getValue()) {
            Set<Integer> set = this.getHeadTeachers(orgId, user.getUserId());
            log.info("[Message] HeadTeachers={},kefuId={}", set, (Object)kefuId);
            if (!set.isEmpty()) {
                TXCascadeAccount cascadeAccount2;
                if (set.contains(kefuId) && kefuId != cascadeId && (cascadeAccount2 = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)Integer.valueOf(kefuId), new String[0])) != null) {
                    TXCascadeCredential credential = this.credentialDao.getTXCascadeCredentialByCredentialId(cascadeAccount2.getCredentialId());
                    throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_OWNER, this.getMessage(credential.getName()));
                }
                if (!set.contains(cascadeId)) {
                    throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_OWNER, "\u60a8\u7684\u6d88\u606f\u65e0\u6cd5\u9001\u8fbe\uff0c\u8be5\u5b66\u5458\u5df2\u6709\u73ed\u4e3b\u4efb\u8001\u5e08\u8ddf\u8fdb");
                }
            }
        } else if (role == MsgUserRole.CLUE.getValue()) {
            kefuId = user.getCascadeId().intValue();
        }
        if ((cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)Integer.valueOf(kefuId), new String[0])) == null || cascadeAccount.getIsdel() == 1 || cascadeAccount.getStatus() == 1) {
            log.warn("[Message] KefuId is invalid.CascadeId=" + cascadeId);
            kefuId = -1;
        }
        if (kefuId >= 0 && cascadeId != kefuId) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_OWNER);
        }
        log.info("[Wechat] Message = {},orgId={},cascadeId={}", new Object[]{ToStringBuilder.reflectionToString((Object)message), orgId, cascadeId});
        MessageDto dto = this.toMessageDto(account.getNumber().longValue(), message, user.getWeixinAppId());
        log.info("[Wechat] Message = " + ToStringBuilder.reflectionToString((Object)dto));
        WebResponse response = this.messagePushService.handle(dto);
        log.info("[Wechat] Response = " + ToStringBuilder.reflectionToString((Object)response));
        if (response.getCode() == 0L) {
            try {
                Date now = new Date();
                user.setLastRemindTime(now);
                user.setUpdateTime(now);
                Integer userRole = this.userCacheService.getUserRole(user);
                user.setCascadeId(Long.valueOf(cascadeId.longValue()));
                message.setReceiverRole(userRole.intValue());
                this.consultUserDao.update((Object)user, new String[0]);
            }
            catch (Exception e) {
                log.error("sendMsgToWechat - update LastRemindTime - error:{}", (Throwable)e);
            }
        }
        MsgUserRole userRole = this.getOrgAccountType(orgId, cascadeId);
        message.setSenderRole(userRole.getValue());
        message.setContent(message.getContent());
        this.messageService.addMessage(message);
        return true;
    }

    private MessageDto toMessageDto(Long orgNumber, ConsultMessage msg, String wechatAppId) {
        MessageDto pushDto = new MessageDto();
        pushDto.setMsgId(Integer.valueOf((int)msg.getId()));
        pushDto.setMsgT(Integer.valueOf(msg.getMsgType()));
        OrgCacheDto org = this.userCacheService.getOrg(orgNumber);
        if (org != null) {
            pushDto.setOrgId(Integer.valueOf(org.getOrgId().intValue()));
        }
        if (StringUtils.isBlank((String)wechatAppId) || !wechatAppId.equals(org.getWechatAppId())) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_BIND_ORG_WECHAT);
        }
        pushDto.setWechatAppid(org.getWechatAppId());
        ConsultUserCacheDto user = this.userCacheService.getConsultUser(Long.valueOf(msg.getReceiverId()));
        pushDto.setWechatOpenId(user.getWechatOpenId());
        MessageContentDto content = new MessageContentDto();
        Gson gson = new Gson();
        if (msg.getMsgType() == MsgType.TEXT.getValue()) {
            TextMsgContent msgContent = (TextMsgContent)gson.fromJson(msg.getContent(), TextMsgContent.class);
            content.setText(msgContent.getText());
        } else if (msg.getMsgType() == MsgType.PICTURE.getValue()) {
            ImageMsgContent imageMsgContent = (ImageMsgContent)gson.fromJson(msg.getContent(), ImageMsgContent.class);
            content.setUrl(imageMsgContent.getUrl());
            content.setWidth(Integer.valueOf(imageMsgContent.getWidth()));
            content.setStorageId(Integer.valueOf(imageMsgContent.getStorageId()));
            content.setHeight(Integer.valueOf(imageMsgContent.getHeight()));
        } else if (msg.getMsgType() == MsgType.VOICE.getValue()) {
            AudioMsgContent msgContent = (AudioMsgContent)gson.fromJson(msg.getContent(), AudioMsgContent.class);
            content.setLength(Integer.valueOf(msgContent.getLen()));
            content.setUrl(msgContent.getUrl());
            content.setStorageId(Integer.valueOf((int)msgContent.getStorageId()));
        } else {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.NOT_SUPPORT_CARD);
        }
        pushDto.setContent(content);
        return pushDto;
    }

    private MsgUserRole getOrgAccountType(long orgId, Integer cascadeId) {
        if (cascadeId == null || cascadeId == 0) {
            OrgSubAccount subAccount = this.orgSubAccountDao.getMasterByOrgId(Integer.valueOf((int)orgId));
            log.info("OrgId=" + orgId + ";OrgSubAccount=" + subAccount);
            if (subAccount != null) {
                return MsgUserRole.HEADER;
            }
            return MsgUserRole.BRANCH_HEADER;
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)cascadeId, new String[0]);
        if (cascadeAccount.getAccountType() == 3) {
            return MsgUserRole.MANAGER;
        }
        return MsgUserRole.STAFF;
    }

    private Set<Integer> getHeadTeachers(Long orgId, Long userId) {
        List orgCourseIds = this.studentCourseDao.getOrgCourseIds(orgId, userId, null);
        List courseIds = ListUtil.toKeyList((Collection)orgCourseIds, (String)"courseId", OrgStudentCourse.class);
        List courses = this.orgCourseDao.getByIds((Collection)courseIds, new String[]{"cascadeId"});
        HashSet<Integer> set = new HashSet<Integer>();
        if (courses != null && courses.size() > 0) {
            for (OrgCourse course : courses) {
                if (course.getCascadeId() == null || course.getCascadeId() < 0) continue;
                set.add(course.getCascadeId());
            }
        }
        return set;
    }

    private String getMessage(String name) {
        return "\u60a8\u7684\u6d88\u606f\u65e0\u6cd5\u9001\u8fbe\uff0c" + name + "\u4e3a\u5bf9\u65b9\u7684\u8054\u7cfb\u4eba\uff0c\u4ec5" + name + "\u53ef\u4e0e\u5bf9\u65b9\u8054\u7cfb";
    }
}

