/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.dto.response.ActivityInfo;
import com.baijia.tianxiao.biz.consult.msg.service.BizActivityService;
import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizActivityServiceImpl
implements BizActivityService {
    private static final Logger log = LoggerFactory.getLogger(BizActivityServiceImpl.class);
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private ActivityConfDao activityConf;
    @Autowired
    private CustomActivityService customActivityService;
    private TemplateConstant templateConstant;

    @Override
    public List<ActivityInfo> getAllActivities(long orgId) {
        ActivityInfo instance;
        ArrayList<ActivityInfo> ret = new ArrayList<ActivityInfo>();
        List activities = this.activityDao.selectCurrentActivityList(orgId);
        List drawList = this.drawActivityDao.selectCurrentDraw(orgId);
        List voteList = this.voteInfoDao.selectCurrentVoteList(orgId);
        List referralList = this.referralInfoDao.selectCurrentReferralList(orgId);
        if (activities != null) {
            for (Activity activity : activities) {
                ActivityConf conf = this.activityConf.getConfigByActivityId(activity.getId().longValue());
                ActivityInfo instance2 = ActivityInfo.getInstance(activity, (Template)TemplateConstant.getMap().get(conf.getTemplateId()));
                instance2.setUrl(this.getUrl("/activity.html?activityId=", activity.getId()));
                ret.add(instance2);
            }
        }
        if (drawList != null) {
            for (DrawInfo info : drawList) {
                instance = ActivityInfo.getInstance(info, (Template)TemplateConstant.getMap().get(info.getTemplateId()));
                instance.setUrl(this.getUrl(String.valueOf(TemplateConstant.getTemplateUrl((Integer)info.getTemplateId())) + "&activityId=", info.getActivityId()));
                ret.add(instance);
            }
        }
        if (voteList != null) {
            for (DrawInfo info : voteList) {
                instance = ActivityInfo.getInstance((VoteInfo)info, (Template)TemplateConstant.getMap().get(info.getTemplateId()));
                instance.setUrl(this.getUrl(String.valueOf(TemplateConstant.getTemplateUrl((Integer)info.getTemplateId())) + "&activityId=", info.getActivityId()));
                ret.add(instance);
            }
        }
        if (referralList != null) {
            for (DrawInfo info : referralList) {
                instance = ActivityInfo.getInstance((ReferralInfo)info, (Template)TemplateConstant.getMap().get(info.getTemplateId().intValue()));
                instance.setUrl(this.getUrl("/referral.html?activityId=", info.getActivityId()));
                ret.add(instance);
            }
        }
        return ret;
    }

    private String getWechatUrl(long activityId, int templateId) {
        log.info("[param] activityId=" + activityId + ";templateId=" + templateId);
        CustomActivityDto dto = this.customActivityService.getCustomActivity((int)activityId, templateId);
        if (dto != null) {
            log.info("ShareUrl=" + dto.getWebAuthUrl());
            return dto.getWebAuthUrl();
        }
        return "";
    }

    private String getUrl(String prefix, long activityId) {
        StringBuilder sb = new StringBuilder();
        sb.append(Config.DOMAIN);
        sb.append(prefix).append(activityId).append("#!/");
        return sb.toString();
    }
}

