/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.dto.response;

import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.Template;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.sal.marketing.commons.enums.TemplateTypeCategory;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityInfo {
    private static final Logger log = LoggerFactory.getLogger(ActivityInfo.class);
    private long id;
    private String name;
    private String thumb;
    private int type;
    private String url;
    private String content;

    public static ActivityInfo getInstance(Activity activity, Template template) {
        ActivityInfo info = new ActivityInfo();
        info.setId(activity.getId());
        info.setName(activity.getTitle());
        info.setThumb(template.getThumbNail());
        info.setContent(template.getActivityDesc());
        info.setType(TemplateTypeCategory.COMMON_TYPE.getType());
        return info;
    }

    public static ActivityInfo getInstance(DrawInfo drawInfo, Template template) {
        ActivityInfo info = new ActivityInfo();
        info.setId(drawInfo.getActivityId());
        info.setName(drawInfo.getName());
        info.setThumb(template.getThumbNail());
        info.setContent(template.getActivityDesc());
        info.setType(TemplateTypeCategory.DRAW_TYPE.getType());
        return info;
    }

    public static ActivityInfo getInstance(VoteInfo vote, Template template) {
        ActivityInfo info = new ActivityInfo();
        info.setId(vote.getActivityId());
        info.setName(vote.getName());
        info.setThumb(template.getThumbNail());
        info.setContent(template.getActivityDesc());
        info.setType(TemplateTypeCategory.VOTE_TYPE.getType());
        return info;
    }

    public static ActivityInfo getInstance(ReferralInfo referralInfo, Template template) {
        log.info("[Activity] template=" + ToStringBuilder.reflectionToString((Object)template));
        ActivityInfo info = new ActivityInfo();
        info.setId(referralInfo.getActivityId());
        info.setName(referralInfo.getTitle());
        info.setThumb(template.getThumbNail());
        info.setContent(template.getActivityDesc());
        info.setType(TemplateTypeCategory.REFERRAL_TYPE.getType());
        return info;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getThumb() {
        return this.thumb;
    }

    public int getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContent() {
        return this.content;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setThumb(String thumb) {
        this.thumb = thumb;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivityInfo)) {
            return false;
        }
        ActivityInfo other = (ActivityInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$thumb = this.getThumb();
        String other$thumb = other.getThumb();
        if (this$thumb == null ? other$thumb != null : !this$thumb.equals(other$thumb)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivityInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id ^ $id >>> 32);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $thumb = this.getThumb();
        result = result * 59 + ($thumb == null ? 43 : $thumb.hashCode());
        result = result * 59 + this.getType();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "ActivityInfo(id=" + this.getId() + ", name=" + this.getName() + ", thumb=" + this.getThumb() + ", type=" + this.getType() + ", url=" + this.getUrl() + ", content=" + this.getContent() + ")";
    }
}

