/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.pc.service.impl;

import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultListResponseDto;
import com.baijia.tianxiao.biz.consult.user.pc.service.ClueService;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClueServiceImpl
implements ClueService {
    private static final Logger log = LoggerFactory.getLogger(ClueServiceImpl.class);
    @Resource
    TxConsultUserDao txConsultUserDao;

    @Override
    public ConsultInfoResponseDto getBaseInfo(Long orgId, Long consulterId) throws Exception {
        if (null == orgId || orgId <= 0L || null == consulterId || consulterId <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxConsultUser consulter = this.txConsultUserDao.getOrgConsultUser(orgId, consulterId);
        if (null == consulter) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        ConsultInfoResponseDto baseInfoDto = new ConsultInfoResponseDto();
        this.cluePo2Dto(consulter, baseInfoDto);
        log.info("getBaseInfo---------baseInfoDto={}", (Object)baseInfoDto);
        return baseInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception {
        if (null == orgId || orgId <= 0L || null == clueInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        this.doSaveBefore(orgId, clueInfo);
        TxConsultUser consulter = new TxConsultUser();
        this.clueDto2Po(clueInfo, consulter, orgId);
        this.txConsultUserDao.save((Object)consulter, Boolean.valueOf(false), new String[0]);
        log.info("addClueInfo---------consulter={}", (Object)consulter.toString());
        return consulter.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo, boolean updateRepeat) throws Exception {
        if (null == orgId || orgId <= 0L || null == clueInfo) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        log.info("orgId:{}, clueInfo:{}, updateRepeat:{}", new Object[]{orgId, clueInfo, updateRepeat});
        TxConsultUser consulter = null;
        if (updateRepeat) {
            List consulters = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile(), new String[0]);
            if (CollectionUtils.isNotEmpty((Collection)consulters)) {
                consulter = (TxConsultUser)consulters.get(0);
                clueInfo.setId(consulter.getId());
            } else {
                consulter = new TxConsultUser();
            }
        } else {
            this.doSaveBefore(orgId, clueInfo);
            consulter = new TxConsultUser();
        }
        this.clueDto2Po(clueInfo, consulter, orgId);
        if (consulter.getId() != null && consulter.getId() > 0L) {
            this.txConsultUserDao.update((Object)consulter, new String[0]);
        } else {
            this.txConsultUserDao.save((Object)consulter, Boolean.valueOf(false), new String[0]);
        }
        log.info("addClueInfo---------consulter={}", (Object)consulter.toString());
        return consulter.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void editClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception {
        if (null == orgId || orgId <= 0L || null == clueInfo || null == clueInfo.getId() || clueInfo.getId() <= 0L) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxConsultUser consulter = this.txConsultUserDao.getOrgConsultUser(orgId, clueInfo.getId());
        if (null == consulter) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        this.doSaveBefore(orgId, clueInfo);
        this.clueDto2Po(clueInfo, consulter, orgId);
        this.txConsultUserDao.update((Object)consulter, Boolean.valueOf(false), new String[0]);
        log.info("editClueInfo---------consulter={}", (Object)consulter.toString());
    }

    private void cluePo2Dto(TxConsultUser po, ConsultInfoResponseDto dto) throws IllegalAccessException, InvocationTargetException {
        log.info("cluePo2Dto---------po={}", (Object)po);
        BeanUtils.copyProperties((Object)dto, (Object)po);
        dto.setConsultSourceStr(ConsultType.getByType((Integer)po.getConsultSource()).getDesc());
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }
        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
        }
        if (null != dto.getAreaId() && dto.getAreaId() > 0) {
            Map areaMap = AreaUtils.getAreaNameByCode((Integer)dto.getAreaId());
            dto.setProvince((String)areaMap.get("province"));
            dto.setCity((String)areaMap.get("city"));
            dto.setCounty((String)areaMap.get("county"));
        }
    }

    private void clueDto2Po(ConsultListResponseDto dto, TxConsultUser po, Long orgId) throws IllegalAccessException, InvocationTargetException {
        log.info("clueDto2Po---------dto={}", (Object)dto);
        BeanUtils.copyProperties((Object)po, (Object)dto);
        if (dto.getNextRemindTime() == null || dto.getNextRemindTime() <= 0L) {
            po.setNextRemindTime(DateUtil.getOffSetDate((int)5));
        } else {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        }
        if (null == po.getId() || 0L == po.getId()) {
            po.setOrgId(orgId);
            po.setCreateTime(new Date());
        }
        if (null != dto.getBirthday()) {
            po.setBirthday(new Date(dto.getBirthday()));
        }
        po.setUpdateTime(new Date());
    }

    private void doSaveBefore(Long orgId, ConsultListResponseDto clueInfo) {
        if (clueInfo.getNextRemindTime() != null && clueInfo.getNextRemindTime() > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0b\u6b21\u63d0\u9192\u65f6\u95f4\u8d85\u8fc7\u6700\u5927\u8303\u56f4(2037-1-1)\u4e86");
        }
        if (clueInfo.getBirthday() != null && clueInfo.getBirthday() > System.currentTimeMillis()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u6765\u7684\u60a8\u8fd8\u672a\u51fa\u751f\u5427");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{clueInfo.getMobile()}) && !clueInfo.getMobile().contains("****")) {
            List targets = this.txConsultUserDao.lookByMobile(orgId, clueInfo.getMobile(), new String[0]);
            log.info("doSaveBefore---------clueInfo={},targets={}", (Object)clueInfo, (Object)targets);
            if (targets != null && !targets.isEmpty()) {
                if (clueInfo.getId() != null && clueInfo.getId() > 0L) {
                    if (targets.size() > 1 || ((TxConsultUser)targets.get(0)).getId().longValue() != clueInfo.getId().longValue()) {
                        throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u8be5\u624b\u673a\u53f7\u5df2\u5bf9\u5e94\u5176\u4ed6\u610f\u5411\u5b66\u5458\u6216\u6b63\u5f0f\u5b66\u5458");
                    }
                } else {
                    throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u8be5\u624b\u673a\u53f7\u5df2\u5bf9\u5e94\u5176\u4ed6\u610f\u5411\u5b66\u5458\u6216\u6b63\u5f0f\u5b66\u5458");
                }
            }
        }
    }

    @Override
    public List<ConsultListResponseDto> getClueList(long orgId, CommonSearchRequestDto request, PageDto pageDto) throws Exception {
        AutoMatchQueryRequest matchModel = request.generateAutoMatchModel(ConsultListResponseDto.class);
        List consultUsers = this.txConsultUserDao.searchConsultByCustomParam(orgId, matchModel, pageDto);
        ArrayList result = Lists.newArrayList();
        for (TxConsultUser consultUser : consultUsers) {
            result.add(ConsultListResponseDto.convertToDto(consultUser));
        }
        return result;
    }
}

