/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.dto;

import com.baijia.tianxiao.biz.consult.user.dto.response.ConsulterResponseDto;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dal.push.constant.ConsultUserType;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.util.date.DateUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ConsulterDto
implements MsgUser {
    private Long consulterId;
    private Long orgId;
    private Long userNumber;
    private String studentName;
    private String nickName;
    private String mobile;
    private int intensionLevel = 3;
    private int consultSource;
    private String weixin;
    private String weixinNickName;
    private String weixinOpenId;
    private int chat = 0;
    private String parentName;
    private String parentMobile;
    private Long nextRemindTime;
    private String school;
    private String qq;
    @JsonProperty(value="mail")
    private String email;
    private Long birthday;
    private String degreeClass;
    private int consultStatus;
    private String address;
    private String fatherOccupation;
    private String matherOccupation;
    private boolean canEditMobile;
    private Integer origin;

    public Long getUserId() {
        return this.consulterId;
    }

    public String getName() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.studentName})) {
            return this.studentName;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.weixinNickName})) {
            return this.weixinNickName;
        }
        return "\u533f\u540d\u5b66\u751f";
    }

    public Long getNumber() {
        return this.userNumber;
    }

    public UserRoleEnum getRole() {
        return UserRoleEnum.STUDENT;
    }

    public ConsultUserType getType() {
        return ConsultUserType.CONSULT_STU;
    }

    public int getIntentLevel() {
        return this.intensionLevel;
    }

    public static ConsulterResponseDto convertToDto(TxConsultUser user) {
        ConsulterResponseDto dto = new ConsulterResponseDto();
        if (user != null) {
            dto.setOrgId(user.getOrgId());
            dto.setConsulterId(user.getId());
            dto.setAddress(user.getAddress());
            dto.setBirthday(user.getBirthday() != null ? user.getBirthday().getTime() : 0L);
            dto.setConsultSource(user.getConsultSource());
            dto.setConsultStatus(user.getConsultStatus());
            dto.setDegreeClass(user.getDegreeClass());
            dto.setEmail(user.getMail());
            dto.setFatherOccupation(user.getFatherOccupation());
            dto.setIntensionLevel(user.getIntensionLevel());
            dto.setMatherOccupation(user.getMatherOccupation());
            dto.setCanEditMobile(true);
            dto.setMobile(user.getMobile());
            dto.setNextRemindTime(user.getNextRemindTime() != null ? user.getNextRemindTime().getTime() : 0L);
            dto.setNickName(user.getNickName());
            dto.setParentMobile(user.getParentMobile());
            dto.setParentName(user.getParentName());
            dto.setQq(user.getQq());
            dto.setSchool(user.getSchool());
            dto.setStudentName(user.getName());
            dto.setUserNumber(user.getUserNumber());
            dto.setWeixin(user.getWeixin());
            dto.setWeixinNickName(user.getWeixinNickName());
            dto.setWeixinOpenId(user.getWeixinOpenId());
        }
        return dto;
    }

    public static TxConsultUser convertToConsultUser(ConsulterDto dto) {
        if (dto == null) {
            return null;
        }
        TxConsultUser user = new TxConsultUser();
        user.setOrgId(dto.getOrgId());
        user.setAddress(dto.getAddress());
        user.setBirthday(dto.getBirthday() != null && dto.getBirthday() > 0L ? new Date(dto.getBirthday()) : null);
        user.setConsultSource(Integer.valueOf(dto.getConsultSource()));
        user.setConsultStatus(dto.getConsultStatus());
        user.setDegreeClass(dto.getDegreeClass());
        user.setMail(dto.getEmail());
        user.setFatherOccupation(dto.getFatherOccupation());
        user.setIntensionLevel(dto.getIntensionLevel());
        user.setMatherOccupation(dto.getMatherOccupation());
        user.setMobile(dto.getMobile());
        if (dto.getNextRemindTime() == null || dto.getNextRemindTime() <= 0L) {
            user.setNextRemindTime(DateUtil.getOffSetDate((int)3));
        } else {
            user.setNextRemindTime(new Date(dto.getNextRemindTime()));
        }
        user.setNickName(dto.getNickName());
        user.setParentMobile(dto.getParentMobile());
        user.setParentName(dto.getParentName());
        user.setQq(dto.getQq());
        user.setSchool(dto.getSchool());
        user.setName(dto.getStudentName());
        user.setUserNumber(dto.getUserNumber());
        user.setWeixin(dto.getWeixin());
        user.setWeixinNickName(dto.getWeixinNickName());
        if (StringUtils.isNotBlank((CharSequence)dto.getWeixinOpenId()) && !"0".equals(dto.getWeixinOpenId())) {
            user.setWeixinOpenId(dto.getWeixinOpenId());
        }
        return user;
    }

    public Long getConsulterId() {
        return this.consulterId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Long getUserNumber() {
        return this.userNumber;
    }

    public String getStudentName() {
        return this.studentName;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getMobile() {
        return this.mobile;
    }

    public int getIntensionLevel() {
        return this.intensionLevel;
    }

    public int getConsultSource() {
        return this.consultSource;
    }

    public String getWeixin() {
        return this.weixin;
    }

    public String getWeixinNickName() {
        return this.weixinNickName;
    }

    public String getWeixinOpenId() {
        return this.weixinOpenId;
    }

    public int getChat() {
        return this.chat;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getParentMobile() {
        return this.parentMobile;
    }

    public Long getNextRemindTime() {
        return this.nextRemindTime;
    }

    public String getSchool() {
        return this.school;
    }

    public String getQq() {
        return this.qq;
    }

    public String getEmail() {
        return this.email;
    }

    public Long getBirthday() {
        return this.birthday;
    }

    public String getDegreeClass() {
        return this.degreeClass;
    }

    public int getConsultStatus() {
        return this.consultStatus;
    }

    public String getAddress() {
        return this.address;
    }

    public String getFatherOccupation() {
        return this.fatherOccupation;
    }

    public String getMatherOccupation() {
        return this.matherOccupation;
    }

    public boolean isCanEditMobile() {
        return this.canEditMobile;
    }

    public Integer getOrigin() {
        return this.origin;
    }

    public void setConsulterId(Long consulterId) {
        this.consulterId = consulterId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setUserNumber(Long userNumber) {
        this.userNumber = userNumber;
    }

    public void setStudentName(String studentName) {
        this.studentName = studentName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setIntensionLevel(int intensionLevel) {
        this.intensionLevel = intensionLevel;
    }

    public void setConsultSource(int consultSource) {
        this.consultSource = consultSource;
    }

    public void setWeixin(String weixin) {
        this.weixin = weixin;
    }

    public void setWeixinNickName(String weixinNickName) {
        this.weixinNickName = weixinNickName;
    }

    public void setWeixinOpenId(String weixinOpenId) {
        this.weixinOpenId = weixinOpenId;
    }

    public void setChat(int chat) {
        this.chat = chat;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setParentMobile(String parentMobile) {
        this.parentMobile = parentMobile;
    }

    public void setNextRemindTime(Long nextRemindTime) {
        this.nextRemindTime = nextRemindTime;
    }

    public void setSchool(String school) {
        this.school = school;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    public void setDegreeClass(String degreeClass) {
        this.degreeClass = degreeClass;
    }

    public void setConsultStatus(int consultStatus) {
        this.consultStatus = consultStatus;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setFatherOccupation(String fatherOccupation) {
        this.fatherOccupation = fatherOccupation;
    }

    public void setMatherOccupation(String matherOccupation) {
        this.matherOccupation = matherOccupation;
    }

    public void setCanEditMobile(boolean canEditMobile) {
        this.canEditMobile = canEditMobile;
    }

    public void setOrigin(Integer origin) {
        this.origin = origin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsulterDto)) {
            return false;
        }
        ConsulterDto other = (ConsulterDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$consulterId = this.getConsulterId();
        Long other$consulterId = other.getConsulterId();
        if (this$consulterId == null ? other$consulterId != null : !((Object)this$consulterId).equals(other$consulterId)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Long this$userNumber = this.getUserNumber();
        Long other$userNumber = other.getUserNumber();
        if (this$userNumber == null ? other$userNumber != null : !((Object)this$userNumber).equals(other$userNumber)) {
            return false;
        }
        String this$studentName = this.getStudentName();
        String other$studentName = other.getStudentName();
        if (this$studentName == null ? other$studentName != null : !this$studentName.equals(other$studentName)) {
            return false;
        }
        String this$nickName = this.getNickName();
        String other$nickName = other.getNickName();
        if (this$nickName == null ? other$nickName != null : !this$nickName.equals(other$nickName)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        if (this.getIntensionLevel() != other.getIntensionLevel()) {
            return false;
        }
        if (this.getConsultSource() != other.getConsultSource()) {
            return false;
        }
        String this$weixin = this.getWeixin();
        String other$weixin = other.getWeixin();
        if (this$weixin == null ? other$weixin != null : !this$weixin.equals(other$weixin)) {
            return false;
        }
        String this$weixinNickName = this.getWeixinNickName();
        String other$weixinNickName = other.getWeixinNickName();
        if (this$weixinNickName == null ? other$weixinNickName != null : !this$weixinNickName.equals(other$weixinNickName)) {
            return false;
        }
        String this$weixinOpenId = this.getWeixinOpenId();
        String other$weixinOpenId = other.getWeixinOpenId();
        if (this$weixinOpenId == null ? other$weixinOpenId != null : !this$weixinOpenId.equals(other$weixinOpenId)) {
            return false;
        }
        if (this.getChat() != other.getChat()) {
            return false;
        }
        String this$parentName = this.getParentName();
        String other$parentName = other.getParentName();
        if (this$parentName == null ? other$parentName != null : !this$parentName.equals(other$parentName)) {
            return false;
        }
        String this$parentMobile = this.getParentMobile();
        String other$parentMobile = other.getParentMobile();
        if (this$parentMobile == null ? other$parentMobile != null : !this$parentMobile.equals(other$parentMobile)) {
            return false;
        }
        Long this$nextRemindTime = this.getNextRemindTime();
        Long other$nextRemindTime = other.getNextRemindTime();
        if (this$nextRemindTime == null ? other$nextRemindTime != null : !((Object)this$nextRemindTime).equals(other$nextRemindTime)) {
            return false;
        }
        String this$school = this.getSchool();
        String other$school = other.getSchool();
        if (this$school == null ? other$school != null : !this$school.equals(other$school)) {
            return false;
        }
        String this$qq = this.getQq();
        String other$qq = other.getQq();
        if (this$qq == null ? other$qq != null : !this$qq.equals(other$qq)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Long this$birthday = this.getBirthday();
        Long other$birthday = other.getBirthday();
        if (this$birthday == null ? other$birthday != null : !((Object)this$birthday).equals(other$birthday)) {
            return false;
        }
        String this$degreeClass = this.getDegreeClass();
        String other$degreeClass = other.getDegreeClass();
        if (this$degreeClass == null ? other$degreeClass != null : !this$degreeClass.equals(other$degreeClass)) {
            return false;
        }
        if (this.getConsultStatus() != other.getConsultStatus()) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$fatherOccupation = this.getFatherOccupation();
        String other$fatherOccupation = other.getFatherOccupation();
        if (this$fatherOccupation == null ? other$fatherOccupation != null : !this$fatherOccupation.equals(other$fatherOccupation)) {
            return false;
        }
        String this$matherOccupation = this.getMatherOccupation();
        String other$matherOccupation = other.getMatherOccupation();
        if (this$matherOccupation == null ? other$matherOccupation != null : !this$matherOccupation.equals(other$matherOccupation)) {
            return false;
        }
        if (this.isCanEditMobile() != other.isCanEditMobile()) {
            return false;
        }
        Integer this$origin = this.getOrigin();
        Integer other$origin = other.getOrigin();
        return !(this$origin == null ? other$origin != null : !((Object)this$origin).equals(other$origin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsulterDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $consulterId = this.getConsulterId();
        result = result * 59 + ($consulterId == null ? 43 : ((Object)$consulterId).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Long $userNumber = this.getUserNumber();
        result = result * 59 + ($userNumber == null ? 43 : ((Object)$userNumber).hashCode());
        String $studentName = this.getStudentName();
        result = result * 59 + ($studentName == null ? 43 : $studentName.hashCode());
        String $nickName = this.getNickName();
        result = result * 59 + ($nickName == null ? 43 : $nickName.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        result = result * 59 + this.getIntensionLevel();
        result = result * 59 + this.getConsultSource();
        String $weixin = this.getWeixin();
        result = result * 59 + ($weixin == null ? 43 : $weixin.hashCode());
        String $weixinNickName = this.getWeixinNickName();
        result = result * 59 + ($weixinNickName == null ? 43 : $weixinNickName.hashCode());
        String $weixinOpenId = this.getWeixinOpenId();
        result = result * 59 + ($weixinOpenId == null ? 43 : $weixinOpenId.hashCode());
        result = result * 59 + this.getChat();
        String $parentName = this.getParentName();
        result = result * 59 + ($parentName == null ? 43 : $parentName.hashCode());
        String $parentMobile = this.getParentMobile();
        result = result * 59 + ($parentMobile == null ? 43 : $parentMobile.hashCode());
        Long $nextRemindTime = this.getNextRemindTime();
        result = result * 59 + ($nextRemindTime == null ? 43 : ((Object)$nextRemindTime).hashCode());
        String $school = this.getSchool();
        result = result * 59 + ($school == null ? 43 : $school.hashCode());
        String $qq = this.getQq();
        result = result * 59 + ($qq == null ? 43 : $qq.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Long $birthday = this.getBirthday();
        result = result * 59 + ($birthday == null ? 43 : ((Object)$birthday).hashCode());
        String $degreeClass = this.getDegreeClass();
        result = result * 59 + ($degreeClass == null ? 43 : $degreeClass.hashCode());
        result = result * 59 + this.getConsultStatus();
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $fatherOccupation = this.getFatherOccupation();
        result = result * 59 + ($fatherOccupation == null ? 43 : $fatherOccupation.hashCode());
        String $matherOccupation = this.getMatherOccupation();
        result = result * 59 + ($matherOccupation == null ? 43 : $matherOccupation.hashCode());
        result = result * 59 + (this.isCanEditMobile() ? 79 : 97);
        Integer $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : ((Object)$origin).hashCode());
        return result;
    }

    public String toString() {
        return "ConsulterDto(super=" + super.toString() + ", consulterId=" + this.getConsulterId() + ", orgId=" + this.getOrgId() + ", userNumber=" + this.getUserNumber() + ", studentName=" + this.getStudentName() + ", nickName=" + this.getNickName() + ", mobile=" + this.getMobile() + ", intensionLevel=" + this.getIntensionLevel() + ", consultSource=" + this.getConsultSource() + ", weixin=" + this.getWeixin() + ", weixinNickName=" + this.getWeixinNickName() + ", weixinOpenId=" + this.getWeixinOpenId() + ", chat=" + this.getChat() + ", parentName=" + this.getParentName() + ", parentMobile=" + this.getParentMobile() + ", nextRemindTime=" + this.getNextRemindTime() + ", school=" + this.getSchool() + ", qq=" + this.getQq() + ", email=" + this.getEmail() + ", birthday=" + this.getBirthday() + ", degreeClass=" + this.getDegreeClass() + ", consultStatus=" + this.getConsultStatus() + ", address=" + this.getAddress() + ", fatherOccupation=" + this.getFatherOccupation() + ", matherOccupation=" + this.getMatherOccupation() + ", canEditMobile=" + this.isCanEditMobile() + ", origin=" + this.getOrigin() + ")";
    }
}

