/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.user.service.impl;

import com.baijia.tianxiao.biz.consult.enums.SortOperation;
import com.baijia.tianxiao.biz.consult.user.service.ConsultCustomSourceService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.roster.dao.ConsultCustomSourceDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.ConsultCustomSource;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultCustomSourceServiceImpl
implements ConsultCustomSourceService {
    private static final Logger log = LoggerFactory.getLogger(ConsultCustomSourceServiceImpl.class);
    @Autowired
    private ConsultCustomSourceDao customSourceDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TXSaleClueRuleService saleClueRuleService;
    @Autowired
    private ConsultSourceService consultSourceService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConsultCustomSourceDto add(Long orgId, String label) {
        Date now = new Date();
        ConsultCustomSource.vaildateLabel((String)label);
        ConsultCustomSource source = this.customSourceDao.getBy(orgId, label);
        if (source != null) {
            throw new ParameterException("\u6307\u5b9a\u540d\u79f0\u5df2\u88ab\u4f7f\u7528,\u8bf7\u52ff\u91cd\u590d\u521b\u5efa\u3002");
        }
        source = new ConsultCustomSource();
        source.setIsPaused(Integer.valueOf(Flag.FALSE.getInt()));
        source.setLabel(label);
        source.setOrgId(orgId);
        source.setCreateTime(now);
        source.setUpdateTime(now);
        this.customSourceDao.save((Object)source, new String[0]);
        log.info("customSourceDao.save - source:{}", (Object)source);
        return ConsultCustomSourceDto.buildBy((ConsultCustomSource)source);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(Long orgId, Long id) {
        if (this.txConsultUserDao.countBySource(orgId, id) > 0) {
            throw new PermissionException("\u8be5\u7ebf\u7d22\u6765\u6e90\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u4ec5\u53ef\u505c\u7528\u3002");
        }
        this.customSourceDao.delById((Serializable)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConsultCustomSourceDto edit(Long orgId, Long id, String label) {
        Date now = new Date();
        ConsultCustomSource.vaildateLabel((String)label);
        ConsultCustomSource source = (ConsultCustomSource)this.customSourceDao.getById((Serializable)id, new String[0]);
        if (source == null) {
            throw new ParameterException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ConsultCustomSource sourceByLabel = this.customSourceDao.getBy(orgId, label);
        if (sourceByLabel != null) {
            if (sourceByLabel.getId().equals(id)) {
                return ConsultCustomSourceDto.buildBy((ConsultCustomSource)source);
            }
            throw new ParameterException("\u6307\u5b9a\u540d\u79f0\u5df2\u88ab\u4f7f\u7528,\u8bf7\u52ff\u91cd\u590d\u521b\u5efa\u3002");
        }
        source.setLabel(label);
        source.setUpdateTime(now);
        this.customSourceDao.update((Object)source, new String[0]);
        log.info("customSourceDao.update - source:{}", (Object)source);
        return ConsultCustomSourceDto.buildBy((ConsultCustomSource)source);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConsultCustomSourceDto pause(Long orgId, Long id, Integer isPaused) {
        Date now = new Date();
        ConsultCustomSource source = (ConsultCustomSource)this.customSourceDao.getById((Serializable)id, new String[0]);
        if (source == null) {
            throw new ParameterException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (isPaused == null || source.getIsPaused().equals((int)isPaused) || !Flag.isBooleanInt((Integer)isPaused)) {
            return ConsultCustomSourceDto.buildBy((ConsultCustomSource)source);
        }
        source.setIsPaused(isPaused);
        source.setUpdateTime(now);
        this.customSourceDao.update((Object)source, new String[0]);
        log.info("customSourceDao.pause - source:{}", (Object)source);
        if (Flag.getBoolean((Integer)isPaused)) {
            this.sortUpdate(orgId, id, SortOperation.DEL);
        } else {
            this.sortUpdate(orgId, id, SortOperation.ADD_RIGHT);
        }
        return ConsultCustomSourceDto.buildBy((ConsultCustomSource)source);
    }

    void sortUpdate(Long orgId, Long sourceId, SortOperation operation) {
        String target;
        TXSaleClueRule rule = this.saleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        String sort = StringUtils.isNotBlank((CharSequence)rule.getConsultSourceSort()) ? rule.getConsultSourceSort().trim() : "";
        String sortClone = String.format("%s%s%s", ",", sort, ",");
        if (sortClone.equals(target = String.format("%s%s%s", ",", sourceId, ","))) {
            sort = "";
        } else if (sortClone.contains(target)) {
            sortClone.replace(target, ",");
            sort = sortClone.substring(1, sortClone.length() - 1);
        }
        switch (operation) {
            case DEL: {
                break;
            }
            case ADD_LEFT: {
                sort = String.format("%s%s%s", ",", sourceId, sort);
                break;
            }
            case ADD_RIGHT: {
                sort = String.format("%s%s%s", sort, ",", sourceId);
                break;
            }
            default: {
                return;
            }
        }
        rule.setConsultSourceSort(sort);
        this.saleClueRuleService.saveTXSaleClueRule(rule);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sort(Long orgId, String sort) {
        Date now = new Date();
        if (StringUtils.isBlank((CharSequence)sort)) {
            return;
        }
        TXSaleClueRule rule = this.saleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
        rule.setConsultSourceSort(sort);
        if (rule.getId() != null) {
            rule.setUpdateTime(now);
        }
        this.saleClueRuleService.saveTXSaleClueRule(rule);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ConsultCustomSourceDto> selection(Long orgId, Integer scope, Integer isPaused) {
        List list;
        ArrayList<ConsultCustomSourceDto> dtos = new ArrayList<ConsultCustomSourceDto>();
        if (isPaused != null && !isPaused.equals(Flag.TRUE.getInt()) && !isPaused.equals(Flag.FALSE.getInt())) {
            isPaused = null;
        }
        if (scope != null && scope == 0) {
            dtos.addAll(this.consultSourceService.listConsultSystemSource(Boolean.valueOf(true)));
        } else if (scope != null && scope == 1) {
            list = this.customSourceDao.list(orgId, isPaused);
            for (ConsultCustomSource ccSource : list) {
                dtos.add(ConsultCustomSourceDto.buildBy((ConsultCustomSource)ccSource));
            }
        } else {
            list = this.customSourceDao.list(orgId, isPaused);
            for (ConsultCustomSource ccSource : list) {
                dtos.add(ConsultCustomSourceDto.buildBy((ConsultCustomSource)ccSource));
            }
            dtos.addAll(this.consultSourceService.listConsultSystemSource(Boolean.valueOf(true)));
        }
        if (CollectionUtils.isNotEmpty(dtos)) {
            LinkedHashMap<Long, ConsultCustomSourceDto> dtosMap = new LinkedHashMap<Long, ConsultCustomSourceDto>();
            for (ConsultCustomSourceDto dto : dtos) {
                dtosMap.put(dto.getId(), dto);
            }
            TXSaleClueRule rule = this.saleClueRuleService.getByOrgId(Integer.valueOf(orgId.intValue()));
            String sort = rule.getConsultSourceSort();
            if (StringUtils.isNotBlank((CharSequence)sort)) {
                int i = 1;
                Long sourceId = null;
                ConsultCustomSourceDto dto = null;
                for (String s : sort.split(",")) {
                    sourceId = Long.parseLong(s);
                    dto = (ConsultCustomSourceDto)dtosMap.get((long)sourceId);
                    if (dto == null || Flag.getBoolean((Integer)dto.getIsPaused())) continue;
                    dto.setSort(Integer.valueOf(i));
                    ++i;
                }
            }
            this.sortConsultCustomSource(dtos);
        }
        return dtos;
    }

    void sortConsultCustomSource(List<ConsultCustomSourceDto> dtos) {
        for (ConsultCustomSourceDto dto : dtos) {
            if (dto.getSort() != null) continue;
            dto.setSort(Integer.valueOf(Flag.NULL.getInt()));
        }
        Comparator<ConsultCustomSourceDto> comparator = new Comparator<ConsultCustomSourceDto>(){

            @Override
            public int compare(ConsultCustomSourceDto o1, ConsultCustomSourceDto o2) {
                if (Flag.getBoolean((Integer)o1.getIsPaused()) && Flag.getBoolean((Integer)o2.getIsPaused())) {
                    if (o1.getUpdateTime().getTime() > o2.getUpdateTime().getTime()) {
                        return 1;
                    }
                    return -1;
                }
                if (Flag.getBoolean((Integer)o1.getIsPaused())) {
                    return 1;
                }
                if (Flag.getBoolean((Integer)o2.getIsPaused())) {
                    return -1;
                }
                if (o1.getSort() != null && o2.getSort() != null) {
                    if (o1.getSort().equals(o2.getSort())) {
                        return o1.getId() > o2.getId() ? -1 : 1;
                    }
                    return o1.getSort() > o2.getSort() ? 1 : -1;
                }
                if (o1.getSort() != null) {
                    return 1;
                }
                if (o2.getSort() != null) {
                    return -1;
                }
                return o1.getId() > o2.getId() ? -1 : 1;
            }
        };
        Collections.sort(dtos, comparator);
    }

    @Override
    @Transactional(readOnly=true)
    public String getConsultSourceStr(Long id) {
        String str = null;
        MessageSource source = MessageSource.getByType((Integer)id.intValue());
        if (source != null && source.isConsultSource()) {
            str = source.getDesc();
        } else {
            ConsultCustomSource csource = (ConsultCustomSource)this.customSourceDao.getById((Serializable)id, new String[0]);
            if (csource != null) {
                str = csource.getLabel();
            }
        }
        return str;
    }
}

