/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.sync.impl;

import com.baijia.tianxiao.biz.consult.sync.SyncService;
import com.baijia.tianxiao.dal.im.dao.ImMessageInfoDao;
import com.baijia.tianxiao.dal.im.po.ImMessageInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.TransformerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="syncIMUserInfoService")
public class SyncIMUserInfoServiceImpl
implements SyncService {
    private static final Logger log = LoggerFactory.getLogger(SyncIMUserInfoServiceImpl.class);
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private ImMessageInfoDao imMessageInfoDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private UserDao userDao;
    @Resource
    private StudentDao studentDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private TxConsultUserDao consultUserDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    private AtomicBoolean flag = new AtomicBoolean(false);

    @Override
    public void sync() {
        TxMsgSyncTimestamp syncInfo;
        block7: {
            syncInfo = this.getSyncInfo(MsgSyncType.IM_STU);
            if (!this.flag.get()) {
                log.info("sync im student info :{}", (Object)syncInfo);
                this.flag.set(true);
                try {
                    try {
                        this.syncTask(syncInfo);
                    }
                    catch (Exception e) {
                        log.error("catch error:", (Throwable)e);
                        this.flag.set(false);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.flag.set(false);
                    throw throwable;
                }
                this.flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        log.info("save sync info:{}", (Object)syncInfo);
        this.txMsgSyncTimestampDao.saveOrUpdate((Object)syncInfo, new String[0]);
    }

    private void syncTask(TxMsgSyncTimestamp syncInfo) {
        List messageInfos = this.imMessageInfoDao.getOrgStudentInfoListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)messageInfos)) {
            HashSet studentNumbers = Sets.newHashSet();
            HashSet orgNumbers = Sets.newHashSet();
            for (ImMessageInfo msgInfo : messageInfos) {
                if (msgInfo.getMsgId() > syncInfo.getSyncId()) {
                    syncInfo.setSyncId(msgInfo.getMsgId());
                }
                studentNumbers.add(msgInfo.getSender());
                orgNumbers.add(msgInfo.getReceiver().intValue());
            }
            List users = this.userDao.getByNumbers((Collection)studentNumbers, new String[]{"id", "number", "mobile"});
            List accounts = this.orgAccountDao.getAccountByNumbers((Collection)orgNumbers, new String[]{"id", "number"});
            this.checkAndSaveConsulters(messageInfos, users, accounts);
        }
    }

    private void checkAndSaveConsulters(List<ImMessageInfo> messageInfos, List<User> users, List<OrgAccount> accounts) {
        HashMap userNumberIdMap = Maps.newHashMap();
        HashSet userIds = Sets.newHashSet();
        for (User u : users) {
            userIds.add(u.getId());
            userNumberIdMap.put(u.getNumber(), u);
        }
        List students = this.studentDao.getByUserIds((Collection)userIds, new String[]{"userId", "realName", "nickName"});
        Map orgIdMap = CollectorUtil.collectMap(accounts, (Function)new Function<OrgAccount, Long>(){

            public Long apply(OrgAccount input) {
                return input.getNumber().longValue();
            }
        }, (Function)new Function<OrgAccount, Long>(){

            public Long apply(OrgAccount input) {
                return input.getId().longValue();
            }
        });
        Map studentMap = CollectorUtil.collectMap((Collection)students, (Transformer)TransformerUtils.invokerTransformer((String)"getUserId"));
        log.debug("student map:{}", (Object)studentMap);
        TxConsultUser consulter = null;
        int successCount = 0;
        for (ImMessageInfo info : messageInfos) {
            try {
                consulter = new TxConsultUser();
                User user = (User)userNumberIdMap.get(info.getSender());
                List txConsultUsers = this.consultUserDao.lookByUserId((Long)orgIdMap.get(info.getReceiver()), user.getId(), new String[0]);
                if (CollectionUtils.isNotEmpty((Collection)txConsultUsers)) continue;
                Student stu = (Student)studentMap.get(user.getId());
                consulter.setConsultSource(Integer.valueOf(ConsultType.ONLINE_IM.getValue()));
                consulter.setMobile(user.getMobile());
                if (stu != null) {
                    consulter.setNickName(stu.getNickName());
                    consulter.setName(stu.getRealName());
                }
                consulter.setUserId(user.getId());
                consulter.setUserNumber(user.getNumber());
                consulter.setConsultStatus(0);
                consulter.setOrgId((Long)orgIdMap.get(info.getReceiver()));
                OrgStudent orgStudent = this.orgStudentDao.getStudent((Long)orgIdMap.get(info.getReceiver()), user.getId(), Integer.valueOf(DeleteStatus.NORMAL.getValue()), new String[0]);
                if (orgStudent != null) {
                    consulter.setStudentId(orgStudent.getId());
                }
                this.consultUserDao.save((Object)consulter, new String[0]);
                ++successCount;
                log.info("save consulter:{} success", (Object)consulter);
            }
            catch (Exception e) {
                log.error("save consulter:{} catch error:{}", (Object)consulter, (Object)e);
            }
        }
        log.info("success save consulter size:{}", (Object)successCount);
    }

    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = this.txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(Long.valueOf(0L));
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(Integer.valueOf(syncType.getSyncType()));
        }
        return syncInfo;
    }
}

