/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.push.service.impl;

import com.baijia.tianxiao.biz.consult.push.service.WechatService;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.sal.push.dto.ConsultUserCacheDto;
import com.baijia.tianxiao.sal.push.dto.OrgCacheDto;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.push.service.UserCacheService;
import com.baijia.tianxiao.sal.wechat.api.MessagePushService;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageContentDto;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageDto;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WechatServiceImpl
implements WechatService {
    private static final Logger log = LoggerFactory.getLogger(WechatServiceImpl.class);
    @Autowired
    private MessagePushService messagePushService;
    @Autowired
    private ConsultMessageService messageService;
    @Autowired
    private UserCacheService userCacheService;

    @Override
    @Transactional(noRollbackFor={BussinessException.class})
    public boolean sendMsgToOrg(ConsultMessage message) throws CustomException {
        log.info("[Wechat] Message = " + ToStringBuilder.reflectionToString((Object)message));
        MessageDto dto = this.toMessageDto(message);
        WebResponse response = this.messagePushService.handle(dto);
        log.info("[Wechat] Response = " + ToStringBuilder.reflectionToString((Object)response));
        this.messageService.addMessage(message);
        return true;
    }

    private MessageDto toMessageDto(ConsultMessage msg) {
        MessageDto pushDto = new MessageDto();
        pushDto.setMsgId(Integer.valueOf((int)msg.getId()));
        pushDto.setMsgT(Integer.valueOf(msg.getMsgType()));
        OrgCacheDto org = this.userCacheService.getOrg(Long.valueOf(msg.getSenderId()));
        if (org != null) {
            pushDto.setOrgId(Integer.valueOf(org.getOrgId().intValue()));
        }
        pushDto.setWechatAppid(org.getWechatAppId());
        ConsultUserCacheDto user = this.userCacheService.getConsultUser(Long.valueOf(msg.getReceiverId()));
        pushDto.setWechatOpenId(user.getWechatOpenId());
        MessageContentDto content = new MessageContentDto();
        content.setUrl(msg.getUrl());
        content.setText(msg.getText());
        content.setWidth(Integer.valueOf(msg.getWidth()));
        content.setHeight(Integer.valueOf(msg.getHeight()));
        content.setLength(Integer.valueOf(msg.getLength()));
        content.setStorageId(msg.getStorageId());
        pushDto.setContent(content);
        return pushDto;
    }
}

