/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.callservice.constant.OrgCallStatus;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.ConsultUserStatus;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orgCallConsultService")
public class OrgCallConsultServiceImpl
extends AbstractConsultService<OrgPushCallInfo> {
    private static final Logger log = LoggerFactory.getLogger(OrgCallConsultServiceImpl.class);
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private OrgStorageDao storageDao;
    @Autowired
    private OrgStudentDao orgStudentDao;

    private MsgUser builderSender(Long orgId, String mobile) {
        List consultUsers = this.consultUserDao.lookByMobile(orgId, mobile, new String[0]);
        TxConsultUser consultUser = null;
        if (CollectionUtils.isEmpty((Collection)consultUsers)) {
            consultUser = new TxConsultUser();
            consultUser.setOrgId(orgId);
            if (ConsultType.getNoEditConsultType().contains(this.getConsultType())) {
                consultUser.setMobile(MaskUtil.maskMobile((String)mobile));
            } else {
                consultUser.setMobile(mobile);
            }
            this.wrapConsult(consultUser, mobile, orgId);
            this.consultUserDao.save((Object)consultUser, new String[0]);
        } else {
            consultUser = (TxConsultUser)consultUsers.get(0);
            OrgStudent student = this.orgStudentDao.getStudentByMobileAndOrgId(orgId, mobile, new String[]{"name", "delStatus"});
            if (student != null && student.getDelStatus().intValue() == DataStatus.NORMAL.getValue()) {
                consultUser.setName(student.getName());
            }
        }
        return ConsulterDto.convertToDto(consultUser);
    }

    private void wrapConsult(TxConsultUser consultUser, String mobile, long orgId) {
        OrgStudent orgStudent = this.orgStudentDao.getStudentByMobileAndOrgId(Long.valueOf(orgId), mobile, new String[0]);
        if (orgStudent != null) {
            User user = (User)this.userDao.getById((Serializable)orgStudent.getUserId(), new String[0]);
            this.studentToConsult(consultUser, orgStudent, user);
        } else {
            this.userToConsult(consultUser, mobile);
        }
    }

    private void studentToConsult(TxConsultUser consultUser, OrgStudent orgStudent, User user) {
        if (user != null) {
            consultUser.setUserNumber(user.getNumber());
        }
        consultUser.setAddress(orgStudent.getAddress());
        consultUser.setConsultStatus(ConsultUserStatus.HAS.getValue());
        consultUser.setCreateTime(new Date());
        consultUser.setDegreeClass(orgStudent.getDegreeClass());
        consultUser.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        consultUser.setFatherOccupation(orgStudent.getFatherOccupation());
        consultUser.setMail(orgStudent.getMail());
        consultUser.setManually(0);
        consultUser.setMatherOccupation(orgStudent.getMatherOccupation());
        consultUser.setName(orgStudent.getName());
        consultUser.setNextRemindTime(orgStudent.getNextRemindTime());
        consultUser.setNickName(orgStudent.getNickName());
        consultUser.setParentMobile(orgStudent.getParentMobile());
        consultUser.setParentName(orgStudent.getParentName());
        consultUser.setQq(orgStudent.getQq());
        consultUser.setSchool(orgStudent.getSchool());
        consultUser.setStudentId(orgStudent.getId());
        consultUser.setUserId(orgStudent.getUserId());
        consultUser.setWeixinOpenId(orgStudent.getWeixin());
    }

    private void userToConsult(TxConsultUser consultUser, String mobile) {
        User user = this.userDao.getByMobile(mobile, new String[]{"id", "number", "mobile"});
        if (user != null) {
            Student student = this.studentDao.getByUserId(user.getId(), new String[]{"userId", "realName", "nickName"});
            consultUser.setName(this.getNameFromStudent(student));
            consultUser.setUserId(user.getId());
            consultUser.setUserNumber(user.getNumber());
        }
    }

    private MsgUser buildOrgMsgUser(String extension) {
        OrgInfo orgInfo = this.orgInfoDao.getByExtension(extension, new String[]{"orgId", "name", "shortName", "extension"});
        if (orgInfo == null) {
            log.warn("can not get org info by extension:{}", (Object)extension);
            return null;
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgInfo.getOrgId().intValue(), new String[]{"number"});
        return this.buildReceiver(orgInfo, orgAccount.getNumber().longValue());
    }

    @Override
    protected ConsultMessage buildPushMessageContent(OrgPushCallInfo msg) {
        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setCallId(msg.getId());
        pushMsg.setConsultType(ConsultType.TELEPHONE.getValue());
        pushMsg.setCreateTime(msg.getStartTime());
        if (msg.getStatus().equals(OrgCallStatus.CONNECTED.getCode())) {
            pushMsg.setMsgType(MsgType.VOICE.getValue());
            pushMsg.setText(msg.getConnectedNumber());
            if (msg.getStorageId() != null && msg.getStorageId() > 0L) {
                OrgStorage storage = (OrgStorage)this.storageDao.getById((Serializable)msg.getStorageId(), new String[0]);
                String url = StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType());
                pushMsg.setUrl(url);
                pushMsg.setLength(msg.getDuringTime());
            }
        } else {
            pushMsg.setMsgType(MsgType.TEXT.getValue());
            pushMsg.setText("\u672a\u63a5\u542c");
        }
        return pushMsg;
    }

    @Override
    public ConsultType getConsultType() {
        return ConsultType.TELEPHONE;
    }

    @Override
    public boolean consume(OrgPushCallInfo callInfo) {
        if (callInfo == null || StringUtils.isBlank((CharSequence)callInfo.getExtention())) {
            throw new IllegalArgumentException(" call info is illegal");
        }
        MsgUser receiver = this.buildOrgMsgUser(callInfo.getExtention());
        if (receiver == null) {
            return false;
        }
        MsgUser sender = this.builderSender(receiver.getUserId(), callInfo.getCustomerNumber());
        if (sender == null || receiver == null) {
            log.warn("sender :{} or receiver:{} is null,skip org 400 call msg:{},skip", new Object[]{sender, receiver, callInfo});
            return false;
        }
        ConsultMessage msgContent = this.buildPushMessageContent(callInfo);
        log.info("consume org call msg sender:{},receiver:{},msgContent:{}", new Object[]{sender.getName(), receiver, msgContent});
        boolean result = this.consultMessageService.sendConsultMessage(sender, receiver, msgContent);
        log.info("push org 400 call msg:{},sender:{},receiver:{},result:{}", new Object[]{msgContent, sender, receiver, result});
        return result;
    }

    @Override
    public OrgPushCallInfo transfer(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        try {
            return (OrgPushCallInfo)JacksonUtil.str2Obj((String)body, OrgPushCallInfo.class);
        }
        catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", (Object)body, (Object)e);
            return null;
        }
    }
}

