/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.consult.user.dto.ConsulterPullLogDto;
import com.baijia.tianxiao.biz.consult.user.service.ConsulterOperationLogService;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;


/**   
 * @title       : ConsulterOperationLogServiceImpl 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年5月30日 下午12:59:15 
 */
@Service
@Slf4j
public class ConsulterOperationLogServiceImpl implements ConsulterOperationLogService {

	@Autowired
	private TxConsulterOperationLogDao operationLogDao;
	@Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao  orgInfoDao;
	
	@Override
	public List<ConsulterPullLogDto> listLogs(Long orgId, Long consulterId) {
		List<ConsulterPullLogDto> dtoList = new ArrayList<ConsulterPullLogDto>();
		
		Set<Integer> operationTypeList = new HashSet<Integer>();
		operationTypeList.add(ConsulterOperation.PUSH_AUTO.getValue());
		operationTypeList.add(ConsulterOperation.PUSH_MANUAL.getValue());
		operationTypeList.add(ConsulterOperation.PASSTO.getValue());
		operationTypeList.add(ConsulterOperation.PULL.getValue());
		operationTypeList.add(ConsulterOperation.ASSIGN.getValue());
		
		List<TxConsulterOperationLog> dbList = operationLogDao.listByConsultUserId(consulterId, operationTypeList);
		Set<Integer> ownerCascadeIds = null;
		
		if(!CollectionUtils.isEmpty(dbList)){
			ownerCascadeIds = new HashSet<Integer>();
			TxConsulterOperationLog log = null;
			TxConsulterOperationLog preLog = null;
			ConsulterPullLogDto dto = null;
			
			for(int i=0;i<dbList.size();i++){
				log = dbList.get(i);
				if(log.getOperationType().intValue() == ConsulterOperation.PUSH_AUTO.getValue()
				 ||log.getOperationType().intValue() == ConsulterOperation.PUSH_MANUAL.getValue()){//判断是一条回归公海记录
					dto = new ConsulterPullLogDto();
					dto.setBacktime( log.getCreateTime().getTime() );
					dto.setBackType( log.getOperationType() );
					for(int j=i+1;j<dbList.size();j++){
						preLog = dbList.get(j);
						if(preLog.getOperationType().intValue() == ConsulterOperation.PASSTO.getValue()
						 ||preLog.getOperationType().intValue() == ConsulterOperation.PULL.getValue()
						 ||preLog.getOperationType().intValue() == ConsulterOperation.ASSIGN.getValue() ){
							ownerCascadeIds.add( preLog.getTargetCascadeId().intValue() );
							dto.setOwnerCascadeId( preLog.getTargetCascadeId() );
							dto.setPulltime( preLog.getCreateTime().getTime() );
							dtoList.add(dto);
							i=j;
							break;
						}else if(log.getOperationType().intValue() == ConsulterOperation.PUSH_AUTO.getValue()
							   ||log.getOperationType().intValue() == ConsulterOperation.PUSH_MANUAL.getValue()){
							i=j-1;
							break;
						}
					}
				}
			}
		}
		
		if(!CollectionUtils.isEmpty(dtoList)){
			Map<Long,String> nameMap = txCascadeCredentialDao.getTxCascadCredentialNameByCascdeIds(ownerCascadeIds);
			
			OrgInfo orgInfo = null;
			for(ConsulterPullLogDto dto:dtoList){
				if(dto.getOwnerCascadeId() < 0 ){
					dto.setOwnerName( "无" );
				}else if(dto.getOwnerCascadeId() == 0 ){//所属人是 主账号
					if(orgInfo == null ){
						orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
					}
					dto.setOwnerName( orgInfo.getShowName() );
				}else{
					dto.setOwnerName( nameMap.get(dto.getOwnerCascadeId().longValue()) );
				}
			}
		}
		return dtoList;
	}

    
}
