/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.user.service;

import com.baijia.tianxiao.biz.consult.dto.request.MergeConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.dto.response.ConsultCallRecordDto;
import com.baijia.tianxiao.biz.consult.enums.CallUserType;
import com.baijia.tianxiao.biz.consult.user.dto.ConsultUserInfo;
import com.baijia.tianxiao.biz.consult.user.dto.ConsultUserResponse;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.biz.consult.user.dto.request.ConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.dto.request.ListConsulterRequestDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.CallStudentInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.ConsulterResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.GetConsulterInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.OutLineDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.SimpleConsulterInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.exception.NonConsultUserException;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListDto;
import com.baijia.tianxiao.dal.solr.dto.ConsulterListQueryParam;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.callservice.dto.BidirectionalCallResponse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Date;
import java.util.List;

/**
 * @title ConsultUserService
 * @desc TODO
 * @author cxm
 * @date 2015年12月7日
 * @version 1.0
 */
public interface ConsultUserService {

    /**
     * 保存咨询人信息
     * 
     * @param consulter
     * @param keepConsultSource 兼容1.5.2版本需求
     */
    Long saveConsultUser(Long orgId, ConsulterRequestDto consulter, Boolean keepConsultSource) throws BussinessException;

    /**
     * 查询机构下知道咨询用户的信息
     * 
     * @param orgId
     * @param consulterId
     * @return
     * @throws NonConsultUserException
     */
    ConsulterResponseDto getConsultUser(Long orgId, Long cascadeId, Long consulterId) throws NonConsultUserException;

    /**
     * 根据咨询用户的ID查找是否存在正式学员,如果存在返回学员的ID
     * 
     * @param orgId
     * @param consulterId
     * @return
     * @throws NonConsultUserException
     */
    GetConsulterInfoResponseDto getExistStudentId(Long orgId, Long consulterId, Long userNumber)
        throws NonConsultUserException;

    /**
     * 根据条件查找历史联系人
     * 
     * @param type 咨询用户类型: 0,非正式学员的咨询用户; 1,正式学员的咨询用户; null,不区分
     * @param orgId
     * @param request
     * @return
     */
    List<SimpleConsulterInfoResponseDto> searchConsulterInfos(Integer type, Long orgId, ListConsulterRequestDto request,
        PageDto pageDto);

    /**
     * 根据手机和机构ID查询联系人信息
     * 
     * @param mobile
     * @param orgId
     * @return
     * @throws NonConsultUserException
     */
    CallStudentInfoResponseDto getCallStudentInfoByMobile(Long consulterId, String mobile, Long orgId)
        throws NonConsultUserException;

    /**
     * 机构发起回拨学生
     * 
     * @param consulterId 联系人ID (优先适用联系人ID)
     * @param studentId 花名册学生ID
     * @param subscriberTel 机构接听的电话号码
     * @param orgId 机构ID
     * @return
     * @throws NonConsultUserException
     */
    BidirectionalCallResponse callStudent(Long consulterId, Long studentId, String subscriberTel, CallUserType userType,
        Long orgId) throws NonConsultUserException;

    ConsulterDto getConsultUserBaseInfo(Long orgId, Long consulterId) throws NonConsultUserException;

    /**
     * 合并咨询
     * 
     * @param param
     * @param orgId 机构ID
     */
    public void mergeCosulter(MergeConsulterRequestDto param, Long orgId, Long cascadeId) throws BussinessException;

    /**
     * 查询所有有电话号码的咨询用户
     * 
     * @param pageDto
     * @return
     */
    List<TxConsultUser> searchHasMobileConsulter(PageDto pageDto, String format, String value);

    /**
     * 浅注册咨询用户
     * 
     * @param orgId
     * @param openId
     * @param showName
     * @return
     */
    Long regConsulter(Long orgId, String openId, String showName, Long studentId);

    /**
     * 删除册咨询用户
     * 
     * @param orgId
     * @return
     */
    public void delConsulter(Long consulterId, Long orgId);

    /**
     * 创建咨询用户(IM、微信、来电咨询、预约留单、来访咨询)的同时创建系统待办事项
     * 
     * @param orgId 机构id
     * @param consulterId 咨询用户id
     * @return
     */
    public void addSysBacklog(Long orgId, Long consulterId);

    /**
     * 编辑咨询学员的同时更新系统待办事项
     * 
     * @param orgId 机构id
     * @param consulterId 咨询用户id
     * @return
     */
    public void updateSysBacklog(Long orgId, Long consulterId);

    // 从公海领取线索
    void assign(Long orgId, Long cascadeId, Long consulterId);

    // 从公海领取线索
    TxConsultUser pull(Long orgId, Long cascadeId, Long consulterId);

    // 释放线索回公海
    void push(Long orgId, Long cascadeId, Long consulterId);

    // 转交线索给他人
    void passto(Long orgId, Long cascadeIdFrom, Long cascadeIdTo, Long consulterId);

    // 线索转为学生
    Long convertToStudent(Long orgId, Long cascadeId, Long consulterId, Integer confirm);

    // 修改线索 有效、无效状态
    void changeStatus(Long orgId, Long cascadeId, Long consulterId, Integer status, String reason);

    // 修改线索 跟进状态
    void changeConsultStatus(Long orgId, Long cascadeId, Long consulterId, Integer consultStatus);

    // 修改线索 下次跟进时间
    void changeNextRemindTime(Long orgId, Long cascadeId, Long consulterId, Long nextRemindTime);

    // 线索 菜单列表
    List<OutLineDto> getOutLine(Long orgId, Long cascadeId);

    // 线索列表
    List<ConsulterListDto> listConsulter(Long orgId, Long cascadeId, ConsulterListQueryParam parma, PageDto pageDto);

    // 线索通话记录查询
    List<ConsultCallRecordDto> listConsultCallRecord(Long orgId, Long cascadeId, Long studentId, Long consulterId);

    TxConsultUser getConsultUserByStudetnId(Long orgId, Long studentId);

    TxConsultUser getConsultUser(Long consulterId);

    boolean changeLastBrowseTime(Long consulterId, Date time);

    // 释放过期线索
    int release();

    public int syncStudentId(PageDto pageDto);
    

    public TxConsultUser testTransaction(Integer vaule, Integer throwsException);
    
    /**
     * 获取线索详情，包括自定义字段
     * @param consultId
     * @param cascadeId
     * @param orgId
     * @return
     */
    public ConsultUserResponse getConsultUserInfo(Long consultId, Long cascadeId, Long orgId);
    
    /**
     * 进行线索信息的保存,包括线索自定义字段
     * @param consultId
     * @param cascadeId
     * @param orgId
     * @return
     */
    public Long saveConsultUserInfoAndCustomFieldValues(ConsultUserInfo consultUserInfo, Long orgId, Boolean keepConsultSource);
}
