package com.baijia.tianxiao.biz.consult.user.pc.service;

import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultInfoResponseDto;
import com.baijia.tianxiao.biz.consult.user.dto.response.pc.ConsultListResponseDto;
import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import javax.servlet.http.HttpServletResponse;

/**
 * @author wangsixia
 * @version 1.0
 * @title ClueService
 * @desc 招生线索
 * @date 2016年3月16日
 */
public interface ClueService {

    /**
     * 获取招生线索基本信息(不包含标签和跟进记录)
     *
     * @param orgId       机构id
     * @param consulterId 招生线索id
     * @return
     */
    ConsultInfoResponseDto getBaseInfo(Long orgId, Long consulterId) throws Exception;

    /**
     * 新增招生线索
     *
     * @param orgId    机构id
     * @param clueInfo 招生线索信息
     * @return
     */
    Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception;

    /**
     * 导入招生线索
     *
     * @param orgId    机构id
     * @param clueInfo 招生线索信息
     * @return
     */
    Long addClueInfo(Long orgId, ConsultListResponseDto clueInfo, boolean updateRepeat) throws Exception;

    /**
     * 编辑招生线索
     *
     * @param orgId    机构id
     * @param clueInfo 招生线索信息
     * @return
     */
    void editClueInfo(Long orgId, ConsultListResponseDto clueInfo) throws Exception;

    /**
     * del
     *
     * @param clueInfoID
     * @throws Exception
     */
    void delClueInfo(Long clueInfoID) throws Exception;


    void delClueInfo(List<Long> clueInfoID) throws Exception;

    /**
     * 线索查询
     *
     * @param orgId
     * @param request
     * @return
     */
    List<ConsultListResponseDto> getClueList(long orgId, CommonSearchRequestDto request, PageDto pageDto) throws Exception;

    
    
    void vaildateConsult(Long orgId, ConsultListResponseDto clueInfo);

}
