/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.dto.ConsultUserDetailDto;
import com.baijia.tianxiao.biz.consult.dto.MessageRecordDto;
import com.baijia.tianxiao.biz.consult.msg.service.ConsultMsgService;
import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.push.constant.CardType;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.constant.MsgUserType;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.push.dto.ConsultMessageDto;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.solr.enums.TimeType;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.sal.push.utils.MsgContentFactory;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;

import com.google.gson.Gson;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年5月21日
 * @desc
 */
@Slf4j
@Service
public class ConsultMsgServiceImpl implements ConsultMsgService{
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao orgTxCascadeCredentialDao;
    @Autowired
    private MessageDao messageDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private ConsultAvatarUrlService consultAvatarUrlService;
    @Autowired
    private TxCascadeCredentialService credentialService;

    @Override
    public List<MessageRecordDto> getMessageRecordDtoList(Long orgId) {
        //根据机构id获取其所有子帐号(员工)
        List<TXCascadeAccount> txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgId);

        Map<Integer, TXCascadeAccount> txCascadeAccountMap = new HashMap<>();
        Map<Integer, TXCascadeCredential> txCascadeCredentialMap = new HashMap<>();
        List<Integer> credentialIds = new ArrayList<>();
        if(GenericsUtils.notNullAndEmpty(txCascadeAccounts)){
            for(TXCascadeAccount txCascadeAccount : txCascadeAccounts){
                credentialIds.add(txCascadeAccount.getCredentialId());
                txCascadeAccountMap.put(txCascadeAccount.getId(), txCascadeAccount);
            }
            //获取机构子帐号详情
            List<TXCascadeCredential> txCascadeCredentials = this.orgTxCascadeCredentialDao.getByCredentialIds(credentialIds,null);
            for(TXCascadeCredential txCascadeCredential : txCascadeCredentials){
                Integer credentialId = txCascadeCredential.getId();
                txCascadeCredentialMap.put(credentialId, txCascadeCredential);
            }
        }
        log.info("credentialIds params{}", credentialIds);

        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue());
        Integer orgNumber = orgAccount.getNumber();
        //判断当前机构身份
        int orgType;
        OrgSubAccount orgSubAccount = this.orgSubAccountDao.getMasterByOrgId(orgId.intValue());
        if(GenericsUtils.notNullAndEmpty(orgSubAccount)){
            orgType = MsgUserRole.HEADER.getValue();
        }else{
            orgType = MsgUserRole.BRANCH_HEADER.getValue();
        }
        Map<Integer, MessageRecordDto> messageRecordMap = new HashMap<>();

        log.info("orgId param:{}, orgType param {}", orgId, orgType);

        //存储访客id
        Set<Long> consultIds = new HashSet<>();

        boolean isShow = credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());

        //根据机构orgNumber获取咨询用户聊天信息
        List<ConsultMessageDto> consultMessagesByOrgNumber = this.messageDao.getMsgDtoByOrgNumberOrCacadeId(orgNumber, getOrgHeadRoles(), getConsultRoles());
        log.info("consultMessagesByOrgNumber params{}", consultMessagesByOrgNumber);
        if(GenericsUtils.notNullAndEmpty(consultMessagesByOrgNumber)){
            //获取机构微信信息
            OrgInfo  orgInfo = this.orgInfoDao.getOrgInfo(orgId.intValue());

            MessageRecordDto messageRecordDto = MessageRecordDto.buildInstanceByOrg(orgInfo, orgNumber, orgType);
            messageRecordMap.put(orgNumber, messageRecordDto);
            int count = 1;
            boolean hasMore = false;
            List<ConsultUserDetailDto> list = new ArrayList<>();
            for(ConsultMessageDto consultMessageDto : consultMessagesByOrgNumber){
                //前端要求显示最近三条，当大于3条时，表示有跟多数据
                if(count <= 3){
                    ConsultUserDetailDto consultUserDetailDto = buildConsultUserDetailDto(consultMessageDto,isShow);
                    consultIds.add(consultMessageDto.getConsultId());
                    list.add(consultUserDetailDto);
                }else{
                    hasMore = true;  //最多存储3条，当判断有第四条时，返回hasMore=true
                }
                count++;
            }
            messageRecordDto.setList(list);
            messageRecordDto.setHasMore(hasMore);
            log.info("orgNumber param:{}, messageRecordMap param:{}", orgNumber, messageRecordMap);
        }

        //根据机构子帐号获取
        if(GenericsUtils.notNullAndEmpty(txCascadeAccountMap)){
            for(Integer casId : txCascadeAccountMap.keySet()){
                TXCascadeAccount txCascadeAccount = txCascadeAccountMap.get(casId);
                Integer type = txCascadeAccount.getAccountType();

                log.info("casId param:{}, cascadeType param:{}", casId, type);

                List<Integer> consultRoles = getConsultRoles();
                List<ConsultMessageDto> consultMessagesByCascadeId = this.messageDao.getMsgDtoByOrgNumberOrCacadeId(casId, getCascadeRoles(), consultRoles);

                log.info("casId param:{}, consultMessagesByCascadeId params:{}", casId, consultMessagesByCascadeId);
                if(GenericsUtils.notNullAndEmpty(consultMessagesByCascadeId)){
                    int count = 1;
                    boolean hasMore = false;
                    Integer credentialId = txCascadeAccount.getCredentialId();
                    TXCascadeCredential txCascadeCredential = txCascadeCredentialMap.get(credentialId);
                    MessageRecordDto messageRecordDto = new MessageRecordDto();
                    messageRecordMap.put(casId, messageRecordDto);
                    messageRecordDto.setName(txCascadeCredential.getName() == null ? "" : txCascadeCredential.getName());
                    messageRecordDto.setUserId(casId);
                    messageRecordDto.setAvatarUrl(AvatarConstants.STUFF_AVATAR_URL);
                    messageRecordDto.setUserRole(type);
                    messageRecordDto.setUserTypeString(MsgUserRole.getByCode(type).getDesc());
                    List<ConsultUserDetailDto> list = new ArrayList<>();
                    for(ConsultMessageDto consultMessageDto : consultMessagesByCascadeId){
                        //前端要求显示最近三条，当大于3条时，表示有跟多数据
                        if(count <= 3){
                            ConsultUserDetailDto consultUserDetailDto = buildConsultUserDetailDto(consultMessageDto,isShow);
                            consultIds.add(consultMessageDto.getConsultId());
                            list.add(consultUserDetailDto);
                        }else{
                            hasMore = true;  //最多存储3条，当判断有第四条时，返回hasMore=true
                        }
                        count++;
                    }
                    messageRecordDto.setList(list);
                    messageRecordDto.setHasMore(hasMore);

                    log.info("casId param:{}, messageRecordMap params:{}", casId, messageRecordMap);
                }
            }
        }

        if(GenericsUtils.isNullOrEmpty(messageRecordMap)){
            log.info("messageRecordMap 为空");
            return Collections.EMPTY_LIST;
        }

        Map<Long, ConsultAvatarUrlAndNameDto> avatarUrlNameMobiledtoMap =  consultAvatarUrlService.batchConsultAvatarUrlAndNameDtoMap(consultIds, orgId);

        List<MessageRecordDto> messageRecordDtos = new ArrayList<>();

        //填充访客姓名和头像，规律是先用户上传头像，微信头像，默认头像
        for(Integer userId : messageRecordMap.keySet()){
            MessageRecordDto messageRecordDto = messageRecordMap.get(userId);
            List<ConsultUserDetailDto> list = messageRecordDto.getList();
            for(ConsultUserDetailDto consultUserDetailDto : list){
                Long consultId = consultUserDetailDto.getUserId();
                ConsultAvatarUrlAndNameDto dto = avatarUrlNameMobiledtoMap.get(consultId);
                if(dto != null){
                    consultUserDetailDto.setAvatarUrl(dto.getAvatarUrl());
                    consultUserDetailDto.setName(dto.getName());
                }else{
                    log.info("[ConsultMessage] 头像为 consultId:{}", consultId);
                    consultUserDetailDto.setAvatarUrl("");
                    consultUserDetailDto.setName("用户不存在");
                }
            }
            messageRecordDtos.add(messageRecordDto);
        }

        //实例化一个比较器
        Comparator<MessageRecordDto> sortOfMessageRecordDto = new Comparator<MessageRecordDto>() {

            @Override
            public int compare(MessageRecordDto o1, MessageRecordDto o2) {
                Long createTime1 = o1.getList().get(0).getCreateTime();
                Long createTime2 = o2.getList().get(0).getCreateTime();
                return createTime1 - createTime2 >= 0 ? 1 : -1;
            }

        };
        Collections.sort(messageRecordDtos, sortOfMessageRecordDto);
        Collections.reverse(messageRecordDtos);
        return messageRecordDtos;
    }

    @Override
    public List<ConsultUserDetailDto> getConsultUserDetailDtos(Long orgId, Integer userId, Integer userType, Integer typeSource,
                                                               PageDto pageDto, Integer timeType) {
        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        int limit = pageDto.getPageSize();

        Date startTime = null;
        Date endTime = null;

        if(GenericsUtils.notNullAndEmpty(timeType)){
            TimeType receiveTime= TimeType.getTimeTypeByCode(timeType);   //接待时间类型
            TimeRange range = receiveTime.timeRange();
            startTime = range.getStartTime();
            endTime = range.getEndTime();
        }

        List<Integer> consultRoles = getConsultRoles();
        List<Integer> orgOrCacadeRoles = new ArrayList<>();
        if(getCascadeRoles().contains(userType)){
            orgOrCacadeRoles = getCascadeRoles();
        }else if (getOrgHeadRoles().contains(userType)){
            orgOrCacadeRoles = getOrgHeadRoles();
        }else{
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        
        Integer count = this.messageDao.getMsgTotal(userId, orgOrCacadeRoles, consultRoles, typeSource, startTime, endTime);

        pageDto.setCount(count == null ? 0 : count);

        if(count == 0){
            return Collections.EMPTY_LIST;
        }

        log.info("count param:{}", count);
        boolean isShow = credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());

        //获取分页列表
        List<ConsultMessageDto> consultMessageDtos = this.messageDao.getMsgListByFilter(userId, orgOrCacadeRoles, consultRoles, typeSource, startTime, endTime, start, limit);

        //存储访客id
        Set<Long> consultIds = new HashSet<>();

        List<ConsultUserDetailDto> consultUserDetailDtos = new ArrayList<>();
        if(GenericsUtils.isNullOrEmpty(consultMessageDtos)){
            return Collections.EMPTY_LIST;
        }

        for(ConsultMessageDto consultMessageDto : consultMessageDtos){
            ConsultUserDetailDto consultUserDetailDto = buildConsultUserDetailDto(consultMessageDto,isShow);
            consultIds.add(consultMessageDto.getConsultId());
            consultUserDetailDtos.add(consultUserDetailDto);
        }

        Map<Long, ConsultAvatarUrlAndNameDto> avatarUrlNameMobiledtoMap =  consultAvatarUrlService.batchConsultAvatarUrlAndNameDtoMap(consultIds, orgId);
        for(ConsultUserDetailDto consultUserDetailDto : consultUserDetailDtos){
            Long consultId = consultUserDetailDto.getUserId();
            ConsultAvatarUrlAndNameDto dto = avatarUrlNameMobiledtoMap.get(consultId);
            
            consultUserDetailDto.setAvatarUrl(dto == null ? "" :dto.getAvatarUrl());
            consultUserDetailDto.setName(dto == null ? "用户不存在" :dto.getName());
        }
        return consultUserDetailDtos;
    }

    private List<Integer> getConsultRoles(){
        Set<MsgUserRole> consultSet = MsgUserRole.getStuUsers();
        List<Integer> consultRoles = MsgUserRole.getRoles(consultSet);
        return consultRoles;
    }
    
    /**
     * 获取机构校长角色类型
     * @return
     */
    private List<Integer> getOrgHeadRoles(){
        Set<MsgUserRole> orgHeadRoleSet = MsgUserRole.getOrgHeadUsers();
        List<Integer> orgHeadRoles = MsgUserRole.getRoles(orgHeadRoleSet);
        return orgHeadRoles;
    }
    
    private List<Integer> getCascadeRoles(){
        Set<MsgUserRole> cascadeRoleSet = MsgUserRole.getCascadeUsers();
        List<Integer> cascadeRoles = MsgUserRole.getRoles(cascadeRoleSet);
        return cascadeRoles;
    }

    private ConsultUserDetailDto buildConsultUserDetailDto(ConsultMessageDto consultMessageDto,boolean isShow){
        ConsultUserDetailDto consultUserDetailDto  = new ConsultUserDetailDto();
        consultUserDetailDto.setUserId(consultMessageDto.getConsultId());
        //获取聊天内容
        Integer msgType = consultMessageDto.getMsgType();
        String msgTypeString = MsgType.getTypeByValue(msgType).getDesc();
        consultUserDetailDto.setMsgTypeString(msgTypeString);
        consultUserDetailDto.setMsgType(msgType);
        //如果是卡片，传卡片类型
        if(msgType == MsgType.CARD.getValue()){
            Gson gson = new Gson();
            CardMsgContent msgContent = gson.fromJson(consultMessageDto.getText(),CardMsgContent.class);
            consultUserDetailDto.setCardType(msgContent.getType());
            CardType cardType = CardType.getTypeByValue(msgContent.getType());
            if(GenericsUtils.notNullAndEmpty(cardType)){
                consultUserDetailDto.setCardTypeString(cardType.getDesc());
            }
        }
        String text = MsgContentFactory.getContentByConsultMessageDto(consultMessageDto);
        consultUserDetailDto.setContent(text == null ? "" : text);
        if(consultMessageDto.getMsgType() == MsgType.CARD.getValue() && !isShow){
            consultUserDetailDto.setContent(MsgContentFactory.maskMobile(text));
        }
        int userRole = consultMessageDto.getConsultRole();
        consultUserDetailDto.setUserRole(userRole);
        consultUserDetailDto.setUserType(MsgUserType.getUserType(userRole).getValue());
        MsgUserRole msgUserRole = MsgUserRole.getByCode(userRole);
        consultUserDetailDto.setUserTypeString(MsgUserRole.getText(msgUserRole));

        int type = consultMessageDto.getConsultType();
        consultUserDetailDto.setType(type);
        MessageSource source = MessageSource.getByType(type);
        String typeDesc = MessageSource.getText(source);
        if(GenericsUtils.notNullAndEmpty(typeDesc)){
            consultUserDetailDto.setTypeString(typeDesc);
        }else{
            consultUserDetailDto.setTypeString(source.getDesc());
        }
        consultUserDetailDto.setCreateTime(consultMessageDto.getCreate_time().getTime());
        return consultUserDetailDto;
    }

}