package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.dto.response.ActivityInfo;
import com.baijia.tianxiao.biz.consult.msg.service.BizActivityService;
import com.baijia.tianxiao.dal.activity.constants.TemplateConstant;
import com.baijia.tianxiao.dal.activity.dao.ActivityConfDao;
import com.baijia.tianxiao.dal.activity.dao.ActivityDao;
import com.baijia.tianxiao.dal.activity.dao.draw.DrawActivityDao;
import com.baijia.tianxiao.dal.activity.dao.referral.ReferralInfoDao;
import com.baijia.tianxiao.dal.activity.dao.vote.VoteInfoDao;
import com.baijia.tianxiao.dal.activity.po.Activity;
import com.baijia.tianxiao.dal.activity.po.ActivityConf;
import com.baijia.tianxiao.dal.activity.po.draw.DrawInfo;
import com.baijia.tianxiao.dal.activity.po.referral.ReferralInfo;
import com.baijia.tianxiao.dal.activity.po.vote.VoteInfo;
import com.baijia.tianxiao.sal.marketing.commons.constants.Config;
import com.baijia.tianxiao.sal.marketing.commons.service.TemplateService;
import com.baijia.tianxiao.sal.wechat.api.CustomActivityService;
import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by liuxp on 16/5/21.
 */
@Service("consutBizActivityServiceImpl")
@Slf4j
public class BizActivityServiceImpl implements BizActivityService {

    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private DrawActivityDao drawActivityDao;
    @Autowired
    private VoteInfoDao voteInfoDao;
    @Autowired
    private ReferralInfoDao referralInfoDao;
    @Autowired
    private ActivityConfDao activityConf;
    @Autowired
    private CustomActivityService customActivityService;

    private TemplateConstant templateConstant;

    @Override
    public List<ActivityInfo> getAllActivities(long orgId) {
        List<ActivityInfo> ret = new ArrayList<>();
        List<Activity> activities = activityDao.selectCurrentActivityList(orgId);
        List<DrawInfo> drawList = drawActivityDao.selectCurrentDraw(orgId);
        List<VoteInfo> voteList = voteInfoDao.selectCurrentVoteList(orgId);
        List<ReferralInfo> referralList = referralInfoDao.selectCurrentReferralList(orgId);

        if (activities != null) {
            for (Activity activity : activities) {
                ActivityConf conf = activityConf.getConfigByActivityId(activity.getId());
                ActivityInfo instance = ActivityInfo.getInstance(activity, TemplateConstant.getMap().get(conf.getTemplateId()));
                instance.setUrl(getUrl(conf.getTemplateId(), activity.getId()));
                ret.add(instance);
            }
        }

        if (drawList != null) {
            for (DrawInfo info : drawList) {
                ActivityInfo instance = ActivityInfo.getInstance(info, TemplateConstant.getMap().get(info.getTemplateId()));
                //instance.setUrl(getWechatUrl(info.getActivityId(), info.getTemplateId()));
                instance.setUrl(getUrl(info.getTemplateId(), info.getActivityId()));
                ret.add(instance);
            }
        }

        if (voteList != null) {
            for (VoteInfo info : voteList) {
                ActivityInfo instance = ActivityInfo.getInstance(info, TemplateConstant.getMap().get(info.getTemplateId()));
                //instance.setUrl(getWechatUrl(info.getActivityId(), info.getTemplateId()));
                instance.setUrl(getUrl(info.getTemplateId(),info.getActivityId()));
                ret.add(instance);
            }
        }

        if (referralList != null) {
            for (ReferralInfo info : referralList) {
                ActivityInfo instance = ActivityInfo.getInstance(info, TemplateConstant.getMap().get(info.getTemplateId().intValue()));
                instance.setUrl(getUrl(info.getTemplateId(), info.getActivityId()));
                ret.add(instance);
            }
        }

        return ret;
    }

    private String getWechatUrl(long activityId, int templateId) {
        log.info("[param] activityId=" + activityId + ";templateId=" + templateId);
        CustomActivityDto dto = customActivityService.getCustomActivity((int) activityId, templateId);
        if (dto != null) {
            log.info("ShareUrl=" + dto.getWebAuthUrl());
            return dto.getWebAuthUrl();
        } else {
            return "";
        }
    }

    private String getUrl(long templateId, long activityId) {
        StringBuilder sb = new StringBuilder();
        String url = TemplateConstant.getTemplateUrl((int)templateId);
        sb.append(Config.DOMAIN);
        sb.append(url).append("&activityId=").append(activityId).append("#!/");
        return sb.toString();
    }
}
