/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.consult.msg.service;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.baijia.tianxiao.biz.consult.dto.response.OrgMsgUser;
import com.baijia.tianxiao.biz.consult.user.service.ConsultUserService;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;

/**
 * @title AbstractConsultMsgService
 * @desc TODO
 * @author cxm
 * @date 2015年12月8日
 * @version 1.0
 */
public abstract class AbstractConsultService<T> implements ConsultMessageConsumeService {
    @Autowired
    protected ConsultUserService consultUserService;
    
    @Autowired
    protected ConsultMessageService consultMessageService;

    @Autowired
    protected TxConsultUserDao consultUserDao;

    @Autowired
    protected UserDao userDao;

    protected abstract ConsultMessage buildPushMessageContent(T msg,Long consultUserId);

    /**
     * 实际消费消息的实现
     * 
     * @param callInfos
     */
    public abstract boolean consume(T message);

    public abstract T transfer(String body);

    @Override
    public boolean consume(String messageBody) {
        T t = transfer(messageBody);
        return consume(t);
    }

    protected String getNameFromStudent(Student student) {
        if (student != null) {
            if (StringUtils.isNoneBlank(student.getNickName())) {
                return student.getNickName();
            } else if (StringUtils.isNoneBlank(student.getRealName())) {
                return student.getRealName();
            }
        }
        return TianXiaoConstant.ANONYMOUS_CONSULT_USER;
    }

    protected MsgUser buildReceiver(final OrgInfo info, final Long orgNumber) {
        return new OrgMsgUser(info.getOrgId().longValue(), orgNumber);
    }

}
