
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.consult.enums;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.commons.ConfigEnum;
import com.google.common.collect.Maps;

/**
 * @title ConsulterListType
 * @desc 线索（列表） 类型
 * @date 2016年5月25日
 * @version 1.0
 */

public enum ConsulterOutLineType {

	ALL(0, "全部", ""),
    MINE(1, "我负责的线索", ""),
    PUBLISH(2, "公共池线索", ""),
    NOT_FOLLOW_UP(3, "7天未跟进线索", ""),
    SUBORDINATE(4, "下属线索", ""),
    INVALID(5, "无效线索", ""),
    ;

    private static Map<Integer, ConsulterOutLineType> map = Maps.newHashMap();

    static {
        for (ConsulterOutLineType p : values()) {
            map.put(p.getValue(), p);
        }
    }
    
    public static String getLabel(Integer value) {
    	if(value==null){
    		return null;
    	}
        return  map.get(value).getLabel();
    }
    
    public static ConsulterOutLineType getEnum(Integer value){
    	if(value==null){
    		return null;
    	}
    	return  map.get(value);
    }
    
    
    private int value;
    private String label;
    private String img;

    private ConsulterOutLineType(int value, String label, String img) {
        this.value = value;
        this.label = label;
        this.img = img;
    }

    public int getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }
    
    public String getImg(){
    	return img;
    }
    
    public static List<ConfigEnum> list(){
    	List<ConfigEnum> list = new ArrayList<ConfigEnum>();
    	for (ConsulterOutLineType p : values()) {
    		 ConfigEnum po = new ConfigEnum();
    		 po.setValue(p.getValue());
    		 po.setLabel(p.getLabel());
    		 po.setImg(p.getImg());
    		 list.add(po);
    	}
    	return list;
    }
    
    public static int getDayNumForNotFollowUp(){
    	return 7;
    }
    
}
