/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.consult.msg.service.impl;

import com.baijia.tianxiao.biz.consult.msg.service.AbstractConsultService;
import com.baijia.tianxiao.biz.consult.user.dto.ConsulterDto;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.dto.response.AdvisoryInfoDto;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.push.constant.ConsultType;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.sal.push.dto.MsgUser;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="advisoryMsgConsumeService")
public class StudentAdvisoryMsgServiceImpl
extends AbstractConsultService<AdvisoryInfoDto> {
    private static final Logger log = LoggerFactory.getLogger(StudentAdvisoryMsgServiceImpl.class);
    @Resource
    private OrgStudentDao orgStudentDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;

    @Override
    public ConsultType getConsultType() {
        return ConsultType.APPOINTMENT;
    }

    @Override
    protected ConsultMessage buildPushMessageContent(AdvisoryInfoDto msg) {
        ConsultMessage pushMsg = new ConsultMessage();
        pushMsg.setConsultType(ConsultType.APPOINTMENT.getValue());
        pushMsg.setCreateTime(msg.getCreateTime());
        pushMsg.setMsgType(MsgType.TEXT.getValue());
        String text = "";
        if (msg.getCourseId() != null && msg.getCourseId() > 0L) {
            text = msg.getCourseName() + " \n";
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg.getWords()})) {
            text = text + msg.getWords();
        }
        pushMsg.setText(text);
        return pushMsg;
    }

    private MsgUser builderSender(AdvisoryInfoDto msg) {
        List consultUsers = this.consultUserDao.lookByMobile(msg.getOrgId(), msg.getStudentMobile(), new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)consultUsers)) {
            TxConsultUser consultUser = (TxConsultUser)consultUsers.get(0);
            OrgStudent student = this.orgStudentDao.getStudentByMobileAndOrgId(msg.getOrgId(), msg.getStudentMobile(), new String[]{"name", "delStatus"});
            if (student != null && student.getDelStatus().intValue() == DataStatus.NORMAL.getValue()) {
                consultUser.setName(student.getName());
            }
            this.buildComment(consultUser, msg, false);
            return ConsulterDto.convertToDto(consultUser);
        }
        TxConsultUser consultUser = new TxConsultUser();
        consultUser.setOrgId(msg.getOrgId());
        if (ConsultType.getNoEditConsultType().contains(this.getConsultType())) {
            consultUser.setMobile(MaskUtil.maskMobile((String)msg.getStudentMobile()));
        } else {
            consultUser.setMobile(msg.getStudentMobile());
        }
        consultUser.setName(msg.getStudentName());
        if (msg.getStudentId() == null) {
            consultUser.setUserId(Long.valueOf(0L));
        } else {
            consultUser.setUserId(msg.getStudentId());
        }
        if (msg.getUserNumber() != null) {
            consultUser.setUserNumber(msg.getUserNumber());
        }
        consultUser.setConsultSource(Integer.valueOf(ConsultType.APPOINTMENT.getValue()));
        consultUser.setNextRemindTime(DateUtil.getOffSetDate((int)5));
        this.consultUserDao.save((Object)consultUser, new String[0]);
        this.buildComment(consultUser, msg, true);
        this.consultUserService.addSysBacklog(msg.getOrgId(), consultUser);
        return ConsulterDto.convertToDto(consultUser);
    }

    private MsgUser buildOrgMsgUser(AdvisoryInfoDto msg) {
        OrgInfo orgInfo = new OrgInfo();
        orgInfo.setOrgId(Integer.valueOf(msg.getOrgId().intValue()));
        return this.buildReceiver(orgInfo, msg.getOrgNumber());
    }

    @Override
    public boolean consume(AdvisoryInfoDto message) {
        if (message == null || message.getOrgId() == null) {
            throw new IllegalArgumentException(" advisory record is illegal");
        }
        MsgUser receiver = this.buildOrgMsgUser(message);
        MsgUser sender = this.builderSender(message);
        if (sender == null || receiver == null) {
            log.warn("sender :{} or receiver:{} is null,skip advisory  msg:{},skip", new Object[]{sender, receiver, message});
            return false;
        }
        ConsultMessage msgContent = this.buildPushMessageContent(message);
        log.info("consume advisory msg sender:{},receiver:{},msgContent:{}", new Object[]{sender.getName(), receiver, msgContent});
        boolean result = this.consultMessageService.sendConsultMessage(sender, receiver, msgContent);
        log.info("push student advisory msg:{},sender:{},receiver:{},result:{}", new Object[]{msgContent, sender, receiver, result});
        return result;
    }

    @Override
    public AdvisoryInfoDto transfer(String body) {
        if (StringUtils.isBlank((CharSequence)body)) {
            return null;
        }
        try {
            return (AdvisoryInfoDto)JacksonUtil.str2Obj((String)body, AdvisoryInfoDto.class);
        }
        catch (Exception e) {
            log.error("pasrse message body:{} catch error:{},skip this message", (Object)body, (Object)e);
            return null;
        }
    }

    private void buildComment(TxConsultUser consultUser, AdvisoryInfoDto msg, boolean isNewStudent) {
        log.info("buildComment--------consultUser={}", (Object)consultUser.toString());
        TxStudentComment comment = new TxStudentComment();
        comment.setConsultUserId(consultUser.getId());
        comment.setUserId(consultUser.getUserId());
        comment.setOrgId(consultUser.getOrgId());
        comment.setIsSystem(Integer.valueOf(AddType.SYSTEM.getCode()));
        StringBuffer content = new StringBuffer();
        if (isNewStudent) {
            content.append("\u7cfb\u7edf\u6dfb\u52a0\u4e86\u5ba2\u6237: " + (StringUtils.isNotBlank((CharSequence)consultUser.getName()) ? consultUser.getName() : "\u533f\u540d\u5b66\u751f") + "\n");
        }
        content.append("\u7559\u5355\u5185\u5bb9: " + (StringUtils.isNotBlank((CharSequence)msg.getWords()) ? msg.getWords() : "\u65e0"));
        comment.setContent(content.toString());
        comment.setOrigin(this.getConsultType().getValue());
        this.txStudentCommentDao.save((Object)comment, Boolean.valueOf(false), new String[0]);
    }
}

