
package com.baijia.tianxiao.biz.club.constant;

/**
 * @title OrgClubLevel
 * @desc 机构会员级别
 * @author caoliang
 * @date 2015年12月23日
 * @version 1.0
 */
public enum OrgClubLevel {
    UNKNOW(0, "未知"), NORMAL(1, "普通用户"), GOLD(2, "金卡会员"), PLATINUM(3, "白金卡会员"), DIAMOND(4, "钻石卡会员");

    private int code;
    private String name;

    OrgClubLevel(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {

        return code;
    }

    public void setCode(int code) {

        this.code = code;
    }

    public String getName() {

        return name;
    }

    public void setName(String name) {

        this.name = name;
    }

    public static int getCodeByRole(ClubRole role) {
        switch (role) {
            case NORMAL_ROLE:
                return NORMAL.code;
            case GOLD_ROLE:
                return GOLD.code;
            case PLATINUM_ROLE:
                return PLATINUM.code;
            case DIAMOND_ROLE:
                return DIAMOND.code;
            default:
                return UNKNOW.code;
        }
    }
}
