/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.club.util;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.QueueMeta;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.beust.jcommander.internal.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqsUtils {
    private static final Logger logger = LoggerFactory.getLogger(MqsUtils.class);
    private static final int POLLING_WAIT_SECONDS = 15;
    private static final long MAX_MSG_SIZE = 2048L;
    private MNSClient client;

    public MqsUtils() {
        CloudAccount account = new CloudAccount(PropertiesReader.getValue((String)"mqs", (String)"mns.accesskeyid"), PropertiesReader.getValue((String)"mqs", (String)"mns.accesskeysecret"), PropertiesReader.getValue((String)"mqs", (String)"mns.accountendpoint"));
        this.client = account.getMNSClient();
    }

    public CloudQueue getAndCreateQueue(String queueName) {
        CloudQueue queue = this.client.getQueueRef(queueName);
        if (queue == null) {
            QueueMeta meta = new QueueMeta();
            meta.setQueueName(queueName);
            meta.setPollingWaitSeconds(Integer.valueOf(15));
            meta.setMaxMessageSize(Long.valueOf(2048L));
            queue = this.client.createQueue(meta);
        }
        return queue;
    }

    public void sendMessage(String queueName, String messageBody) {
        CloudQueue queue = this.getAndCreateQueue(queueName);
        String msgId = UUID.randomUUID().toString();
        Message message = new Message();
        message.setMessageBody(messageBody);
        message.setRequestId(msgId);
        logger.info("sendMessage.queueName:{}, messageBody:{}", (Object)queueName, (Object)messageBody);
        queue.putMessage(message);
    }

    public void doAfter() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public MNSClient getClient() {
        return this.client;
    }

    public void setClient(MNSClient client) {
        this.client = client;
    }

    public static void main(String[] args) {
        Map map = Maps.newHashMap();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        map.put("org_id", list);
        String msg = JSONObject.fromObject((Object)map).toString();
        System.out.println(msg);
    }
}

