/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.club.impl;

import com.baijia.cas.ac.dto.AccountDto;
import com.baijia.cas.ac.dto.RoleDto;
import com.baijia.cas.ac.protocol.GetAccountResponse;
import com.baijia.cas.ac.protocol.GetAccountsResponse;
import com.baijia.cas.ac.protocol.GetSubAccountsResponse;
import com.baijia.tianxiao.biz.club.OrgClubEssentialInfoService;
import com.baijia.tianxiao.biz.club.constant.ClubRole;
import com.baijia.tianxiao.biz.club.constant.OrgClubLevel;
import com.baijia.tianxiao.biz.club.protocol.Deductible;
import com.baijia.tianxiao.biz.club.protocol.GetBatchOrgClubLevelResponse;
import com.baijia.tianxiao.biz.club.protocol.GetSingleOrgClubLevelResponse;
import com.baijia.tianxiao.biz.club.protocol.GetUpgradeInfo;
import com.baijia.tianxiao.dal.club.po.OrgVip;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.club.OrgVipService;
import com.baijia.tianxiao.sal.club.cas.CasAccountApi;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgInfoSimpleDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgClubEssentialInfoServiceImpl
implements OrgClubEssentialInfoService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CasAccountApi casAccountApi;
    @Autowired
    private OrgVipService orgVipService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private OrgInfoDao orgInfoDao;

    @Override
    public GetSingleOrgClubLevelResponse getSigleOrgClubLevel(String orgNumber) {
        GetSingleOrgClubLevelResponse response = new GetSingleOrgClubLevelResponse();
        this.logger.debug("orgNumber:{}", (Object)orgNumber);
        if (StringUtils.isBlank((String)orgNumber)) {
            throw new ParameterException("orgNumber must not be null");
        }
        GetAccountResponse acResponse = null;
        try {
            acResponse = this.casAccountApi.getAccount(orgNumber);
        }
        catch (Exception e) {
            this.logger.error("getSigleOrgClubLevel error", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "system error");
        }
        if (acResponse.getAccount() == null) {
            response.setLevel(OrgClubLevel.NORMAL.getCode());
        } else {
            List roles = acResponse.getAccount().getHasRoles();
            if (CollectionUtils.isEmpty((Collection)roles)) {
                response.setLevel(OrgClubLevel.NORMAL.getCode());
            } else {
                for (RoleDto role : roles) {
                    response.setLevel(OrgClubLevel.getCodeByRole(ClubRole.getRoleByTag(role.getTag())));
                }
            }
        }
        return response;
    }

    @Override
    public GetBatchOrgClubLevelResponse getBatchOrgClubLevel(String orgNumbers) throws ParameterException, BussinessException {
        GetBatchOrgClubLevelResponse response = new GetBatchOrgClubLevelResponse();
        LinkedHashMap data = Maps.newLinkedHashMap();
        this.logger.debug("orgNumbers:{}", (Object)orgNumbers);
        if (StringUtils.isBlank((String)orgNumbers)) {
            throw new ParameterException("orgNumbers must not be null");
        }
        List orgNumberList = null;
        try {
            orgNumberList = JacksonUtil.str2List((String)orgNumbers, String.class);
        }
        catch (Exception e) {
            throw new ParameterException("The pattern of orgNumbers must be wrong!orgNumbers:" + orgNumbers);
        }
        if (orgNumberList.size() > 1000) {
            throw new ParameterException("orgNumbers' length must less than 1000");
        }
        GetAccountsResponse acResponse = null;
        try {
            acResponse = this.casAccountApi.getAccounts(orgNumberList);
        }
        catch (Exception e) {
            this.logger.error("getBatchOrgClubLevel error", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "system error");
        }
        for (String orgNumber : orgNumberList) {
            data.put(orgNumber, OrgClubLevel.NORMAL.getCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)acResponse.getAccounts())) {
            for (AccountDto dto : acResponse.getAccounts()) {
                List roles = dto.getHasRoles();
                if (!CollectionUtils.isNotEmpty((Collection)roles)) continue;
                for (RoleDto role : roles) {
                    data.put(dto.getName(), OrgClubLevel.getCodeByRole(ClubRole.getRoleByTag(role.getTag())));
                }
            }
        }
        response.setLevel(data);
        return response;
    }

    @Override
    public GetBatchOrgClubLevelResponse getAllOrgClubLevel() throws ParameterException, BussinessException {
        GetSubAccountsResponse acResponse = null;
        try {
            acResponse = this.casAccountApi.getSubAccounts();
        }
        catch (Exception e) {
            this.logger.error("getAllOrgClubLevel error!", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "system error");
        }
        HashMap data = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)acResponse.getAccounts())) {
            for (AccountDto dto : acResponse.getAccounts()) {
                List roles = dto.getHasRoles();
                if (!CollectionUtils.isNotEmpty((Collection)roles)) continue;
                for (RoleDto role : roles) {
                    data.put(dto.getName(), OrgClubLevel.getCodeByRole(ClubRole.getRoleByTag(role.getTag())));
                }
            }
        }
        GetBatchOrgClubLevelResponse response = new GetBatchOrgClubLevelResponse();
        response.setLevel(data);
        return response;
    }

    @Override
    public List<OrgVip> getOrgVipByOrgNumber(Integer orgNumber) throws ParameterException, BussinessException {
        if (orgNumber == null) {
            throw new ParameterException("orgNumber must not be null");
        }
        List result = null;
        try {
            result = this.orgVipService.getOrgVipByOrgNumber(orgNumber);
        }
        catch (Exception e) {
            this.logger.error("getOrgVipByOrgNumber error!", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "system error");
        }
        return result;
    }

    @Override
    public Integer getOrgVipRemainDay(Integer orgNumber) throws ParameterException, BussinessException {
        if (orgNumber == null) {
            throw new ParameterException("orgNumber must not be null");
        }
        int remainDay = -1;
        List orgVips = null;
        try {
            orgVips = this.orgVipService.getOrgVipByOrgNumber(orgNumber);
        }
        catch (Exception e) {
            this.logger.error("getOrgVipByOrgNumber error!", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "system error");
        }
        this.logger.info("orgVips:{}", (Object)orgVips);
        if (CollectionUtils.isNotEmpty((Collection)orgVips)) {
            for (OrgVip orgVip : orgVips) {
                this.logger.info("orgVip:{}", (Object)orgVip);
                if (orgVip.getRemainDay() <= remainDay) continue;
                remainDay = orgVip.getRemainDay();
            }
        }
        return remainDay;
    }

    @Override
    public GetUpgradeInfo getUpgradeInfo(String mobile, String beginTime) throws Exception {
        if (StringUtils.isBlank((String)mobile)) {
            throw new ParameterException("mobile must not be null");
        }
        if (StringUtils.isBlank((String)beginTime)) {
            throw new ParameterException("beginTime must not be null");
        }
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByMobile(mobile);
        if (orgAccount == null) {
            throw new ParameterException("mobile does not exist");
        }
        List orgVips = this.orgVipService.getOrgVipByOrgNumber(orgAccount.getNumber());
        if (CollectionUtils.isEmpty((Collection)orgVips)) {
            OrgVip orgVip = new OrgVip();
            orgVip.setVipLevel(Integer.valueOf(0));
            orgVip.setRemainDay(Integer.valueOf(0));
            orgVip.setTotalDay(Integer.valueOf(0));
            orgVips.add(orgVip);
        }
        HashMap priceLevel = Maps.newHashMap();
        priceLevel.put(ClubRole.GOLD_ROLE.getCode().toString(), PropertiesReader.getValue((String)"org_vip_level", (String)ClubRole.GOLD_ROLE.getCode().toString()));
        priceLevel.put(ClubRole.PLATINUM_ROLE.getCode().toString(), PropertiesReader.getValue((String)"org_vip_level", (String)ClubRole.PLATINUM_ROLE.getCode().toString()));
        priceLevel.put(ClubRole.DIAMOND_ROLE.getCode().toString(), PropertiesReader.getValue((String)"org_vip_level", (String)ClubRole.DIAMOND_ROLE.getCode().toString()));
        OrgVip orgVip = (OrgVip)orgVips.get(0);
        GetUpgradeInfo response = new GetUpgradeInfo();
        OrgInfoSimpleDto orgInfo = this.orgInfoService.getOrgInfo(Long.valueOf(orgAccount.getId().intValue()));
        response.setUserName(orgInfo.getShortName());
        response.setNumber(orgAccount.getNumber());
        response.setRemainDays(orgVip.getRemainDay());
        response.setUserId(orgAccount.getId());
        OrgInfo auditOrgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
        if (auditOrgInfo.getAuditStatus().intValue() != AuditStatus.PASS.getValue()) {
            response.setVipLevel(-1);
        } else {
            response.setVipLevel(orgVip.getVipLevel());
        }
        response.setLevelPrice(priceLevel);
        if (orgVip.getVipLevel() != ClubRole.UNKNOW_ROLE.getCode()) {
            Deductible deductible = new Deductible();
            Double remainDay = (double)orgVip.getRemainDay();
            Double totalDay = (double)orgVip.getTotalDay();
            List totalVips = this.orgVipService.getTotalOrgVipByOrgNumber(orgAccount.getNumber());
            BigDecimal totalMoney = null;
            totalMoney = totalVips.size() > 1 ? new BigDecimal(orgVip.getOrderPrice()) : new BigDecimal(orgVip.getPayPrice());
            BigDecimal btd = new BigDecimal(totalDay);
            BigDecimal perDayIncome = totalMoney.divide(btd, 2, RoundingMode.DOWN);
            Double value = totalMoney.subtract(perDayIncome.multiply(new BigDecimal(totalDay - remainDay))).doubleValue();
            deductible.setBeginTime(beginTime);
            DecimalFormat df = new DecimalFormat("######0.00");
            if (remainDay > 1.0) {
                deductible.setValue(df.format(value));
            } else {
                deductible.setValue("0.00");
            }
            response.setDeductible(deductible);
        }
        return response;
    }

    public static void main(String[] args) {
        DecimalFormat df = new DecimalFormat("######0.00");
        System.out.println(df.format(new BigDecimal(9.9)));
    }
}

