/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.club.impl;

import com.baijia.tianxiao.biz.club.OrgClubOperateService;
import com.baijia.tianxiao.biz.club.constant.CasAccountStatus;
import com.baijia.tianxiao.biz.club.constant.ClubRole;
import com.baijia.tianxiao.biz.club.util.MqsUtils;
import com.baijia.tianxiao.dal.cas.po.Account;
import com.baijia.tianxiao.dal.cas.po.AccountRole;
import com.baijia.tianxiao.dal.cas.po.Role;
import com.baijia.tianxiao.dal.club.po.OrgVip;
import com.baijia.tianxiao.dal.club.po.OrgVipChargingHistory;
import com.baijia.tianxiao.dal.club.po.OrgVipScanRecord;
import com.baijia.tianxiao.dal.constant.VipStatus;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.shoukuan.po.GoodsMembership;
import com.baijia.tianxiao.dal.shoukuan.po.SuccessOrderInfo;
import com.baijia.tianxiao.sal.club.OrgVipChargingHistoryService;
import com.baijia.tianxiao.sal.club.OrgVipScanRecordService;
import com.baijia.tianxiao.sal.club.OrgVipService;
import com.baijia.tianxiao.sal.club.ReceivablesService;
import com.baijia.tianxiao.sal.club.cas.CasService;
import com.baijia.tianxiao.sal.club.constant.App;
import com.baijia.tianxiao.sal.club.constant.OrgVipChargingHistoryStatus;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgClubOperateServiceImpl
implements OrgClubOperateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OrgVipChargingHistoryService orgVipChargingHistoryService;
    @Autowired
    private OrgVipService orgVipService;
    @Autowired
    private ReceivablesService receivablesService;
    @Autowired
    private CasService casService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgVipScanRecordService orgVipScanRecordService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void signHistoryHandled(String orgVipHistoryIdsStr) throws Exception {
        List orgVipChargingHistoryIds = JacksonUtil.str2List((String)orgVipHistoryIdsStr, Integer.class);
        this.logger.debug("signHistoryHandled ids:{}", (Object)orgVipChargingHistoryIds);
        this.orgVipChargingHistoryService.batchUpdateStatus(orgVipChargingHistoryIds, Integer.valueOf(OrgVipChargingHistoryStatus.HANDLED.getCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int dailySyncOrgVip() {
        int syncCount = 0;
        int index = 0;
        boolean toBeContinued = true;
        do {
            OrgVip orgVip;
            if ((orgVip = this.orgVipService.getSingleNormalOrgVip(Integer.valueOf(index))) != null) {
                if (orgVip.getStartTime().getTime() <= System.currentTimeMillis()) {
                    int remainDay = orgVip.getRemainDay();
                    orgVip.setRemainDay(Integer.valueOf(--remainDay));
                    orgVip.setUpdateTime(new Date());
                    this.orgVipService.updateOrgVip(orgVip);
                    if (remainDay == 0) {
                        this.casService.updateAccountRoleStatus(orgVip.getOrgNumber().toString(), Integer.valueOf(CasAccountStatus.PAUSE.getCode()), ClubRole.getRoleByCode(orgVip.getVipLevel()).getTag());
                    }
                    if (orgVip.getPurchaseId() > 0L) {
                        ++syncCount;
                        OrgVipChargingHistory history = new OrgVipChargingHistory();
                        history.setOrgNumber(orgVip.getOrgNumber());
                        history.setStatus(Integer.valueOf(OrgVipChargingHistoryStatus.WAITING.getCode()));
                        history.setVipId(orgVip.getId());
                        history.setRemainDay(orgVip.getRemainDay());
                        this.orgVipChargingHistoryService.saveOrgVipChargingHistory(history);
                    }
                }
                index = orgVip.getId();
                continue;
            }
            toBeContinued = false;
        } while (toBeContinued);
        return syncCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int syncNewOrgVip() {
        List newOrderInfos;
        int syncCount = 0;
        int index = 0;
        OrgVip lastOrgVip = this.orgVipService.getLastOrgVip();
        if (lastOrgVip != null) {
            index = lastOrgVip.getOrderId();
        }
        if (CollectionUtils.isNotEmpty((Collection)(newOrderInfos = this.receivablesService.getPayedOrderInfo(index)))) {
            List purchaseIds = BaseUtils.getListFilter((List)newOrderInfos, (String)"purchaseId");
            List goodsList = this.receivablesService.getByPurchaseIds(purchaseIds);
            Map goodsMap = BaseUtils.listToMap((List)goodsList, (String)"purchaseId");
            ArrayList orgVips = Lists.newArrayList();
            ArrayList acs = Lists.newArrayList();
            for (SuccessOrderInfo orderInfo : newOrderInfos) {
                GoodsMembership goods = (GoodsMembership)goodsMap.get(orderInfo.getPurchaseId());
                if (goods == null) continue;
                this.generateOrgVips(orgVips, goods, orderInfo);
                this.generateAccountRoles(acs, goods);
            }
            this.orgVipService.saveAll((List)orgVips);
            this.casService.saveAllAccountRole((List)acs);
            this.noticeTeacherToRefresh(orgVips);
            syncCount = orgVips.size();
        }
        return syncCount;
    }

    private void noticeTeacherToRefresh(List<OrgVip> orgVips) {
        HashMap map = Maps.newHashMap();
        try {
            List numbers;
            List orgAccounts;
            if (CollectionUtils.isNotEmpty(orgVips) && CollectionUtils.isNotEmpty((Collection)(orgAccounts = this.orgAccountDao.getAccountByNumbers((Collection)(numbers = BaseUtils.getListFilter(orgVips, (String)"orgNumber")), new String[0])))) {
                List orgIds = BaseUtils.getListFilter((List)orgAccounts, (String)"id");
                MqsUtils util = new MqsUtils();
                map.put("org_id", orgIds);
                util.sendMessage(PropertiesReader.getValue((String)"mqs", (String)"mns.queue.clear_org_teacher_cache"), JSONObject.fromObject((Object)map).toString());
            }
        }
        catch (Exception e) {
            this.logger.error("send mqs error!info:{}", (Object)map, (Object)e);
        }
    }

    private void generateAccountRoles(List<AccountRole> acs, GoodsMembership goods) {
        Account account = this.casService.getAccountByName(goods.getOrgNumber().toString());
        if (account == null) {
            return;
        }
        Role role = this.casService.getRoleByTag(ClubRole.getRoleByCode(goods.getGrade()).getTag());
        if (role == null) {
            return;
        }
        AccountRole ar = new AccountRole();
        ar.setAppId(Integer.valueOf(App.JIGOU.getId()));
        ar.setCreatetime(new Date());
        ar.setAccountId(Integer.valueOf(account.getId()));
        ar.setRoleId(Integer.valueOf(role.getId()));
        acs.add(ar);
    }

    private void generateOrgVips(List<OrgVip> orgVips, GoodsMembership goods, SuccessOrderInfo orderInfo) {
        OrgVip orgVip = new OrgVip();
        orgVip.setCreateTime(new Date());
        orgVip.setEndTime(goods.getEndTime());
        orgVip.setIsdel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgVip.setOrderId(orderInfo.getId());
        orgVip.setOrderPrice(goods.getPrice());
        orgVip.setOrgNumber(goods.getOrgNumber());
        orgVip.setPayPrice(goods.getPayMoney());
        orgVip.setPurchaseId(goods.getPurchaseId());
        DateTime startTime = new DateTime(goods.getBeginTime().getTime());
        DateTime endTime = new DateTime(goods.getEndTime().getTime());
        int days = Days.daysBetween((ReadableInstant)startTime, (ReadableInstant)endTime).getDays();
        orgVip.setRemainDay(Integer.valueOf(days));
        orgVip.setStartTime(goods.getBeginTime());
        orgVip.setStatus(Integer.valueOf(VipStatus.NORMAL.getCode()));
        orgVip.setTotalDay(Integer.valueOf(days));
        orgVip.setUserRole(Integer.valueOf(6));
        orgVip.setUpdateTime(new Date());
        orgVip.setVipLevel(goods.getGrade());
        orgVips.add(orgVip);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int syncUpgradeOrgVip() {
        List newOrderInfos;
        int syncCount = 0;
        int index = 0;
        OrgVipScanRecord lastRecord = this.orgVipScanRecordService.getLastUpgradeOrgVipScanRecord();
        if (lastRecord != null) {
            index = lastRecord.getSuccessOrderInfoId();
        }
        if (CollectionUtils.isNotEmpty((Collection)(newOrderInfos = this.receivablesService.getPayedUpgradeOrderInfo(index)))) {
            List purchaseIds = BaseUtils.getListFilter((List)newOrderInfos, (String)"purchaseId");
            List goodsList = this.receivablesService.getByPurchaseIds(purchaseIds);
            Map goodsMap = BaseUtils.listToMap((List)goodsList, (String)"purchaseId");
            ArrayList orgVips = Lists.newArrayList();
            ArrayList acs = Lists.newArrayList();
            for (SuccessOrderInfo orderInfo : newOrderInfos) {
                GoodsMembership goods = (GoodsMembership)goodsMap.get(orderInfo.getPurchaseId());
                if (goods == null) continue;
                this.delOrgVipAndAccountRole(goods);
                this.generateOrgVips(orgVips, goods, orderInfo);
                this.generateAccountRoles(acs, goods);
                this.saveScanRecord(orderInfo);
            }
            this.orgVipService.saveAll((List)orgVips);
            this.casService.saveAllAccountRole((List)acs);
            this.noticeTeacherToRefresh(orgVips);
            syncCount = orgVips.size();
        }
        return syncCount;
    }

    private void saveScanRecord(SuccessOrderInfo orderInfo) {
        OrgVipScanRecord record = new OrgVipScanRecord();
        record.setCreateTime(new Date());
        record.setPurchaseId(orderInfo.getPurchaseId());
        record.setSubType(orderInfo.getSubType());
        record.setSuccessOrderInfoId(orderInfo.getId());
        record.setType(orderInfo.getType());
        this.orgVipScanRecordService.saveUpgradeRecord(record);
    }

    private void delOrgVipAndAccountRole(GoodsMembership goods) {
        List orgVips = this.orgVipService.getOrgVipByOrgNumber(goods.getOrgNumber());
        if (CollectionUtils.isEmpty((Collection)orgVips)) {
            return;
        }
        for (OrgVip orgVip : orgVips) {
            orgVip.setStatus(Integer.valueOf(VipStatus.DISABLE.getCode()));
            this.orgVipService.updateOrgVip(orgVip);
            this.casService.updateAccountRoleStatus(goods.getOrgNumber().toString(), Integer.valueOf(DeleteStatus.DELETED.getValue()), ClubRole.getRoleByCode(orgVip.getVipLevel()).getTag());
        }
    }
}

