/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.club.impl;

import com.baijia.cas.ac.api.AccountApi;
import com.baijia.cas.ac.dto.AccountDto;
import com.baijia.cas.ac.dto.RoleDto;
import com.baijia.cas.ac.protocol.GetAccountRequest;
import com.baijia.cas.ac.protocol.GetAccountResponse;
import com.baijia.cas.ac.protocol.GetAccountsRequest;
import com.baijia.cas.ac.protocol.GetAccountsResponse;
import com.baijia.cas.ac.protocol.GetSubAccountsRequest;
import com.baijia.cas.ac.protocol.GetSubAccountsResponse;
import com.baijia.tianxiao.biz.club.OrgClubEssentialInfoService;
import com.baijia.tianxiao.biz.club.constant.App;
import com.baijia.tianxiao.biz.club.constant.OrgClubLevel;
import com.baijia.tianxiao.biz.club.constant.Role;
import com.baijia.tianxiao.biz.club.protocol.GetBatchOrgClubLevelResponse;
import com.baijia.tianxiao.biz.club.protocol.GetSingleOrgClubLevelResponse;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgClubEssentialInfoServiceImpl
implements OrgClubEssentialInfoService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AccountApi accountApi;

    @Override
    public GetSingleOrgClubLevelResponse getSigleOrgClubLevel(String orgNumber) {
        GetSingleOrgClubLevelResponse response = new GetSingleOrgClubLevelResponse();
        this.logger.debug("orgNumber:{}", (Object)orgNumber);
        if (StringUtils.isBlank((String)orgNumber)) {
            throw new ParameterException("orgNumber must not be null");
        }
        GetAccountResponse acResponse = null;
        try {
            GetAccountRequest acRequest = new GetAccountRequest();
            acRequest.setAccountName(orgNumber);
            acRequest.setAppId(App.JIGOU.getId());
            acResponse = this.accountApi.getAccount(acRequest);
        }
        catch (Exception e) {
            this.logger.error("getSigleOrgClubLevel error", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "system error");
        }
        if (acResponse.getAccount() == null) {
            response.setLevel(OrgClubLevel.NORMAL.getCode());
        } else {
            List roles = acResponse.getAccount().getHasRoles();
            if (CollectionUtils.isEmpty((Collection)roles)) {
                response.setLevel(OrgClubLevel.NORMAL.getCode());
            } else {
                for (RoleDto role : roles) {
                    response.setLevel(OrgClubLevel.getCodeByRole(Role.getRoleByTag(role.getTag())));
                }
            }
        }
        return response;
    }

    @Override
    public GetBatchOrgClubLevelResponse getBatchOrgClubLevel(String orgNumbers) throws ParameterException, BussinessException {
        GetBatchOrgClubLevelResponse response = new GetBatchOrgClubLevelResponse();
        LinkedHashMap data = Maps.newLinkedHashMap();
        this.logger.debug("orgNumbers:{}", (Object)orgNumbers);
        if (StringUtils.isBlank((String)orgNumbers)) {
            throw new ParameterException("orgNumbers must not be null");
        }
        List orgNumberList = null;
        try {
            orgNumberList = JacksonUtil.str2List((String)orgNumbers, String.class);
        }
        catch (IOException e) {
            this.logger.info("trans orgNumbers to list error!", (Throwable)e);
            throw new ParameterException("The pattern of orgNumbers must be wrong!orgNumbers:" + orgNumbers);
        }
        if (orgNumberList.size() > 1000) {
            throw new ParameterException("orgNumbers' length must less than 1000");
        }
        GetAccountsResponse acResponse = null;
        try {
            GetAccountsRequest acRequest = new GetAccountsRequest();
            acRequest.setAccountNames(orgNumberList);
            acRequest.setAppId(App.JIGOU.getId());
            acResponse = this.accountApi.getAccounts(acRequest);
        }
        catch (Exception e) {
            this.logger.error("getBatchOrgClubLevel error", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "system error");
        }
        for (String orgNumber : orgNumberList) {
            data.put(orgNumber, OrgClubLevel.NORMAL.getCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)acResponse.getAccounts())) {
            for (AccountDto dto : acResponse.getAccounts()) {
                List roles = dto.getHasRoles();
                if (!CollectionUtils.isNotEmpty((Collection)roles)) continue;
                for (RoleDto role : roles) {
                    data.put(dto.getName(), OrgClubLevel.getCodeByRole(Role.getRoleByTag(role.getTag())));
                }
            }
        }
        response.setLevel(data);
        return response;
    }

    @Override
    public GetBatchOrgClubLevelResponse getAllOrgClubLevel() throws ParameterException, BussinessException {
        GetSubAccountsRequest acRequest = new GetSubAccountsRequest();
        acRequest.setSubRoleTag("yunying_jigou_club_");
        acRequest.setAppId(App.JIGOU.getId());
        GetSubAccountsResponse acResponse = null;
        try {
            acResponse = this.accountApi.getSubAccounts(acRequest);
        }
        catch (Exception e) {
            this.logger.error("getAllOrgClubLevel error!", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "system error");
        }
        HashMap data = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)acResponse.getAccounts())) {
            for (AccountDto dto : acResponse.getAccounts()) {
                List roles = dto.getHasRoles();
                if (!CollectionUtils.isNotEmpty((Collection)roles)) continue;
                for (RoleDto role : roles) {
                    data.put(dto.getName(), OrgClubLevel.getCodeByRole(Role.getRoleByTag(role.getTag())));
                }
            }
        }
        GetBatchOrgClubLevelResponse response = new GetBatchOrgClubLevelResponse();
        response.setLevel(data);
        return response;
    }
}

