
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.campus.service;

import java.util.List;

import com.baijia.tianxiao.biz.campus.dto.AddAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.AddCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.CampusAccountDto;
import com.baijia.tianxiao.biz.campus.dto.ModAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.ModCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.SettingCampusListDto;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * @title SettingService
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年5月13日
 * @version 1.0
 */

public interface SettingService {
    
    public List<SettingCampusListDto> getCampusList(Integer orgId, PageDto pageDto) throws BussinessException, Exception;
    
    public void addCampus(AddCampusRequest addCampusRequest) throws BussinessException, Exception;
    
    public void modCampus(ModCampusRequest modCampusRequest) throws BussinessException, Exception;
    
    public List<CampusAccountDto> getAccountList(OrgAccount orgAccount, PageDto pageDto, boolean isAll) throws BussinessException, Exception;
    
    /**
     * true-新建了账户，许发送密码短信 false不发送
     * 
     * @param request
     * @return
     */
    public boolean addAccount(AddAccountRequest request);
    
    public void modAccount(ModAccountRequest request);
    
    public void modAccountStatus(ModAccountRequest request);
}

    