/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.CampusAccountStatus;
import com.baijia.tianxiao.biz.campus.constant.CampusType;
import com.baijia.tianxiao.biz.campus.dto.AddAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.AddCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.CampusAccountDto;
import com.baijia.tianxiao.biz.campus.dto.ModAccountRequest;
import com.baijia.tianxiao.biz.campus.dto.ModCampusRequest;
import com.baijia.tianxiao.biz.campus.dto.SettingCampusListDto;
import com.baijia.tianxiao.biz.campus.dto.TXPermissionNodeDto;
import com.baijia.tianxiao.biz.campus.service.SettingService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXCascadeAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.enums.SMSErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionAccountType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionHasType;
import com.baijia.tianxiao.sal.organization.mqs.OrganizationRegist;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.MqsUtils;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.VerifyCodeUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.yunying.hag.common.web.WebResponse;
import com.baijia.yunying.hag.dal.bo.Entity;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SettingServiceImpl
implements SettingService {
    private static final Logger log = LoggerFactory.getLogger(SettingServiceImpl.class);
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired(required=false)
    private HagService hagService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private TxConsulterOperationLogDao txConsulterOperationLogDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;

    @Override
    public List<SettingCampusListDto> getCampusList(Integer orgId, PageDto pageDto) throws BussinessException, Exception {
        ArrayList data = Lists.newArrayList();
        SettingCampusListDto master = new SettingCampusListDto();
        OrgSubAccount masterSub = this.orgSubAccountService.getMaster(orgId);
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(orgId);
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgId, new String[0]);
        master.setCampusName(orgInfo.getShortName());
        master.setCampusNumber(orgAccount.getNumber());
        master.setCampusType(CampusType.MASTER.getCode());
        master.setCampusTypeName(CampusType.MASTER.getLabel());
        master.setAreaId(orgInfo.getAreaId());
        master.setMobile(orgAccount.getMobile());
        master.setPrincipal(orgInfo.getContacts());
        master.setCoverUrl(masterSub.getCoverUrl());
        if (orgInfo.getAreaId() != null) {
            Map areaMap = AreaUtils.getAreaNameByCode((Integer)orgInfo.getAreaId().intValue());
            master.setProvince((String)areaMap.get("province"));
            master.setCity((String)areaMap.get("city"));
        }
        Integer mCascadeCount = this.txCascadeAccountDao.getCountByOrgId(orgId);
        mCascadeCount = mCascadeCount + 1;
        master.setAccountSum(mCascadeCount);
        data.add(master);
        if (pageDto.getPageNum() == 1) {
            pageDto.setPageSize(Integer.valueOf(pageDto.getPageSize() - 1));
        } else {
            pageDto.setCurPageCount(Integer.valueOf((pageDto.getPageNum() - 1) * pageDto.getPageSize() - 1));
            data.clear();
        }
        List slaves = this.orgSubAccountService.getSlaves(orgId, pageDto);
        if (CollectionUtils.isNotEmpty((Collection)slaves)) {
            for (OrgSubAccount subAccount : slaves) {
                OrgAccount oAccount = this.orgAccountService.getOrgAccountById(subAccount.getOrgId());
                if (oAccount == null) continue;
                OrgInfo oInfo = this.orgInfoDao.getOrgInfo(oAccount.getId(), new String[0]);
                Integer subCount = this.txCascadeAccountDao.getCountByOrgId(oAccount.getId());
                SettingCampusListDto slave = new SettingCampusListDto();
                subCount = subCount + 1;
                slave.setAccountSum(subCount);
                slave.setCampusName(oInfo.getShortName());
                slave.setCampusNumber(oAccount.getNumber());
                slave.setCampusType(subAccount.getAccountType());
                slave.setAreaId(oInfo.getAreaId());
                slave.setCampusId(subAccount.getId());
                slave.setMobile(oAccount.getMobile());
                slave.setCoverUrl(subAccount.getCoverUrl());
                if (oInfo.getAreaId() != null) {
                    Map areaMap = AreaUtils.getAreaNameByCode((Integer)oInfo.getAreaId().intValue());
                    slave.setProvince((String)areaMap.get("province"));
                    slave.setCity((String)areaMap.get("city"));
                }
                slave.setPrincipal(oInfo.getContacts());
                data.add(slave);
            }
        }
        Integer slaveCount = this.orgSubAccountService.getSlaveCount(orgId);
        slaveCount = slaveCount + 1;
        pageDto.setCount(slaveCount);
        return data;
    }

    @Override
    public void addCampus(AddCampusRequest addCampusRequest) {
        OrgSubAccount slaveInDB;
        Integer subCount = this.orgSubAccountService.getSlaveCount(TianxiaoPCContext.getOrgId());
        TXAccount txAccount = this.txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId());
        if (txAccount.getCampusCount() <= subCount + 1) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCESS_CAMPUS_COUNT);
        }
        OrgAccount subAccount = this.orgAccountService.getOrgAccountByMobile(addCampusRequest.getMobile());
        if (subAccount != null) {
            if (subAccount.getId().intValue() == txAccount.getOrgId().intValue()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e0d\u80fd\u6dfb\u52a0\u81ea\u5df1");
            }
            if (StringUtils.isBlank((CharSequence)addCampusRequest.getCode()) || VerifyCodeUtil.valid((boolean)false, (String)addCampusRequest.getMobile(), (String)addCampusRequest.getCode(), (String)TxSmsCodeType.INVITE_TOBE_CAMPUS.getCacheKey())) {
                throw new BussinessException((UniverseErrorCode)SMSErrorCode.CODE_INVALID);
            }
        } else {
            subAccount = this.saveOrgAccount(addCampusRequest.getMobile());
            this.saveOrgInfo(addCampusRequest.getAreaId(), subAccount.getId(), addCampusRequest.getCampusName(), addCampusRequest.getPrincipal());
            this.sendMQSMsg(subAccount.getId(), addCampusRequest.getAreaId(), null);
            boolean sendResult = false;
            try {
                sendResult = SmsSendUtil.sendSms((String)addCampusRequest.getMobile(), (String)TxSmsCodeType.getSmsMsg((TxSmsCodeType)TxSmsCodeType.NEW_ORG_PWD, (String)"a123456"), (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)TianxiaoPCContext.getOrgId(), (Integer)UserRole.ORGANIZATION.getRole(), (boolean)true);
            }
            catch (Throwable e) {
                log.error("send invite campus sms error:", e);
            }
            if (!sendResult) {
                log.info("send invite campus sms to :{} error:{}!code :{}", new Object[]{addCampusRequest.getMobile(), sendResult, "a123456"});
            }
            log.info("send default campus pwd sms to :{} error:{}!code :{}", new Object[]{addCampusRequest.getMobile(), sendResult, "a123456"});
        }
        if ((slaveInDB = this.orgSubAccountService.getByOrgId(subAccount.getId())) != null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6b64\u6821\u533a\u5df2\u7ed1\u5b9a\u4e3b\u6821\u533a\uff0c\u4e0d\u53ef\u91cd\u590d\u7ed1\u5b9a");
        }
        OrgSubAccount slave = new OrgSubAccount();
        slave.setAccountType(addCampusRequest.getCampusType());
        slave.setComment(addCampusRequest.getPrincipal());
        slave.setOrgId(subAccount.getId());
        slave.setCreateTime(new Date());
        slave.setPid(TianxiaoPCContext.getOrgId());
        slave.setCoverUrl(PropertiesReader.getValue((String)"upload", (String)"campus.cover.url"));
        this.orgSubAccountService.addOrgSubAccount(slave);
        OrgSubAccount masterInDB = this.orgSubAccountService.getMaster(TianxiaoPCContext.getOrgId());
        if (masterInDB == null) {
            OrgSubAccount master = new OrgSubAccount();
            master.setAccountType(CampusType.MASTER.getCode());
            master.setCreateTime(new Date());
            master.setOrgId(TianxiaoPCContext.getOrgId());
            master.setPid(Integer.valueOf(0));
            master.setCoverUrl(PropertiesReader.getValue((String)"upload", (String)"campus.cover.url"));
            this.orgSubAccountService.addOrgSubAccount(master);
        }
        this.addToHag(subAccount.getNumber());
        TXAccount subTXAccount = this.txAccountDao.getByOrgId(subAccount.getId());
        if (subTXAccount != null) {
            subTXAccount.setStatus(TXAccountStatus.PAUSE.getCode());
            this.txAccountDao.update((Object)subTXAccount, new String[0]);
        }
    }

    private void sendMQSMsg(int orgId, long areaId, String mobile) {
        OrganizationRegist regist = new OrganizationRegist();
        regist.setAreaId(Long.valueOf(areaId));
        regist.setMobile("");
        regist.setOrgId(Integer.valueOf(orgId));
        regist.setTime(String.valueOf(System.currentTimeMillis() / 1000L));
        String messageBody = JacksonUtil.obj2Str((Object)regist);
        MqsUtils mqs = new MqsUtils();
        String queueName = PropertiesReader.getValue((String)"mns", (String)"mqs.queue.org.reg");
        mqs.sendMessage(queueName, messageBody);
    }

    private void addToHag(Integer orgNumber) {
        log.info("add to hag orgNumber:{}", (Object)orgNumber);
        if (orgNumber == null) {
            return;
        }
        ArrayList entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName((Object)orgNumber);
        entities.add(entity);
        WebResponse result1 = this.hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tianxiao_orgNumber");
        log.info("add {} to hag {} result:{}", new Object[]{orgNumber, "jigou_tianxiao_orgNumber", result1});
        WebResponse result2 = this.hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_3810_orgNumber");
        log.info("add {} to hag {} result:{}", new Object[]{orgNumber, "jigou_3810_orgNumber", result2});
        WebResponse result3 = this.hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tixian_orgNumber");
        log.info("add {} to hag {} result:{}", new Object[]{orgNumber, "jigou_tixian_orgNumber", result3});
    }

    private OrgAccount saveOrgAccount(String mobile) {
        OrgAccount saveToDB = new OrgAccount();
        saveToDB.setCreateTime(new Date());
        saveToDB.setMobile(mobile);
        saveToDB.setPassword(PasswordUtil.createHash((String)"a123456"));
        saveToDB.setUpdateTime(new Date());
        this.orgAccountDao.save((Object)saveToDB, new String[0]);
        Integer id = saveToDB.getId();
        if (id == null) {
            throw new BusinessException("\u6d45\u6ce8\u518c\u8d26\u6237\u5931\u8d25");
        }
        saveToDB.setNumber(Integer.valueOf(SerialNumberUtil.generateNumber((int)id, (int)99999999)));
        this.orgAccountDao.update((Object)saveToDB, new String[0]);
        return saveToDB;
    }

    private void saveOrgInfo(Long areaId, int org_id, String shortName, String contacts) {
        OrgInfo info = new OrgInfo();
        Date time = new Date();
        info.setName("");
        info.setShortName(shortName);
        info.setOrgType(Integer.valueOf(0));
        info.setAreaId(areaId);
        info.setContacts(contacts);
        info.setIdCardType(Integer.valueOf(0));
        info.setIdCard("");
        info.setIdCardStorageId(Integer.valueOf(0));
        info.setBizLicense("");
        info.setBizLicenseStorageId(Integer.valueOf(0));
        info.setSchLicenseType(Integer.valueOf(0));
        info.setSchLicense("");
        info.setSchLicenseStorageId(Integer.valueOf(0));
        info.setAuditStatus(Integer.valueOf(AuditStatus.INIT.getValue()));
        info.setRejectReason("");
        info.setRejectReasonOther("");
        info.setSignStatus(Integer.valueOf(SignStatus.UNSIGN.getCode()));
        info.setOrgId(Integer.valueOf(org_id));
        info.setCreateTime(time);
        info.setUpdateTime(time);
        this.orgInfoDao.save((Object)info, new String[0]);
    }

    @Override
    public void modCampus(ModCampusRequest modCampusRequest) throws BussinessException, Exception {
        OrgInfo orgInfo;
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(modCampusRequest.getCampusNumber());
        if (orgAccount == null) {
            return;
        }
        boolean subChange = false;
        OrgSubAccount subAccount = null;
        if (modCampusRequest.getCampusType().intValue() == CampusType.MASTER.getCode().intValue()) {
            subAccount = this.orgSubAccountService.getMaster(orgAccount.getId());
        } else {
            log.debug("mod subCampus orgId:{},pid:{}", (Object)orgAccount.getId(), (Object)TianxiaoPCContext.getOrgId());
            subAccount = this.orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        }
        if (subAccount == null) {
            log.error("Oops! check orgsubAccount data! orgId:{}", (Object)orgAccount.getId());
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getPrincipal())) {
            subAccount.setComment(modCampusRequest.getPrincipal());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getCoverUrl())) {
            subAccount.setCoverUrl(modCampusRequest.getCoverUrl());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        if (subChange) {
            this.orgSubAccountService.update(subAccount);
        }
        if ((orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0])) == null) {
            log.error("Oops! check orgInfo data! orgId:{}", (Object)orgAccount.getId());
            return;
        }
        boolean orgInfoChange = false;
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getCampusName())) {
            orgInfo.setShortName(modCampusRequest.getCampusName());
            orgInfoChange = true;
        }
        if (modCampusRequest.getAreaId() != null && modCampusRequest.getAreaId() > 0L) {
            orgInfo.setAreaId(modCampusRequest.getAreaId());
            orgInfoChange = true;
        }
        if (StringUtils.isNotBlank((CharSequence)modCampusRequest.getPrincipal())) {
            orgInfo.setContacts(modCampusRequest.getPrincipal());
        }
        if (orgInfoChange) {
            orgInfo.setUpdateTime(new Date());
            this.orgInfoDao.update((Object)orgInfo, new String[0]);
        }
    }

    @Override
    public List<CampusAccountDto> getAccountList(OrgAccount orgAccount, PageDto pageDto, boolean isAll) throws BussinessException, Exception {
        OrgInfo parentInfo;
        OrgAccount parentAccount;
        List cascadeAccounts;
        int curPageCount;
        List subAccounts;
        List<CampusAccountDto> data = Lists.newArrayList();
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
        CampusAccountDto master = this.makeMasterDto(orgAccount, orgInfo);
        data.add(master);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(orgAccount.getId());
        if (isAll && CollectionUtils.isNotEmpty((Collection)(subAccounts = this.orgSubAccountService.getSlavesIgnoreStatus(orgAccount.getId(), null)))) {
            for (OrgSubAccount subAccount : subAccounts) {
                OrgAccount slaveAccount = this.orgAccountService.getOrgAccountById(subAccount.getOrgId());
                OrgInfo slaveInfo = this.orgInfoDao.getOrgInfo(subAccount.getOrgId(), new String[0]);
                CampusAccountDto slave = this.makeSlaveDto(slaveAccount, slaveInfo, subAccount);
                data.add(slave);
                orgIds.add(slaveAccount.getId());
            }
        }
        if ((curPageCount = (pageDto.getPageNum() - 1) * pageDto.getPageSize()) == 0) {
            if (data.size() >= pageDto.getPageSize()) {
                data = data.subList(0, pageDto.getPageSize());
            } else {
                pageDto.setPageSize(Integer.valueOf(pageDto.getPageSize() - data.size()));
                cascadeAccounts = this.txCascadeAccountDao.getByOrgIds((List)orgIds, pageDto);
                if (CollectionUtils.isNotEmpty((Collection)cascadeAccounts)) {
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        parentAccount = this.orgAccountService.getOrgAccountById(cascadeAccount.getOrgId());
                        parentInfo = this.orgInfoDao.getOrgInfo(parentAccount.getId(), new String[0]);
                        TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
                        CampusAccountDto cascade = this.makeCascadeDto(parentAccount, parentInfo, credential, cascadeAccount);
                        data.add(cascade);
                    }
                }
            }
        } else if (data.size() >= curPageCount) {
            if ((data = data.subList(curPageCount, data.size())).size() >= pageDto.getPageSize()) {
                data.subList(0, pageDto.getPageSize());
            } else {
                pageDto.setCurPageCount(Integer.valueOf(0));
                pageDto.setPageSize(Integer.valueOf(pageDto.getPageSize() - data.size()));
                cascadeAccounts = this.txCascadeAccountDao.getByOrgIds((List)orgIds, pageDto);
                if (CollectionUtils.isNotEmpty((Collection)cascadeAccounts)) {
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        parentAccount = this.orgAccountService.getOrgAccountById(cascadeAccount.getOrgId());
                        parentInfo = this.orgInfoDao.getOrgInfo(parentAccount.getId(), new String[0]);
                        TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
                        CampusAccountDto cascade = this.makeCascadeDto(parentAccount, parentInfo, credential, cascadeAccount);
                        data.add(cascade);
                    }
                }
            }
        } else {
            pageDto.setCurPageCount(Integer.valueOf(curPageCount - data.size()));
            log.debug("getAccountList the 3pageDto is:{}", (Object)pageDto);
            data.clear();
            cascadeAccounts = this.txCascadeAccountDao.getByOrgIds((List)orgIds, pageDto);
            log.debug("getAccountList the cascadeAccounts is:{}", (Object)cascadeAccounts);
            if (CollectionUtils.isNotEmpty((Collection)cascadeAccounts)) {
                for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                    parentAccount = this.orgAccountService.getOrgAccountById(cascadeAccount.getOrgId());
                    parentInfo = this.orgInfoDao.getOrgInfo(parentAccount.getId(), new String[0]);
                    TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
                    CampusAccountDto cascade = this.makeCascadeDto(parentAccount, parentInfo, credential, cascadeAccount);
                    data.add(cascade);
                }
            }
        }
        Integer count = this.txCascadeAccountDao.getCountByOrgIds((List)orgIds, null);
        log.debug("the length of orgIds is:{},the casAcc count is:{}", (Object)orgIds.size(), (Object)count);
        pageDto.setCount(Integer.valueOf(count + orgIds.size()));
        return data;
    }

    private CampusAccountDto makeCascadeDto(OrgAccount orgAccount, OrgInfo orgInfo, TXCascadeCredential credential, TXCascadeAccount cascadeAccount) {
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(cascadeAccount.getAccountType());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        TXAccount txAccount = this.txAccountDao.getByOrgId(orgAccount.getId());
        if (txAccount != null) {
            dto.setCampusType(CampusType.MASTER.getCode());
        } else {
            OrgSubAccount orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId());
            if (orgSubAccount != null) {
                dto.setCampusType(orgSubAccount.getAccountType());
                txAccount = this.txAccountDao.getByOrgId(orgSubAccount.getPid());
            }
        }
        dto.setName(credential.getName());
        dto.setMobile(credential.getMobile());
        dto.setStatus(cascadeAccount.getStatus());
        dto.setTitle(cascadeAccount.getTitle());
        dto.setCredentialId(cascadeAccount.getId());
        Map txAccountPermissions = this.txAccountPermissionService.getPMapByUidLevelRoleDevice(cascadeAccount.getId(), txAccount.getVipLevel(), cascadeAccount.getAccountType(), null);
        List Permissions = this.txPermissionService.getAllByPid(new ArrayList(txAccountPermissions.keySet()));
        ArrayList<TXPermissionNodeDto> result = new ArrayList<TXPermissionNodeDto>();
        for (TXPermission txPermission : Permissions) {
            TxAccountPermission txAccountPermission = (TxAccountPermission)txAccountPermissions.get(txPermission.getId());
            TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
            nodeDto.setCode(txPermission.getCode());
            nodeDto.setName(txPermission.getName());
            nodeDto.setType(txAccountPermission.getPType());
            result.add(nodeDto);
        }
        dto.setAuthList(result);
        return dto;
    }

    private CampusAccountDto makeSlaveDto(OrgAccount orgAccount, OrgInfo orgInfo, OrgSubAccount subAccount) {
        OrgSubAccount orgSubAccount;
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        dto.setCampusType(subAccount.getAccountType());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        dto.setName(orgInfo.getContacts());
        dto.setMobile(orgAccount.getMobile());
        dto.setStatus(subAccount.getStatus());
        dto.setTitle(CampusAccountType.SLAVE_PRINCIPAL.getLabel());
        log.debug("makeSlaveDto orgAccount is:{}", (Object)orgAccount);
        TXAccount txAccount = this.txAccountDao.getByOrgId(orgAccount.getId());
        log.debug("makeSlaveDto txAccount is:{}", (Object)txAccount);
        if (txAccount == null && (orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId())) != null) {
            txAccount = this.txAccountDao.getByOrgId(orgSubAccount.getPid());
        }
        log.debug("makeSlaveDto txAccount is:{}", (Object)txAccount);
        Map txAccountPermissions = this.txAccountPermissionService.getPMapByUidLevelRoleDevice(null, txAccount.getVipLevel(), RoleType.BRANCH_SCH_PRESIDENT.type, null);
        List Permissions = this.txPermissionService.getAllByPid(new ArrayList(txAccountPermissions.keySet()));
        ArrayList<TXPermissionNodeDto> result = new ArrayList<TXPermissionNodeDto>();
        for (TXPermission txPermission : Permissions) {
            TxAccountPermission txAccountPermission = (TxAccountPermission)txAccountPermissions.get(txPermission.getId());
            TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
            nodeDto.setCode(txPermission.getCode());
            nodeDto.setName(txPermission.getName());
            nodeDto.setType(txAccountPermission.getPType());
            result.add(nodeDto);
        }
        dto.setAuthList(result);
        return dto;
    }

    private CampusAccountDto makeMasterDto(OrgAccount orgAccount, OrgInfo orgInfo) {
        OrgSubAccount orgSubAccount;
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
        dto.setCampusType(CampusType.MASTER.getCode());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        dto.setName(orgInfo.getContacts());
        dto.setMobile(orgAccount.getMobile());
        dto.setStatus(CampusAccountStatus.NORMAL.getCode());
        dto.setTitle(CampusAccountType.MASTER_PRINCIPAL.getLabel());
        TXAccount txAccount = this.txAccountDao.getByOrgId(orgAccount.getId());
        if (txAccount == null && (orgSubAccount = this.orgSubAccountService.getByOrgId(orgAccount.getId())) != null) {
            txAccount = this.txAccountDao.getByOrgId(orgSubAccount.getPid());
            dto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            dto.setTitle(CampusAccountType.SLAVE_PRINCIPAL.getLabel());
        }
        Map txAccountPermissions = this.txAccountPermissionService.getPMapByUidLevelRoleDevice(null, txAccount.getVipLevel(), RoleType.PRESIDENT.type, null);
        List Permissions = this.txPermissionService.getAllByPid(new ArrayList(txAccountPermissions.keySet()));
        ArrayList<TXPermissionNodeDto> result = new ArrayList<TXPermissionNodeDto>();
        for (TXPermission txPermission : Permissions) {
            TxAccountPermission txAccountPermission = (TxAccountPermission)txAccountPermissions.get(txPermission.getId());
            TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
            nodeDto.setCode(txPermission.getCode());
            nodeDto.setName(txPermission.getName());
            nodeDto.setType(txAccountPermission.getPType());
            result.add(nodeDto);
        }
        dto.setAuthList(result);
        return dto;
    }

    public static void main(String[] args) {
        List list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        list.add(6);
        list = list.subList(5, list.size());
        System.out.println(list);
    }

    @Override
    public boolean addAccount(AddAccountRequest request) {
        TXAccount txAccount = this.txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId());
        if (txAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(TianxiaoPCContext.getOrgId());
        List subAccounts = this.orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
        if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
            for (OrgSubAccount subAccount : subAccounts) {
                orgIds.add(subAccount.getOrgId());
            }
        }
        boolean hasSendSms = false;
        Integer count = this.txCascadeAccountDao.getCountByOrgIds((List)orgIds);
        if (count + 1 > txAccount.getCascadeAccountCount() - txAccount.getCampusCount()) {
            throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
        }
        OrgAccount master = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        TXCascadeCredential credential = this.txCascadeCredentialDao.getByMobile(request.getMobile());
        if (credential == null) {
            credential = new TXCascadeCredential();
            credential.setCreateTime(new Date());
            credential.setMobile(request.getMobile());
            credential.setName(request.getName());
            OrgAccount credentialOrg = this.orgAccountService.getOrgAccountByMobile(request.getMobile());
            if (credentialOrg == null) {
                credential.setPassword(PasswordUtil.createHash((String)"a123456"));
                boolean sendResult = false;
                try {
                    sendResult = SmsSendUtil.sendSms((String)request.getMobile(), (String)TxSmsCodeType.getSmsMsg((TxSmsCodeType)TxSmsCodeType.NEW_ORG_PWD, (String)"a123456"), (Integer)SmsMessageType.TIANXIAO_NOTIFY.getCode(), (Integer)TianxiaoPCContext.getOrgId(), (Integer)UserRole.ORGANIZATION.getRole(), (boolean)true);
                    hasSendSms = true;
                }
                catch (Throwable e) {
                    log.error("send invite campus sms error:", e);
                }
                if (!sendResult) {
                    log.info("send invite campus sms to :{} error:{}!code :{}", new Object[]{request.getMobile(), sendResult, "a123456"});
                }
                log.info("send default campus pwd sms to :{} error:{}!code :{}", new Object[]{request.getMobile(), sendResult, "a123456"});
            }
            this.txCascadeCredentialDao.save((Object)credential, new String[0]);
        }
        TXCascadeAccount txCascadeAccount = new TXCascadeAccount();
        txCascadeAccount.setAccountType(request.getType());
        txCascadeAccount.setCreateTime(new Date());
        txCascadeAccount.setCredentialId(credential.getId());
        txCascadeAccount.setOrgId(master.getId());
        txCascadeAccount.setStatus(TXCascadeAccountStatus.VALID.getCode());
        txCascadeAccount.setTitle(request.getTitle());
        this.txCascadeAccountDao.save((Object)txCascadeAccount, new String[0]);
        TXAccount superAcc = this.findSuperTXAccount(txCascadeAccount);
        this.modPermission(txCascadeAccount, request, superAcc);
        return hasSendSms;
    }

    @Override
    public void modAccount(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode((int)request.getType());
        switch (accountType) {
            case MASTER_PRINCIPAL: {
                this.modMasterPrincipal(request);
                break;
            }
            case SLAVE_PRINCIPAL: {
                this.modSlavePrincipal(request);
                break;
            }
            case DIRECTOR: {
                this.modDirector(request);
                break;
            }
            case STAFF: {
                this.modDirector(request);
                break;
            }
        }
    }

    private void modMasterPrincipal(ModAccountRequest request) {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (StringUtils.isNotBlank((CharSequence)request.getMobile()) && !orgAccount.getMobile().equals(request.getMobile())) {
            if (StringUtils.isBlank((CharSequence)request.getCode())) {
                throw new BussinessException((UniverseErrorCode)SMSErrorCode.CODE_INVALID);
            }
            if (!VerifyCodeUtil.valid((boolean)false, (String)orgAccount.getMobile(), (String)request.getCode(), (String)TxSmsCodeType.MOD_ORG_MOBILE.getCacheKey())) {
                throw new BussinessException((UniverseErrorCode)SMSErrorCode.CODE_INVALID);
            }
            orgAccount.setMobile(request.getMobile());
            this.orgAccountDao.update((Object)orgAccount, new String[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getName())) {
            OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
            orgInfo.setContacts(request.getName());
            this.orgInfoDao.update((Object)orgInfo, new String[0]);
        }
    }

    private void modSlavePrincipal(ModAccountRequest request) {
        OrgSubAccount orgSubAccount;
        if (request.getCampusNumber() == null || StringUtils.isEmpty((CharSequence)request.getCampusName())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM);
        }
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM);
        }
        OrgInfo orgInfo = this.orgInfoDao.getOrgInfo(orgAccount.getId(), new String[0]);
        orgInfo.setShortName(request.getCampusName());
        orgInfo.setContacts(request.getName());
        orgInfo.setUpdateTime(new Date());
        this.orgInfoDao.update((Object)orgInfo, new String[0]);
        if (!request.getMobile().equals(orgAccount.getMobile()) && (orgSubAccount = this.orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId())) != null) {
            if (orgSubAccount.getAccountType().intValue() == CampusType.LEAGUE.getCode().intValue()) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u52a0\u76df\u5206\u6821\u4e0d\u652f\u6301\u4fee\u6539\u7535\u8bdd\uff0c\u8bf7\u8054\u7cfb\u5e08\u8d44");
            }
            OrgAccount temp = this.orgAccountService.getOrgAccountByMobile(request.getMobile());
            if (temp != null) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.MOBILE_EXIST);
            }
            orgAccount.setMobile(request.getMobile());
            orgAccount.setUpdateTime(new Date());
            this.orgAccountDao.update((Object)orgAccount, new String[0]);
        }
    }

    private void modDirector(ModAccountRequest request) {
        if (request.getCampusNumber() == null || request.getCredentialId() == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.REQUIRE_PARAM);
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)request.getCredentialId(), new String[0]);
        TXCascadeCredential credential = (TXCascadeCredential)this.txCascadeCredentialDao.getById((Serializable)cascadeAccount.getCredentialId(), new String[0]);
        if (cascadeAccount == null || credential == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        cascadeAccount.setOrgId(orgAccount.getId());
        cascadeAccount.setTitle(request.getTitle());
        cascadeAccount.setUpdateTime(new Date());
        this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
        if (!credential.getMobile().equals(request.getMobile())) {
            TXCascadeCredential temp = this.txCascadeCredentialDao.getByMobile(request.getMobile());
            if (temp == null) {
                credential.setName(request.getName());
                credential.setUpdateTime(new Date());
                credential.setMobile(request.getMobile());
                this.txCascadeCredentialDao.update((Object)credential, new String[0]);
            } else {
                temp.setName(request.getName());
                temp.setUpdateTime(new Date());
                this.txCascadeCredentialDao.update((Object)temp, new String[0]);
                cascadeAccount.setCredentialId(temp.getId());
                cascadeAccount.setUpdateTime(new Date());
                this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
            }
        } else {
            credential.setName(request.getName());
            credential.setUpdateTime(new Date());
            this.txCascadeCredentialDao.update((Object)credential, new String[0]);
        }
        TXAccount superAcc = this.findSuperTXAccount(cascadeAccount);
        this.modPermission(cascadeAccount, request, superAcc);
        this.modAccountType(cascadeAccount, request);
    }

    private TXAccount findSuperTXAccount(TXCascadeAccount cascadeAccount) {
        OrgSubAccount subAcc = this.orgSubAccountService.getByOrgId(cascadeAccount.getOrgId());
        if (subAcc.getPid() == 0) {
            return this.txAccountDao.getByOrgId(subAcc.getOrgId());
        }
        return this.txAccountDao.getByOrgId(subAcc.getPid());
    }

    private void modAccountType(TXCascadeAccount cascadeAccount, ModAccountRequest request) {
        if (cascadeAccount.getAccountType().intValue() == request.getType().intValue()) {
            return;
        }
        if (request.getType().intValue() == CampusAccountType.DIRECTOR.getCode().intValue()) {
            cascadeAccount.setAccountType(request.getType());
            this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
        }
        if (request.getType().intValue() == CampusAccountType.STAFF.getCode().intValue()) {
            cascadeAccount.setAccountType(request.getType());
            this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
        }
    }

    private void modPermission(TXCascadeAccount cascadeAccount, AddAccountRequest request, TXAccount superAcc) {
        List txAccountPermissions = this.txAccountPermissionService.getAllPByUidLevelRoleDevice(null, superAcc.getVipLevel(), cascadeAccount.getAccountType(), null);
        List<TXPermissionNodeDto> subAuths = request.getAuthList();
        Map allPCodeMap = this.txPermissionService.getAllTXPermissionsCodeMap();
        HashMap pCodeTypeMap = Maps.newHashMap();
        for (TXPermissionNodeDto tXPermissionNodeDto : subAuths) {
            pCodeTypeMap.put(((TXPermission)allPCodeMap.get(tXPermissionNodeDto.getCode())).getCode(), tXPermissionNodeDto.getType());
        }
        HashMap tempMap = Maps.newHashMap();
        for (Long pCode : pCodeTypeMap.keySet()) {
            ArrayList linkedCodes = new ArrayList(TXPermissionConst.ONE_MULTY_CODE_MAP.get((Object)pCode));
            if (!CollectionUtils.isNotEmpty(linkedCodes)) continue;
            Integer pType = (Integer)pCodeTypeMap.get(pCode);
            for (Long sub : linkedCodes) {
                tempMap.put(sub, pType);
            }
        }
        for (Long sub : tempMap.keySet()) {
            pCodeTypeMap.put(sub, tempMap.get(sub));
        }
        this.specialTypeOperate(pCodeTypeMap, cascadeAccount);
        log.debug("the frontEnd param length is {}", (Object)pCodeTypeMap.size());
        HashMap hashMap = Maps.newHashMap();
        HashMap appMap = Maps.newHashMap();
        for (TxAccountPermission txAccountPermission : txAccountPermissions) {
            if (txAccountPermission.getDeviceType().intValue() == DeviceType.APP.getCode()) {
                appMap.put(txAccountPermission.getPId(), txAccountPermission);
            }
            if (txAccountPermission.getDeviceType().intValue() != DeviceType.PC.getCode()) continue;
            hashMap.put(txAccountPermission.getPId(), txAccountPermission);
        }
        Map allPIdMap = this.txPermissionService.getAllTXPermissionsIDMap();
        for (TXPermission txPermission : allPIdMap.values()) {
            TxAccountPermission pc = (TxAccountPermission)hashMap.get(txPermission.getId());
            Integer pTypeTemp = (Integer)pCodeTypeMap.get(txPermission.getCode());
            if (pTypeTemp != null) {
                pc.setPType(pTypeTemp);
            }
            TxAccountPermission app = (TxAccountPermission)appMap.get(txPermission.getId());
            pTypeTemp = (Integer)pCodeTypeMap.get(txPermission.getCode());
            if (pTypeTemp == null) continue;
            app.setPType(pTypeTemp);
        }
        List ownedPList = this.txAccountPermissionDao.listAllConfigs(null, null, cascadeAccount.getId(), Integer.valueOf(TXPermissionAccountType.CASCADE_ACCOUNT.getCode()));
        HashMap ownedPMap = Maps.newHashMap();
        for (TxAccountPermission tap : ownedPList) {
            if (tap.getDeviceType().equals(DeviceType.PC.getCode())) {
                ownedPMap.put("pc_" + tap.getPId(), tap);
                continue;
            }
            if (!tap.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            ownedPMap.put("app_" + tap.getPId(), tap);
        }
        log.debug("the owned permission set size is:{}", (Object)ownedPMap.size());
        ArrayList updatePermissions = Lists.newArrayList();
        LinkedList savePermissions = Lists.newLinkedList();
        for (TxAccountPermission tap : txAccountPermissions) {
            TxAccountPermission temp;
            if (tap.getDeviceType().equals(DeviceType.PC.getCode())) {
                if (ownedPMap.containsKey("pc_" + tap.getPId())) {
                    temp = (TxAccountPermission)ownedPMap.get("pc_" + tap.getPId());
                    temp.setPType((Integer)pCodeTypeMap.get(((TXPermission)allPIdMap.get(tap.getPId())).getCode()));
                    updatePermissions.add(temp);
                    continue;
                }
                tap.setCreateTime(new Date());
                tap.setUId(cascadeAccount.getId());
                tap.setUpdateTime(new Date());
                savePermissions.add(tap);
                continue;
            }
            if (!tap.getDeviceType().equals(DeviceType.APP.getCode())) continue;
            if (ownedPMap.containsKey("app_" + tap.getPId())) {
                temp = (TxAccountPermission)ownedPMap.get("app_" + tap.getPId());
                temp.setPType((Integer)pCodeTypeMap.get(((TXPermission)allPIdMap.get(tap.getPId())).getCode()));
                updatePermissions.add(temp);
                continue;
            }
            tap.setCreateTime(new Date());
            tap.setUId(cascadeAccount.getId());
            tap.setUpdateTime(new Date());
            savePermissions.add(tap);
        }
        log.debug("the update permission list size is:{}", (Object)updatePermissions.size());
        this.txAccountPermissionService.updateAll((List)updatePermissions);
        log.debug("before pick save permission list size is:{}", (Object)savePermissions.size());
        this.pickPermissions(savePermissions, TXPermissionConst.PERMISSION_SAVE_CONTROL_SET, allPIdMap);
        log.debug("the save permission set size is:{}", (Object)savePermissions.size());
        this.txAccountPermissionService.saveAll((List)savePermissions);
    }

    private void pickPermissions(List<TxAccountPermission> savePermissions, Set<Long> ControlSet, Map<Integer, TXPermission> allPIdMap) {
        Iterator<TxAccountPermission> iter = savePermissions.iterator();
        while (iter.hasNext()) {
            if (ControlSet.contains(allPIdMap.get(iter.next().getPId()).getCode())) continue;
            iter.remove();
        }
    }

    private void specialTypeOperate(Map<Long, Integer> pTypeMap, TXCascadeAccount cascadeAccount) {
        HashMap tempMap = Maps.newHashMap();
        for (Long pCode : pTypeMap.keySet()) {
            if (pCode.equals(TXPermissionConst.PAIKE.getpCode()) && pTypeMap.get(pCode).equals(TXPermissionHasType.OWN.getCode())) {
                if (cascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
                    tempMap.put(pCode, TXPermissionHasType.OWN.getCode());
                }
                if (cascadeAccount.getAccountType().intValue() != CascadeType.STAFF.getValue()) continue;
                tempMap.put(pCode, TXPermissionHasType.LOST.getCode());
                continue;
            }
            if (pCode != TXPermissionConst.KEBIAO_XIANSHI.getpCode() || !pTypeMap.get(pCode).equals(TXPermissionHasType.OWN.getCode())) continue;
            if (cascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
                tempMap.put(pCode, TXPermissionHasType.OWN.getCode());
            }
            if (cascadeAccount.getAccountType().intValue() != CascadeType.STAFF.getValue()) continue;
            tempMap.put(pCode, TXPermissionHasType.LOST.getCode());
        }
        for (Long pCode : tempMap.keySet()) {
            pTypeMap.put(pCode, (Integer)tempMap.get(pCode));
        }
    }

    @Override
    public void modAccountStatus(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode((int)request.getType());
        switch (accountType) {
            case SLAVE_PRINCIPAL: {
                this.modSlavePrincipalStatus(request);
                break;
            }
            case DIRECTOR: {
                this.modDirectorStatus(request);
                break;
            }
            case STAFF: {
                this.modDirectorStatus(request);
                break;
            }
        }
    }

    private void modSlavePrincipalStatus(ModAccountRequest request) {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        OrgSubAccount subAccount = this.orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        if (request.getStatus().intValue() == OrgSubAccountStatus.NORMAL.getCode().intValue()) {
            OrgSubAccount mainAcc = this.orgSubAccountService.getMaster(orgAccount.getId());
            if (null != mainAcc) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u8d26\u53f7\u5df2\u7ecf\u72ec\u7acb\u5f00\u901a\u5929\u6821\u8d26\u53f7,\u65e0\u6cd5\u542f\u7528");
            }
            subAccount.setStatus(request.getStatus());
            subAccount.setUpdateTime(new Date());
            this.orgSubAccountService.update(subAccount);
            this.addToHag(orgAccount.getNumber());
        }
        if (request.getStatus().intValue() == OrgSubAccountStatus.FIRE.getCode().intValue()) {
            subAccount.setStatus(request.getStatus());
            subAccount.setFireTime(new Date());
            subAccount.setUpdateTime(new Date());
            this.orgSubAccountService.update(subAccount);
            this.delInHag(orgAccount.getNumber());
        }
    }

    private void delInHag(Integer orgNumber) {
        log.info("del hag orgNumber:{}", (Object)orgNumber);
        if (orgNumber == null) {
            return;
        }
        ArrayList entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName((Object)orgNumber);
        entities.add(entity);
        WebResponse result1 = this.hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tianxiao_orgNumber");
        log.info("del hag {} in {} result:{}", new Object[]{orgNumber, "jigou_tianxiao_orgNumber", result1});
        WebResponse result2 = this.hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_3810_orgNumber");
        log.info("del hag {} in {} result:{}", new Object[]{orgNumber, "jigou_3810_orgNumber", result2});
        WebResponse result3 = this.hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue((String)"hag", (String)"hag.token.id")), PropertiesReader.getValue((String)"hag", (String)"hag.token"), (Collection)entities, "jigou_tixian_orgNumber");
        log.info("del hag {} in {} result:{}", new Object[]{orgNumber, "jigou_tixian_orgNumber", result3});
    }

    private void modDirectorStatus(ModAccountRequest request) {
        TXAccount txAccount = this.txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId());
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode().intValue()) {
            Integer count;
            if (txAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8d26\u6237\u4e0d\u5b58\u5728");
            }
            ArrayList orgIds = Lists.newArrayList();
            orgIds.add(TianxiaoPCContext.getOrgId());
            List subAccounts = this.orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
            if (CollectionUtils.isNotEmpty((Collection)subAccounts)) {
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(subAccount.getOrgId());
                }
            }
            if ((count = this.txCascadeAccountDao.getCountByOrgIds((List)orgIds)) + 1 > txAccount.getCascadeAccountCount() - txAccount.getCampusCount()) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
            }
        }
        TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)request.getCredentialId(), new String[0]);
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode().intValue() || request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode().intValue()) {
            cascadeAccount.setStatus(request.getStatus());
            this.txCascadeAccountDao.update((Object)cascadeAccount, new String[0]);
            if (request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode().intValue()) {
                try {
                    this.releaseConsulter(cascadeAccount.getId().longValue());
                    this.orgCourseDao.batchUpdateHeadTeacher(txAccount.getOrgNumber(), cascadeAccount.getId(), Integer.valueOf(-1));
                }
                catch (Exception e) {
                    log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", (Object)cascadeAccount.getId());
                    log.error("modDirectorStatus - releaseConsulter - error:{}", (Throwable)e);
                    throw new BusinessException("\u91ca\u653e\u7ebf\u7d22\u5931\u8d25\uff0c\u53ef\u5c1d\u8bd5\u624b\u52a8\u6e05\u7a7a\u8d26\u53f7\u7ebf\u7d22\u540e\u518d\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002");
                }
            }
        }
    }

    public void releaseConsulter(Long cascadeId) {
        Date now = new Date();
        List consulterIds = this.consultUserDao.listConsulterUserIdsByCascade(cascadeId);
        log.info("modAccountStatus - consulter - Release - consulterIds:{}, size:{},time:{}", new Object[]{consulterIds, consulterIds.size(), now.getTime()});
        if (CollectionUtils.isNotEmpty((Collection)consulterIds)) {
            this.consultUserDao.release(consulterIds, now);
            ArrayList<TxConsulterOperationLog> manualLogs = new ArrayList<TxConsulterOperationLog>();
            for (int i = 0; i > consulterIds.size(); ++i) {
                TxConsulterOperationLog log = new TxConsulterOperationLog((Long)consulterIds.get(i), Long.valueOf(Flag.NULL.getLong()), Long.valueOf(Flag.NULL.getLong()), ConsulterOperation.PUSH_MANUAL);
                manualLogs.add(log);
                if (i % 100 != 0 && i != consulterIds.size() - 1) continue;
                this.txConsulterOperationLogDao.saveAll(manualLogs, new String[0]);
            }
        }
    }

    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public void enter(Integer orgNumber) throws Exception {
        TXAccount superAcc = this.txAccountDao.getByOrgNumber(orgNumber);
        Preconditions.checkNotNull((Object)superAcc);
        log.info("the superAcc is:{}", (Object)superAcc);
        this.fixData(superAcc);
    }

    @Deprecated
    private void fixData(TXAccount superAcc) throws Exception {
        int i = 0;
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(1));
        pageDto.setPageSize(Integer.valueOf(999));
        OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)superAcc.getOrgId(), new String[0]);
        Preconditions.checkNotNull((Object)superAcc);
        log.info("find orgAccount done! account is:{}", (Object)orgAccount);
        List<CampusAccountDto> before = this.getAccountList(orgAccount, pageDto, true);
        log.info("\u627e\u5230\u4e86\u5b50\u5e10\u53f7 \u5171:{}\u4e2a", (Object)before.size());
        for (CampusAccountDto dto : before) {
            if (dto.getType() != 3 && dto.getType() != 4) continue;
            TXCascadeAccount cascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)dto.getCredentialId(), new String[0]);
            Preconditions.checkNotNull((Object)cascadeAccount);
            AddAccountRequest request = new AddAccountRequest();
            request.setName(dto.getName());
            request.setCampusNumber(dto.getCampusNumber());
            request.setMobile(dto.getMobile());
            request.setTitle(dto.getTitle());
            request.setType(dto.getType());
            request.setAuthList(dto.getAuthList());
            this.modPermission(cascadeAccount, request, superAcc);
            log.info("\u66f4\u65b0\u4e86{}\u4e2a!", (Object)i++);
        }
        log.info("done!");
    }
}

