/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.biz.campus.constant.CommonRuleValue;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;

public class CommonRuleDto {
    private Integer studentMobileRule;
    private Integer callMobileRule;
    private Integer teacherSignRule;
    private Integer consumeRule;

    public static CommonRuleDto from(TXCommonRule txCommonRule) {
        if (txCommonRule == null) {
            return null;
        }
        CommonRuleDto dto = new CommonRuleDto();
        dto.setCallMobileRule(txCommonRule.getCallMobileRule());
        dto.setStudentMobileRule(txCommonRule.getStudentMobileRule());
        dto.setConsumeRule(txCommonRule.getConsumeRule());
        return dto;
    }

    public boolean valid() {
        if (this.studentMobileRule != null && this.studentMobileRule.intValue() != CommonRuleValue.STUDENT_MOBILE_NOT_SHOW.getCode() && this.studentMobileRule.intValue() != CommonRuleValue.STUDENT_MOBILE_SHOW.getCode()) {
            return false;
        }
        if (this.callMobileRule != null && this.callMobileRule.intValue() != CommonRuleValue.CALL_MOBILE_NOT_OWN.getCode() && this.callMobileRule.intValue() != CommonRuleValue.CALL_MOBILE_OWN.getCode()) {
            return false;
        }
        return this.teacherSignRule == null || this.teacherSignRule.intValue() == CommonRuleValue.TEACER_SING_NOT_PERMIT.getCode() || this.teacherSignRule.intValue() == CommonRuleValue.TEACER_SING_PERMIT.getCode();
    }

    public Integer getStudentMobileRule() {
        return this.studentMobileRule;
    }

    public Integer getCallMobileRule() {
        return this.callMobileRule;
    }

    public Integer getTeacherSignRule() {
        return this.teacherSignRule;
    }

    public Integer getConsumeRule() {
        return this.consumeRule;
    }

    public void setStudentMobileRule(Integer studentMobileRule) {
        this.studentMobileRule = studentMobileRule;
    }

    public void setCallMobileRule(Integer callMobileRule) {
        this.callMobileRule = callMobileRule;
    }

    public void setTeacherSignRule(Integer teacherSignRule) {
        this.teacherSignRule = teacherSignRule;
    }

    public void setConsumeRule(Integer consumeRule) {
        this.consumeRule = consumeRule;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonRuleDto)) {
            return false;
        }
        CommonRuleDto other = (CommonRuleDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$studentMobileRule = this.getStudentMobileRule();
        Integer other$studentMobileRule = other.getStudentMobileRule();
        if (this$studentMobileRule == null ? other$studentMobileRule != null : !((Object)this$studentMobileRule).equals(other$studentMobileRule)) {
            return false;
        }
        Integer this$callMobileRule = this.getCallMobileRule();
        Integer other$callMobileRule = other.getCallMobileRule();
        if (this$callMobileRule == null ? other$callMobileRule != null : !((Object)this$callMobileRule).equals(other$callMobileRule)) {
            return false;
        }
        Integer this$teacherSignRule = this.getTeacherSignRule();
        Integer other$teacherSignRule = other.getTeacherSignRule();
        if (this$teacherSignRule == null ? other$teacherSignRule != null : !((Object)this$teacherSignRule).equals(other$teacherSignRule)) {
            return false;
        }
        Integer this$consumeRule = this.getConsumeRule();
        Integer other$consumeRule = other.getConsumeRule();
        return !(this$consumeRule == null ? other$consumeRule != null : !((Object)this$consumeRule).equals(other$consumeRule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonRuleDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $studentMobileRule = this.getStudentMobileRule();
        result = result * 59 + ($studentMobileRule == null ? 43 : ((Object)$studentMobileRule).hashCode());
        Integer $callMobileRule = this.getCallMobileRule();
        result = result * 59 + ($callMobileRule == null ? 43 : ((Object)$callMobileRule).hashCode());
        Integer $teacherSignRule = this.getTeacherSignRule();
        result = result * 59 + ($teacherSignRule == null ? 43 : ((Object)$teacherSignRule).hashCode());
        Integer $consumeRule = this.getConsumeRule();
        result = result * 59 + ($consumeRule == null ? 43 : ((Object)$consumeRule).hashCode());
        return result;
    }

    public String toString() {
        return "CommonRuleDto(studentMobileRule=" + this.getStudentMobileRule() + ", callMobileRule=" + this.getCallMobileRule() + ", teacherSignRule=" + this.getTeacherSignRule() + ", consumeRule=" + this.getConsumeRule() + ")";
    }
}

