/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.campus.utils;

import java.sql.Timestamp;
import java.util.*;

import com.baijia.tianxiao.biz.campus.dto.finance.BindCardForPerVerifyDto;
import com.baijia.tianxiao.biz.campus.dto.OrgAccountDetailDto;
import com.baijia.tianxiao.biz.campus.dto.OrgSubAccountDetailDto;
import com.baijia.tianxiao.biz.campus.dto.finance.OrgAccountRecordDetailDto;
import com.baijia.tianxiao.biz.campus.utils.PayRestUtils.RestMethod;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.sal.organization.finance.dto.OrgAccountBankListDto;
import com.baijia.tianxiao.util.http.RestUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Maps;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

/**
 * @Title : PayMentSystemApiHelper
 * @Description : 支付系统接口 http://git.baijiahulian.com/pay/paywiki/wikis/home
 * @Author : zhenyujian
 * @Date : 2015年11月23日 下午3:24:33
 * @Version : v1.0
 */
public class PayMentSystemApiHelper {

    private static final String BASE_URL = PropertiesReader.getValue("rest", "rest.appServiceUrl.new");
    private static final String APPID = PropertiesReader.getValue("rest", "rest.appId");
    private static final String APPKEY = PropertiesReader.getValue("rest", "rest.appKey");


    public static RestfulResult<Object> commonBanks() throws Exception {

        String controller = "pay";
        String action = "api";

        Map<String, String> params = Maps.newHashMap();
        params.put("class", "Account\\UserMarketingAccount");
        params.put("method", "billBankList");
        params.put("_param", "[]");
        params.put("timestamp", System.currentTimeMillis() + "");
        params.put("app_id", APPID);
        params.put("auth_token", PayRestUtils.getAuthToken() + "");

        return PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }


    private static boolean isNotNullJsonNode(Object node) {
        if (node != null && !node.equals("null") && !node.toString().equals("{}") && !node.toString().equals("[]")) {

            return true;
        }
        return false;
    }

    private static String collextionToStr(Collection collection) {
        StringBuilder builder = new StringBuilder("");
        if (collection != null && !collection.isEmpty()) {
            for (Iterator iterator = collection.iterator(); iterator.hasNext(); ) {
                builder.append(iterator.next()).append(",");
            }
        }
        String result = builder.toString();
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    /**
     * @Description : 提现
     * @Author : zhenyujian
     * @CreationDate : 2015年11月24日 上午11:09:17
     * @Return : RestfulResult
     */
    public static RestfulResult<Object> drawCash(Integer client, Long orgId, Integer orgNum, Double ammount,
                                                 Double feeAmount) throws Exception {

        if (feeAmount == null) {
            feeAmount = 0d;
        }

        String controller = "org";
        String action = "orgAccountDrawCash";

        Map<String, String> params = Maps.newHashMap();
        params.put("client", client + "");
        params.put("org_id", orgId + "");
        params.put("org_number", orgNum + "");
        params.put("amount", ammount + "");
        params.put("fee_amount", feeAmount + "");
        params.put("timestamp", System.currentTimeMillis() + "");
        params.put("app_id", APPID);
        params.put("auth_token", PayRestUtils.getAuthToken() + "");

        return PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    /**
     * @throws Exception
     * @Description : 查询机构账户资金信息
     * @Author : zhenyujian
     * @CreationDate : 2015年11月24日 上午11:09:24
     * @Return : RestfulResult<OrgAccountDetailDto>
     */
    public static RestfulResult<OrgAccountDetailDto> orgAccountDetail(Integer orgId, Collection<Integer> subOrgIds)
            throws Exception {
        String controller = "org";
        String action = "orgAccountDetail";

        Map<String, String> params = Maps.newHashMap();
        JSONObject orgIdsJson = new JSONObject();
        orgIdsJson.put("main", orgId == null ? "" : orgId);
        orgIdsJson.put("sub", collextionToStr(subOrgIds));
        params.put("org_ids", orgIdsJson.toString());

        RestfulResult<Object> restResult = PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params,
                null);
        RestfulResult<OrgAccountDetailDto> methodResult = new RestfulResult<OrgAccountDetailDto>();

        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());

        if (isNotNullJsonNode(restResult.getData())) {
            JSONObject data = JSONObject.fromObject(restResult.getData());

            OrgAccountDetailDto dto = new OrgAccountDetailDto();
            dto.setBalance(data.optDouble("balance", 0));
            dto.setExpected(data.optDouble("expected", 0));
            dto.setIncome(data.optDouble("income", 0));
            dto.setIncomeMonth(data.optDouble("income_month", 0));
            dto.setIncomeWeek(data.optDouble("income_week", 0));
            dto.setFreezeMoney(data.optDouble("freeze_money", 0));
            methodResult.setData(dto);
        }

        return methodResult;
    }


    public static RestfulResult<Map<Integer, OrgSubAccountDetailDto>> subOrgAccountDetail(Collection<Integer> subOrgIds)
            throws Exception {
        String controller = "org";
        String action = "subOrgAccountDetail";

        Map<String, String> params = Maps.newHashMap();
        params.put("sub_org_ids", subOrgIds != null ? subOrgIds.toString() : new ArrayList<Integer>().toString());

        RestfulResult<Object> restResult = PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params,
                null);
        RestfulResult<Map<Integer, OrgSubAccountDetailDto>> methodResult = new RestfulResult<Map<Integer, OrgSubAccountDetailDto>>();
        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());

        Map<Integer, OrgSubAccountDetailDto> map = new HashMap<Integer, OrgSubAccountDetailDto>();
        methodResult.setData(map);
        if (isNotNullJsonNode(restResult.getData())) {
            JSONObject data = JSONObject.fromObject(restResult.getData());

            JSONArray records = data.getJSONArray("records");
            JSONObject record;
            OrgSubAccountDetailDto dto;
            if (records != null && records.size() > 0) {
                for (int i = 0; i < records.size(); i++) {
                    record = records.getJSONObject(i);
                    dto = new OrgSubAccountDetailDto();
                    dto.setBalance(record.optDouble("balance", 0));
                    dto.setEarn(record.optDouble("earn", 0));
                    dto.setExpected(record.optDouble("expected", 0));
                    dto.setIncome(record.optDouble("income", 0));
                    dto.setOrgId(record.getInt("org_id"));
                    map.put(dto.getOrgId(), dto);
                }
            }
        }

        return methodResult;
    }

    /**
     * @Description : 机构绑定银行卡列表
     * @Author : zhenyujian
     * @CreationDate : 2015年11月26日 下午1:51:55
     * @Return : RestfulResult<OrgAccountBankListDto>
     */
    public static RestfulResult<OrgAccountBankListDto> orgAccountBankList(Long orgId) throws Exception {
        String controller = "org";
        String action = "orgAccountBankList";

        Map<String, String> params = Maps.newHashMap();
        params.put("org_id", orgId + "");

        RestfulResult<Object> restResult = PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params,
                null);
        RestfulResult<OrgAccountBankListDto> methodResult = new RestfulResult<OrgAccountBankListDto>();

        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());

        if (isNotNullJsonNode(restResult)) {
            JSONObject data = JSONObject.fromObject(restResult.getData());

            OrgAccountBankListDto dto = new OrgAccountBankListDto();
            methodResult.setData(dto);

            JSONObject userInfoNode = data.getJSONObject("user_info");
            if (isNotNullJsonNode(userInfoNode) && isNotNullJsonNode(userInfoNode.getString("bank_no"))) {
                OrgAccountBankListDto.UserInfo userInfo = dto.new UserInfo();
                userInfo.setBankNo(userInfoNode.getString("bank_no"));
                userInfo.setBankName(userInfoNode.getString("bank_name"));
                userInfo.setCardNum(userInfoNode.getString("card_num"));
                userInfo.setRegion(userInfoNode.getString("region"));
                userInfo.setOwnerName(userInfoNode.getString("owner_name"));
                userInfo.setOrgId(Long.parseLong(userInfoNode.getString("org_id")));
                userInfo.setOpenLocation(userInfoNode.getString("open_location"));
                String status = userInfoNode.getString("status");
                String id = userInfoNode.getString("id");
                if (status != null && !status.equals("null"))
                    userInfo.setStatus(Integer.parseInt(userInfoNode.getString("status")));
                if (id != null && !id.equals("null"))
                    userInfo.setId(Integer.parseInt(userInfoNode.getString("id")));
                // userInfo.setStatus(-1);
                // userInfo.setId(-1);
                dto.setUserInfo(userInfo);
            }

            JSONArray bankArray = data.getJSONArray("bank_list");
            if (bankArray != null) {
                List<OrgAccountBankListDto.Bank> bankList = new ArrayList<OrgAccountBankListDto.Bank>();
                if (bankArray.size() > 0) {
                    for (int i = 0; i < bankArray.size(); i++) {
                        JSONObject bankNode = bankArray.getJSONObject(i);
                        OrgAccountBankListDto.Bank bank = dto.new Bank();
                        bank.setCode(bankNode.getString("code"));
                        bank.setIconUrl(bankNode.getString("icon_url"));
                        bank.setName(bankNode.getString("name"));
                        bank.setPayFast(bankNode.getBoolean("pay_fast"));
                        bankList.add(bank);
                    }
                }
                dto.setBankList(bankList);
            }
        }

        return methodResult;
    }

    /**
     * @Description : 机构账户银行卡绑定（企业）
     * @Author : zhenyujian
     * @CreationDate : 2015年11月26日 下午2:32:06
     * @Return : RestfulResult<OrgAccountDetailDto>
     */
    public static RestfulResult<Object> bindCardForCot(Long orgId, String bankNo, String cardNum, String ownerName,
                                                       String region, String openLocation) throws Exception {
        String controller = "org";
        String action = "bindCardForCot";

        Map<String, String> params = Maps.newHashMap();
        params.put("org_id", orgId + "");
        params.put("bank_no", bankNo);
        params.put("card_num", cardNum);
        params.put("owner_name", ownerName);
        params.put("region", region);
        if (openLocation == null) {
            params.put("open_location", "");
        } else {
            params.put("open_location", openLocation);
        }

        return PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    /**
     * @Description : 机构账户绑定银行卡验证（个人）
     * @Author : zhenyujian
     * @CreationDate : 2015年11月26日 下午2:37:35
     * @Return : RestfulResult<OrgAccountDetailDto>
     */
    public static RestfulResult<BindCardForPerVerifyDto> bindCardForPerVerify(Long orgId, String idNumber,
                                                                              String bankNo, String cardNum, String ownerName, String mobile) throws Exception {
        String controller = "org";
        String action = "bindCardForPerVerify";

        Map<String, String> params = Maps.newHashMap();
        params.put("org_id", orgId + "");
        params.put("id_number", idNumber);
        params.put("bank_no", bankNo);
        params.put("card_num", cardNum);
        params.put("owner_name", ownerName);
        params.put("mobile", mobile);

        RestfulResult<Object> restResult = PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params,
                null);
        RestfulResult<BindCardForPerVerifyDto> methodResult = new RestfulResult<BindCardForPerVerifyDto>();

        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());

        if (isNotNullJsonNode(restResult.getData())) {
            JSONObject data = JSONObject.fromObject(restResult.getData());

            BindCardForPerVerifyDto dto = new BindCardForPerVerifyDto();
            dto.setPurchaseId(data.getLong("purchase_id"));
            dto.setToken(data.getString("token"));
            dto.setThirdType(data.getInt("third_type"));
            methodResult.setData(dto);
        }

        return methodResult;
    }

    /**
     * @Description : 机构账户绑定银行卡（个人）
     * @Author : zhenyujian
     * @CreationDate : 2015年11月26日 下午2:44:26
     * @Return : RestfulResult
     */
    public static RestfulResult<Object> bindCardForPer(Long orgId, String idNumber, String purchaseId, String bankNo,
                                                       String cardNum, String ownerName, String region, String openLocation, String mobile, String smsCode,
                                                       String token, Integer thirdType) throws Exception {
        String controller = "org";
        String action = "bindCardForPer";

        Map<String, String> params = Maps.newHashMap();
        params.put("org_id", orgId + "");
        params.put("purchase_id", purchaseId + "");
        params.put("id_number", idNumber);
        params.put("bank_no", bankNo);
        params.put("card_num", cardNum);
        params.put("owner_name", ownerName);
        params.put("region", region);
        params.put("mobile", mobile);
        params.put("sms_code", smsCode);
        params.put("token", token);
        params.put("third_type", thirdType + "");
        if (openLocation == null) {
            params.put("open_location", "");
        } else {
            params.put("open_location", openLocation);
        }

        return PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    /**
     * @Description : 机构账户解绑接口
     * @Author : zhenyujian
     * @CreationDate : 2015年11月26日 下午2:51:08
     * @Return : RestfulResult
     */
    public static RestfulResult<Object> unbindCard(Long orgId, String payPassword) throws Exception {
        String controller = "org";
        String action = "unbindCard";

        Map<String, String> params = Maps.newHashMap();
        params.put("org_id", orgId + "");
        params.put("pay_password", payPassword);

        return PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params, null);
    }

    /**
     * @Description : 查询资金明细
     * @Author : zhenyujian
     * @CreationDate : 2015年11月24日 上午11:51:44
     * @Return : RestfulResult<OrgAccountDetailDto>
     */
    public static RestfulResult<OrgAccountRecordDetailDto> orgAccountRecordDetail(Long orgId,
                                                                                  Collection<Long> subOrgIds, String startTime, String endTime, Long teacherId, Integer pageNum, Integer size)
            throws Exception {
        String controller = "org";
        String action = "orgAccountRecordDetail";

        if (pageNum == null) {
            pageNum = -1;
        }
        if (size == null) {
            size = -1;
        }

        Map<String, String> params = Maps.newHashMap();
        params.put("size", size + "");
        if (pageNum != -1) {
            params.put("offset", (pageNum - 1) * size + 1 + "");
        }

        JSONObject orgIdsJson = new JSONObject();
        orgIdsJson.put("main", orgId != null ? orgId : "");
        orgIdsJson.put("sub", collextionToStr(subOrgIds));
        params.put("org_ids", orgIdsJson.toString());

        if (StringUtils.isNotBlank(startTime)) {
            params.put("start_time", startTime + " 00:00:00");
        } else {
            params.put("start_time", "2014-09-22 00:00:00");
        }

        if (StringUtils.isNotBlank(endTime)) {
            params.put("end_time", endTime + " 23:59:59");
        } else {
            params.put("end_time", "2020-01-01 23:59:59");
        }

        if (teacherId != null && teacherId.intValue() != -1) {
            params.put("teacher_id", teacherId + "");
        } else {
            params.put("teacher_id", "");
        }

        RestfulResult<Object> restResult = PayRestUtils.rest(RestMethod.POST, BASE_URL, controller, action, null, params,
                null);
        RestfulResult<OrgAccountRecordDetailDto> methodResult = new RestfulResult<OrgAccountRecordDetailDto>();
        methodResult.setCode(restResult.getCode());
        methodResult.setMsg(restResult.getMsg());

        if (isNotNullJsonNode(restResult.getData())) {
            JSONObject data = JSONObject.fromObject(restResult.getData());

            OrgAccountRecordDetailDto dto = new OrgAccountRecordDetailDto();
            methodResult.setData(dto);

            String sumMoney = data.getString("sum_money");
            if (StringUtils.isNotBlank(sumMoney) && !sumMoney.equals("null")) {
                dto.setSumMoney(Double.parseDouble(data.getString("sum_money")));
            } else {
                dto.setSumMoney(0d);
            }
            dto.setTotal(data.getInt("total"));

            JSONArray recordArray = data.getJSONArray("records");
            if (recordArray != null) {
                List<OrgAccountRecordDetailDto.Record> recordList = new ArrayList<OrgAccountRecordDetailDto.Record>();
                if (recordArray.size() > 0) {
                    for (int i = 0; i < recordArray.size(); i++) {
                        JSONObject recordNode = recordArray.getJSONObject(i);
                        OrgAccountRecordDetailDto.Record record = dto.new Record();
                        record.setOpInfo(recordNode.getString("op_info"));
                        record.setOpType(recordNode.getInt("op_type"));
                        record.setOpMoney(recordNode.optDouble("op_money", 0));
                        record.setOpDesc(recordNode.getString("op_desc"));
                        record.setCreateTime(Timestamp.valueOf(recordNode.getString("create_time")));
                        record.setPurchaseId(recordNode.optString("purchase_id", ""));
                        record.setOpTypeName(recordNode.optString("op_type_name", ""));

                        if (recordNode.containsKey("is_settlement")
                                && isNotNullJsonNode(recordNode.get("is_settlement"))) {
                            record.setIsSettlement(recordNode.getInt("is_settlement"));
                        }

                        if (recordNode.containsKey("is_coin_pay") && isNotNullJsonNode(recordNode.get("is_coin_pay"))) {
                            record.setIsCoinPay(recordNode.getInt("is_coin_pay"));
                        }
                        recordList.add(record);
                    }
                }
                dto.setRecordList(recordList);
            }
        }

        return methodResult;
    }


}
