
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.service;

import com.baijia.tianxiao.biz.campus.dto.*;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.List;

/**
 * @author caoliang
 * @version 1.0
 * @title SettingService
 * @desc O(∩_∩)O~
 * @date 2016年5月13日
 */

public interface SettingService {

    List<SettingCampusListDto> getCampusList(Integer orgId, String campusName, String name, String mobile,
        Integer campusNumber, Integer campusType, PageDto pageDto);

    void addCampus(AddCampusRequest addCampusRequest) throws BussinessException, Exception;

    void modCampus(ModCampusRequest modCampusRequest) throws BussinessException, Exception;

    void delCampus(Integer campusNumber);

    void addToHag(Integer orgNumber);

    List<CampusAccountDto> getAccountList(OrgAccount orgAccount, PageDto pageDto, String name, String mobile, Integer type, boolean isAll);

    /**
     * true-新建了账户，许发送密码短信 false不发送
     *
     * @param request
     * @return
     */
    boolean addAccount(AddAccountRequest request);

    void modAccount(ModAccountRequest request);

    void delAccount(ModAccountRequest request);

    void modAccountStatus(ModAccountRequest request);

    /**
     * 获取用户的所有校区
     * @param pageDto
     * @return
     */
    public List<SimpleCampusDto> getCampusList(Integer loginOrgId, Integer loginCascadeId, Integer visitorOrgId, Integer visitorCascadeId,String keyword, PageDto pageDto);
    
    List<SimpleCampusDto> getAllCampusList(Integer masterOrgId);

    /**
     * 获取用户在校区中的所有角色
     * @param orgId
     * @return
     */
    public List<AccountRoleDto> getAccountRoleList(Integer orgId, Integer cascadeId);

    public Integer getMasterOrgId(int loginOrgId,Integer cascadeId);
}

    