
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.sal.card.dto.TimescardRuleDto;
import org.apache.commons.lang3.builder.ToStringBuilder;

import lombok.Data;

/**
 * @title RuleDetialRequest
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年6月1日
 * @version 1.0
 */
@Data
public class RuleDetialRequest {
    private KefuRuleDto kefuRule;
    private SaleClueRuleDto saleClueRule;
    private CommonRuleDto commonRule;
    private TimescardRuleDto timescardRule;

    public boolean valid() {
        if (kefuRule != null) {
            if (!kefuRule.valid()) {
                return false;
            }
        }
        if (saleClueRule != null) {
            if (!saleClueRule.valid()) {
                return false;
            }
        }
        if (commonRule != null) {
            if (!commonRule.valid()) {
                return false;
            }
        }
        return true;
    }
    
    @Override
    public String toString(){
        return ToStringBuilder.reflectionToString(this);
    }
}
