
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.dto;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.biz.campus.constant.CampusType;

import lombok.Data;

/**
 * @title AddCampusRequest
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年5月14日
 * @version 1.0
 */
@Data
public class AddCampusRequest {

    protected String campusName;
    protected Integer campusType;
    protected Long areaId;
    protected String mobile;
    protected String presidentName;
    protected String code;
    protected String coverUrl;
    protected Integer orgWechatType;// 0:公用主账号微公众号 1:使用独立公众号

    public boolean validRequest() {
        return StringUtils.isNotBlank(campusName) && CampusType.isTypeValid(campusType) && areaId != null
            && StringUtils.isNotBlank(mobile) && StringUtils.isNotBlank(presidentName);
    }

    public String toString() {
        return " , orgWechatType is : " + this.orgWechatType;
    }

}
