/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.biz.campus.dto.TXPermissionNodeDto;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.io.IOException;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AddAccountRequest {
    protected Integer campusNumber;
    protected String name;
    protected String mobile;
    protected String title;
    protected Integer type;
    protected String authListJson;
    protected List<TXPermissionNodeDto> authList;

    public List<TXPermissionNodeDto> getAuthList() {
        if (CollectionUtils.isEmpty(this.authList)) {
            BussinessPreconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.authListJson), (Object)"authListJson is empty!");
            try {
                this.authList = JacksonUtil.str2List((String)this.authListJson, TXPermissionNodeDto.class);
            }
            catch (IOException e) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "authListJson parse error!");
            }
        }
        return this.authList;
    }

    public boolean validRequest() {
        return this.campusNumber != null && CampusAccountType.isTypeValid((Integer)this.type) && StringUtils.isNotBlank((CharSequence)this.mobile) && StringUtils.isNotBlank((CharSequence)this.name);
    }

    public Integer getCampusNumber() {
        return this.campusNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getType() {
        return this.type;
    }

    public String getAuthListJson() {
        return this.authListJson;
    }

    public void setCampusNumber(Integer campusNumber) {
        this.campusNumber = campusNumber;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setAuthListJson(String authListJson) {
        this.authListJson = authListJson;
    }

    public void setAuthList(List<TXPermissionNodeDto> authList) {
        this.authList = authList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddAccountRequest)) {
            return false;
        }
        AddAccountRequest other = (AddAccountRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$campusNumber = this.getCampusNumber();
        Integer other$campusNumber = other.getCampusNumber();
        if (this$campusNumber == null ? other$campusNumber != null : !((Object)this$campusNumber).equals(other$campusNumber)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$authListJson = this.getAuthListJson();
        String other$authListJson = other.getAuthListJson();
        if (this$authListJson == null ? other$authListJson != null : !this$authListJson.equals(other$authListJson)) {
            return false;
        }
        List<TXPermissionNodeDto> this$authList = this.getAuthList();
        List<TXPermissionNodeDto> other$authList = other.getAuthList();
        return !(this$authList == null ? other$authList != null : !((Object)this$authList).equals(other$authList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddAccountRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $campusNumber = this.getCampusNumber();
        result = result * 59 + ($campusNumber == null ? 43 : ((Object)$campusNumber).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $authListJson = this.getAuthListJson();
        result = result * 59 + ($authListJson == null ? 43 : $authListJson.hashCode());
        List<TXPermissionNodeDto> $authList = this.getAuthList();
        result = result * 59 + ($authList == null ? 43 : ((Object)$authList).hashCode());
        return result;
    }

    public String toString() {
        return "AddAccountRequest(campusNumber=" + this.getCampusNumber() + ", name=" + this.getName() + ", mobile=" + this.getMobile() + ", title=" + this.getTitle() + ", type=" + this.getType() + ", authListJson=" + this.getAuthListJson() + ", authList=" + this.getAuthList() + ")";
    }
}

