/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.BizConf;
import com.baijia.tianxiao.biz.campus.constant.CommonRuleValue;
import com.baijia.tianxiao.biz.campus.dto.CascadeAccountDto;
import com.baijia.tianxiao.biz.campus.dto.CommonRuleDto;
import com.baijia.tianxiao.biz.campus.dto.KefuRuleDto;
import com.baijia.tianxiao.biz.campus.dto.RuleDetailDto;
import com.baijia.tianxiao.biz.campus.dto.RuleDetialRequest;
import com.baijia.tianxiao.biz.campus.dto.SaleClueRuleDto;
import com.baijia.tianxiao.biz.campus.service.RuleService;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.AuditStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgTxtMsgDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.org.po.TXKefuRule;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.OrgHomepageType;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXKefuRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RuleServiceImpl
implements RuleService {
    private static final Logger log = LoggerFactory.getLogger(RuleServiceImpl.class);
    @Autowired
    private TXKefuRuleService txKefuRuleService;
    @Autowired
    private TXSaleClueRuleService txSaleClueRuleService;
    @Autowired
    private TXCommonRuleService txCommonRuleService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Resource
    private OrgTxtMsgDao orgTxtMsgDao;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private TXAccountService txAccountService;

    @Override
    public RuleDetailDto getRuleDetail(Integer orgId) {
        RuleDetailDto dto = new RuleDetailDto();
        TXKefuRule txKefuRule = this.txKefuRuleService.getByOrgId(orgId);
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(orgId);
        TXCommonRule txCommonRule = this.txCommonRuleService.getByOrgId(orgId);
        OrgTxtMsg txtMsg = this.orgTxtMsgDao.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.PHONE.getValue());
        dto.setKefuRule(KefuRuleDto.from(txKefuRule, txtMsg));
        dto.setSaleClueRule(SaleClueRuleDto.from(txSaleClueRule));
        CommonRuleDto commonRule = CommonRuleDto.from(txCommonRule);
        Integer findSigninStatus = this.orgInfoService.findSigninStatus(orgId);
        commonRule.setTeacherSignRule(findSigninStatus);
        dto.setCommonRule(commonRule);
        return dto;
    }

    @Override
    public void saveRule(RuleDetialRequest request, OrgAccount orgAccount) {
        this.handleKefuRule(request.getKefuRule(), orgAccount);
        this.handleSalClueRule(request.getSaleClueRule(), orgAccount);
        this.handleCommonrule(request.getCommonRule(), orgAccount);
    }

    private void handleCommonrule(CommonRuleDto commonRuleDto, OrgAccount orgAccount) {
        if (commonRuleDto == null) {
            return;
        }
        TXCommonRule txCommonRule = this.txCommonRuleService.getByOrgId(orgAccount.getId());
        if (txCommonRule == null) {
            txCommonRule = new TXCommonRule();
            txCommonRule.setCreateTime(new Date());
            txCommonRule.setOrgId(orgAccount.getId());
            txCommonRule.setOrgNumber(orgAccount.getNumber());
        }
        txCommonRule.setUpdateTime(new Date());
        if (commonRuleDto.getCallMobileRule() != null) {
            txCommonRule.setCallMobileRule(commonRuleDto.getCallMobileRule());
        }
        if (commonRuleDto.getStudentMobileRule() != null) {
            txCommonRule.setStudentMobileRule(commonRuleDto.getStudentMobileRule());
        }
        if (commonRuleDto.getTeacherSignRule() != null) {
            this.orgInfoService.updateTeacherSigninStatus(Long.valueOf(orgAccount.getId().longValue()), commonRuleDto.getTeacherSignRule());
        }
        if (commonRuleDto.getConsumeRule() != null) {
            txCommonRule.setConsumeRule(commonRuleDto.getConsumeRule());
        }
        if (commonRuleDto.getVipConsumeRule() != null) {
            if (commonRuleDto.getVipConsumeRule() != 1 && commonRuleDto.getVipConsumeRule() != 3 && commonRuleDto.getVipConsumeRule() != 5 && commonRuleDto.getVipConsumeRule() != 7) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4e00\u5bf9\u4e00\u8bfe\u6d88\u8bbe\u7f6e\u89c4\u5219\u53c2\u6570\u9519\u8bef");
            }
            txCommonRule.setVipConsumeRule(commonRuleDto.getVipConsumeRule());
        }
        this.txCommonRuleService.saveTXCommonRule(txCommonRule);
    }

    public void handleSalClueRule(SaleClueRuleDto saleClueRuleDto, OrgAccount orgAccount) {
        if (saleClueRuleDto == null) {
            return;
        }
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(orgAccount.getId());
        if (txSaleClueRule == null) {
            txSaleClueRule = new TXSaleClueRule();
            txSaleClueRule.setCreateTime(new Date());
            txSaleClueRule.setOrgId(orgAccount.getId());
            txSaleClueRule.setOrgNumber(orgAccount.getNumber());
        }
        txSaleClueRule.setUpdateTime(new Date());
        if (saleClueRuleDto.getClueAllot() != null) {
            txSaleClueRule.setClueAllot(saleClueRuleDto.getClueAllot());
        }
        if (saleClueRuleDto.getClueTransValid() != null) {
            txSaleClueRule.setClueTransValid(saleClueRuleDto.getClueTransValid());
        }
        if (saleClueRuleDto.getMaxClueCount() != null) {
            txSaleClueRule.setMaxClueCount(saleClueRuleDto.getMaxClueCount());
        }
        if (saleClueRuleDto.getMaxClueDelay() != null) {
            txSaleClueRule.setMaxClueDelay(saleClueRuleDto.getMaxClueDelay());
        }
        if (saleClueRuleDto.getReturnClue() != null) {
            txSaleClueRule.setReturnClue(saleClueRuleDto.getReturnClue());
        }
        if (saleClueRuleDto.getEvaluateMsg() != null) {
            txSaleClueRule.setEvaluateMsg(saleClueRuleDto.getEvaluateMsg());
        }
        if (saleClueRuleDto.getAttendClassMsg() != null) {
            txSaleClueRule.setAttendClassMsg(saleClueRuleDto.getAttendClassMsg());
        }
        if (saleClueRuleDto.getSigninMsg() != null) {
            txSaleClueRule.setSigninMsg(saleClueRuleDto.getSigninMsg());
        }
        if (saleClueRuleDto.getSignupMsg() != null) {
            txSaleClueRule.setSignupMsg(saleClueRuleDto.getSignupMsg());
        }
        log.debug("*********************txSaleClueRule:{}", (Object)txSaleClueRule);
        this.txSaleClueRuleService.saveTXSaleClueRule(txSaleClueRule);
    }

    private void handleKefuRule(KefuRuleDto kefuRuleDto, OrgAccount orgAccount) {
        OrgTxtMsg orgTxtMsg;
        if (kefuRuleDto == null) {
            return;
        }
        TXKefuRule txKefuRule = this.txKefuRuleService.getByOrgId(orgAccount.getId());
        if (txKefuRule == null) {
            txKefuRule = new TXKefuRule();
            txKefuRule.setCreateTime(new Date());
            txKefuRule.setOrgId(orgAccount.getId());
            txKefuRule.setOrgNumber(orgAccount.getNumber());
        }
        txKefuRule.setUpdateTime(new Date());
        if (kefuRuleDto.getConsultRule() != null) {
            txKefuRule.setConsultRule(kefuRuleDto.getConsultRule());
        }
        if (kefuRuleDto.getBespeakOrder() != null) {
            txKefuRule.setBespeakRule(kefuRuleDto.getBespeakOrder());
        }
        String mobiles = "";
        if (CollectionUtils.isNotEmpty(kefuRuleDto.getConsultMobiles())) {
            if (kefuRuleDto.getConsultMobiles().size() > BizConf.MAX_KEFU_MOBILE_COUNT) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5ba2\u670d\u7535\u8bdd\u6570\u91cf\u8fc7\u591a");
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < kefuRuleDto.getConsultMobiles().size(); ++i) {
                sb.append(kefuRuleDto.getConsultMobiles().get(i));
                if (i + 1 >= kefuRuleDto.getConsultMobiles().size()) continue;
                sb.append(",");
            }
            mobiles = sb.toString();
        }
        if ((orgTxtMsg = this.orgTxtMsgDao.getOrgTxtByIdAndType(orgAccount.getId().intValue(), AuditColumType.PHONE.getValue())) == null) {
            orgTxtMsg = new OrgTxtMsg();
            orgTxtMsg.setAuditstatus(Integer.valueOf(AuditStatus.PASS.getValue()));
            orgTxtMsg.setCreateTime(DateUtil.getToday());
            orgTxtMsg.setOrgId(orgAccount.getId());
            orgTxtMsg.setType(Integer.valueOf(AuditColumType.PHONE.getValue()));
            orgTxtMsg.setGroupId(OrgHomepageType.BASE_INFO.getGroup());
            orgTxtMsg.setValue(mobiles);
            this.orgTxtMsgDao.save((Object)orgTxtMsg, new String[0]);
        } else {
            orgTxtMsg.setValue(mobiles);
            orgTxtMsg.setUpdateTime(DateUtil.getToday());
            this.orgTxtMsgDao.update((Object)orgTxtMsg, new String[0]);
        }
        this.txKefuRuleService.saveTXKefuRule(txKefuRule);
    }

    @Override
    public List<CascadeAccountDto> getCascadeAccount() {
        OrgAccount orgAccount = this.orgAccountService.getOrgAccountById(TianxiaoPCContext.getOrgId());
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65e0\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        List txCascadeAccounts = this.txCascadeAccountDao.getTXCascadeAccountListByOrgId(Long.valueOf(orgAccount.getId().longValue()));
        if (CollectionUtils.isEmpty((Collection)txCascadeAccounts)) {
            return null;
        }
        ArrayListMultimap dtoMap = ArrayListMultimap.create();
        ArrayList ids = Lists.newArrayList();
        for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
            CascadeAccountDto dto = new CascadeAccountDto();
            dto.setTitle(txCascadeAccount.getTitle());
            ids.add(txCascadeAccount.getCredentialId());
            dtoMap.put((Object)txCascadeAccount.getCredentialId(), (Object)dto);
        }
        List txCascadeCredentials = this.txCascadeCredentialDao.getByIds((Collection)ids, new String[0]);
        if (CollectionUtils.isEmpty((Collection)txCascadeCredentials)) {
            return null;
        }
        ArrayList data = Lists.newArrayList();
        for (TXCascadeCredential txCascadeCredential : txCascadeCredentials) {
            ArrayList dtos = new ArrayList(dtoMap.get((Object)txCascadeCredential.getId()));
            if (!CollectionUtils.isNotEmpty(dtos)) continue;
            for (CascadeAccountDto dto : dtos) {
                dto.setMobile(txCascadeCredential.getMobile());
                dto.setUName(txCascadeCredential.getName());
            }
            data.addAll(dtos);
        }
        return data;
    }

    @Override
    public RuleDetailDto getRuleDetail(Integer orgId, Integer cascadeAccountId) {
        RuleDetailDto dto = new RuleDetailDto();
        TXKefuRule txKefuRule = this.txKefuRuleService.getByOrgId(orgId);
        TXSaleClueRule txSaleClueRule = this.txSaleClueRuleService.getByOrgId(orgId);
        TXCommonRule txCommonRule = this.txCommonRuleService.getByOrgId(orgId);
        OrgTxtMsg txtMsg = this.orgTxtMsgDao.getOrgTxtByIdAndType(orgId.intValue(), AuditColumType.PHONE.getValue());
        dto.setKefuRule(KefuRuleDto.from(txKefuRule, txtMsg));
        dto.setSaleClueRule(SaleClueRuleDto.from(txSaleClueRule));
        CommonRuleDto commonRule = CommonRuleDto.from(txCommonRule);
        Integer findSigninStatus = this.orgInfoService.findSigninStatus(orgId);
        commonRule.setTeacherSignRule(findSigninStatus);
        TXAccount txAccount = this.txAccountService.getByOrgId(orgId, new String[0]);
        log.debug("***************txAccount:{}", (Object)txAccount);
        if (txAccount != null && txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode().intValue()) {
            commonRule.setCallMobileRule(CommonRuleValue.CAN_USE_OWN_CALL.getCode());
            commonRule.setStudentMobileRule(CommonRuleValue.STUDENT_MOBILE_SHOW.getCode());
            log.debug("***************commonRule  dazhong:{}", (Object)txAccount);
        } else if (cascadeAccountId == null) {
            commonRule.setCallMobileRule(CommonRuleValue.CALL_MOBILE_OWN.getCode());
            commonRule.setStudentMobileRule(CommonRuleValue.STUDENT_MOBILE_SHOW.getCode());
            log.debug("***************commonRule  zizhanghao:{}", (Object)txAccount);
        }
        dto.setCommonRule(commonRule);
        return dto;
    }
}

