
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.dto;

import com.baijia.tianxiao.biz.campus.constant.CommonRuleValue;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;

import lombok.Data;

/**
 * @title CommonRuleDto
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年6月1日
 * @version 1.0
 */
@Data
public class CommonRuleDto {
    private Integer studentMobileRule;
    private Integer callMobileRule;
    private Integer teacherSignRule;
    private Integer consumeRule;

    public static CommonRuleDto from(TXCommonRule txCommonRule) {
        if (txCommonRule == null) {
            return null;
        }
        CommonRuleDto dto = new CommonRuleDto();
        dto.setCallMobileRule(txCommonRule.getCallMobileRule());
        dto.setStudentMobileRule(txCommonRule.getStudentMobileRule());
        dto.setConsumeRule(txCommonRule.getConsumeRule());
        return dto;
    }

    public boolean valid() {
        if (studentMobileRule != null) {
            if (studentMobileRule != CommonRuleValue.STUDENT_MOBILE_NOT_SHOW.getCode()
                && studentMobileRule != CommonRuleValue.STUDENT_MOBILE_SHOW.getCode()) {
                return false;
            }
        }
        if (callMobileRule != null) {
            if (callMobileRule != CommonRuleValue.CALL_MOBILE_NOT_OWN.getCode()
                && callMobileRule != CommonRuleValue.CALL_MOBILE_OWN.getCode()) {
                return false;
            }
        }
        if (teacherSignRule != null) {
            if (teacherSignRule != CommonRuleValue.TEACER_SING_NOT_PERMIT.getCode()
                && teacherSignRule != CommonRuleValue.TEACER_SING_PERMIT.getCode()) {
                return false;
            }
        }
        return true;
    }
}
