
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.constant;

/**
 * @title CampusAccountStatus
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年5月16日
 * @version 1.0
 */
    
public enum CampusAccountStatus {
    NORMAL(0, "启用"), PAUSE(1, "暂停");

    private Integer code;
    private String label;

    CampusAccountStatus(Integer code, String label) {
        this.code = code;
        this.label = label;
    }

    public Integer getCode() {

        return code;
    }

    public void setCode(Integer code) {

        this.code = code;
    }

    public String getLabel() {

        return label;
    }

    public void setLabel(String label) {

        this.label = label;
    }

    public static String getLabelByCode(int code) {
        for (CampusAccountStatus ct : CampusAccountStatus.values()) {
            if (ct.getCode() == code) {
                return ct.getLabel();
            }
        }
        return null;
    }

    public static boolean isTypeValid(Integer code) {
        if (code == null) {
            return false;
        }
        for(CampusAccountStatus cType : CampusAccountStatus.values()){
            if(cType.getCode().intValue() == code){
                return true;
            }
        }
        return false;
    }
}
