
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.campus.service.impl;

import com.baijia.tianxiao.biz.campus.constant.BizConf;
import com.baijia.tianxiao.biz.campus.constant.CampusAccountStatus;
import com.baijia.tianxiao.biz.campus.constant.CampusType;
import com.baijia.tianxiao.biz.campus.dto.*;
import com.baijia.tianxiao.biz.campus.service.SettingService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.dal.org.constant.*;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.pcAuthority.dao.TxAccountPermissionDao;
import com.baijia.tianxiao.dal.pcAuthority.po.TXPermission;
import com.baijia.tianxiao.dal.pcAuthority.po.TxAccountPermission;
import com.baijia.tianxiao.dal.roster.constant.ConsulterOperation;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsulterOperationLogDao;
import com.baijia.tianxiao.dal.roster.po.TxConsulterOperationLog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.enums.SMSErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.marketing.commons.exceptions.BusinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.*;
import com.baijia.tianxiao.sal.organization.mqs.OrganizationRegist;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.MqsUtils;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.VerifyCodeUtil;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.yunying.hag.dal.bo.Entity;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author caoliang
 * @version 1.0
 * @title SettingServiceImpl
 * @desc O(∩_∩)O~
 * @date 2016年5月13日
 */
@Service
@Transactional
@Slf4j
public class SettingServiceImpl implements SettingService {
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired(required = false)
    private HagService hagService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private TXPermissionService txPermissionService;
    @Autowired
    private TxConsultUserDao consultUserDao;
    @Autowired
    private TxConsulterOperationLogDao txConsulterOperationLogDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private TxAccountPermissionDao txAccountPermissionDao;
    @Autowired
    private TXAccountService txAccountService;

    @Override
    public List<SettingCampusListDto> getCampusList(Integer orgId, PageDto pageDto)
            throws BussinessException, Exception {
        List<SettingCampusListDto> data = Lists.newArrayList();
        SettingCampusListDto master = new SettingCampusListDto();
        OrgSubAccount masterSub = orgSubAccountService.getMaster(orgId);
        OrgAccount orgAccount = orgAccountService.getOrgAccountById(orgId);
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId);
        master.setCampusName(orgInfo.getShortName());
        master.setCampusNumber(orgAccount.getNumber());
        master.setCampusType(CampusType.MASTER.getCode());
        master.setCampusTypeName(CampusType.MASTER.getLabel());
        master.setAreaId(orgInfo.getAreaId());
        master.setMobile(orgAccount.getMobile());
        master.setPrincipal(orgInfo.getContacts());
        master.setCoverUrl(masterSub.getCoverUrl());
        if (orgInfo.getAreaId() != null) {
            Map<String, String> areaMap = AreaUtils.getAreaNameByCode(orgInfo.getAreaId().intValue());
            master.setProvince(areaMap.get("province"));
            master.setCity(areaMap.get("city"));
        }
        Integer mCascadeCount = txCascadeAccountDao.getCountByOrgId(orgId);
        // 算上自己
        master.setAccountSum(++mCascadeCount);
        data.add(master);
        if (pageDto.getPageNum() == 1) {
            pageDto.setPageSize(pageDto.getPageSize() - 1);
        } else {
            pageDto.setCurPageCount((pageDto.getPageNum() - 1) * pageDto.getPageSize() - 1);
            data.clear();
        }
        // 分校区数据
        List<OrgSubAccount> slaves = orgSubAccountService.getSlaves(orgId, pageDto);
        if (CollectionUtils.isNotEmpty(slaves)) {
            for (OrgSubAccount subAccount : slaves) {
                OrgAccount oAccount = orgAccountService.getOrgAccountById(subAccount.getOrgId());
                if (oAccount != null) {
                    OrgInfo oInfo = orgInfoDao.getOrgInfo(oAccount.getId());
                    Integer subCount = txCascadeAccountDao.getCountByOrgId(oAccount.getId());
                    SettingCampusListDto slave = new SettingCampusListDto();
                    // 算上自己
                    slave.setAccountSum(++subCount);
                    slave.setCampusName(oInfo.getShortName());
                    slave.setCampusNumber(oAccount.getNumber());
                    slave.setCampusType(subAccount.getAccountType());
                    slave.setAreaId(oInfo.getAreaId());
                    slave.setCampusId(subAccount.getId());
                    slave.setMobile(oAccount.getMobile());
                    slave.setCoverUrl(subAccount.getCoverUrl());
                    if (oInfo.getAreaId() != null) {
                        Map<String, String> areaMap = AreaUtils.getAreaNameByCode(oInfo.getAreaId().intValue());
                        slave.setProvince(areaMap.get("province"));
                        slave.setCity(areaMap.get("city"));
                    }
                    slave.setPrincipal(oInfo.getContacts());
                    data.add(slave);
                }
            }
        }

        Integer slaveCount = orgSubAccountService.getSlaveCount(orgId);
        pageDto.setCount(++slaveCount);

        return data;
    }

    @Override
    public void addCampus(AddCampusRequest addCampusRequest) {
        Integer subCount = orgSubAccountService.getSlaveCount(TianxiaoPCContext.getOrgId());
        TXAccount txAccount = txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId());
        if (txAccount.getCampusCount() <= (subCount + 1)) {
            throw new BussinessException(CrmErrorCode.EXCESS_CAMPUS_COUNT);
        }
        OrgAccount orgAccount = orgAccountService.getOrgAccountByMobile(addCampusRequest.getMobile());
        // 手机号已存在，校验验证码
        // 手机号不存在，浅注册一个机构
        if (orgAccount != null) {
            if (orgAccount.getId().intValue() == txAccount.getOrgId()) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "不能添加自己");
            }
            // code为空或者不正确，kill
            if (StringUtils.isBlank(addCampusRequest.getCode())
                    || VerifyCodeUtil.valid(false, addCampusRequest.getMobile(), addCampusRequest.getCode(),
                    TxSmsCodeType.INVITE_TOBE_CAMPUS.getCacheKey())) {
                throw new BussinessException(SMSErrorCode.CODE_INVALID);
            }
        } else {
            orgAccount = saveOrgAccount(addCampusRequest.getMobile());
            saveOrgInfo(addCampusRequest.getAreaId(), orgAccount.getId(), addCampusRequest.getCampusName(),
                    addCampusRequest.getPrincipal());
            sendMQSMsg(orgAccount.getId(), addCampusRequest.getAreaId(), null);
            boolean sendResult = false;
            try {
                sendResult = SmsSendUtil.sendSms(addCampusRequest.getMobile(),
                        TxSmsCodeType.getSmsMsg(TxSmsCodeType.NEW_ORG_PWD, TXCascadeCredential.DEFAULT_PWD),
                        SmsMessageType.TIANXIAO_NOTIFY.getCode(), TianxiaoPCContext.getOrgId(), UserRole.ORGANIZATION.getRole(), true, txAccountService.getTxAccountSmsGate(TianxiaoPCContext.getOrgId()));
            } catch (Throwable e) {
                log.error("send invite campus sms error:", e);
            }
            if (!sendResult) {
                log.info("send invite campus sms to :{} error:{}!code :{}", addCampusRequest.getMobile(), sendResult,
                        TXCascadeCredential.DEFAULT_PWD);
            }
            log.info("send default campus pwd sms to :{} error:{}!code :{}", addCampusRequest.getMobile(), sendResult,
                    TXCascadeCredential.DEFAULT_PWD);
        }

        OrgSubAccount slaveInDB = orgSubAccountService.getByOrgIdIgnoreDelStatus(orgAccount.getId());
        if (slaveInDB == null) {
            OrgSubAccount slave = new OrgSubAccount();
            slave.setAccountType(addCampusRequest.getCampusType());
            slave.setComment(addCampusRequest.getPrincipal());
            slave.setOrgId(orgAccount.getId());
            slave.setCreateTime(new Date());
            slave.setPid(TianxiaoPCContext.getOrgId());
            slave.setCoverUrl(PropertiesReader.getValue("upload", "campus.cover.url"));
            orgSubAccountService.addOrgSubAccount(slave);
        } else if (slaveInDB.getIsdel().intValue() == DeleteStatus.DELETED.getValue()) {//对于删除状态的子校区,更改状态
            slaveInDB.setAccountType(addCampusRequest.getCampusType());
            slaveInDB.setComment(addCampusRequest.getPrincipal());
            slaveInDB.setOrgId(orgAccount.getId());
            slaveInDB.setUpdateTime(new Date());
            slaveInDB.setPid(TianxiaoPCContext.getOrgId());
            slaveInDB.setCoverUrl(PropertiesReader.getValue("upload", "campus.cover.url"));
            slaveInDB.setStatus(OrgSubAccountStatus.NORMAL.getCode());
            slaveInDB.setIsdel(DeleteStatus.NORMAL.getValue());
            slaveInDB.setAccountVersion(slaveInDB.getAccountVersion() + 1);
            orgSubAccountService.update(slaveInDB);
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
            orgInfo.setAreaId(addCampusRequest.getAreaId());
            orgInfo.setShortName(addCampusRequest.getCampusName());
            orgInfoDao.update(orgInfo);
        } else if (slaveInDB.getIsdel().intValue() == DeleteStatus.NORMAL.getValue() && slaveInDB.getPid() != 0) {//生效中的分校区
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "此校区已绑定主校区，不可重复绑定(在原校区上删除该校区后可以再次绑定).");
        } else if (slaveInDB.getIsdel().intValue() == DeleteStatus.NORMAL.getValue() && slaveInDB.getPid() == 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "该校区已经是天校帐号,无法绑定成为分校区.");
        }
        // 主校区第一次添加时才创建
        OrgSubAccount masterInDB = orgSubAccountService.getByOrgIdIgnoreDelStatus(TianxiaoPCContext.getOrgId());
        if (masterInDB == null) {
            OrgSubAccount master = new OrgSubAccount();
            master.setAccountType(CampusType.MASTER.getCode());
            master.setCreateTime(new Date());
            master.setOrgId(TianxiaoPCContext.getOrgId());
            master.setPid(OrgSubAccount.MASTER_PID);
            master.setCoverUrl(PropertiesReader.getValue("upload", "campus.cover.url"));
            orgSubAccountService.addOrgSubAccount(master);
        }
        addToHag(orgAccount.getNumber());
    }

    private void sendMQSMsg(int orgId, long areaId, String mobile) {
        OrganizationRegist regist = new OrganizationRegist();
        regist.setAreaId(areaId);
        regist.setMobile("");
        //regist.setMobile(StringUtils.isNotBlank(mobile) ? mobile : "");
        regist.setOrgId(orgId);
        regist.setTime(String.valueOf(System.currentTimeMillis() / 1000));

        String messageBody = JacksonUtil.obj2Str(regist);
        MqsUtils mqs = new MqsUtils();
        String queueName = PropertiesReader.getValue("mns", "mqs.queue.org.reg");
        mqs.sendMessage(queueName, messageBody);
    }

    private void addToHag(Integer orgNumber) {
        log.info("add to hag orgNumber:{}", orgNumber);
        if (orgNumber == null) {
            return;
        }
        List<Entity> entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName(orgNumber);
        entities.add(entity);
        // 天校白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result1 =
                hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                        PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER);
        log.info("add {} to hag {} result:{}", orgNumber, BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER, result1);
        // 3810白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result2 =

                hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                        PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURCE_PYXIS_ORG_NUMBER);
        log.info("add {} to hag {} result:{}", orgNumber, BizConf.HAG_RESOURCE_PYXIS_ORG_NUMBER, result2);
        // 每日提现白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result3 =
                hagService.addEntitiesToResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                        PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURSE_ORG_TIXIAN_NUMBER);

        log.info("add {} to hag {} result:{}", orgNumber, BizConf.HAG_RESOURSE_ORG_TIXIAN_NUMBER, result3);
    }

    private OrgAccount saveOrgAccount(String mobile) {
        OrgAccount saveToDB = new OrgAccount();
        saveToDB.setCreateTime(new Date());
        saveToDB.setMobile(mobile);
        saveToDB.setPassword(PasswordUtil.createHash(TXCascadeCredential.DEFAULT_PWD));
        saveToDB.setUpdateTime(new Date());
        orgAccountDao.save(saveToDB);
        Integer id = saveToDB.getId();
        if (id != null) {
            saveToDB.setNumber(SerialNumberUtil.generateNumber(id, SerialNumberUtil.MAX));
            orgAccountDao.update(saveToDB);
        } else {
            throw new BusinessException("浅注册账户失败");
        }
        return saveToDB;
    }

    private void saveOrgInfo(Long areaId, int org_id, String shortName, String contacts) {
        OrgInfo info = new OrgInfo();
        Date time = new Date();
        info.setName("");
        info.setShortName(shortName);
        info.setOrgType(0);
        info.setAreaId(areaId);
        info.setContacts(contacts);
        info.setIdCardType(0);
        info.setIdCard("");
        info.setIdCardStorageId(0);
        info.setBizLicense("");
        info.setBizLicenseStorageId(0);
        info.setSchLicenseType(0);
        info.setSchLicense("");
        info.setSchLicenseStorageId(0);
        info.setAuditStatus(AuditStatus.INIT.getValue());
        info.setRejectReason("");
        info.setRejectReasonOther("");
        info.setSignStatus(SignStatus.UNSIGN.getCode());
        info.setOrgId(org_id);
        info.setCreateTime(time);
        info.setUpdateTime(time);

        orgInfoDao.save(info);
    }

    @Override
    public void modCampus(ModCampusRequest modCampusRequest) throws BussinessException, Exception {
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(modCampusRequest.getCampusNumber());
        if (orgAccount == null) {
            return;
        }
        boolean subChange = false;
        OrgSubAccount subAccount = null;
        if (modCampusRequest.getCampusType().intValue() == CampusType.MASTER.getCode()) {
            subAccount = orgSubAccountService.getMaster(orgAccount.getId());
        } else {
            log.debug("mod subCampus orgId:{},pid:{}", orgAccount.getId(), TianxiaoPCContext.getOrgId());
            subAccount = orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        }

        if (subAccount == null) {
            // 没查到分校区信息，说明出现脏数据，直接返回
            log.error("Oops! check orgsubAccount data! orgId:{}", orgAccount.getId());
            return;
        }
        if (StringUtils.isNotBlank(modCampusRequest.getPrincipal())) {
            subAccount.setComment(modCampusRequest.getPrincipal());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        if (StringUtils.isNotBlank(modCampusRequest.getCoverUrl())) {
            subAccount.setCoverUrl(modCampusRequest.getCoverUrl());
            subAccount.setUpdateTime(new Date());
            subChange = true;
        }
        if (subChange) {
            orgSubAccountService.update(subAccount);
        }
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
        if (orgInfo == null) {
            log.error("Oops! check orgInfo data! orgId:{}", orgAccount.getId());
            return;
        }
        boolean orgInfoChange = false;
        if (StringUtils.isNotBlank(modCampusRequest.getCampusName())) {
            orgInfo.setShortName(modCampusRequest.getCampusName());
            orgInfoChange = true;
        }
        if (modCampusRequest.getAreaId() != null && modCampusRequest.getAreaId() > 0) {
            orgInfo.setAreaId(modCampusRequest.getAreaId());
            orgInfoChange = true;
        }
        if (StringUtils.isNotBlank(modCampusRequest.getPrincipal())) {
            orgInfo.setContacts(modCampusRequest.getPrincipal());
        }
        if (orgInfoChange) {
            orgInfo.setUpdateTime(new Date());
            orgInfoDao.update(orgInfo);
        }

        // if (StringUtils.isNotBlank(modCampusRequest.getMobile())) {
        // OrgAccount temp = orgAccountService.getOrgAccountByMobile(modCampusRequest.getMobile());
        // if (temp != null) {
        //
        // if (!modCampusRequest.getMobile().equals(orgAccount.getMobile())) {
        // throw new BussinessException(CrmErrorCode.MOBILE_EXIST);
        // }
        // orgAccount.setMobile(modCampusRequest.getMobile());
        // orgAccount.setUpdateTime(new Date());
        // orgAccountDao.update(orgAccount);
        // } else {
        // orgAccount.setMobile(modCampusRequest.getMobile());
        // orgAccount.setUpdateTime(new Date());
        // orgAccountDao.update(orgAccount);
        // }
        // }
    }

    @Override
    public void delCampus(Integer campusNumber) {
        OrgAccount orgAccount = orgAccountDao.getAccountByNumber(campusNumber);
        if (null == orgAccount) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "找不到对应的机构!");
        }
        OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
        if (null == orgSubAccount) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "找不到对应的子校区!");
        }

        List<TXCascadeAccount> cascadeAccountList = txCascadeAccountDao.getTXCascadeAccountListByOrgId(orgAccount.getId().longValue());
        for (TXCascadeAccount cascadeAccount : cascadeAccountList) {
            try {
                releaseConsulter(cascadeAccount.getId().longValue());
                // 释放班主任
                orgCourseDao.batchUpdateHeadTeacher(orgAccount.getNumber(), cascadeAccount.getId(), -1);
            } catch (Exception e) {
                log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", cascadeAccount.getId());
                log.error("modDirectorStatus - releaseConsulter - error:{}", e);
                throw new BusinessException("释放线索失败，可尝试手动清空账号线索后再进行此操作。");
            }
        }

        delInHag(orgAccount.getNumber());
        orgSubAccountDao.deleteByOrgid(orgAccount.getId());
        txCascadeAccountDao.deleteByOrgId(orgAccount.getId());
    }

    /**
     * 涉及多张表的翻页，ಥ_ಥ， 拼信息时，为了看起来逻辑清晰些，有重复的代码段在不同的if中
     *
     * @param orgAccount 两种情况:1未指定num,传入主校区 此时isAll为true 2指定了num,传入特定校区 此时isAll为false
     * @param pageDto
     * @return
     * @throws BussinessException
     * @throws Exception
     */
    @Override
    public List<CampusAccountDto> getAccountList(OrgAccount orgAccount, PageDto pageDto, boolean isAll)
            throws BussinessException, Exception {
        List<CampusAccountDto> data = Lists.newArrayList();
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
        CampusAccountDto master = makeMasterDto(orgAccount, orgInfo);
        data.add(master);
        List<Integer> orgIds = Lists.newArrayList();
        orgIds.add(orgAccount.getId());
        if (isAll) {
            List<OrgSubAccount> subAccounts = orgSubAccountService.getSlavesIgnoreStatus(orgAccount.getId(), null);
            if (CollectionUtils.isNotEmpty(subAccounts)) {
                for (OrgSubAccount subAccount : subAccounts) {
                    OrgAccount slaveAccount = orgAccountService.getOrgAccountById(subAccount.getOrgId());
                    OrgInfo slaveInfo = orgInfoDao.getOrgInfo(subAccount.getOrgId());
                    CampusAccountDto slave = makeSlaveDto(slaveAccount, slaveInfo, subAccount);
                    data.add(slave);
                    orgIds.add(slaveAccount.getId());
                }
            }
        }
        int curPageCount = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        // 第一页时，如果校长帐号数量>20 ，截断返回。<20填充子帐号返回
        // 从第二页开始，先看校长帐号数量是否超过curPageCount，超过的话，看超过的部分是否超过pagesize，超过截断，不超过取子帐号填充
        if (curPageCount == 0) {
            if (data.size() >= pageDto.getPageSize()) {
                data = data.subList(0, pageDto.getPageSize());
            } else {
                pageDto.setPageSize(pageDto.getPageSize() - data.size());//刨去校区占用的空间,剩下子账号的可占用的最大个数
                List<TXCascadeAccount> cascadeAccounts = txCascadeAccountDao.getByOrgIds(orgIds, pageDto);
                if (CollectionUtils.isNotEmpty(cascadeAccounts)) {
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        OrgAccount parentAccount = orgAccountService.getOrgAccountById(cascadeAccount.getOrgId());
                        OrgInfo parentInfo = orgInfoDao.getOrgInfo(parentAccount.getId());
                        TXCascadeCredential credential =
                                txCascadeCredentialDao.getById(cascadeAccount.getCredentialId());
                        CampusAccountDto cascade =
                                makeCascadeDto(parentAccount, parentInfo, credential, cascadeAccount);
                        data.add(cascade);
                    }
                }
            }
        } else if (data.size() >= curPageCount) {
            // 走到这里，说明校长帐号超过了一页，有钱！！！
            data = data.subList(curPageCount, data.size());
            // 还是超过一页，真壕
            if (data.size() >= pageDto.getPageSize()) {
                data.subList(0, pageDto.getPageSize());
            } else {
                //  校长帐号不足一页，用子帐号补全一页
                pageDto.setCurPageCount(0);
                pageDto.setPageSize(pageDto.getPageSize() - data.size());
                List<TXCascadeAccount> cascadeAccounts = txCascadeAccountDao.getByOrgIds(orgIds, pageDto);
                if (CollectionUtils.isNotEmpty(cascadeAccounts)) {
                    for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                        OrgAccount parentAccount = orgAccountService.getOrgAccountById(cascadeAccount.getOrgId());
                        OrgInfo parentInfo = orgInfoDao.getOrgInfo(parentAccount.getId());
                        TXCascadeCredential credential =
                                txCascadeCredentialDao.getById(cascadeAccount.getCredentialId());
                        CampusAccountDto cascade =
                                makeCascadeDto(parentAccount, parentInfo, credential, cascadeAccount);
                        data.add(cascade);
                    }
                }
            }
        } else {
            // 不是第一页，校长帐号也未超过当前 curPageCount应当减校长帐号数量，得出上一次补全的子帐号offset位置
            pageDto.setCurPageCount(curPageCount - data.size());
            log.debug("getAccountList the 3pageDto is:{}", pageDto);
            data.clear();
            List<TXCascadeAccount> cascadeAccounts = txCascadeAccountDao.getByOrgIds(orgIds, pageDto);
            log.debug("getAccountList the cascadeAccounts is:{}", cascadeAccounts);
            if (CollectionUtils.isNotEmpty(cascadeAccounts)) {
                for (TXCascadeAccount cascadeAccount : cascadeAccounts) {
                    OrgAccount parentAccount = orgAccountService.getOrgAccountById(cascadeAccount.getOrgId());
                    OrgInfo parentInfo = orgInfoDao.getOrgInfo(parentAccount.getId());
                    TXCascadeCredential credential = txCascadeCredentialDao.getById(cascadeAccount.getCredentialId());
                    CampusAccountDto cascade = makeCascadeDto(parentAccount, parentInfo, credential, cascadeAccount);
                    data.add(cascade);
                }
            }
        }

        Integer count = txCascadeAccountDao.getCountByOrgIds(orgIds, null);
        log.debug("the length of orgIds is:{},the casAcc count is:{}", orgIds.size(), count);
        pageDto.setCount(count + orgIds.size());
        return data;
    }

    private CampusAccountDto makeCascadeDto(OrgAccount orgAccount, OrgInfo orgInfo, TXCascadeCredential credential,
                                            TXCascadeAccount cascadeAccount) {
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(cascadeAccount.getAccountType());//主管or员工
        dto.setCampusName(orgInfo.getShortName());//所属机构名
        dto.setCampusNumber(orgAccount.getNumber());//所属机构num
        TXAccount txAccount = txAccountDao.getByOrgId(orgAccount.getId());
        if (txAccount != null) {
            dto.setCampusType(CampusType.MASTER.getCode());
        } else {
            OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
            if (orgSubAccount != null) {
                dto.setCampusType(orgSubAccount.getAccountType());//总校 or 直营 or 加盟
                txAccount = txAccountDao.getByOrgId(orgSubAccount.getPid());
            }
        }
        dto.setName(credential.getName());//姓名
        dto.setMobile(credential.getMobile());//手机
        dto.setStatus(cascadeAccount.getStatus());//启用 or 停用
        dto.setTitle(cascadeAccount.getTitle());//职务字段
        dto.setCascadeId(cascadeAccount.getId());//子账号id
        Map<Integer, TxAccountPermission> txAccountPermissions =//得到这个子账户对应的权限集合 **** device为null意思是权限包括pc app,重复的code将被map过滤掉
                txAccountPermissionService.getPMapByUidLevelRoleDevice(cascadeAccount.getId(), txAccount.getVipLevel(), cascadeAccount.getAccountType(), null);
        List<TXPermission> Permissions =
                txPermissionService.getAllByPid(new ArrayList<Integer>(txAccountPermissions.keySet()));
        List<TXPermissionNodeDto> result = new ArrayList<>();
        for (TXPermission txPermission : Permissions) {
            TxAccountPermission txAccountPermission = txAccountPermissions.get(txPermission.getId());
            TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
            nodeDto.setCode(txPermission.getCode());
            nodeDto.setName(txPermission.getName());
            nodeDto.setType(txAccountPermission.getPType());
            result.add(nodeDto);
        }
        dto.setAuthList(result);
        return dto;
    }

    private CampusAccountDto makeSlaveDto(OrgAccount orgAccount, OrgInfo orgInfo, OrgSubAccount subAccount) {
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        dto.setCampusType(subAccount.getAccountType());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        dto.setName(orgInfo.getContacts());
        dto.setMobile(orgAccount.getMobile());
        dto.setStatus(subAccount.getStatus());
        dto.setTitle(CampusAccountType.SLAVE_PRINCIPAL.getLabel());
        log.debug("makeSlaveDto orgAccount is:{}", orgAccount);
        TXAccount txAccount = txAccountDao.getByOrgId(orgAccount.getId());
        log.debug("makeSlaveDto txAccount is:{}", txAccount);
        if (txAccount == null) {
            OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
            if (orgSubAccount != null) {
                txAccount = txAccountDao.getByOrgId(orgSubAccount.getPid());
            }
        }
        log.debug("makeSlaveDto txAccount is:{}", txAccount);
        Map<Integer, TxAccountPermission> txAccountPermissions =//得到这个子账户对应的权限集合 **** device为null意思是权限包括pc app,重复的code将被map过滤掉
                txAccountPermissionService.getPMapByUidLevelRoleDevice(null, txAccount.getVipLevel(), RoleType.BRANCH_SCH_PRESIDENT.type, null);
        List<TXPermission> Permissions =
                txPermissionService.getAllByPid(new ArrayList<Integer>(txAccountPermissions.keySet()));
        List<TXPermissionNodeDto> result = new ArrayList<>();
        for (TXPermission txPermission : Permissions) {
            TxAccountPermission txAccountPermission = txAccountPermissions.get(txPermission.getId());
            TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
            nodeDto.setCode(txPermission.getCode());
            nodeDto.setName(txPermission.getName());
            nodeDto.setType(txAccountPermission.getPType());
            result.add(nodeDto);
        }
        dto.setAuthList(result);
        return dto;
    }

    private CampusAccountDto makeMasterDto(OrgAccount orgAccount, OrgInfo orgInfo) {
        CampusAccountDto dto = new CampusAccountDto();
        dto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
        dto.setCampusType(CampusType.MASTER.getCode());
        dto.setCampusName(orgInfo.getShortName());
        dto.setCampusNumber(orgAccount.getNumber());
        dto.setName(orgInfo.getContacts());
        dto.setMobile(orgAccount.getMobile());
        dto.setTitle(CampusAccountType.MASTER_PRINCIPAL.getLabel());

        Map<Integer, TxAccountPermission> txAccountPermissions = null;
        //得到这个子账户对应的权限集合 **** device为null意思是权限包括pc app,重复的code将被map过滤掉

        TXAccount txAccount = txAccountDao.getByOrgId(orgAccount.getId());
        if (txAccount == null) {
            OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
            if (orgSubAccount != null) {
                txAccount = txAccountDao.getByOrgId(orgSubAccount.getPid());
                dto.setCampusType(orgSubAccount.getAccountType());
                dto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
                dto.setTitle(CampusAccountType.SLAVE_PRINCIPAL.getLabel());
                txAccountPermissions = txAccountPermissionService
                        .getPMapByUidLevelRoleDevice(null, txAccount.getVipLevel(), RoleType.BRANCH_SCH_PRESIDENT.type, null);
                dto.setStatus(orgSubAccount.getStatus());
            }
        } else {
            txAccountPermissions = txAccountPermissionService
                    .getPMapByUidLevelRoleDevice(null, txAccount.getVipLevel(), RoleType.PRESIDENT.type, null);
            dto.setStatus(CampusAccountStatus.NORMAL.getCode());
        }
        List<TXPermission> Permissions =
                txPermissionService.getAllByPid(new ArrayList<Integer>(txAccountPermissions.keySet()));
        List<TXPermissionNodeDto> result = new ArrayList<>();
        for (TXPermission txPermission : Permissions) {
            TxAccountPermission txAccountPermission = txAccountPermissions.get(txPermission.getId());
            TXPermissionNodeDto nodeDto = new TXPermissionNodeDto();
            nodeDto.setCode(txPermission.getCode());
            nodeDto.setName(txPermission.getName());
            nodeDto.setType(txAccountPermission.getPType());
            result.add(nodeDto);
        }
        dto.setAuthList(result);
        return dto;
    }

    public static void main(String[] args) {
        List<Integer> list = Lists.newArrayList();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        list.add(6);
        list = list.subList(5, list.size());
        System.out.println(list);
    }

    @Override
    public boolean addAccount(AddAccountRequest request) {
        TXAccount txAccount = txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId());
        if (txAccount == null) {
            throw new BussinessException(CommonErrorCode.SIGN_INVALIDATE);
        }
        List<Integer> orgIds = Lists.newArrayList();
        orgIds.add(TianxiaoPCContext.getOrgId());
        List<OrgSubAccount> subAccounts =
                orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
        if (CollectionUtils.isNotEmpty(subAccounts)) {
            for (OrgSubAccount subAccount : subAccounts) {
                orgIds.add(subAccount.getOrgId());
            }
        }
        boolean sendSms = false;
        Integer count = txCascadeAccountDao.getCountByOrgIds(orgIds);
        if ((count + 1) > +(txAccount.getCascadeAccountCount() - txAccount.getCampusCount())) {
            throw new BussinessException(CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
        }
        OrgAccount master = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        TXCascadeCredential credential = txCascadeCredentialDao.getByMobile(request.getMobile());
        if (credential == null) {
            credential = new TXCascadeCredential();
            credential.setCreateTime(new Date());
            credential.setMobile(request.getMobile());
            credential.setName(request.getName());
            OrgAccount credentialOrg = orgAccountService.getOrgAccountByMobile(request.getMobile());
            if (credentialOrg == null) {
                credential.setPassword(PasswordUtil.createHash(TXCascadeCredential.DEFAULT_PWD));
                sendSms = true;
            }
            txCascadeCredentialDao.save(credential);

        }
        TXCascadeAccount txCascadeAccount = new TXCascadeAccount();
        txCascadeAccount.setAccountType(request.getType());
        txCascadeAccount.setCreateTime(new Date());
        txCascadeAccount.setCredentialId(credential.getId());
        txCascadeAccount.setOrgId(master.getId());
        txCascadeAccount.setStatus(TXCascadeAccountStatus.VALID.getCode());
        txCascadeAccount.setTitle(request.getTitle());
        txCascadeAccountDao.save(txCascadeAccount);
        // 初始化权限
        TXAccount superAcc = this.findSuperTXAccount(txCascadeAccount);
        modPermission(txCascadeAccount, request, superAcc);

        boolean sendResult = false;
        if (sendSms) {
            try {
                sendResult = SmsSendUtil.sendSms(request.getMobile(),
                        TxSmsCodeType.getSmsMsg(TxSmsCodeType.NEW_ORG_PWD, TXCascadeCredential.DEFAULT_PWD),
                        SmsMessageType.TIANXIAO_NOTIFY.getCode(), TianxiaoPCContext.getOrgId(), UserRole.ORGANIZATION.getRole(), true, txAccountService.getTxAccountSmsGate(TianxiaoPCContext.getOrgId()));
            } catch (Throwable e) {
                log.error("send invite campus sms error:", e);
            }
            if (!sendResult) {
                log.error("send invite campus sms to :{} error:{}!code :{}", request.getMobile(), sendResult,
                        TXCascadeCredential.DEFAULT_PWD);
            } else {
                log.info("send default campus pwd sms to :{} error:{}!code :{}", request.getMobile(), sendResult,
                        TXCascadeCredential.DEFAULT_PWD);
            }
        }
        return sendResult;
    }

    @Override
    public void modAccount(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode(request.getType());
        switch (accountType) {
            case MASTER_PRINCIPAL://更改手机号码,姓名
                modMasterPrincipal(request);
                break;
            case SLAVE_PRINCIPAL://更改手机号码,姓名,校区名字
                modSlavePrincipal(request);
                break;
            case DIRECTOR:
                modDirector(request);
                break;
            case STAFF:
                modDirector(request);
                break;
            default:
                break;
        }
    }

    @Override
    public void delAccount(ModAccountRequest request) {
        if (request.getType().intValue() != CampusAccountType.DIRECTOR.getCode()
                && request.getType().intValue() != CampusAccountType.STAFF.getCode()) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "只能删除员工或主管!");
        }
        TXCascadeAccount cascadeAccount = txCascadeAccountDao.getById(request.getCascadeId());
        OrgAccount orgAccount = orgAccountDao.getAccountById(cascadeAccount.getOrgId());
        try {
            releaseConsulter(cascadeAccount.getId().longValue());
            // 释放班主任
            orgCourseDao.batchUpdateHeadTeacher(orgAccount.getNumber(), cascadeAccount.getId(), -1);
        } catch (Exception e) {
            log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", cascadeAccount.getId());
            log.error("modDirectorStatus - releaseConsulter - error:{}", e);
            throw new BusinessException("释放线索失败，可尝试手动清空账号线索后再进行此操作。");
        }
        txCascadeAccountDao.deleteById(request.getCascadeId());
    }

    private void modMasterPrincipal(ModAccountRequest request) {
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (StringUtils.isNotBlank(request.getMobile()) && !orgAccount.getMobile().equals(request.getMobile())) {
            if (StringUtils.isBlank(request.getCode())) {
                throw new BussinessException(SMSErrorCode.CODE_INVALID);
            }
            //这里校验验证码
            if (!VerifyCodeUtil.valid(false, orgAccount.getMobile(), request.getCode(),
                    TxSmsCodeType.MOD_ORG_MOBILE.getCacheKey())) {
                throw new BussinessException(SMSErrorCode.CODE_INVALID);
            }
            orgAccount.setMobile(request.getMobile());
            orgAccountDao.update(orgAccount);
            OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
            orgSubAccount.setAccountVersion(orgSubAccount.getAccountVersion() + 1);
            orgSubAccountService.update(orgSubAccount);
        }

        if (StringUtils.isNotBlank(request.getName())) {
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
            orgInfo.setContacts(request.getName());
            orgInfoDao.update(orgInfo);
        }
    }

    /**
     * @param request
     */

    private void modSlavePrincipal(ModAccountRequest request) {
        if (request.getCampusNumber() == null || StringUtils.isEmpty(request.getCampusName())) {
            throw new BussinessException(CommonErrorCode.REQUIRE_PARAM);
        }
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (orgAccount != null) {
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgAccount.getId());
            orgInfo.setShortName(request.getCampusName());
            orgInfo.setContacts(request.getName());
            orgInfo.setUpdateTime(new Date());
            orgInfoDao.update(orgInfo);
        } else {
            throw new BussinessException(CommonErrorCode.REQUIRE_PARAM);
        }
        if (!request.getMobile().equals(orgAccount.getMobile())) {
            OrgSubAccount orgSubAccount =
                    orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
            if (orgSubAccount != null) {
                if (orgSubAccount.getAccountType().intValue() == CampusType.LEAGUE.getCode()) {
                    throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "加盟分校不支持修改电话，请联系师资");
                }
                OrgAccount temp = orgAccountService.getOrgAccountByMobile(request.getMobile());
                if (temp != null) {
                    throw new BussinessException(CrmErrorCode.MOBILE_EXIST);
                }
                orgAccount.setMobile(request.getMobile());
                orgAccount.setUpdateTime(new Date());
                orgAccountDao.update(orgAccount);
                orgSubAccount.setAccountVersion(orgSubAccount.getAccountVersion() + 1);
                orgSubAccountService.update(orgSubAccount);
            }
        }
    }

    /**
     * @param request
     */
    private void modDirector(ModAccountRequest request) {
        if (request.getCampusNumber() == null || request.getCascadeId() == null) {
            throw new BussinessException(CommonErrorCode.REQUIRE_PARAM);
        }
        TXCascadeAccount cascadeAccount = txCascadeAccountDao.getById(request.getCascadeId());
        TXCascadeCredential credential = txCascadeCredentialDao.getById(cascadeAccount.getCredentialId());
        if (cascadeAccount == null || credential == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());
        if (cascadeAccount.getOrgId().intValue() != orgAccount.getId()) {//所属机构有变动
            try {
                releaseConsulter(cascadeAccount.getId().longValue());
                // 释放班主任
                orgCourseDao.batchUpdateHeadTeacher(orgAccountDao.getById(cascadeAccount.getOrgId()).getNumber(), cascadeAccount.getId(), -1);
            } catch (Exception e) {
                log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", cascadeAccount.getId());
                log.error("modDirectorStatus - releaseConsulter - error:{}", e);
                throw new BusinessException("释放线索失败，可尝试手动清空账号线索后再进行此操作。");
            }
            cascadeAccount.setOrgId(orgAccount.getId());
        }
        cascadeAccount.setTitle(request.getTitle());
        cascadeAccount.setUpdateTime(new Date());
        cascadeAccount.setAccountVersion(cascadeAccount.getAccountVersion() + 1);
        txCascadeAccountDao.update(cascadeAccount);
        if (!credential.getMobile().equals(request.getMobile())) {//手机号码有变动
            TXCascadeCredential temp = txCascadeCredentialDao.getByMobile(request.getMobile());
            if (temp == null) {
                credential.setName(request.getName());
                credential.setUpdateTime(new Date());
                credential.setMobile(request.getMobile());

                OrgAccount credentialOrg = orgAccountService.getOrgAccountByMobile(request.getMobile());
                if (credentialOrg == null) {
                    credential.setPassword(PasswordUtil.createHash(TXCascadeCredential.DEFAULT_PWD));
                    boolean sendResult = false;
                    try {
                        sendResult = SmsSendUtil.sendSms(request.getMobile(),
                                TxSmsCodeType.getSmsMsg(TxSmsCodeType.NEW_CASCADE_PWD, TXCascadeCredential.DEFAULT_PWD),
                                SmsMessageType.TIANXIAO_NOTIFY.getCode(), TianxiaoPCContext.getOrgId(), UserRole.ORGANIZATION.getRole(), true, txAccountService.getTxAccountSmsGate(TianxiaoPCContext.getOrgId()));
                    } catch (Throwable e) {
                        log.error("send invite campus sms error:", e);
                    }
                    if (!sendResult) {
                        log.error("send invite campus sms to :{} error:{}!code :{}", request.getMobile(), sendResult,
                                TXCascadeCredential.DEFAULT_PWD);
                    } else {
                        log.info("send default campus pwd sms to :{} error:{}!code :{}", request.getMobile(), sendResult,
                                TXCascadeCredential.DEFAULT_PWD);
                    }
                }

                txCascadeCredentialDao.update(credential);
                txCascadeAccountDao.update(cascadeAccount);
            } else {
                temp.setName(request.getName());
                temp.setUpdateTime(new Date());
                txCascadeCredentialDao.update(temp);
                cascadeAccount.setCredentialId(temp.getId());
                cascadeAccount.setUpdateTime(new Date());
                cascadeAccount.setAccountVersion(cascadeAccount.getAccountVersion() + 1);
                txCascadeAccountDao.update(cascadeAccount);
            }
        } else {
            credential.setName(request.getName());
            credential.setUpdateTime(new Date());
            txCascadeCredentialDao.update(credential);
        }
        TXAccount superAcc = findSuperTXAccount(cascadeAccount);
        // 修改权限
        modPermission(cascadeAccount, request, superAcc);
        modAccountType(cascadeAccount, request);
    }

    private TXAccount findSuperTXAccount(TXCascadeAccount cascadeAccount) {
        OrgSubAccount subAcc = orgSubAccountService.getByOrgId(cascadeAccount.getOrgId());
        if (subAcc.getPid() == 0) {
            return txAccountDao.getByOrgId(subAcc.getOrgId());
        } else {
            return txAccountDao.getByOrgId(subAcc.getPid());
        }
    }

    /**
     * @param cascadeAccount
     * @param request
     */
    private void modAccountType(TXCascadeAccount cascadeAccount, ModAccountRequest request) {
        if (cascadeAccount.getAccountType().intValue() == request.getType()) {
            return;
        }
        if (request.getType() == CampusAccountType.DIRECTOR.getCode().intValue()) {
            cascadeAccount.setAccountType(request.getType());
            txCascadeAccountDao.update(cascadeAccount);
        }
        if (request.getType() == CampusAccountType.STAFF.getCode().intValue()) {
            cascadeAccount.setAccountType(request.getType());
            txCascadeAccountDao.update(cascadeAccount);
        }
    }

    /**
     * @param cascadeAccount
     * @param request
     */
    private void modPermission(TXCascadeAccount cascadeAccount, AddAccountRequest request, TXAccount superAcc) {
        List<TxAccountPermission> txAccountPermissions =//所有的权限 包括pc app
                txAccountPermissionService.getAllPByUidLevelRoleDevice(null, superAcc.getVipLevel(), cascadeAccount.getAccountType(), null);
        List<TXPermissionNodeDto> subAuths = request.getAuthList();//前端请求更改的内容
        Map<Long, TXPermission> allPCodeMap = txPermissionService.getAllTXPermissionsCodeMap();
        Map<Long, Integer> pCodeTypeMap = Maps.newHashMap();
        for (TXPermissionNodeDto nodeDto : subAuths) {//先把前端给的权限拥有情况保存到map中
            pCodeTypeMap.put(allPCodeMap.get(nodeDto.getCode()).getCode(), nodeDto.getType());
        }
//        Map<Long, Integer> tempMap = Maps.newHashMap();//一对多的特殊逻辑开始
//        for (Long pCode : pCodeTypeMap.keySet()) {
//            List<Long> linkedCodes = new ArrayList<Long>(TXPermissionConst.ONE_MULTY_CODE_MAP.get(pCode));
//            if (CollectionUtils.isNotEmpty(linkedCodes)) {
//                Integer pType = pCodeTypeMap.get(pCode);
//                for (Long sub : linkedCodes) {
//                    tempMap.put(sub, pType);
//                }
//            }
//        }
//        for (Long sub : tempMap.keySet()) {
//            pCodeTypeMap.put(sub, tempMap.get(sub));
//        }//一对多的特殊逻辑done!
        //特殊逻辑开始
        specialTypeOperate(pCodeTypeMap, cascadeAccount);
        //特殊逻辑结束
        log.debug("the frontEnd param length is {}", pCodeTypeMap.size());
        Map<Integer, TxAccountPermission> pcMap = Maps.newHashMap();//更新查询出来的权限开始
        Map<Integer, TxAccountPermission> appMap = Maps.newHashMap();
        for (TxAccountPermission txAccountPermission : txAccountPermissions) {
            if (txAccountPermission.getDeviceType() == DeviceType.APP.getCode()) {
                appMap.put(txAccountPermission.getPId(), txAccountPermission);
            }
            if (txAccountPermission.getDeviceType() == DeviceType.PC.getCode()) {
                pcMap.put(txAccountPermission.getPId(), txAccountPermission);
            }
        }
        Map<Integer, TXPermission> allPIdMap = txPermissionService.getAllTXPermissionsIDMap();
        Integer pTypeTemp;
        for (TXPermission txPermission : allPIdMap.values()) {
            // pc
            TxAccountPermission pc = pcMap.get(txPermission.getId());
            if ((pTypeTemp = pCodeTypeMap.get(txPermission.getCode())) != null)
                pc.setPType(pTypeTemp);
            // app
            TxAccountPermission app = appMap.get(txPermission.getId());
            if ((pTypeTemp = pCodeTypeMap.get(txPermission.getCode())) != null)
                app.setPType(pTypeTemp);
        }//更新查询出来的权限结束
        List<TxAccountPermission> ownedPList = txAccountPermissionDao.listAllConfigs(null, null, cascadeAccount.getId(), TXPermissionAccountType.CASCADE_ACCOUNT.getCode());
        Map<String, TxAccountPermission> ownedPMap = Maps.newHashMap();
        for (TxAccountPermission tap : ownedPList) {
            if (tap.getDeviceType().equals(DeviceType.PC.getCode())) {
                ownedPMap.put("pc_" + tap.getPId(), tap);
            } else if (tap.getDeviceType().equals(DeviceType.APP.getCode())) {
                ownedPMap.put("app_" + tap.getPId(), tap);
            }
        }//得到了数据库中已经有的集合
        log.debug("the owned permission set size is:{}", ownedPMap.size());
        List<TxAccountPermission> updatePermissions = Lists.newArrayList();
        List<TxAccountPermission> savePermissions = Lists.newLinkedList();
        for (TxAccountPermission tap : txAccountPermissions) {
            if (tap.getDeviceType().equals(DeviceType.PC.getCode())) {
                if (ownedPMap.containsKey("pc_" + tap.getPId())) {
                    TxAccountPermission temp = ownedPMap.get("pc_" + tap.getPId());
                    temp.setPType(pCodeTypeMap.get(allPIdMap.get(tap.getPId()).getCode()));
                    updatePermissions.add(temp);
                } else {
                    tap.setCreateTime(new Date());//补全信息
                    tap.setUId(cascadeAccount.getId());
                    tap.setUpdateTime(new Date());
                    savePermissions.add(tap);
                }
            } else if (tap.getDeviceType().equals(DeviceType.APP.getCode())) {
                if (ownedPMap.containsKey("app_" + tap.getPId())) {
                    TxAccountPermission temp = ownedPMap.get("app_" + tap.getPId());
                    temp.setPType(pCodeTypeMap.get(allPIdMap.get(tap.getPId()).getCode()));
                    updatePermissions.add(temp);
                } else {
                    tap.setCreateTime(new Date());//补全信息
                    tap.setUId(cascadeAccount.getId());
                    tap.setUpdateTime(new Date());
                    savePermissions.add(tap);
                }
            }
        }
        log.debug("the update permission list size is:{}", updatePermissions.size());
        txAccountPermissionService.updateAll(updatePermissions);

        /*控制保存指定的权限*/
        log.debug("before pick save permission list size is:{}", savePermissions.size());
        pickPermissions(savePermissions, TXPermissionConst.PERMISSION_SAVE_CONTROL_SET, allPIdMap);

        log.debug("the save permission set size is:{}", savePermissions.size());
        txAccountPermissionService.saveAll(savePermissions);
    }

    private void pickPermissions(List<TxAccountPermission> savePermissions, Set<Long> ControlSet, Map<Integer, TXPermission> allPIdMap) {
        Iterator<TxAccountPermission> iter = savePermissions.iterator();
        while (iter.hasNext()) {
            if (!ControlSet.contains(allPIdMap.get(iter.next().getPId()).getCode())) {
                iter.remove();
            }
        }
    }

    /**
     * nodeDto中code可能对应多个code，有些code的权限，和角色相关
     * 如果你看到这里看不懂，是正常的
     * 先找pm周希，了解app界面上，不同角色，拥有不同操作权限，但操作权限，是由后端决定。
     *
     * @param pTypeMap
     * @param cascadeAccount
     */
    private void specialTypeOperate(Map<Long, Integer> pTypeMap, TXCascadeAccount cascadeAccount) {
        Map<Long, Integer> tempMap = Maps.newHashMap();
        for (Long pCode : pTypeMap.keySet()) {
            if (pCode.equals(TXPermissionConst.IF_CLASS_ARRANGE.getpCode()) && pTypeMap.get(pCode).equals(TXPermissionHasType.OWN.getCode())) {
                if (cascadeAccount.getAccountType() == CascadeType.MANAGER.getValue()) {
                    tempMap.put(pCode, TXPermissionHasType.OWN.getCode());
                }
                if (cascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                    tempMap.put(pCode, TXPermissionHasType.LOST.getCode());
                }
            } else if (pCode == TXPermissionConst.SHOW_ENTER_CLASS_SCHEDULE.getpCode() && pTypeMap.get(pCode).equals(TXPermissionHasType.OWN.getCode())) {
                if (cascadeAccount.getAccountType() == CascadeType.MANAGER.getValue()) {
                    tempMap.put(pCode, TXPermissionHasType.OWN.getCode());
                }
                if (cascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                    tempMap.put(pCode, TXPermissionHasType.LOST.getCode());
                }
            }
        }//pick done
        for (Long pCode : tempMap.keySet()) {
            pTypeMap.put(pCode, tempMap.get(pCode));
        }//put done
    }

    @Override
    public void modAccountStatus(ModAccountRequest request) {
        CampusAccountType accountType = CampusAccountType.getTypeByCode(request.getType());
        switch (accountType) {
            case SLAVE_PRINCIPAL:
                modSlavePrincipalStatus(request);
                break;
            case DIRECTOR:
                modDirectorStatus(request);
                break;
            case STAFF:
                modDirectorStatus(request);
                break;
            default:
                break;
        }
    }

    /**
     * @param request
     */

    private void modSlavePrincipalStatus(ModAccountRequest request) {
        OrgAccount orgAccount = orgAccountService.getOrgAccountByNumber(request.getCampusNumber());

        OrgSubAccount subAccount =
                orgSubAccountService.getSlaveIgnoreStatus(orgAccount.getId(), TianxiaoPCContext.getOrgId());
        if (request.getStatus().intValue() == OrgSubAccountStatus.NORMAL.getCode()) {
            OrgSubAccount mainAcc = orgSubAccountService.getMaster(orgAccount.getId());
            if (null != mainAcc) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "该账号已经独立开通天校账号,无法启用");
            }
            subAccount.setStatus(request.getStatus());
            subAccount.setUpdateTime(new Date());
            orgSubAccountService.update(subAccount);
            addToHag(orgAccount.getNumber());
        }
        if (request.getStatus().intValue() == OrgSubAccountStatus.FIRE.getCode()) {
            subAccount.setStatus(request.getStatus());
            subAccount.setFireTime(new Date());
            subAccount.setUpdateTime(new Date());
            subAccount.setAccountVersion(subAccount.getAccountVersion() + 1);
            orgSubAccountService.update(subAccount);
            delInHag(orgAccount.getNumber());
        }
    }

    private void delInHag(Integer orgNumber) {
        log.info("del hag orgNumber:{}", orgNumber);
        if (orgNumber == null) {
            return;
        }
        List<Entity> entities = Lists.newArrayList();
        Entity entity = new Entity();
        entity.setName(orgNumber);
        entities.add(entity);
        // 天校白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result1 =
                hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                        PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER);
        log.info("del hag {} in {} result:{}", orgNumber, BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER, result1);
        // 3810白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result2 =
                hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                        PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURCE_PYXIS_ORG_NUMBER);
        log.info("del hag {} in {} result:{}", orgNumber, BizConf.HAG_RESOURCE_PYXIS_ORG_NUMBER, result2);
        // 每日提现白名单
        com.baijia.yunying.hag.common.web.WebResponse<String> result3 =
                hagService.delEntitiesOfResource(Long.valueOf(PropertiesReader.getValue("hag", "hag.token.id")),
                        PropertiesReader.getValue("hag", "hag.token"), entities, BizConf.HAG_RESOURSE_ORG_TIXIAN_NUMBER);
        log.info("del hag {} in {} result:{}", orgNumber, BizConf.HAG_RESOURSE_ORG_TIXIAN_NUMBER, result3);
    }

    /**
     * @param request
     */

    private void modDirectorStatus(ModAccountRequest request) {
        // 控制启用的总量
        TXAccount txAccount = txAccountDao.getByOrgId(TianxiaoPCContext.getOrgId());
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode()) {
            if (txAccount == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "账户不存在");
            }
            List<Integer> orgIds = Lists.newArrayList();
            orgIds.add(TianxiaoPCContext.getOrgId());
            List<OrgSubAccount> subAccounts =
                    orgSubAccountService.getSlavesIgnoreStatus(TianxiaoPCContext.getOrgId(), null);
            if (CollectionUtils.isNotEmpty(subAccounts)) {
                for (OrgSubAccount subAccount : subAccounts) {
                    orgIds.add(subAccount.getOrgId());
                }
            }
            Integer count = txCascadeAccountDao.getCountByOrgIds(orgIds);
            if ((count + 1) > +(txAccount.getCascadeAccountCount() - txAccount.getCampusCount())) {
                throw new BussinessException(CrmErrorCode.EXCESS_CASCADE_ACCOUNT_COUNT);
            }
        }
        TXCascadeAccount cascadeAccount = txCascadeAccountDao.getById(request.getCascadeId());
        if (request.getStatus().intValue() == TXCascadeAccountStatus.VALID.getCode()
                || request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode()) {
            cascadeAccount.setStatus(request.getStatus());
            cascadeAccount.setAccountVersion(cascadeAccount.getAccountVersion() + 1);
            txCascadeAccountDao.update(cascadeAccount);

            //释放班主任
            if (request.getStatus().intValue() == TXCascadeAccountStatus.PAUSE.getCode()) {
                try {
                    releaseConsulter(cascadeAccount.getId().longValue());

                    // 释放班主任
                    orgCourseDao.batchUpdateHeadTeacher(txAccount.getOrgNumber(), cascadeAccount.getId(), -1);
                } catch (Exception e) {
                    log.error("modDirectorStatus - releaseConsulter - cascadeAccount:{}", cascadeAccount.getId());
                    log.error("modDirectorStatus - releaseConsulter - error:{}", e);
                    throw new BusinessException("释放线索失败，可尝试手动清空账号线索后再进行此操作。");
                }
            }
        }
    }


    /**
     * @Description : 释放指定账号的线索
     * @Author : zhenyujian
     * @Date : 2016年6月22日 下午3:40:13
     * @Return : void
     */
    public void releaseConsulter(Long cascadeId) {

        Date now = new Date();
        List<Long> consulterIds = consultUserDao.listConsulterUserIdsByCascade(cascadeId);
        log.info("modAccountStatus - consulter - Release - consulterIds:{}, size:{},time:{}", consulterIds,
                consulterIds.size(), now.getTime());

        if (CollectionUtils.isNotEmpty(consulterIds)) {
            // 释放线索
            consultUserDao.release(consulterIds, now);

            List<TxConsulterOperationLog> manualLogs = new ArrayList<TxConsulterOperationLog>();
            TxConsulterOperationLog log;
            for (int i = 0; i > consulterIds.size(); i++) {
                // 添加操作记录
                log = new TxConsulterOperationLog(consulterIds.get(i), Flag.NULL.getLong(), Flag.NULL.getLong(),
                        ConsulterOperation.PUSH_MANUAL);
                manualLogs.add(log);
                if (i % 100 == 0 || i == consulterIds.size() - 1) {// 每100条 批量插入
                    txConsulterOperationLogDao.saveAll(manualLogs);
                }
            }
        }
    }

    @Deprecated//权限不一致时搞的补数据方法,看着碍事儿可以删掉. 其他人不要用  by hongyan
    @Transactional(rollbackFor = Exception.class)
    public void enter(Integer orgNumber) throws Exception {
        TXAccount superAcc = txAccountDao.getByOrgNumber(orgNumber);
        Preconditions.checkNotNull(superAcc);
        log.info("the superAcc is:{}", superAcc);
        this.fixData(superAcc);
    }

    @Deprecated//权限不一致时搞的补数据方法 同上
    private void fixData(TXAccount superAcc) throws Exception {
        int i = 0;
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(1);
        pageDto.setPageSize(999);
        OrgAccount orgAccount = orgAccountDao.getById(superAcc.getOrgId());
        Preconditions.checkNotNull(superAcc);
        log.info("find orgAccount done! account is:{}", orgAccount);
        List<CampusAccountDto> before = getAccountList(orgAccount, pageDto, true);
        log.info("找到了子帐号 共:{}个", before.size());
        for (CampusAccountDto dto : before) {
            if (dto.getType() == 3 || dto.getType() == 4) {
                TXCascadeAccount cascadeAccount = txCascadeAccountDao.getById(dto.getCascadeId());
                Preconditions.checkNotNull(cascadeAccount);
                AddAccountRequest request = new AddAccountRequest();
                request.setName(dto.getName());
                request.setCampusNumber(dto.getCampusNumber());
                request.setMobile(dto.getMobile());
                request.setTitle(dto.getTitle());
                request.setType(dto.getType());
                request.setAuthList(dto.getAuthList());
                modPermission(cascadeAccount, request, superAcc);
                log.info("更新了{}个!", i++);
            }
        }
        log.info("done!");
    }
}
