/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.assignment.sal.webchat.service.impl;

import com.baijia.doorgod.dao.DoorGodClientDao;
import com.baijia.doorgod.dao.DoorGodUserDao;
import com.baijia.doorgod.po.DoorGodClient;
import com.baijia.doorgod.po.DoorGodUser;
import com.baijia.tianxiao.assignment.common.enums.AssignmentErrorCode;
import com.baijia.tianxiao.assignment.common.enums.GradeSelectType;
import com.baijia.tianxiao.assignment.common.enums.GradeStudentStatus;
import com.baijia.tianxiao.assignment.common.enums.GradeSwitch;
import com.baijia.tianxiao.assignment.common.errorcode.UniverseErrorCode;
import com.baijia.tianxiao.assignment.common.exception.BusinessException;
import com.baijia.tianxiao.assignment.common.model.BaseLoginUser;
import com.baijia.tianxiao.assignment.common.util.BaseLoginUtil;
import com.baijia.tianxiao.assignment.common.util.BaseUtils;
import com.baijia.tianxiao.assignment.common.util.MD5Utils;
import com.baijia.tianxiao.assignment.dal.grade.dao.GradeDao;
import com.baijia.tianxiao.assignment.dal.grade.dao.GradeStudentDao;
import com.baijia.tianxiao.assignment.dal.grade.dto.StudentGradeListDto;
import com.baijia.tianxiao.assignment.dal.grade.po.Grade;
import com.baijia.tianxiao.assignment.dal.grade.po.GradeStudent;
import com.baijia.tianxiao.assignment.sal.thirdpart.dto.OrgInfo;
import com.baijia.tianxiao.assignment.sal.thirdpart.service.OrgInfoService;
import com.baijia.tianxiao.assignment.sal.webchat.dto.grade.GradeQueryResultDto;
import com.baijia.tianxiao.assignment.sal.webchat.dto.grade.StudentGradeDetailDto;
import com.baijia.tianxiao.assignment.sal.webchat.enums.DoorgodUserRole;
import com.baijia.tianxiao.assignment.sal.webchat.service.QueryGradeService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.VerifyCodeUtil;
import com.beust.jcommander.internal.Lists;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QueryGradeServiceImpl
implements QueryGradeService {
    private static final Logger log = LoggerFactory.getLogger(QueryGradeServiceImpl.class);
    @Resource
    private GradeDao gradeDao;
    @Resource
    private GradeStudentDao gradeStudentDao;
    @Resource
    private DoorGodUserDao doorGodUserDao;
    @Resource
    private DoorGodClientDao doorGodClientDao;
    @Resource
    private OrgInfoService orgInfoService;

    @Override
    public List<StudentGradeListDto> list(BaseLoginUser user, PageDto pageDto) {
        log.debug("[user list]--------[user id]={}", (Object)user.getUserId());
        return this.gradeDao.listStudentGrade(user.getUserId(), GradeSwitch.ON.getStatus(), pageDto);
    }

    @Override
    public StudentGradeDetailDto detail(String studentGradeId) {
        Integer id = Integer.parseInt(MD5Utils.JM((String)studentGradeId));
        GradeStudent gs = (GradeStudent)this.gradeStudentDao.getById((Serializable)id, new String[0]);
        if (gs == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u5b66\u751f\u6210\u7ee9\u4e0d\u5b58\u5728");
        }
        Grade g = this.getGrade(gs.getGradeId());
        DoorGodUser dgu = (DoorGodUser)this.doorGodUserDao.getById((Serializable)gs.getUserId(), new String[0]);
        StudentGradeDetailDto dto = new StudentGradeDetailDto();
        dto.setScore(gs.getScore());
        dto.setComment(gs.getComment());
        dto.setGradeName(g.getName());
        dto.setRank(gs.getRank());
        dto.setStudentName(dgu.getUserName());
        dto.setHeadUrl(dgu.getCover());
        OrgInfo orgInfo = this.orgInfoService.getOrgInfo(BaseLoginUtil.getCurrentUser().getOrgId(), Long.valueOf(0L));
        dto.setOrgName(orgInfo.getOrgName());
        gs.setStatus(Integer.valueOf(GradeStudentStatus.READ.getStatus()));
        gs.setSearchTime(new Date());
        this.gradeStudentDao.update((Object)gs, new String[]{"status", "searchTime"});
        return dto;
    }

    @Override
    @Transactional
    public List<GradeQueryResultDto> query(Long gradeId, String mobile, String code, String name) {
        Grade g = this.getGrade(gradeId);
        if (g.getStartTime().getTime() > new Date().getTime()) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u672a\u5230\u5f00\u542f\u67e5\u8be2\u65f6\u95f4\uff0c\u4e0d\u5f97\u67e5\u8be2");
        }
        if (g.getEndTime().getTime() < new Date().getTime()) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u5df2\u8fc7\u622a\u6b62\u67e5\u8be2\u65f6\u95f4\uff0c\u4e0d\u5f97\u67e5\u8be2");
        }
        List<DoorGodUser> users = GradeSelectType.MOBILE.getStatus() == g.getType().intValue() ? this.searchByMobile(g.getClientId(), mobile, code) : this.searchByName(g.getClientId(), name);
        if (CollectionUtils.isEmpty(users)) {
            return null;
        }
        Map doorGodUserMap = BaseUtils.listToMap(users, (String)"id");
        Set doorGodUserIds = BaseUtils.getPropertiesList(users, (String)"id");
        List gradeStudents = this.gradeStudentDao.getByGradeIdAndUserIds(gradeId, doorGodUserIds);
        return this.bulidQueryResult(doorGodUserMap, gradeStudents);
    }

    private List<DoorGodUser> searchByMobile(Long clientId, String mobile, String code) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        if (!VerifyCodeUtil.valid((boolean)true, (String)mobile, (String)code, (String)"tx:hw:grade_")) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        List result = this.doorGodUserDao.getUsersByNameOrMobile(clientId, null, mobile);
        VerifyCodeUtil.delete((boolean)true, (String)mobile, (String)code, (String)"tx:hw:grade_");
        return result;
    }

    private List<DoorGodUser> searchByName(Long clientId, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u5b66\u751f\u59d3\u540d\u4e3a\u7a7a");
        }
        List result = this.doorGodUserDao.getUsersByNameOrMobile(clientId, name, null);
        return result;
    }

    private List<GradeQueryResultDto> bulidQueryResult(Map<Long, DoorGodUser> doorGodUserMap, List<GradeStudent> gradeStudents) {
        List list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(gradeStudents)) {
            return list;
        }
        for (GradeStudent gs : gradeStudents) {
            GradeQueryResultDto dto = new GradeQueryResultDto();
            dto.setStudentGradeId(MD5Utils.KL((String)String.valueOf(gs.getId())));
            DoorGodUser user = doorGodUserMap.get(gs.getUserId());
            dto.setName(user.getUserName());
            dto.setMobile(user.getUserMobile().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
            dto.setHeadUrl(user.getCover());
            list.add(dto);
        }
        return list;
    }

    @Override
    public StudentGradeListDto readyToQuery(Long gradeId) {
        Grade g = this.getGrade(gradeId);
        StudentGradeListDto dto = new StudentGradeListDto();
        dto.setName(g.getName());
        dto.setStartTime(g.getStartTime());
        dto.setEndTime(g.getEndTime());
        dto.setType(g.getType());
        DoorGodUser user = this.doorGodUserDao.getUserByParams(g.getClientId(), Long.valueOf(0L), DoorgodUserRole.STAFF.getRole());
        DoorGodClient client = (DoorGodClient)this.doorGodClientDao.getById((Serializable)user.getClientId(), new String[0]);
        OrgInfo orgInfo = this.orgInfoService.getOrgInfo(client.getOrgId(), Long.valueOf(0L));
        dto.setOrgName(orgInfo.getOrgName());
        dto.setLogo(orgInfo.getLogo());
        return dto;
    }

    public Grade getGrade(Long gradeId) {
        Grade g = (Grade)this.gradeDao.getById((Serializable)gradeId, new String[0]);
        if (g == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u6210\u7ee9\u4e0d\u5b58\u5728");
        }
        return g;
    }
}

