/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.assignment.sal.webchat.service.impl;

import com.baijia.tianxiao.assignment.common.enums.AssignmentErrorCode;
import com.baijia.tianxiao.assignment.common.enums.ClientType;
import com.baijia.tianxiao.assignment.common.enums.CorrectStatus;
import com.baijia.tianxiao.assignment.common.enums.HomeworkCompletedStatus;
import com.baijia.tianxiao.assignment.common.enums.HomeworkStatus;
import com.baijia.tianxiao.assignment.common.enums.QuestionCompletedStatus;
import com.baijia.tianxiao.assignment.common.enums.QuestionType;
import com.baijia.tianxiao.assignment.common.errorcode.UniverseErrorCode;
import com.baijia.tianxiao.assignment.common.exception.BusinessException;
import com.baijia.tianxiao.assignment.common.model.BaseLoginUser;
import com.baijia.tianxiao.assignment.common.util.BaseUtils;
import com.baijia.tianxiao.assignment.dal.homework.dao.HomeworkListDao;
import com.baijia.tianxiao.assignment.dal.homework.dao.HomeworkQuestionDao;
import com.baijia.tianxiao.assignment.dal.homework.dao.HomeworkStudentAnswerDao;
import com.baijia.tianxiao.assignment.dal.homework.dao.HomeworkStudentDao;
import com.baijia.tianxiao.assignment.dal.homework.dto.HomeworkListRespDto;
import com.baijia.tianxiao.assignment.dal.homework.po.Homework;
import com.baijia.tianxiao.assignment.dal.homework.po.HomeworkQuestion;
import com.baijia.tianxiao.assignment.dal.homework.po.HomeworkStudent;
import com.baijia.tianxiao.assignment.dal.homework.po.HomeworkStudentAnswer;
import com.baijia.tianxiao.assignment.dal.question.dao.QuestionDao;
import com.baijia.tianxiao.assignment.dal.question.po.Question;
import com.baijia.tianxiao.assignment.sal.webchat.dto.ImageDto;
import com.baijia.tianxiao.assignment.sal.webchat.dto.QuestionAnswerDto;
import com.baijia.tianxiao.assignment.sal.webchat.dto.ReadyExamDto;
import com.baijia.tianxiao.assignment.sal.webchat.dto.getallquestions.HomeworkStudentInfoDto;
import com.baijia.tianxiao.assignment.sal.webchat.dto.getallquestions.QuestionDetailDto;
import com.baijia.tianxiao.assignment.sal.webchat.dto.getallquestions.QuestionTypeDto;
import com.baijia.tianxiao.assignment.sal.webchat.dto.getallquestions.QuestionsToAnswerDto;
import com.baijia.tianxiao.assignment.sal.webchat.service.DoHomeworkService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.SerializeUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DoHomeworkServiceImpl
implements DoHomeworkService {
    private static final Logger log = LoggerFactory.getLogger(DoHomeworkServiceImpl.class);
    @Autowired
    private QuestionDao questionDao;
    @Autowired
    private HomeworkListDao homeworkListDao;
    @Autowired
    private HomeworkStudentDao homeworkStudentDao;
    @Autowired
    private HomeworkQuestionDao homeworkQuestionDao;
    @Autowired
    private HomeworkStudentAnswerDao homeworkStudentAnswerDao;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Override
    public List<HomeworkListRespDto> getHomeworkList(BaseLoginUser user, PageDto pageDto) {
        List dtos = this.homeworkListDao.getHomeworkListRespDto(user.getId(), Integer.valueOf(HomeworkStatus.PUBLISHED.getStatus()), user.getClientType(), pageDto);
        return dtos;
    }

    @Override
    public long submitQuestions(BaseLoginUser user, QuestionAnswerDto questionAnswerDto) {
        HomeworkStudent homeworkStudent = (HomeworkStudent)this.homeworkStudentDao.getById((Serializable)Long.valueOf(questionAnswerDto.getHomeworkStudentId()), new String[0]);
        if (homeworkStudent == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u5b66\u751f\u4f5c\u4e1a\u4e0d\u5b58\u5728");
        }
        if (homeworkStudent.getUserId().longValue() != user.getId().longValue()) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u4f5c\u4e1a");
        }
        if (homeworkStudent.getStatus().intValue() != HomeworkCompletedStatus.UNCOMPLETED.getStatus()) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u4f5c\u4e1a\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u518d\u7b54\u9898");
        }
        Question question = this.questionDao.getQuestionById(questionAnswerDto.getQuestionId());
        if (question == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u8bd5\u9898\u4e0d\u80fd\u5b58\u5728");
        }
        HomeworkStudentAnswer answer = this.homeworkStudentAnswerDao.getStudentHomework(homeworkStudent.getId().longValue(), question.getId().longValue());
        if (answer == null) {
            byte[] answerBytes = this.getContent("tx:hw:TIANXIAO_HOMEWORK_" + homeworkStudent.getId() + question.getId());
            if (answerBytes != null) {
                return -1L;
            }
            answer = new HomeworkStudentAnswer();
            this.saveContent("tx:hw:TIANXIAO_HOMEWORK_" + homeworkStudent.getId() + question.getId(), SerializeUtil.serialize((Object)answer));
        }
        answer.setHomeworkId(homeworkStudent.getHomeworkId());
        answer.setQuestionId(question.getId());
        answer.setUserId(homeworkStudent.getUserId());
        answer.setHomeworkStudentId(homeworkStudent.getId());
        if (!CollectionUtils.isEmpty(questionAnswerDto.getAnswer())) {
            String answerStr = BaseUtils.listToStr(questionAnswerDto.getAnswer(), (String)"@#@");
            answer.setAnswer(answerStr);
        }
        if (!CollectionUtils.isEmpty(questionAnswerDto.getAnswerImage())) {
            String s = JacksonUtil.obj2Str(questionAnswerDto.getAnswerImage());
            answer.setAnswerImage(s);
        }
        answer.setCorrectStatus(Integer.valueOf(CorrectStatus.UNCONRRECT.getStatus()));
        if (answer.getId() == null) {
            this.homeworkStudentAnswerDao.save((Object)answer, new String[0]);
        } else {
            this.homeworkStudentAnswerDao.update((Object)answer, new String[0]);
        }
        return answer.getId();
    }

    @Override
    @Transactional
    public long submitHomework(BaseLoginUser user, long homeworkStudentId) {
        HomeworkStudent homeworkStudent = (HomeworkStudent)this.homeworkStudentDao.getById((Serializable)Long.valueOf(homeworkStudentId), new String[0]);
        if (homeworkStudent == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u5b66\u751f\u4f5c\u4e1a\u4e0d\u5b58\u5728");
        }
        if (homeworkStudent.getUserId().longValue() != user.getId().longValue()) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u4f5c\u4e1a");
        }
        Homework homework = this.homeworkListDao.getHomeworkById(homeworkStudent.getHomeworkId().longValue());
        if (homework == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u4f5c\u4e1a\u4e0d\u5b58\u5728");
        }
        this.saveHomeworkStudentAnswer(homeworkStudent);
        homeworkStudent.setSubmitTime(new Date());
        homeworkStudent.setStatus(Integer.valueOf(HomeworkCompletedStatus.NOCORRECT.getStatus()));
        this.homeworkStudentDao.update((Object)homeworkStudent, new String[]{"submitTime", "status"});
        this.autoCorrectHomework(homeworkStudentId, user.getClientType());
        return homeworkStudent.getId();
    }

    private void saveHomeworkStudentAnswer(HomeworkStudent homeworkStudent) {
        List hqs = this.homeworkQuestionDao.getQuestionsByHomeworkId(homeworkStudent.getHomeworkId().longValue());
        List hsas = this.homeworkStudentAnswerDao.getHomeworkStudentAnswers(homeworkStudent.getId().longValue(), new String[0]);
        Set allQuestions = BaseUtils.getPropertiesList((List)hqs, (String)"questionId");
        Set toRemoveQuestions = BaseUtils.getPropertiesList((List)hsas, (String)"questionId");
        allQuestions.removeAll(toRemoveQuestions);
        if (CollectionUtils.isEmpty((Collection)allQuestions)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        List questions = this.questionDao.getByIds((Collection)allQuestions, new String[0]);
        Map map = BaseUtils.listToMap((List)questions, (String)"id");
        for (Long id : allQuestions) {
            HomeworkStudentAnswer answer = new HomeworkStudentAnswer();
            answer.setHomeworkId(homeworkStudent.getHomeworkId());
            answer.setQuestionId(id);
            answer.setUserId(homeworkStudent.getUserId());
            answer.setHomeworkStudentId(homeworkStudent.getId());
            if (((Question)map.get(id)).getQuestionType().intValue() != QuestionType.QUESTION.getType()) {
                answer.setCorrectStatus(Integer.valueOf(CorrectStatus.CONRRECTED.getStatus()));
            } else {
                answer.setCorrectStatus(Integer.valueOf(CorrectStatus.UNCONRRECT.getStatus()));
            }
            list.add(answer);
        }
        this.homeworkStudentAnswerDao.saveAll((List)list, new String[0]);
    }

    @Override
    public void autoCorrectHomework(long homeworkStudentId, Integer systemType) {
        HomeworkStudent homeworkStudent = (HomeworkStudent)this.homeworkStudentDao.getById((Serializable)Long.valueOf(homeworkStudentId), new String[0]);
        if (homeworkStudent == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u5b66\u751f\u4f5c\u4e1a\u4e0d\u5b58\u5728");
        }
        List studentAnswers = this.homeworkStudentAnswerDao.getHomeworkStudentAnswers(homeworkStudentId, new String[0]);
        Set questionIds = BaseUtils.getPropertiesList((List)studentAnswers, (String)"questionId");
        log.debug("DoHomeworkServiceImpl->{},{}", (Object)homeworkStudentId, (Object)questionIds);
        if (CollectionUtils.isNotEmpty((Collection)questionIds)) {
            List questions = this.questionDao.getQuestionByIds((Collection)questionIds);
            List homeworkQuestions = this.homeworkQuestionDao.getQuestionsByHomeworkId(homeworkStudent.getHomeworkId().longValue());
            Map hqmap = BaseUtils.listToMap((List)homeworkQuestions, (String)"questionId");
            Map questionMap = BaseUtils.listToMap((List)questions, (String)"id");
            for (HomeworkStudentAnswer homeworkStudentAnswer : studentAnswers) {
                Question question = (Question)questionMap.get((long)homeworkStudentAnswer.getQuestionId());
                log.debug("DoHomeworkServiceImpl={},{}", (Object)question, (Object)homeworkStudentAnswer);
                if (question == null || !QuestionType.isAutoCorrect((int)question.getQuestionType())) continue;
                float scorce = 0.0f;
                if (homeworkStudentAnswer != null) {
                    String rightAnswer = question.getAnswer();
                    String studentAnswer = homeworkStudentAnswer.getAnswer();
                    if (StringUtils.isNotBlank((CharSequence)studentAnswer)) {
                        scorce = this.caculateScore(rightAnswer, studentAnswer, question);
                    }
                }
                if (systemType.intValue() == ClientType.EXAM.getCode()) {
                    HomeworkQuestion hq = (HomeworkQuestion)hqmap.get(question.getId());
                    scorce = hq == null ? 0.0f : scorce * hq.getScore().floatValue() / 100.0f;
                }
                this.homeworkStudentAnswerDao.corectAnswer(question.getId().longValue(), homeworkStudentId, homeworkStudentAnswer.getHomeworkId().longValue(), scorce, 0);
            }
            List hasCorrectList = this.homeworkStudentAnswerDao.listByCorrectStatus(homeworkStudentId, CorrectStatus.CONRRECTED.getStatus(), new String[0]);
            List notCorrectList = this.homeworkStudentAnswerDao.listByCorrectStatus(homeworkStudentId, CorrectStatus.UNCONRRECT.getStatus(), new String[0]);
            homeworkStudent.setScore(Float.valueOf((float)this.getHomeworkScore(hasCorrectList, systemType)));
            homeworkStudent.setCorrectTime(new Date());
            homeworkStudent.setCorrectId(Long.valueOf(0L));
            homeworkStudent.setStatus(Integer.valueOf(notCorrectList.size() == 0 ? HomeworkCompletedStatus.CORRECTED.getStatus() : HomeworkCompletedStatus.NOCORRECT.getStatus()));
            log.debug("HomeworkStudentAnswerDaoImpl==>{}", (Object)homeworkStudent);
            this.homeworkStudentDao.update((Object)homeworkStudent, new String[]{"score", "correctTime", "correctId", "status"});
        }
    }

    private float caculateScore(String rightAnswer, String studentAnswer, Question question) {
        int score = 100;
        List<String> rightAnswerList = this.dealAnswer(rightAnswer, question);
        List<String> studentAnswerList = this.dealAnswer(studentAnswer, question);
        if (CollectionUtils.isEmpty(studentAnswerList)) {
            return 0.0f;
        }
        if (rightAnswerList.size() != studentAnswerList.size()) {
            score = 0;
        } else {
            for (int i = 0; i < rightAnswerList.size(); ++i) {
                log.debug("[rightAnswer]={},[studentAnswer]={}", (Object)rightAnswerList.get(i), (Object)studentAnswerList.get(i));
                if (rightAnswerList.get(i).equals(studentAnswerList.get(i))) continue;
                score = 0;
            }
        }
        return score;
    }

    private double getHomeworkScore(List<HomeworkStudentAnswer> hasCorrectList, Integer systemType) {
        float score = 0.0f;
        if (CollectionUtils.isEmpty(hasCorrectList)) {
            return score;
        }
        for (HomeworkStudentAnswer homeworkStudentAnswer : hasCorrectList) {
            score += homeworkStudentAnswer.getScore().floatValue();
        }
        log.debug("[all score]={},[size]={}", (Object)Float.valueOf(score), (Object)hasCorrectList.size());
        double dscource = score;
        if (systemType.intValue() != ClientType.HW.getCode()) {
            return BaseUtils.doubleFormat((Double)dscource, (Integer)1);
        }
        return BaseUtils.doubleFormat((Double)(dscource / (double)hasCorrectList.size()), (Integer)1);
    }

    @Override
    public HomeworkStudentInfoDto getAllQuestions(BaseLoginUser user, long homeworkStudentId) {
        HomeworkStudent homeworkStudent = (HomeworkStudent)this.homeworkStudentDao.getById((Serializable)Long.valueOf(homeworkStudentId), new String[0]);
        if (homeworkStudent == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u5b66\u751f\u4f5c\u4e1a\u4e0d\u5b58\u5728");
        }
        if (homeworkStudent.getUserId().intValue() != user.getUserId().intValue()) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u4f5c\u4e1a");
        }
        Homework homework = this.homeworkListDao.getHomeworkById(homeworkStudent.getHomeworkId().longValue());
        if (homework == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u4f5c\u4e1a\u4e0d\u5b58\u5728");
        }
        List homeworkQuestions = this.homeworkQuestionDao.getQuestionsByHomeworkId(homeworkStudent.getHomeworkId().longValue());
        Set questionIds = BaseUtils.getPropertiesList((List)homeworkQuestions, (String)"questionId");
        List questions = this.questionDao.getByIds((Collection)questionIds, new String[0]);
        Map questionMap = BaseUtils.listToMap((List)questions, (String)"id");
        List answers = this.homeworkStudentAnswerDao.getHomeworkAnswers(homeworkStudent.getHomeworkId().longValue(), homeworkStudent.getUserId().longValue());
        Map answerMap = BaseUtils.listToMap((List)answers, (String)"questionId");
        HomeworkStudentInfoDto questionInfoDto = new HomeworkStudentInfoDto();
        ArrayList questionIdList = Lists.newArrayList();
        ArrayList questionTypes = Lists.newArrayList();
        for (QuestionType questionType : QuestionType.values()) {
            QuestionTypeDto questionTypeDto = new QuestionTypeDto();
            ArrayList list = Lists.newArrayList();
            for (Question question : questions) {
                String studentAnswer;
                if (question.getQuestionType().intValue() != questionType.getType()) continue;
                questionIdList.add(question.getId());
                QuestionsToAnswerDto questionsToAnswerDto = new QuestionsToAnswerDto();
                questionsToAnswerDto.setQuestionId(question.getId());
                questionsToAnswerDto.setQuestionType(questionType.getType());
                HomeworkStudentAnswer answer = (HomeworkStudentAnswer)answerMap.get(question.getId());
                String string = studentAnswer = answer == null ? "" : answer.getAnswer();
                if (StringUtils.isEmpty((CharSequence)studentAnswer)) {
                    questionsToAnswerDto.setCompleteStatus(QuestionCompletedStatus.UNCOMPLETED.getStatus());
                    questionsToAnswerDto.setCorrectScore(answer == null ? 0.0f : answer.getScore().floatValue());
                    questionsToAnswerDto.setCorrectStatus(answer == null ? CorrectStatus.UNCONRRECT.getStatus() : answer.getCorrectStatus().intValue());
                } else {
                    questionsToAnswerDto.setCompleteStatus(QuestionCompletedStatus.COMPLETED.getStatus());
                    questionsToAnswerDto.setCorrectStatus(CorrectStatus.UNCONRRECT.getStatus());
                }
                list.add(questionsToAnswerDto);
            }
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            questionTypeDto.setQuestionType(questionType.getType());
            questionTypeDto.setQuestionTypeStr(QuestionType.get((int)questionType.getType()).getLabel());
            questionInfoDto.setQuestionTypes(questionTypes);
        }
        ArrayList questionDetailDtos = Lists.newArrayList();
        for (Long id : questionIdList) {
            HomeworkStudentAnswer studentAnswer;
            Question question = (Question)questionMap.get(id);
            QuestionDetailDto detail = QuestionDetailDto.parseToDto(question);
            if (homeworkStudent.getStatus().intValue() == HomeworkCompletedStatus.CORRECTED.getStatus() && StringUtils.isNotEmpty((CharSequence)question.getAnswer())) {
                detail.setAnswer(BaseUtils.strToList((String)question.getAnswer(), (String)"@#@"));
            }
            if ((studentAnswer = (HomeworkStudentAnswer)answerMap.get(id)) != null) {
                String answerImage;
                String answer = studentAnswer.getAnswer();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{answer})) {
                    detail.setStudentAnswer(BaseUtils.strToList((String)answer, (String)"@#@"));
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{answerImage = studentAnswer.getAnswerImage()})) {
                    detail.setStudentAnswerImage(BaseUtils.strToList((String)answerImage, (String)"@#@"));
                }
                if (detail.getCorrectStatus() == CorrectStatus.CONRRECTED.getStatus()) {
                    detail.setCorrectScore(studentAnswer.getScore().floatValue());
                }
                detail.setCorrectStatus(detail.getCorrectStatus());
            }
            questionDetailDtos.add(detail);
        }
        questionInfoDto.setStatus(homework.getStatus());
        questionInfoDto.setName(homework.getName());
        questionInfoDto.setTotalNum(homework.getCount());
        questionInfoDto.setQuestions(questionDetailDtos);
        questionInfoDto.setHomeworkId(homeworkStudent.getHomeworkId());
        questionInfoDto.setHomeworkStudentId(homeworkStudent.getId());
        return questionInfoDto;
    }

    @Override
    public HomeworkStudentInfoDto getHomeworkStudentDetail(BaseLoginUser user, long homeworkStudentId) {
        HomeworkStudent homeworkStudent = (HomeworkStudent)this.homeworkStudentDao.getById((Serializable)Long.valueOf(homeworkStudentId), new String[0]);
        log.debug("[user]={},[homeworkStudent]={}", (Object)user, (Object)homeworkStudent);
        if (homeworkStudent == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u5b66\u751f\u4f5c\u4e1a\u4e0d\u5b58\u5728");
        }
        if (homeworkStudent.getUserId().longValue() != user.getId().longValue()) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u4f5c\u4e1a");
        }
        Homework homework = this.homeworkListDao.getHomeworkById(homeworkStudent.getHomeworkId().longValue());
        if (homework == null) {
            throw new BusinessException((UniverseErrorCode)AssignmentErrorCode.PARAM_ERROR, "\u4f5c\u4e1a\u4e0d\u5b58\u5728");
        }
        List homeworkQuestions = this.homeworkQuestionDao.getQuestionsByHomeworkId(homeworkStudent.getHomeworkId().longValue());
        Map homeworkQuestionMap = BaseUtils.listToMap((List)homeworkQuestions, (String)"questionId");
        Set questionIds = BaseUtils.getPropertiesList((List)homeworkQuestions, (String)"questionId");
        List questions = this.questionDao.getByIds((Collection)questionIds, new String[0]);
        List answers = this.homeworkStudentAnswerDao.getHomeworkStudentAnswers(homeworkStudentId, new String[0]);
        Map answerMap = BaseUtils.listToMap((List)answers, (String)"questionId");
        HomeworkStudentInfoDto homeworkStudentInfoDto = new HomeworkStudentInfoDto();
        ArrayList questionIdList = Lists.newArrayList();
        ArrayList questionTypes = Lists.newArrayList();
        int rigthNum = 0;
        for (QuestionType questionType : QuestionType.values()) {
            QuestionTypeDto questionTypeDto = new QuestionTypeDto();
            ArrayList list = Lists.newArrayList();
            for (Question question : questions) {
                String comment;
                if (question.getQuestionType().intValue() != questionType.getType()) continue;
                HomeworkQuestion hq = (HomeworkQuestion)homeworkQuestionMap.get(question.getId());
                questionIdList.add(question.getId());
                QuestionsToAnswerDto questionsToAnswerDto = QuestionsToAnswerDto.parseToDto(question);
                questionsToAnswerDto.setQuestionType(questionType.getType());
                HomeworkStudentAnswer studentAnswerPO = (HomeworkStudentAnswer)answerMap.get((long)question.getId());
                if (studentAnswerPO != null && (double)Math.abs(studentAnswerPO.getScore().floatValue() - hq.getScore().floatValue()) < 1.0E-8) {
                    ++rigthNum;
                }
                String studentAnswer = studentAnswerPO == null ? "" : studentAnswerPO.getAnswer();
                String studentAnswerImg = studentAnswerPO == null ? "" : studentAnswerPO.getAnswerImage();
                String string = comment = studentAnswerPO == null ? "" : studentAnswerPO.getComment();
                if (StringUtils.isEmpty((CharSequence)studentAnswer)) {
                    questionsToAnswerDto.setCompleteStatus(QuestionCompletedStatus.UNCOMPLETED.getStatus());
                    questionsToAnswerDto.setCorrectScore(studentAnswerPO == null ? 0.0f : studentAnswerPO.getScore().floatValue());
                } else {
                    questionsToAnswerDto.setStudentAnswer(this.dealAnswer(studentAnswer, question));
                    questionsToAnswerDto.setCompleteStatus(QuestionCompletedStatus.COMPLETED.getStatus());
                    questionsToAnswerDto.setCorrectScore(studentAnswerPO.getScore().floatValue());
                }
                questionsToAnswerDto.setCorrectStatus(studentAnswerPO == null ? CorrectStatus.UNCONRRECT.getStatus() : studentAnswerPO.getCorrectStatus().intValue());
                if (StringUtils.isNotEmpty((CharSequence)studentAnswerImg)) {
                    List imageDtoList = null;
                    try {
                        imageDtoList = JacksonUtil.str2List((String)studentAnswerImg, ImageDto.class);
                    }
                    catch (IOException e) {
                        log.debug("[cast image catch exception]={}", (Throwable)e);
                    }
                    questionsToAnswerDto.setStudentAnswerImage(imageDtoList);
                    questionsToAnswerDto.setCompleteStatus(QuestionCompletedStatus.COMPLETED.getStatus());
                }
                questionsToAnswerDto.setStatus();
                if (questionsToAnswerDto.getCorrectStatus() == CorrectStatus.CONRRECTED.getStatus() && StringUtils.isNotEmpty((CharSequence)question.getAnswer())) {
                    questionsToAnswerDto.setAnswer(this.dealAnswer(question.getAnswer(), question));
                }
                questionsToAnswerDto.setComment(comment);
                questionsToAnswerDto.setScore(hq.getScore().floatValue());
                list.add(questionsToAnswerDto);
            }
            if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
            questionTypeDto.setQuestionType(questionType.getType());
            questionTypeDto.setQuestionTypeStr(QuestionType.get((int)questionType.getType()).getLabel());
            questionTypes.add(questionTypeDto);
            questionTypeDto.setList(list);
        }
        homeworkStudentInfoDto.setStatus(homeworkStudent.getStatus());
        homeworkStudentInfoDto.setRightNum(rigthNum);
        homeworkStudentInfoDto.setName(homework.getName());
        homeworkStudentInfoDto.setTotalNum(homework.getCount());
        if (user.getClientType().intValue() == ClientType.HW.getCode()) {
            homeworkStudentInfoDto.setScore((float)questions.size() * 100.0f);
        } else {
            homeworkStudentInfoDto.setScore(homework.getExamScore().floatValue());
        }
        homeworkStudentInfoDto.setCorrectScore(homeworkStudent.getScore().floatValue());
        homeworkStudentInfoDto.setHomeworkId(homeworkStudent.getHomeworkId());
        homeworkStudentInfoDto.setHomeworkStudentId(homeworkStudent.getId());
        homeworkStudentInfoDto.setQuestionTypes(questionTypes);
        homeworkStudentInfoDto.setExamTime(homework.getDuration());
        if (homeworkStudent.getStartTime() != null) {
            homeworkStudentInfoDto.setLastedTime(System.currentTimeMillis() - homeworkStudent.getStartTime().getTime());
        } else {
            homeworkStudentInfoDto.setLastedTime(0L);
        }
        if (homeworkStudent.getSubmitTime() != null) {
            long submit = homeworkStudent.getSubmitTime().getTime();
            long start = homeworkStudent.getStartTime().getTime();
            homeworkStudentInfoDto.setConsumeTime(submit - start);
        }
        return homeworkStudentInfoDto;
    }

    private List<String> dealAnswer(String answer, Question question) {
        List answerList = Lists.newArrayList();
        if (question.getQuestionType().intValue() == QuestionType.MULTI.getType()) {
            String[] arr = answer.split("@#@");
            HashSet answerSet = Sets.newHashSet();
            for (String s : arr) {
                if (!StringUtils.isNotBlank((CharSequence)s) || s.equals("null")) continue;
                answerSet.add(s);
            }
            answerList.addAll(answerSet);
            Collections.sort(answerList);
        } else {
            answerList = BaseUtils.strToList((String)answer, (String)"@#@");
        }
        return answerList;
    }

    @Override
    public ReadyExamDto getReadyExamDto(long homeworkStudentId) {
        HomeworkStudent homeworkStudent = (HomeworkStudent)this.homeworkStudentDao.getById((Serializable)Long.valueOf(homeworkStudentId), new String[0]);
        Homework homework = this.homeworkListDao.getHomeworkById(homeworkStudent.getHomeworkId().longValue());
        ReadyExamDto dto = new ReadyExamDto();
        dto.setExamName(homework.getName());
        dto.setExamTime(homework.getDuration());
        long l = homework.getPublicTime().getTime() - new Date().getTime();
        dto.setStatus(l > 0L ? -1 : 1);
        log.debug("[publish time]={},[now time]={},status={}", new Object[]{homework.getPublicTime(), new Date(), dto.getStatus()});
        dto.setStartTime(homework.getPublicTime());
        return dto;
    }

    private boolean saveContent(final String MKEY, final byte[] contents) {
        boolean result = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                boolean result = connection.setNX(MKEY.getBytes(), contents);
                connection.expire(MKEY.getBytes(), 60L);
                return result;
            }
        });
        return result;
    }

    private byte[] getContent(final String MKEY) {
        byte[] result = (byte[])this.redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(){

            public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.get(MKEY.getBytes());
            }
        });
        return result;
    }
}

