/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.assignment.sal.webchat.dto.getallquestions;

import com.baijia.component.permission.util.BaseUtils;
import com.baijia.tianxiao.assignment.common.enums.QuestionType;
import com.baijia.tianxiao.assignment.dal.question.po.Question;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QuestionDetailDto {
    private long questionId;
    private int questionType;
    private String questionTypeStr;
    private String name;
    private List<String> options;
    private List<String> answer;
    private Integer answerNum;
    private List<String> studentAnswer;
    private List<String> studentAnswerImage;
    private float correctScore;
    private int correctStatus;

    public static QuestionDetailDto parseToDto(Question question) {
        QuestionDetailDto dto = new QuestionDetailDto();
        dto.setQuestionId(question.getId());
        dto.setQuestionType(question.getQuestionType());
        dto.setQuestionTypeStr(QuestionType.get((int)question.getQuestionType()).getLabel());
        dto.setName(question.getName());
        if (StringUtils.isNotBlank((CharSequence)question.getOptions())) {
            dto.setOptions(BaseUtils.strToList((String)question.getOptions(), (String)"@#@"));
        }
        if (StringUtils.isNotEmpty((CharSequence)question.getAnswer())) {
            dto.setAnswerNum(BaseUtils.strToList((String)question.getAnswer(), (String)"@#@").size());
        }
        dto.setName(question.getName());
        return dto;
    }

    public long getQuestionId() {
        return this.questionId;
    }

    public int getQuestionType() {
        return this.questionType;
    }

    public String getQuestionTypeStr() {
        return this.questionTypeStr;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public List<String> getAnswer() {
        return this.answer;
    }

    public Integer getAnswerNum() {
        return this.answerNum;
    }

    public List<String> getStudentAnswer() {
        return this.studentAnswer;
    }

    public List<String> getStudentAnswerImage() {
        return this.studentAnswerImage;
    }

    public float getCorrectScore() {
        return this.correctScore;
    }

    public int getCorrectStatus() {
        return this.correctStatus;
    }

    public void setQuestionId(long questionId) {
        this.questionId = questionId;
    }

    public void setQuestionType(int questionType) {
        this.questionType = questionType;
    }

    public void setQuestionTypeStr(String questionTypeStr) {
        this.questionTypeStr = questionTypeStr;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public void setAnswer(List<String> answer) {
        this.answer = answer;
    }

    public void setAnswerNum(Integer answerNum) {
        this.answerNum = answerNum;
    }

    public void setStudentAnswer(List<String> studentAnswer) {
        this.studentAnswer = studentAnswer;
    }

    public void setStudentAnswerImage(List<String> studentAnswerImage) {
        this.studentAnswerImage = studentAnswerImage;
    }

    public void setCorrectScore(float correctScore) {
        this.correctScore = correctScore;
    }

    public void setCorrectStatus(int correctStatus) {
        this.correctStatus = correctStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuestionDetailDto)) {
            return false;
        }
        QuestionDetailDto other = (QuestionDetailDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQuestionId() != other.getQuestionId()) {
            return false;
        }
        if (this.getQuestionType() != other.getQuestionType()) {
            return false;
        }
        String this$questionTypeStr = this.getQuestionTypeStr();
        String other$questionTypeStr = other.getQuestionTypeStr();
        if (this$questionTypeStr == null ? other$questionTypeStr != null : !this$questionTypeStr.equals(other$questionTypeStr)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$options = this.getOptions();
        List<String> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        List<String> this$answer = this.getAnswer();
        List<String> other$answer = other.getAnswer();
        if (this$answer == null ? other$answer != null : !((Object)this$answer).equals(other$answer)) {
            return false;
        }
        Integer this$answerNum = this.getAnswerNum();
        Integer other$answerNum = other.getAnswerNum();
        if (this$answerNum == null ? other$answerNum != null : !((Object)this$answerNum).equals(other$answerNum)) {
            return false;
        }
        List<String> this$studentAnswer = this.getStudentAnswer();
        List<String> other$studentAnswer = other.getStudentAnswer();
        if (this$studentAnswer == null ? other$studentAnswer != null : !((Object)this$studentAnswer).equals(other$studentAnswer)) {
            return false;
        }
        List<String> this$studentAnswerImage = this.getStudentAnswerImage();
        List<String> other$studentAnswerImage = other.getStudentAnswerImage();
        if (this$studentAnswerImage == null ? other$studentAnswerImage != null : !((Object)this$studentAnswerImage).equals(other$studentAnswerImage)) {
            return false;
        }
        if (Float.compare(this.getCorrectScore(), other.getCorrectScore()) != 0) {
            return false;
        }
        return this.getCorrectStatus() == other.getCorrectStatus();
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuestionDetailDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $questionId = this.getQuestionId();
        result = result * 59 + (int)($questionId >>> 32 ^ $questionId);
        result = result * 59 + this.getQuestionType();
        String $questionTypeStr = this.getQuestionTypeStr();
        result = result * 59 + ($questionTypeStr == null ? 43 : $questionTypeStr.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        List<String> $answer = this.getAnswer();
        result = result * 59 + ($answer == null ? 43 : ((Object)$answer).hashCode());
        Integer $answerNum = this.getAnswerNum();
        result = result * 59 + ($answerNum == null ? 43 : ((Object)$answerNum).hashCode());
        List<String> $studentAnswer = this.getStudentAnswer();
        result = result * 59 + ($studentAnswer == null ? 43 : ((Object)$studentAnswer).hashCode());
        List<String> $studentAnswerImage = this.getStudentAnswerImage();
        result = result * 59 + ($studentAnswerImage == null ? 43 : ((Object)$studentAnswerImage).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getCorrectScore());
        result = result * 59 + this.getCorrectStatus();
        return result;
    }

    public String toString() {
        return "QuestionDetailDto(questionId=" + this.getQuestionId() + ", questionType=" + this.getQuestionType() + ", questionTypeStr=" + this.getQuestionTypeStr() + ", name=" + this.getName() + ", options=" + this.getOptions() + ", answer=" + this.getAnswer() + ", answerNum=" + this.getAnswerNum() + ", studentAnswer=" + this.getStudentAnswer() + ", studentAnswerImage=" + this.getStudentAnswerImage() + ", correctScore=" + this.getCorrectScore() + ", correctStatus=" + this.getCorrectStatus() + ")";
    }
}

