/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.assignment.sal.webchat.dto;

import com.baijia.tianxiao.assignment.common.enums.HomeworkCompletedStatus;
import com.baijia.tianxiao.assignment.dal.homework.po.HomeworkStudent;
import com.baijia.tianxiao.assignment.sal.webchat.dto.QuestionCorrectDetail;
import com.google.common.collect.Lists;
import java.util.List;

public class QuestionListRespDto {
    private long homeworkId;
    private String name;
    private long classId;
    private int status;
    private String statusStr;
    private int correctCount;
    private int totalCount;
    List<QuestionCorrectDetail> details = Lists.newArrayList();

    public static QuestionListRespDto parseToDto(HomeworkStudent homeworkStudent) {
        QuestionListRespDto dto = new QuestionListRespDto();
        dto.setHomeworkId(homeworkStudent.getHomeworkId());
        dto.setClassId(homeworkStudent.getClassinfoId());
        dto.setStatus(homeworkStudent.getStatus());
        dto.setStatusStr(QuestionListRespDto.getStatus(homeworkStudent.getStatus(), homeworkStudent.getScore().floatValue()));
        return dto;
    }

    private static String getStatus(int status, float score) {
        String st = null;
        st = status == HomeworkCompletedStatus.CORRECTED.getStatus() ? "" + score + "%\u6b63\u786e\u7387" : HomeworkCompletedStatus.NOCORRECT.getLabel();
        return st;
    }

    public long getHomeworkId() {
        return this.homeworkId;
    }

    public String getName() {
        return this.name;
    }

    public long getClassId() {
        return this.classId;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusStr() {
        return this.statusStr;
    }

    public int getCorrectCount() {
        return this.correctCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public List<QuestionCorrectDetail> getDetails() {
        return this.details;
    }

    public void setHomeworkId(long homeworkId) {
        this.homeworkId = homeworkId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClassId(long classId) {
        this.classId = classId;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatusStr(String statusStr) {
        this.statusStr = statusStr;
    }

    public void setCorrectCount(int correctCount) {
        this.correctCount = correctCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setDetails(List<QuestionCorrectDetail> details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuestionListRespDto)) {
            return false;
        }
        QuestionListRespDto other = (QuestionListRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHomeworkId() != other.getHomeworkId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getClassId() != other.getClassId()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$statusStr = this.getStatusStr();
        String other$statusStr = other.getStatusStr();
        if (this$statusStr == null ? other$statusStr != null : !this$statusStr.equals(other$statusStr)) {
            return false;
        }
        if (this.getCorrectCount() != other.getCorrectCount()) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        List<QuestionCorrectDetail> this$details = this.getDetails();
        List<QuestionCorrectDetail> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuestionListRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $homeworkId = this.getHomeworkId();
        result = result * 59 + (int)($homeworkId >>> 32 ^ $homeworkId);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        long $classId = this.getClassId();
        result = result * 59 + (int)($classId >>> 32 ^ $classId);
        result = result * 59 + this.getStatus();
        String $statusStr = this.getStatusStr();
        result = result * 59 + ($statusStr == null ? 43 : $statusStr.hashCode());
        result = result * 59 + this.getCorrectCount();
        result = result * 59 + this.getTotalCount();
        List<QuestionCorrectDetail> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String toString() {
        return "QuestionListRespDto(homeworkId=" + this.getHomeworkId() + ", name=" + this.getName() + ", classId=" + this.getClassId() + ", status=" + this.getStatus() + ", statusStr=" + this.getStatusStr() + ", correctCount=" + this.getCorrectCount() + ", totalCount=" + this.getTotalCount() + ", details=" + this.getDetails() + ")";
    }
}

