/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.support.web.util;

import com.baijia.support.web.dto.PageDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;

public class PageUtils {
    public static <T> List<T> getList(Query query, PageDto pageDto) {
        if (pageDto == null) {
            return query.list();
        }
        ScrollableResults scrollRes = query.scroll();
        scrollRes.last();
        if (scrollRes.getRowNumber() >= 0) {
            pageDto.setCount(scrollRes.getRowNumber() + 1);
        }
        query.setFirstResult(pageDto.getOffset().intValue());
        query.setMaxResults(pageDto.getPageSize().intValue());
        List result = query.list();
        pageDto.setCurPageCount(result.size());
        return result;
    }

    public static <T> List<T> getList(List<T> list, PageDto pageDto) {
        if (pageDto == null) {
            return list;
        }
        pageDto.setCount(list.size());
        ArrayList subList = Lists.newArrayList();
        int offset = pageDto.getOffset();
        int count = 0;
        int i = offset;
        while (i < list.size()) {
            if (count < pageDto.getPageSize()) {
                subList.add(list.get(i));
                ++count;
            }
            ++i;
        }
        pageDto.setCurPageCount(subList.size());
        return subList;
    }
}

